/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptor;
import org.xwiki.filter.FilterElementDescriptor;
import org.xwiki.filter.FilterElementParameterDescriptor;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.UnknownFilter;
import org.xwiki.filter.xml.XMLConfiguration;
import org.xwiki.filter.xml.internal.XMLUtils;
import org.xwiki.filter.xml.internal.parameter.ParameterManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.xml.Sax2Dom;

public class DefaultXMLParser
extends DefaultHandler
implements ContentHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultXMLParser.class);
    private ParameterManager parameterManager;
    private ConverterManager stringConverter;
    private FilterDescriptor filterDescriptor;
    private Object filter;
    private Stack<Block> blockStack = new Stack();
    private int elementDepth = 0;
    private StringBuilder content;
    private XMLConfiguration configuration;

    public DefaultXMLParser(Object listener, FilterDescriptor listenerDescriptor, ConverterManager stringConverter, ParameterManager parameterManager, XMLConfiguration configuration) {
        this.filter = listener;
        this.filterDescriptor = listenerDescriptor;
        this.stringConverter = stringConverter;
        this.parameterManager = parameterManager;
        this.configuration = configuration != null ? configuration : new XMLConfiguration();
    }

    private boolean onBlockChild() {
        if (!this.blockStack.isEmpty()) {
            Block currentBlock = this.blockStack.peek();
            return currentBlock.elementDepth == this.elementDepth - 1;
        }
        boolean result = false;
        return result;
    }

    private boolean onBlockElement(String elementName) {
        boolean result;
        if (!this.blockStack.isEmpty()) {
            Block currentBlock = this.blockStack.peek();
            result = this.elementDepth - currentBlock.elementDepth <= 1 && !this.configuration.getElementParameters().equals(elementName);
        } else {
            result = true;
        }
        return result;
    }

    private boolean onParametersElement(String elementName) {
        return this.onBlockChild() && this.configuration.getElementParameters().equals(elementName);
    }

    private int extractParameterIndex(String elementName) {
        Matcher matcher = XMLUtils.INDEX_PATTERN.matcher(elementName);
        matcher.find();
        return Integer.valueOf(matcher.group(1));
    }

    private boolean isReservedBlockAttribute(String attributeName) {
        return this.configuration.getAttributeBlockName().equals(attributeName) || this.configuration.getAttributeParameterName().equals(attributeName);
    }

    private void setParameter(Block block, String name, Object value, boolean attribute) throws SAXException {
        if (XMLUtils.INDEX_PATTERN.matcher(name).matches()) {
            int parameterIndex = this.extractParameterIndex(name);
            if (block.filterElement != null && block.filterElement.getParameters().length > parameterIndex) {
                FilterElementParameterDescriptor filterParameter = block.filterElement.getParameters()[parameterIndex];
                this.setParameter(block, filterParameter, value);
            } else {
                LOGGER.warn("Unknown element parameter [{}] (=[{}]) in block [{}]", new Object[]{name, value, block.name});
                block.setParameter(name, value);
            }
        } else if (!attribute || !this.isReservedBlockAttribute(name)) {
            FilterElementParameterDescriptor filterParameter;
            FilterElementParameterDescriptor filterElementParameterDescriptor = filterParameter = block.filterElement != null ? block.filterElement.getParameter(name) : null;
            if (filterParameter != null) {
                this.setParameter(block, filterParameter, value);
            } else {
                LOGGER.warn("Unknown element parameter [{}] (=[{}]) in block [{}]", new Object[]{name, value, block.name});
                block.setParameter(name, value);
            }
        }
    }

    private void setParameter(Block block, FilterElementParameterDescriptor<?> filterParameter, Object value) throws SAXException {
        Type type = filterParameter.getType();
        if (value instanceof Element) {
            try {
                block.setParameter(filterParameter.getIndex(), this.unserializeParameter(type, (Element)value));
            }
            catch (ClassNotFoundException e) {
                throw new SAXException("Failed to parse property", e);
            }
        } else if (value instanceof String) {
            String stringValue = (String)value;
            Class typeClass = ReflectionUtils.getTypeClass((Type)type);
            if (typeClass == String.class || typeClass == Object.class) {
                block.setParameter(filterParameter.getIndex(), (Object)stringValue);
            } else {
                try {
                    block.setParameter(filterParameter.getIndex(), this.stringConverter.convert(type, value));
                }
                catch (ConversionException e) {
                    if (stringValue.isEmpty()) {
                        block.setParameter(filterParameter.getIndex(), XMLUtils.emptyValue(typeClass));
                    }
                    LOGGER.warn("Unsuported conversion to type [{}] for value [{}]", (Object)type, value);
                }
            }
        } else {
            LOGGER.warn("Unsuported type [{}] for value [{}]", value.getClass(), value);
        }
    }

    private Object unserializeParameter(Type type, Element element) throws ClassNotFoundException {
        if (element.hasAttribute(this.configuration.getAttributeParameterType())) {
            String typeString = element.getAttribute(this.configuration.getAttributeParameterType());
            return this.parameterManager.unSerialize(Class.forName(typeString, true, Thread.currentThread().getContextClassLoader()), element);
        }
        return this.parameterManager.unSerialize(type, element);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Block currentBlock;
        Block block = currentBlock = this.blockStack.isEmpty() ? null : this.blockStack.peek();
        if (this.onBlockElement(qName)) {
            if (currentBlock != null && !currentBlock.beginSent) {
                currentBlock.fireBeginEvent(this.filter);
            }
            Block block2 = this.getBlock(qName, attributes);
            currentBlock = this.blockStack.push(block2);
            if (!block2.isContainer() && block2.filterElement != null && block2.filterElement.getParameters().length > 0) {
                this.content = new StringBuilder();
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeName = attributes.getQName(i);
                this.setParameter(block2, attributeName, attributes.getValue(i), true);
            }
        } else {
            if (this.onParametersElement(qName) && currentBlock.filterElement != null) {
                try {
                    currentBlock.parametersDOMBuilder = new Sax2Dom();
                }
                catch (ParserConfigurationException e) {
                    throw new SAXException("Failed to create new Sax2Dom handler", e);
                }
                currentBlock.parametersDOMBuilder.startDocument();
            }
            if (currentBlock.parametersDOMBuilder != null) {
                currentBlock.parametersDOMBuilder.startElement(uri, localName, qName, attributes);
            }
        }
        ++this.elementDepth;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Block currentBlock = this.blockStack.isEmpty() ? null : this.blockStack.peek();
        --this.elementDepth;
        if (this.onBlockElement(qName)) {
            Block block = this.blockStack.pop();
            if (block.isContainer()) {
                if (!block.beginSent) {
                    block.fireBeginEvent(this.filter);
                }
                block.fireEndEvent(this.filter);
            } else {
                if (block.getParametersList().size() == 0 && this.filterDescriptor.getElement(qName).getParameters().length > 0 && this.content != null && this.content.length() > 0) {
                    block.setParameter(0, this.stringConverter.convert(this.filterDescriptor.getElement(qName).getParameters()[0].getType(), (Object)this.content.toString()));
                    this.content = null;
                }
                block.fireOnEvent(this.filter);
            }
        } else if (currentBlock.parametersDOMBuilder != null) {
            currentBlock.parametersDOMBuilder.endElement(uri, localName, qName);
            if (this.onParametersElement(qName)) {
                currentBlock.parametersDOMBuilder.endDocument();
                Element rootElement = currentBlock.parametersDOMBuilder.getRootElement();
                NodeList parameterNodes = rootElement.getChildNodes();
                for (int i = 0; i < parameterNodes.getLength(); ++i) {
                    Node parameterNode = parameterNodes.item(i);
                    if (parameterNode.getNodeType() != 1) continue;
                    String nodeName = parameterNode.getLocalName();
                    this.setParameter(currentBlock, nodeName, parameterNode, true);
                }
                currentBlock.parametersDOMBuilder = null;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parametersDOMBuilder != null) {
            this.blockStack.peek().parametersDOMBuilder.characters(ch, start, length);
        } else if (this.content != null) {
            this.content.append(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parametersDOMBuilder != null) {
            this.blockStack.peek().parametersDOMBuilder.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.blockStack.isEmpty() && this.blockStack.peek().parametersDOMBuilder != null) {
            this.blockStack.peek().parametersDOMBuilder.skippedEntity(name);
        }
    }

    private Block getBlock(String qName, Attributes attributes) {
        String blockName = this.configuration.getElementBlock().equals(qName) ? attributes.getValue(this.configuration.getAttributeBlockName()) : qName;
        FilterElementDescriptor element = this.filterDescriptor.getElement(blockName);
        if (element == null) {
            LOGGER.warn("Uknown filter element [{}]", (Object)blockName);
        }
        return new Block(qName, element, this.elementDepth);
    }

    public static class Block {
        public String name;
        public FilterElementDescriptor filterElement;
        public boolean beginSent = false;
        public List<Object> parameters = new ArrayList<Object>();
        public FilterEventParameters namedParameters = new FilterEventParameters();
        public Sax2Dom parametersDOMBuilder;
        public int elementDepth;
        private Object[] parametersTable;

        public Block(String name, FilterElementDescriptor listenerElement, int elementDepth) {
            this.name = name;
            this.filterElement = listenerElement;
            this.elementDepth = elementDepth;
        }

        public boolean isContainer() {
            return this.filterElement == null || this.filterElement.getBeginMethod() != null;
        }

        public void setParameter(String name, Object value) {
            this.namedParameters.put((Object)name, value);
        }

        public void setParameter(int index, Object value) {
            for (int i = this.parameters.size(); i <= index; ++i) {
                this.parameters.add(this.filterElement.getParameters()[i].getDefaultValue());
            }
            this.parameters.set(index, value);
            this.parametersTable = null;
        }

        public List<Object> getParametersList() {
            return this.parameters;
        }

        public Object[] getParametersTable() {
            if (this.parametersTable == null) {
                if (this.parameters.isEmpty()) {
                    this.parametersTable = ArrayUtils.EMPTY_OBJECT_ARRAY;
                }
                this.parametersTable = this.parameters.toArray();
            }
            return this.parametersTable;
        }

        public void fireBeginEvent(Object listener) throws SAXException {
            if (this.filterElement != null) {
                this.fireEvent(this.filterElement.getBeginMethod(), listener);
            } else if (listener instanceof UnknownFilter) {
                try {
                    ((UnknownFilter)listener).beginUnknwon(this.name, this.namedParameters);
                }
                catch (Exception e) {
                    throw new SAXException("Failed to invoke unknown event with name [" + this.name + "] and parameters [" + this.namedParameters + "]", e);
                }
            }
            this.beginSent = true;
        }

        public void fireEndEvent(Object listener) throws SAXException {
            if (this.filterElement != null) {
                this.fireEvent(this.filterElement.getEndMethod(), listener);
            } else if (listener instanceof UnknownFilter) {
                try {
                    ((UnknownFilter)listener).endUnknwon(this.name, this.namedParameters);
                }
                catch (Exception e) {
                    throw new SAXException("Failed to invoke unknown event with name [" + this.name + "] and parameters [" + this.namedParameters + "]", e);
                }
            }
        }

        public void fireOnEvent(Object listener) throws SAXException {
            if (this.filterElement != null) {
                this.fireEvent(this.filterElement.getOnMethod(), listener);
            } else if (listener instanceof UnknownFilter) {
                try {
                    ((UnknownFilter)listener).onUnknwon(this.name, this.namedParameters);
                }
                catch (Exception e) {
                    throw new SAXException("Failed to invoke unknown event with name [" + this.name + "] and parameters [" + this.namedParameters + "]", e);
                }
            }
        }

        private void fireEvent(Method eventMethod, Object listener) throws SAXException {
            int i;
            Object[] properParameters;
            Object[] parameters = this.getParametersTable();
            Class<?>[] methodParameters = eventMethod.getParameterTypes();
            if (methodParameters.length > parameters.length) {
                properParameters = new Object[methodParameters.length];
                for (i = 0; i < methodParameters.length; ++i) {
                    properParameters[i] = i < parameters.length ? parameters[i] : this.filterElement.getParameters()[i].getDefaultValue();
                }
            } else {
                properParameters = parameters;
            }
            for (i = 0; i < properParameters.length; ++i) {
                Class<?> methodParameter;
                Object parameter = properParameters[i];
                if (parameter != null || !(methodParameter = methodParameters[i]).isPrimitive()) continue;
                properParameters[i] = XMLUtils.emptyValue(methodParameter);
            }
            try {
                eventMethod.invoke(listener, properParameters);
            }
            catch (InvocationTargetException e) {
                throw new SAXException("Event [" + eventMethod + "] thrown exception", e.getCause() instanceof Exception ? (Exception)e.getCause() : e);
            }
            catch (Exception e) {
                throw new SAXException("Failed to invoke event [" + eventMethod + "]", e);
            }
        }
    }
}

