/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import net.osmand.shared.data.KLatLon;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.extensions.DoubleExtensionsKt;
import net.osmand.shared.util.KMapUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0013\n\u0002\b%\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\f\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J6\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 J&\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ\u0016\u0010!\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u001e\u0010!\u001a\u00020\t2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ6\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tJ\u0016\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020'J&\u00103\u001a\u0002062\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\tJ.\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\tJ6\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tJ6\u0010D\u001a\u00020'2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tJ6\u0010E\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tJ\u000e\u0010F\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\u000e\u0010G\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tJ\u000e\u0010H\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\tJ\u000e\u0010I\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\tJ\u000e\u0010J\u001a\u00020\t2\u0006\u0010K\u001a\u00020\u0005J\u000e\u0010L\u001a\u00020\t2\u0006\u0010M\u001a\u00020\u0005J\u0016\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\u0016\u0010P\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tJ\u0016\u0010Q\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tJ\u001e\u0010R\u001a\u0002062\u0006\u0010O\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\t2\u0006\u0010S\u001a\u00020\u0005J\u0016\u0010T\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010U\u001a\u00020\tJ\u000e\u0010V\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tJ\u0016\u0010V\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tJ\u0016\u0010W\u001a\u00020\t2\u0006\u0010B\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tJ\u0016\u0010X\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010Y\u001a\u00020\tJ\u000e\u0010Z\u001a\u00020\t2\u0006\u0010O\u001a\u00020\tJ.\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\2\u0006\u0010^\u001a\u00020\\2\u0006\u0010_\u001a\u00020\\2\u0006\u0010`\u001a\u00020\\2\u0006\u0010S\u001a\u00020\\J.\u0010a\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\2\u0006\u0010^\u001a\u00020\\2\u0006\u0010_\u001a\u00020\\2\u0006\u0010`\u001a\u00020\\2\u0006\u0010S\u001a\u00020\\J\u0016\u0010b\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t2\u0006\u0010c\u001a\u00020\tJ&\u0010d\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\t2\u0006\u0010e\u001a\u00020\t2\u0006\u0010f\u001a\u00020\t2\u0006\u0010S\u001a\u00020\tJ&\u0010g\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010S\u001a\u00020\tJ\u001e\u0010h\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\u0006\u0010O\u001a\u00020\u0005J\u001e\u0010i\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010O\u001a\u00020\u0005J\u001e\u0010j\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010O\u001a\u00020\u0005J\u0016\u0010k\u001a\u00020l2\u0006\u0010Y\u001a\u00020l2\u0006\u0010c\u001a\u00020lJ\u0016\u0010m\u001a\u00020\\2\u0006\u0010n\u001a\u00020\\2\u0006\u0010o\u001a\u00020\\J\u000e\u0010p\u001a\u00020\\2\u0006\u0010n\u001a\u00020\\J\u000e\u0010q\u001a\u00020\\2\u0006\u0010r\u001a\u00020\\J\u000e\u0010s\u001a\u00020\t2\u0006\u0010t\u001a\u00020\tJ\u0016\u0010u\u001a\u00020\t2\u0006\u0010v\u001a\u00020\t2\u0006\u0010w\u001a\u00020\tJ&\u0010x\u001a\u00020\t2\u0006\u0010y\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\u00052\u0006\u0010{\u001a\u00020\u00052\u0006\u0010|\u001a\u00020\u0005J&\u0010}\u001a\u00020\t2\u0006\u0010y\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\u00052\u0006\u0010{\u001a\u00020\u00052\u0006\u0010|\u001a\u00020\u0005J&\u0010\u007f\u001a\u00020\t2\u0006\u0010y\u001a\u00020\u00052\u0006\u0010z\u001a\u00020\u00052\u0006\u0010{\u001a\u00020\u00052\u0006\u0010|\u001a\u00020\u0005J\u0019\u0010\u0085\u0001\u001a\u00020\t2\u0007\u0010\u0086\u0001\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0003\u0010\u0087\u0001J;\u0010\u0088\u0001\u001a\u00020 2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0007\u0010\u0089\u0001\u001a\u00020\t2\u0007\u0010\u008a\u0001\u001a\u00020\t2\u0007\u0010\u008b\u0001\u001a\u00020\t2\u0007\u0010\u008c\u0001\u001a\u00020\tJ\u0010\u0010\u008d\u0001\u001a\u00020l2\u0007\u0010\u008e\u0001\u001a\u00020lJ\u0010\u0010\u008f\u0001\u001a\u00020l2\u0007\u0010\u008e\u0001\u001a\u00020lJ!\u0010\u0090\u0001\u001a\u00030\u0091\u00012\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0007\u0010\u0092\u0001\u001a\u00020\u0005J/\u0010\u0093\u0001\u001a\u00020\\2\u0006\u0010y\u001a\u00020\\2\u0006\u0010z\u001a\u00020\\2\u0006\u0010{\u001a\u00020\\2\u0006\u0010|\u001a\u00020\\2\u0006\u0010Y\u001a\u00020\\J\"\u0010\u0094\u0001\u001a\u00030\u0095\u00012\b\u0010\u0096\u0001\u001a\u00030\u0091\u00012\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\u001b\u0010\u0097\u0001\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'J!\u0010\u0097\u0001\u001a\u00020 2\b\u0010)\u001a\u0004\u0018\u00010'2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\tJ'\u0010\u0097\u0001\u001a\u00020 2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ$\u0010\u0097\u0001\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'2\u0007\u0010\u0098\u0001\u001a\u00020\tJ0\u0010\u0097\u0001\u001a\u00020 2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\u0007\u0010\u0098\u0001\u001a\u00020\tJ\"\u0010\u0099\u0001\u001a\u00020'2\u0007\u0010\u009a\u0001\u001a\u00020'2\u0007\u0010\u009b\u0001\u001a\u00020\t2\u0007\u0010\u009c\u0001\u001a\u00020\tJ)\u0010\u0099\u0001\u001a\u00020'2\u0006\u0010B\u001a\u00020\t2\u0006\u0010C\u001a\u00020\t2\u0007\u0010\u009b\u0001\u001a\u00020\t2\u0007\u0010\u009c\u0001\u001a\u00020\tJ+\u0010\u009d\u0001\u001a\u00020\t2\u0007\u0010\u009e\u0001\u001a\u00020\u00052\u0007\u0010\u009f\u0001\u001a\u00020\u00052\u0007\u0010\u00a0\u0001\u001a\u00020\u00052\u0007\u0010\u00a1\u0001\u001a\u00020\u0005J+\u0010\u009d\u0001\u001a\u00020\t2\u0007\u0010\u009e\u0001\u001a\u00020\\2\u0007\u0010\u009f\u0001\u001a\u00020\\2\u0007\u0010\u00a0\u0001\u001a\u00020\\2\u0007\u0010\u00a1\u0001\u001a\u00020\\J5\u0010\u00a2\u0001\u001a\u00020\u00122\u0007\u0010\u00a3\u0001\u001a\u00020\u00052\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u00012\u0007\u0010\u00a6\u0001\u001a\u00020\u00052\u0007\u0010\u00a7\u0001\u001a\u00020\u00052\u0007\u0010\u00a8\u0001\u001a\u00020\u0005J6\u0010\u00a9\u0001\u001a\u00020\u00052\b\u0010\u00aa\u0001\u001a\u00030\u00a5\u00012\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u00012\u0007\u0010\u00a6\u0001\u001a\u00020\u00052\u0007\u0010\u00a7\u0001\u001a\u00020\u00052\u0007\u0010\u00a8\u0001\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010~\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0080\u0001\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0081\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u0082\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0083\u0001\u001a\u00030\u0084\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00ab\u0001"}, d2={"Lnet/osmand/shared/util/KMapUtils;", "", "<init>", "()V", "ROUNDING_ERROR", "", "EARTH_RADIUS_B", "EARTH_RADIUS_A", "MIN_LATITUDE", "", "MAX_LATITUDE", "LATITUDE_TURN", "MIN_LONGITUDE", "MAX_LONGITUDE", "LONGITUDE_TURN", "DEFAULT_LATLON_PRECISION", "HIGH_LATLON_PRECISION", "BASE_SHORT_OSM_URL", "", "intToBase64", "", "calculateFromBaseZoomPrecisionXY", "baseZoom", "finalZoom", "xFinal", "yFinal", "calculateFinalXYFromBaseAndPrecisionXY", "", "precisionXY", "xBase", "yBase", "ignoreNotEnoughPrecision", "", "getDistance", "lat1", "lon1", "lat2", "lon2", "l1", "Lnet/osmand/shared/data/KLatLon;", "l2", "l", "latitude", "longitude", "scalarMultiplication", "xA", "yA", "xB", "yB", "xC", "yC", "calculateMidPoint", "s1", "s2", "", "firstLat", "firstLon", "secondLat", "secondLon", "calculateIntermediatePoint", "fromLat", "fromLon", "toLat", "toLon", "coeff", "getOrthogonalDistance", "lat", "lon", "getProjection", "getProjectionCoeff", "checkLongitude", "checkLatitude", "get31TileNumberX", "get31TileNumberY", "get31LongitudeX", "tileX", "get31LatitudeY", "tileY", "getTileNumberX", "zoom", "getTileNumberY", "getTileEllipsoidNumberY", "getTileEllipsoidNumberAndOffsetY", "tileSize", "getLatitudeFromEllipsoidTileY", "tileNumberY", "getTileDistanceWidth", "getTileDistanceHeight", "getLongitudeFromTile", "x", "getPowZoom", "calcDiffPixelX", "", "rotateSin", "rotateCos", "dTileX", "dTileY", "calcDiffPixelY", "getLatitudeFromTile", "y", "getPixelShiftX", "long1", "long2", "getPixelShiftY", "buildGeoUrl", "buildShortOsmUrl", "createShortLinkString", "interleaveBits", "", "unifyRotationDiff", "rotate", "targetRotate", "unifyRotationTo360", "normalizeDegrees360", "degrees", "alignAngleDifference", "diff", "degreesDiff", "a1", "a2", "squareRootDist31", "x1", "y1", "x2", "y2", "measuredDist31", "EQUATOR", "squareDist31TileMetric", "PRECISION_ZOOM", "DIST_CACHE", "", "distCacheMutex", "Lkotlinx/coroutines/sync/Mutex;", "getTileWidth", "y31", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rightSide", "aLat", "aLon", "bLat", "bLon", "deinterleaveY", "coord", "deinterleaveX", "calculateLatLonBbox", "Lnet/osmand/shared/data/KQuadRect;", "radiusMeters", "getInterpolatedY", "insetLatLonRect", "", "r", "areLatLonEqual", "precision", "rhumbDestinationPoint", "latLon", "distance", "bearing", "getSqrtDistance", "startX", "startY", "endX", "endY", "convertDistToChar", "dist", "firstLetter", "", "firstDist", "mult1", "mult2", "convertCharToDist", "ch", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nKMapUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KMapUtils.kt\nnet/osmand/shared/util/KMapUtils\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,722:1\n116#2,10:723\n116#2,10:733\n*S KotlinDebug\n*F\n+ 1 KMapUtils.kt\nnet/osmand/shared/util/KMapUtils\n*L\n524#1:723,10\n539#1:733,10\n*E\n"})
public final class KMapUtils {
    @NotNull
    public static final KMapUtils INSTANCE = new KMapUtils();
    public static final int ROUNDING_ERROR = 3;
    private static final int EARTH_RADIUS_B = 6356752;
    private static final int EARTH_RADIUS_A = 6378137;
    public static final double MIN_LATITUDE = -85.0511;
    public static final double MAX_LATITUDE = 85.0511;
    public static final double LATITUDE_TURN = 180.0;
    public static final double MIN_LONGITUDE = -180.0;
    public static final double MAX_LONGITUDE = 180.0;
    public static final double LONGITUDE_TURN = 360.0;
    public static final double DEFAULT_LATLON_PRECISION = 1.0E-5;
    public static final double HIGH_LATLON_PRECISION = 1.0E-7;
    @NotNull
    private static final String BASE_SHORT_OSM_URL = "https://openstreetmap.org/go/";
    @NotNull
    private static final char[] intToBase64;
    public static final int EQUATOR = 0x40000000;
    private static final int PRECISION_ZOOM = 14;
    @NotNull
    private static final Map<Integer, Double> DIST_CACHE;
    @NotNull
    private static final Mutex distCacheMutex;

    private KMapUtils() {
    }

    public final int calculateFromBaseZoomPrecisionXY(int baseZoom, int finalZoom, int xFinal, int yFinal) {
        int px = xFinal;
        int py = yFinal;
        int precisionNumber = 1;
        int zoom = finalZoom - 1;
        if (baseZoom <= zoom) {
            while (true) {
                int x = px / 2;
                int y = py / 2;
                int deltax = px - x * 2;
                int deltay = py - y * 2;
                precisionNumber = (precisionNumber << 2) + (deltax << 1) + deltay;
                px = x;
                py = y;
                if (zoom == baseZoom) break;
                --zoom;
            }
        }
        return precisionNumber;
    }

    @NotNull
    public final int[] calculateFinalXYFromBaseAndPrecisionXY(int baseZoom, int finalZoom, int precisionXY, int xBase, int yBase, boolean ignoreNotEnoughPrecision) {
        int tPrecisionXY;
        int finalX = xBase;
        int finalY = yBase;
        int precisionCalc = tPrecisionXY = precisionXY;
        for (int zoom = baseZoom; zoom < finalZoom; ++zoom) {
            if (precisionCalc <= 1 && precisionCalc > 0 && !ignoreNotEnoughPrecision) {
                throw new IllegalArgumentException("Not enough bits to retrieve zoom approximation");
            }
            finalY = finalY * 2 + (tPrecisionXY & 1);
            finalX = finalX * 2 + ((tPrecisionXY & 2) >> 1);
            tPrecisionXY >>= 2;
        }
        int[] nArray = new int[]{finalX, finalY};
        return nArray;
    }

    public final double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double R = 6372.8;
        double dLat = DoubleExtensionsKt.toRadians(lat2 - lat1);
        double dLon = DoubleExtensionsKt.toRadians(lon2 - lon1);
        double sinHalfLat = Math.sin(dLat / (double)2);
        double sinHalfLon = Math.sin(dLon / (double)2);
        double a = sinHalfLat * sinHalfLat + Math.cos(DoubleExtensionsKt.toRadians(lat1)) * Math.cos(DoubleExtensionsKt.toRadians(lat2)) * sinHalfLon * sinHalfLon;
        return (double)2 * R * (double)1000 * Math.asin(Math.sqrt(a));
    }

    public final double getDistance(@NotNull KLatLon l1, @NotNull KLatLon l2) {
        Intrinsics.checkNotNullParameter((Object)l1, (String)"l1");
        Intrinsics.checkNotNullParameter((Object)l2, (String)"l2");
        return this.getDistance(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude());
    }

    public final double getDistance(@NotNull KLatLon l, double latitude, double longitude) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return this.getDistance(l.getLatitude(), l.getLongitude(), latitude, longitude);
    }

    public final double scalarMultiplication(double xA, double yA, double xB, double yB, double xC, double yC) {
        return (xB - xA) * (xC - xA) + (yB - yA) * (yC - yA);
    }

    @NotNull
    public final KLatLon calculateMidPoint(@NotNull KLatLon s1, @NotNull KLatLon s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        double[] latLon = this.calculateMidPoint(s1.getLatitude(), s1.getLongitude(), s2.getLatitude(), s2.getLongitude());
        return new KLatLon(latLon[0], latLon[1]);
    }

    @NotNull
    public final double[] calculateMidPoint(double firstLat, double firstLon, double secondLat, double secondLon) {
        double lat1 = firstLat / (double)180 * Math.PI;
        double lon1 = firstLon / (double)180 * Math.PI;
        double lat2 = secondLat / (double)180 * Math.PI;
        double lon2 = secondLon / (double)180 * Math.PI;
        double Bx = Math.cos(lat2) * Math.cos(lon2 - lon1);
        double By = Math.cos(lat2) * Math.sin(lon2 - lon1);
        double latMid = Math.atan2(Math.sin(lat1) + Math.sin(lat2), Math.sqrt((Math.cos(lat1) + Bx) * (Math.cos(lat1) + Bx) + By * By));
        double lonMid = lon1 + Math.atan2(By, Math.cos(lat1) + Bx);
        double[] dArray = new double[]{this.checkLatitude(latMid * (double)180 / Math.PI), this.checkLongitude(lonMid * (double)180 / Math.PI)};
        return dArray;
    }

    @NotNull
    public final KLatLon calculateIntermediatePoint(double fromLat, double fromLon, double toLat, double toLon, double coeff) {
        double lat1 = DoubleExtensionsKt.toRadians(fromLat);
        double lon1 = DoubleExtensionsKt.toRadians(fromLon);
        double lat2 = DoubleExtensionsKt.toRadians(toLat);
        double lon2 = DoubleExtensionsKt.toRadians(toLon);
        double lat1Cos = Math.cos(lat1);
        double lat2Cos = Math.cos(lat2);
        double d = (double)2 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / (double)2), 2.0) + lat1Cos * lat2Cos * Math.pow(Math.sin((lon1 - lon2) / (double)2), 2.0)));
        double A = Math.sin((1.0 - coeff) * d) / Math.sin(d);
        double B = Math.sin(coeff * d) / Math.sin(d);
        double x = A * lat1Cos * Math.cos(lon1) + B * lat2Cos * Math.cos(lon2);
        double y = A * lat1Cos * Math.sin(lon1) + B * lat2Cos * Math.sin(lon2);
        double z = A * Math.sin(lat1) + B * Math.sin(lat2);
        double lat = Math.atan2(z, Math.sqrt(x * x + y * y));
        double lon = Math.atan2(y, x);
        return new KLatLon(this.checkLatitude(lat * (double)180 / Math.PI), this.checkLongitude(lon * (double)180 / Math.PI));
    }

    public final double getOrthogonalDistance(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        return this.getDistance(this.getProjection(lat, lon, fromLat, fromLon, toLat, toLon), lat, lon);
    }

    @NotNull
    public final KLatLon getProjection(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        double mDist = Math.pow(fromLat - toLat, 2.0) + Math.pow(fromLon - toLon, 2.0);
        double projection = this.scalarMultiplication(fromLat, fromLon, toLat, toLon, lat, lon);
        double prlat = 0.0;
        double prlon = 0.0;
        if (projection < 0.0) {
            prlat = fromLat;
            prlon = fromLon;
        } else if (projection >= mDist) {
            prlat = toLat;
            prlon = toLon;
        } else {
            prlat = fromLat + (toLat - fromLat) * (projection / mDist);
            prlon = fromLon + (toLon - fromLon) * (projection / mDist);
        }
        return new KLatLon(prlat, prlon);
    }

    public final double getProjectionCoeff(double lat, double lon, double fromLat, double fromLon, double toLat, double toLon) {
        double mDist = Math.pow(fromLat - toLat, 2.0) + Math.pow(fromLon - toLon, 2.0);
        double projection = this.scalarMultiplication(fromLat, fromLon, toLat, toLon, lat, lon);
        return projection < 0.0 ? 0.0 : (projection >= mDist ? 1.0 : projection / mDist);
    }

    public final double checkLongitude(double longitude) {
        double adjustedLongitude;
        boolean bl = -180.0 <= longitude ? longitude <= 180.0 : false;
        if (bl) {
            return longitude;
        }
        for (adjustedLongitude = longitude; adjustedLongitude <= -180.0 || adjustedLongitude > 180.0; adjustedLongitude += adjustedLongitude < 0.0 ? 360.0 : -360.0) {
        }
        return adjustedLongitude;
    }

    public final double checkLatitude(double latitude) {
        double adjustedLatitude;
        boolean bl = -85.0511 <= latitude ? latitude <= 85.0511 : false;
        if (bl) {
            return latitude;
        }
        for (adjustedLatitude = latitude; adjustedLatitude < -90.0 || adjustedLatitude > 90.0; adjustedLatitude += adjustedLatitude < 0.0 ? 180.0 : -180.0) {
        }
        return RangesKt.coerceIn((double)adjustedLatitude, (double)-85.0511, (double)85.0511);
    }

    public final int get31TileNumberX(double longitude) {
        double checkedLongitude = this.checkLongitude(longitude);
        long l = 0x80000000L;
        return (int)((checkedLongitude + 180.0) / 360.0 * (double)l);
    }

    public final int get31TileNumberY(double latitude) {
        double checkedLatitude = this.checkLatitude(latitude);
        double eval = Math.log(Math.tan(DoubleExtensionsKt.toRadians(checkedLatitude)) + 1.0 / Math.cos(DoubleExtensionsKt.toRadians(checkedLatitude)));
        long l = 0x80000000L;
        return (int)((1.0 - eval / Math.PI) / (double)2 * (double)l);
    }

    public final double get31LongitudeX(int tileX) {
        return this.getLongitudeFromTile(21.0, (double)tileX / 1024.0);
    }

    public final double get31LatitudeY(int tileY) {
        return this.getLatitudeFromTile(21.0, (double)tileY / 1024.0);
    }

    public final double getTileNumberX(double zoom, double longitude) {
        double powZoom;
        double checkedLongitude = this.checkLongitude(longitude);
        double dz = (checkedLongitude + 180.0) / 360.0 * (powZoom = this.getPowZoom(zoom));
        return dz >= powZoom ? powZoom - 0.01 : dz;
    }

    public final double getTileNumberY(double zoom, double latitude) {
        double checkedLatitude = this.checkLatitude(latitude);
        double eval = Math.log(Math.tan(DoubleExtensionsKt.toRadians(checkedLatitude)) + 1.0 / Math.cos(DoubleExtensionsKt.toRadians(checkedLatitude)));
        if (Double.isInfinite(eval) || Double.isNaN(eval)) {
            checkedLatitude = checkedLatitude < 0.0 ? -89.9 : 89.9;
            eval = Math.log(Math.tan(DoubleExtensionsKt.toRadians(checkedLatitude)) + 1.0 / Math.cos(DoubleExtensionsKt.toRadians(checkedLatitude)));
        }
        return (1.0 - eval / Math.PI) / (double)2 * this.getPowZoom(zoom);
    }

    public final double getTileEllipsoidNumberY(double zoom, double latitude) {
        double E2 = latitude * Math.PI / (double)180;
        double sradiusa = 6378137.0;
        double sradiusb = 6356752.0;
        double J2 = Math.sqrt(sradiusa * sradiusa - sradiusb * sradiusb) / sradiusa;
        double M2 = Math.log((1.0 + Math.sin(E2)) / (1.0 - Math.sin(E2))) / (double)2 - J2 * Math.log((1.0 + J2 * Math.sin(E2)) / (1.0 - J2 * Math.sin(E2))) / (double)2;
        double B2 = this.getPowZoom(zoom);
        return B2 / (double)2 - M2 * B2 / (double)2 / Math.PI;
    }

    @NotNull
    public final double[] getTileEllipsoidNumberAndOffsetY(int zoom, double latitude, int tileSize) {
        double E2 = latitude * Math.PI / (double)180;
        double sradiusa = 6378137.0;
        double sradiusb = 6356752.0;
        double J2 = Math.sqrt(sradiusa * sradiusa - sradiusb * sradiusb) / sradiusa;
        double M2 = Math.log((1.0 + Math.sin(E2)) / (1.0 - Math.sin(E2))) / (double)2 - J2 * Math.log((1.0 + J2 * Math.sin(E2)) / (1.0 - J2 * Math.sin(E2))) / (double)2;
        double B2 = this.getPowZoom(zoom);
        double tileY = B2 / (double)2 - M2 * B2 / (double)2 / Math.PI;
        double tilesCount = 1 << zoom;
        double yTileNumber = Math.floor(tilesCount * (0.5 - M2 / (double)2 / Math.PI));
        double offsetY = Math.floor((tilesCount * (0.5 - M2 / (double)2 / Math.PI) - yTileNumber) * (double)tileSize);
        double[] dArray = new double[]{tileY, offsetY};
        return dArray;
    }

    public final double getLatitudeFromEllipsoidTileY(double zoom, double tileNumberY) {
        double MerkElipsK = 1.0E-7;
        double sradiusa = 6378137.0;
        double sradiusb = 6356752.0;
        double FExct = Math.sqrt(sradiusa * sradiusa - sradiusb * sradiusb) / sradiusa;
        double TilesAtZoom = this.getPowZoom(zoom);
        double result = (tileNumberY - TilesAtZoom / (double)2) / -(TilesAtZoom / (Math.PI * 2));
        result = ((double)2 * Math.atan(Math.exp(result)) - 1.5707963267948966) * (double)180 / Math.PI;
        double Zu = result / 57.29577951308232;
        double yy = tileNumberY - TilesAtZoom / (double)2;
        double Zum1 = Zu;
        Zu = Math.asin(1.0 - (1.0 + Math.sin(Zum1)) * Math.pow(1.0 - FExct * Math.sin(Zum1), FExct) / (Math.exp((double)2 * yy / -(TilesAtZoom / (Math.PI * 2))) * Math.pow(1.0 + FExct * Math.sin(Zum1), FExct)));
        while (Math.abs(Zum1 - Zu) >= MerkElipsK) {
            Zum1 = Zu;
            Zu = Math.asin(1.0 - (1.0 + Math.sin(Zum1)) * Math.pow(1.0 - FExct * Math.sin(Zum1), FExct) / (Math.exp((double)2 * yy / -(TilesAtZoom / (Math.PI * 2))) * Math.pow(1.0 + FExct * Math.sin(Zum1), FExct)));
        }
        return Zu * (double)180 / Math.PI;
    }

    public final double getTileDistanceWidth(double zoom) {
        return this.getTileDistanceWidth(30.0, zoom);
    }

    public final double getTileDistanceWidth(double lat, double zoom) {
        KLatLon ll = new KLatLon(lat, this.getLongitudeFromTile(zoom, 0.0));
        KLatLon ll2 = new KLatLon(lat, this.getLongitudeFromTile(zoom, 1.0));
        return this.getDistance(ll, ll2);
    }

    public final double getTileDistanceHeight(double lat, double zoom) {
        double y = this.getTileNumberY(zoom, lat);
        KLatLon ll = new KLatLon(this.getLatitudeFromTile(zoom, Math.floor(y)), 0.0);
        KLatLon ll2 = new KLatLon(this.getLatitudeFromTile(zoom, Math.floor(y) + 1.0), 0.0);
        return this.getDistance(ll, ll2);
    }

    public final double getLongitudeFromTile(double zoom, double x) {
        return x / this.getPowZoom(zoom) * 360.0 - 180.0;
    }

    public final double getPowZoom(double zoom) {
        return zoom >= 0.0 && zoom - Math.floor(zoom) < (double)0.001f ? (double)(1 << (int)zoom) : Math.pow(2.0, zoom);
    }

    public final float calcDiffPixelX(float rotateSin, float rotateCos, float dTileX, float dTileY, float tileSize) {
        return (rotateCos * dTileX - rotateSin * dTileY) * tileSize;
    }

    public final float calcDiffPixelY(float rotateSin, float rotateCos, float dTileX, float dTileY, float tileSize) {
        return (rotateSin * dTileX + rotateCos * dTileY) * tileSize;
    }

    public final double getLatitudeFromTile(double zoom, double y) {
        int sign = y < 0.0 ? -1 : 1;
        return Math.atan((double)sign * Math.sinh(Math.PI * (1.0 - (double)2 * y / this.getPowZoom(zoom)))) * (double)180 / Math.PI;
    }

    public final int getPixelShiftX(double zoom, double long1, double long2, double tileSize) {
        return (int)((this.getTileNumberX(zoom, long1) - this.getTileNumberX(zoom, long2)) * tileSize);
    }

    public final int getPixelShiftY(double zoom, double lat1, double lat2, double tileSize) {
        return (int)((this.getTileNumberY(zoom, lat1) - this.getTileNumberY(zoom, lat2)) * tileSize);
    }

    @NotNull
    public final String buildGeoUrl(@NotNull String latitude, @NotNull String longitude, int zoom) {
        Intrinsics.checkNotNullParameter((Object)latitude, (String)"latitude");
        Intrinsics.checkNotNullParameter((Object)longitude, (String)"longitude");
        return "geo:" + latitude + "," + longitude + "?z=" + zoom;
    }

    @NotNull
    public final String buildShortOsmUrl(double latitude, double longitude, int zoom) {
        return BASE_SHORT_OSM_URL + this.createShortLinkString(latitude, longitude, zoom) + "?m";
    }

    @NotNull
    public final String createShortLinkString(double latitude, double longitude, int zoom) {
        long lat = (long)((latitude + (double)90) / (double)180 * (double)0x100000000L);
        long lon = (long)((longitude + (double)180) / (double)360 * (double)0x100000000L);
        long code = this.interleaveBits(lon, lat);
        Object str = "";
        int n = (int)Math.ceil((double)(zoom + 8) / 3.0);
        for (int i = 0; i < n; ++i) {
            str = (String)str + intToBase64[(int)(code >> 58 - 6 * i & 0x3FL)];
        }
        n = (zoom + 8) % 3;
        for (int j = 0; j < n; ++j) {
            str = (String)str + "-";
        }
        return str;
    }

    public final long interleaveBits(long x, long y) {
        long c = 0L;
        for (int b = 31; -1 < b; --b) {
            c = c << 1 | x >> b & 1L;
            c = c << 1 | y >> b & 1L;
        }
        return c;
    }

    public final float unifyRotationDiff(float rotate, float targetRotate) {
        float d;
        for (d = targetRotate - rotate; d >= 180.0f; d -= (float)360) {
        }
        while (d < -180.0f) {
            d += (float)360;
        }
        return d;
    }

    public final float unifyRotationTo360(float rotate) {
        float rotateVar;
        for (rotateVar = rotate; rotateVar < -180.0f; rotateVar += (float)360) {
        }
        while (rotateVar > 180.0f) {
            rotateVar -= (float)360;
        }
        return rotateVar;
    }

    public final float normalizeDegrees360(float degrees) {
        float degreesVar;
        for (degreesVar = degrees; degreesVar < 0.0f; degreesVar += 360.0f) {
        }
        while (degreesVar >= 360.0f) {
            degreesVar -= 360.0f;
        }
        return degreesVar;
    }

    public final double alignAngleDifference(double diff) {
        double diffVar;
        for (diffVar = diff; diffVar > Math.PI; diffVar -= Math.PI * 2) {
        }
        while (diffVar <= -Math.PI) {
            diffVar += Math.PI * 2;
        }
        return diffVar;
    }

    public final double degreesDiff(double a1, double a2) {
        double diff;
        for (diff = a1 - a2; diff > 180.0; diff -= (double)360) {
        }
        while (diff <= -180.0) {
            diff += (double)360;
        }
        return diff;
    }

    public final double squareRootDist31(int x1, int y1, int x2, int y2) {
        return Math.sqrt(this.squareDist31TileMetric(x1, y1, x2, y2));
    }

    public final double measuredDist31(int x1, int y1, int x2, int y2) {
        return this.getDistance(this.get31LatitudeY(y1), this.get31LongitudeX(x1), this.get31LatitudeY(y2), this.get31LongitudeX(x2));
    }

    public final double squareDist31TileMetric(int x1, int y1, int x2, int y2) {
        boolean top2;
        boolean top1 = y1 > 0x40000000;
        boolean bl = top2 = y2 > 0x40000000;
        if (top1 != top2 && y1 != 0x40000000 && y2 != 0x40000000) {
            int mx = x1 / 2 + x2 / 2;
            double d1 = Math.sqrt(this.squareDist31TileMetric(mx, 0x40000000, x2, y2));
            double d2 = Math.sqrt(this.squareDist31TileMetric(mx, 0x40000000, x1, y1));
            return Math.pow(d1 + d2, 2.0);
        }
        int ymidx = y1 / 2 + y2 / 2;
        double tw2 = ((Number)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Double>, Object>(ymidx, null){
            int label;
            final /* synthetic */ int $ymidx;
            {
                this.$ymidx = $ymidx;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = KMapUtils.access$getTileWidth(KMapUtils.INSTANCE, this.$ymidx, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Double> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).doubleValue();
        double dy = (double)(y1 - y2) * tw2;
        double dx = (double)(x2 - x1) * tw2;
        return dx * dx + dy * dy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object getTileWidth(int var1_1, Continuation<? super Double> $completion) {
        if (!($completion instanceof getTileWidth.1)) ** GOTO lbl-1000
        var20_3 = $completion;
        if ((var20_3.label & -2147483648) != 0) {
            var20_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                double D$0;
                /* synthetic */ Object result;
                final /* synthetic */ KMapUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KMapUtils.access$getTileWidth(this.this$0, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                y = (double)y31 / 131072.0;
                tileY = new Ref.IntRef();
                tileY.element = (int)y;
                ry = y - (double)tileY.element;
                d = new Ref.ObjectRef();
                dp = new Ref.ObjectRef();
                try {
                    d.element = KMapUtils.DIST_CACHE.get(Boxing.boxInt((int)tileY.element));
                }
                catch (RuntimeException var10_11) {
                    // empty catch block
                }
                if (d.element != null) ** GOTO lbl63
                $this$withLock_u24default$iv = KMapUtils.distCacheMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = tileY;
                $continuation.L$1 = d;
                $continuation.L$2 = dp;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.D$0 = ry;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var21_5) {
                    return var21_5;
                }
                ** GOTO lbl49
            }
            case 1: {
                $i$f$withLock = false;
                ry = $continuation.D$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                dp = (Ref.ObjectRef)$continuation.L$2;
                d = (Ref.ObjectRef)$continuation.L$1;
                tileY = (Ref.IntRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl49:
                // 2 sources

                try {
                    $i$a$-withLock$default-KMapUtils$getTileWidth$2 = false;
                    td = KMapUtils.INSTANCE.getTileDistanceWidth(KMapUtils.INSTANCE.get31LatitudeY(tileY.element << 17), 14.0) / (double)131072;
                    d.element = Boxing.boxDouble((double)td);
                    var16_19 = Boxing.boxDouble((double)td);
                    KMapUtils.DIST_CACHE.put(Boxing.boxInt((int)tileY.element), var16_19);
                    var17_20 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
lbl63:
                // 2 sources

                ++tileY.element;
                try {
                    dp.element = KMapUtils.DIST_CACHE.get(Boxing.boxInt((int)tileY.element));
                }
                catch (RuntimeException $this$withLock_u24default$iv) {
                    // empty catch block
                }
                if (dp.element != null) ** GOTO lbl109
                $this$withLock_u24default$iv = KMapUtils.distCacheMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = tileY;
                $continuation.L$1 = d;
                $continuation.L$2 = dp;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.D$0 = ry;
                $continuation.label = 2;
                v1 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v1 == var21_5) {
                    return var21_5;
                }
                ** GOTO lbl95
            }
            case 2: {
                $i$f$withLock = false;
                ry = $continuation.D$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                dp = (Ref.ObjectRef)$continuation.L$2;
                d = (Ref.ObjectRef)$continuation.L$1;
                tileY = (Ref.IntRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl95:
                // 2 sources

                try {
                    $i$a$-withLock$default-KMapUtils$getTileWidth$3 = false;
                    tdp = KMapUtils.INSTANCE.getTileDistanceWidth(KMapUtils.INSTANCE.get31LatitudeY(tileY.element << 17), 14.0) / (double)131072;
                    dp.element = Boxing.boxDouble((double)tdp);
                    var16_19 = Boxing.boxDouble((double)tdp);
                    KMapUtils.DIST_CACHE.put(Boxing.boxInt((int)tileY.element), var16_19);
                    var17_20 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
lbl109:
                // 2 sources

                v2 = dp.element;
                Intrinsics.checkNotNull((Object)v2);
                v3 = ry * ((Number)v2).doubleValue();
                v4 = (double)true - ry;
                v5 = d.element;
                Intrinsics.checkNotNull((Object)v5);
                return Boxing.boxDouble((double)(v3 + v4 * ((Number)v5).doubleValue()));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean rightSide(double lat, double lon, double aLat, double aLon, double bLat, double bLon) {
        double ax = aLon - lon;
        double by = bLat - lat;
        double bx = bLon - lon;
        double ay = aLat - lat;
        double sa = ax * by - bx * ay;
        return sa < 0.0;
    }

    public final long deinterleaveY(long coord) {
        long x = 0L;
        for (int b = 31; -1 < b; --b) {
            x = x << 1 | (1L & coord) >> b * 2;
        }
        return x;
    }

    public final long deinterleaveX(long coord) {
        long x = 0L;
        for (int b = 31; -1 < b; --b) {
            x = x << 1 | (1L & coord) >> b * 2 + 1;
        }
        return x;
    }

    @NotNull
    public final KQuadRect calculateLatLonBbox(double latitude, double longitude, int radiusMeters) {
        double zoom = 16.0;
        double coeff = (double)radiusMeters / this.getTileDistanceWidth(zoom);
        double tx = this.getTileNumberX(zoom, longitude);
        double ty = this.getTileNumberY(zoom, latitude);
        double topLeftX = Math.max(0.0, tx - coeff);
        double topLeftY = Math.max(0.0, ty - coeff);
        int max = (1 << (int)zoom) - 1;
        double bottomRightX = Math.min((double)max, tx + coeff);
        double bottomRightY = Math.min((double)max, ty + coeff);
        double pw = this.getPowZoom((double)31 - zoom);
        KQuadRect rect = new KQuadRect(topLeftX * pw, topLeftY * pw, bottomRightX * pw, bottomRightY * pw);
        rect.setLeft(this.get31LongitudeX((int)rect.getLeft()));
        rect.setTop(this.get31LatitudeY((int)rect.getTop()));
        rect.setRight(this.get31LongitudeX((int)rect.getRight()));
        rect.setBottom(this.get31LatitudeY((int)rect.getBottom()));
        return rect;
    }

    public final float getInterpolatedY(float x1, float y1, float x2, float y2, float x) {
        float f;
        float a = y1 - y2;
        float b = x2 - x1;
        float d = -a * b;
        if (!(d == 0.0f)) {
            float c1 = y2 * x1 - x2 * y1;
            float c2 = x * (y2 - y1);
            f = a * (c1 - c2) / d;
        } else {
            f = y1;
        }
        return f;
    }

    public final void insetLatLonRect(@NotNull KQuadRect r, double latitude, double longitude) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (r.getLeft() == 0.0 && r.getRight() == 0.0) {
            r.setLeft(longitude);
            r.setRight(longitude);
            r.setTop(latitude);
            r.setBottom(latitude);
        } else {
            r.setLeft(Math.min(r.getLeft(), longitude));
            r.setRight(Math.max(r.getRight(), longitude));
            r.setTop(Math.max(r.getTop(), latitude));
            r.setBottom(Math.min(r.getBottom(), latitude));
        }
    }

    public final boolean areLatLonEqual(@Nullable KLatLon l1, @Nullable KLatLon l2) {
        return l1 == null && l2 == null || l2 != null && this.areLatLonEqual(l1, l2.getLatitude(), l2.getLongitude());
    }

    public final boolean areLatLonEqual(@Nullable KLatLon l, double lat, double lon) {
        return l != null && this.areLatLonEqual(l.getLatitude(), l.getLongitude(), lat, lon);
    }

    public final boolean areLatLonEqual(double lat1, double lon1, double lat2, double lon2) {
        return this.areLatLonEqual(lat1, lon1, lat2, lon2, 1.0E-5);
    }

    public final boolean areLatLonEqual(@Nullable KLatLon l1, @Nullable KLatLon l2, double precision) {
        return l1 == null && l2 == null || l1 != null && l2 != null && this.areLatLonEqual(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude(), precision);
    }

    public final boolean areLatLonEqual(double lat1, double lon1, double lat2, double lon2, double precision) {
        return Math.abs(lat1 - lat2) < precision && Math.abs(lon1 - lon2) < precision;
    }

    @NotNull
    public final KLatLon rhumbDestinationPoint(@NotNull KLatLon latLon, double distance, double bearing) {
        Intrinsics.checkNotNullParameter((Object)latLon, (String)"latLon");
        return this.rhumbDestinationPoint(latLon.getLatitude(), latLon.getLongitude(), distance, bearing);
    }

    @NotNull
    public final KLatLon rhumbDestinationPoint(double lat, double lon, double distance, double bearing) {
        double radius = 6378137.0;
        double d = distance / radius;
        double phi1 = DoubleExtensionsKt.toRadians(lat);
        double lambda1 = DoubleExtensionsKt.toRadians(lon);
        double theta = DoubleExtensionsKt.toRadians(bearing);
        double deltaPhi = d * Math.cos(theta);
        double phi2 = phi1 + deltaPhi;
        double deltaPsi = Math.log(Math.tan(phi2 / (double)2 + 0.7853981633974483) / Math.tan(phi1 / (double)2 + 0.7853981633974483));
        double q = Math.abs(deltaPsi) > 1.0E-11 ? deltaPhi / deltaPsi : Math.cos(phi1);
        double deltaLambda = d * Math.sin(theta) / q;
        double lambda2 = lambda1 + deltaLambda;
        return new KLatLon(DoubleExtensionsKt.toDegrees(phi2), DoubleExtensionsKt.toDegrees(lambda2));
    }

    public final double getSqrtDistance(int startX, int startY, int endX, int endY) {
        return Math.sqrt((endX - startX) * (endX - startX) + (endY - startY) * (endY - startY));
    }

    public final double getSqrtDistance(float startX, float startY, float endX, float endY) {
        return Math.sqrt((double)((endX - startX) * (endX - startX)) + (double)(endY - startY) * (double)(endY - startY));
    }

    @NotNull
    public final String convertDistToChar(int dist, char firstLetter, int firstDist, int mult1, int mult2) {
        int iteration = 0;
        int currentDist = firstDist;
        while (dist - currentDist > 0) {
            currentDist *= ++iteration % 2 == 1 ? mult1 : mult2;
        }
        return String.valueOf((char)(firstLetter + iteration));
    }

    public final int convertCharToDist(char ch, char firstLetter, int firstDist, int mult1, int mult2) {
        int dist = firstDist;
        int n = ch - firstLetter + 1;
        for (int iteration = 1; iteration < n; ++iteration) {
            dist *= iteration % 2 == 1 ? mult1 : mult2;
        }
        return dist;
    }

    public static final /* synthetic */ Object access$getTileWidth(KMapUtils $this, int y31, Continuation $completion) {
        return $this.getTileWidth(y31, (Continuation<? super Double>)$completion);
    }

    static {
        char[] cArray = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '~'};
        intToBase64 = cArray;
        DIST_CACHE = new LinkedHashMap();
        distCacheMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }
}

