/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.util.KMapUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lnet/osmand/shared/util/KMapAlgorithms;", "", "<init>", "()V", "augmentTrkSegmentWithAltitudes", "", "sgm", "Lnet/osmand/shared/gpx/primitives/TrkSegment;", "decodedSteps", "", "", "startEle", "", "decodeIntHeightArrayGraph", "str", "", "repeatBits", "OsmAnd-shared"})
public final class KMapAlgorithms {
    @NotNull
    public static final KMapAlgorithms INSTANCE = new KMapAlgorithms();

    private KMapAlgorithms() {
    }

    public final void augmentTrkSegmentWithAltitudes(@NotNull TrkSegment sgm, @NotNull List<Integer> decodedSteps, double startEle) {
        Intrinsics.checkNotNullParameter((Object)sgm, (String)"sgm");
        Intrinsics.checkNotNullParameter(decodedSteps, (String)"decodedSteps");
        int stepDist = ((Number)decodedSteps.get(0)).intValue();
        int stepHNextInd = 1;
        double prevHDistX = 0.0;
        sgm.getPoints().get(0).setEle(startEle);
        for (int i = 1; i < sgm.getPoints().size(); ++i) {
            WptPt prev = sgm.getPoints().get(i - 1);
            WptPt cur = sgm.getPoints().get(i);
            double origHDistX = prevHDistX;
            double len = KMapUtils.INSTANCE.getDistance(prev.getLat(), prev.getLon(), cur.getLat(), cur.getLon()) / (double)stepDist;
            double curHDistX = len + prevHDistX;
            double hInc = 0.0;
            while (curHDistX > (double)stepHNextInd && stepHNextInd < decodedSteps.size()) {
                if (prevHDistX < (double)stepHNextInd) {
                    hInc += ((double)stepHNextInd - prevHDistX) * ((Number)decodedSteps.get(stepHNextInd)).doubleValue();
                    if ((double)stepHNextInd - prevHDistX > 0.5) {
                        double fraction = ((double)stepHNextInd - prevHDistX) / (curHDistX - origHDistX);
                        WptPt newPt = new WptPt(prev.getLat() + fraction * (cur.getLat() - prev.getLat()), prev.getLon() + fraction * (cur.getLon() - prev.getLon()));
                        newPt.setEle(prev.getEle() + hInc);
                        sgm.getPoints().add(i, newPt);
                        ++i;
                    }
                    prevHDistX = stepHNextInd;
                }
                ++stepHNextInd;
            }
            if (stepHNextInd < decodedSteps.size()) {
                hInc += (curHDistX - prevHDistX) * ((Number)decodedSteps.get(stepHNextInd)).doubleValue();
            }
            cur.setEle(prev.getEle() + hInc);
            prevHDistX = curHDistX;
        }
    }

    @NotNull
    public final List<Integer> decodeIntHeightArrayGraph(@NotNull String str, int repeatBits) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        int maxRepeats = (1 << repeatBits) - 1;
        List res = new ArrayList();
        char[] cArray = str.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] ch = cArray;
        res.add(Integer.valueOf(ch[0]));
        int n = ch.length;
        for (int i = 1; i < n; ++i) {
            char c = ch[i];
            for (int rept = c & maxRepeats; rept > 0; --rept) {
                res.add(0);
            }
            int num = c >> repeatBits;
            boolean bl = num % 2 == 0 ? res.add(num >> 1) : res.add(-(num >> 1));
        }
        return res;
    }
}

