/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.extensions.StringExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tJ\u0018\u0010\u0006\u001a\u00020\u00072\u0010\u0010\n\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000bJ!\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J#\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000e\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0019J\u001a\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u001eJ\u0018\u0010!\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u0017J\u0018\u0010\"\u001a\u00020#2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020#J\u0018\u0010$\u001a\u00020%2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020%J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0017J\u000e\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0011J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110+2\u0006\u0010\u0012\u001a\u00020\u0011J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110+2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011J\u001a\u0010-\u001a\u00020\u0011\"\u0004\b\u0000\u0010\f2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\f0\tJ\"\u0010-\u001a\u00020\u0011\"\u0004\b\u0000\u0010\f2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H\f0\t2\u0006\u0010,\u001a\u00020\u0011J\u001e\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020#J\u0016\u00105\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00106\u001a\u000202J\u0012\u00107\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lnet/osmand/shared/util/KAlgorithms;", "", "<init>", "()V", "CHAR_TO_SPLIT", "", "isEmpty", "", "c", "", "map", "", "T", "array", "", "([Ljava/lang/Object;)Z", "emptyIfNull", "", "s", "trimIfNotNull", "", "isBlank", "hash", "", "values", "([Ljava/lang/Object;)I", "stringsEqual", "s1", "s2", "parseLongSilently", "", "input", "def", "parseIntSilently", "parseDoubleSilently", "", "parseFloatSilently", "", "colorToString", "color", "parseColor", "colorString", "decodeStringSet", "", "split", "encodeCollection", "collection", "extendRectToContainPoint", "", "mapRect", "Lnet/osmand/shared/data/KQuadRect;", "longitude", "latitude", "extendRectToContainRect", "gpxRect", "capitalizeFirstLetter", "OsmAnd-shared"})
public final class KAlgorithms {
    @NotNull
    public static final KAlgorithms INSTANCE = new KAlgorithms();
    private static final char CHAR_TO_SPLIT = ',';

    private KAlgorithms() {
    }

    public final boolean isEmpty(@Nullable Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public final boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public final <T> boolean isEmpty(@Nullable T[] array) {
        T[] TArray = array;
        return TArray == null || TArray.length == 0;
    }

    @NotNull
    public final String emptyIfNull(@Nullable String s) {
        String string = s;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final String trimIfNotNull(@Nullable String s) {
        String string = s;
        return string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
    }

    public final boolean isEmpty(@Nullable CharSequence s) {
        CharSequence charSequence = s;
        return charSequence == null || charSequence.length() == 0;
    }

    public final boolean isBlank(@Nullable String s) {
        return s == null || ((CharSequence)((Object)StringsKt.trim((CharSequence)s)).toString()).length() == 0;
    }

    public final int hash(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return Arrays.hashCode(values);
    }

    public final boolean stringsEqual(@Nullable String s1, @Nullable String s2) {
        return Intrinsics.areEqual((Object)s1, (Object)s2);
    }

    public final long parseLongSilently(@Nullable String input, long def) {
        long l;
        if (!this.isEmpty(input)) {
            long l2;
            try {
                String string = input;
                l2 = string != null ? Long.parseLong(string) : def;
            }
            catch (NumberFormatException e) {
                l2 = def;
            }
            l = l2;
        } else {
            l = def;
        }
        return l;
    }

    public final int parseIntSilently(@Nullable String input, int def) {
        int n;
        if (!this.isEmpty(input)) {
            int n2;
            try {
                String string = input;
                n2 = string != null ? Integer.parseInt(string) : def;
            }
            catch (NumberFormatException e) {
                n2 = def;
            }
            n = n2;
        } else {
            n = def;
        }
        return n;
    }

    public final double parseDoubleSilently(@Nullable String input, double def) {
        double d;
        if (!this.isEmpty(input)) {
            double d2;
            try {
                String string = input;
                d2 = string != null ? Double.parseDouble(string) : def;
            }
            catch (NumberFormatException e) {
                d2 = def;
            }
            d = d2;
        } else {
            d = def;
        }
        return d;
    }

    public final float parseFloatSilently(@Nullable String input, float def) {
        float f;
        if (!this.isEmpty(input)) {
            float f2;
            try {
                String string = input;
                f2 = string != null ? Float.parseFloat(string) : def;
            }
            catch (NumberFormatException e) {
                f2 = def;
            }
            f = f2;
        } else {
            f = def;
        }
        return f;
    }

    @NotNull
    public final String colorToString(int color) {
        String string;
        if ((0xFF000000 & color) == -16777216) {
            Object[] objectArray = new Object[]{color & 0xFFFFFF};
            string = StringExtensionsKt.format("#%06X", objectArray);
        } else {
            Object[] objectArray = new Object[]{color};
            string = StringExtensionsKt.format("#%08X", objectArray);
        }
        return string;
    }

    public final int parseColor(@NotNull String colorString) {
        Intrinsics.checkNotNullParameter((Object)colorString, (String)"colorString");
        if (StringsKt.startsWith$default((String)colorString, (String)"#", (boolean)false, (int)2, null)) {
            Object colorStr = colorString;
            if (((String)colorStr).length() == 4) {
                colorStr = "#" + ((String)colorStr).charAt(1) + ((String)colorStr).charAt(1) + ((String)colorStr).charAt(2) + ((String)colorStr).charAt(2) + ((String)colorStr).charAt(3) + ((String)colorStr).charAt(3);
            }
            String string = ((String)colorStr).substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            long color = Long.parseLong(string, CharsKt.checkRadix((int)16));
            return switch (((String)colorStr).length()) {
                case 7 -> (int)(color | 0xFF000000L);
                case 9 -> (int)color;
                default -> throw new IllegalArgumentException("Unknown color " + colorString);
            };
        }
        throw new IllegalArgumentException("Unknown color " + colorString);
    }

    @NotNull
    public final Set<String> decodeStringSet(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.decodeStringSet(s, ",");
    }

    @NotNull
    public final Set<String> decodeStringSet(@NotNull String s, @NotNull String split) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)split, (String)"split");
        if (((CharSequence)s).length() == 0) {
            return SetsKt.emptySet();
        }
        String[] stringArray = new String[]{split};
        return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)s, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @NotNull
    public final <T> String encodeCollection(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return this.encodeCollection(collection, ",");
    }

    @NotNull
    public final <T> String encodeCollection(@NotNull Collection<? extends T> collection, @NotNull String split) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)split, (String)"split");
        if (!collection.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (T item : collection) {
                sb.append(item).append(split);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return "";
    }

    public final void extendRectToContainPoint(@NotNull KQuadRect mapRect, double longitude, double latitude) {
        Intrinsics.checkNotNullParameter((Object)mapRect, (String)"mapRect");
        mapRect.setLeft(mapRect.getLeft() == 0.0 ? longitude : Math.min(mapRect.getLeft(), longitude));
        mapRect.setRight(Math.max(mapRect.getRight(), longitude));
        mapRect.setBottom(mapRect.getBottom() == 0.0 ? latitude : Math.min(mapRect.getBottom(), latitude));
        mapRect.setTop(Math.max(mapRect.getTop(), latitude));
    }

    public final void extendRectToContainRect(@NotNull KQuadRect mapRect, @NotNull KQuadRect gpxRect) {
        Intrinsics.checkNotNullParameter((Object)mapRect, (String)"mapRect");
        Intrinsics.checkNotNullParameter((Object)gpxRect, (String)"gpxRect");
        mapRect.setLeft(mapRect.getLeft() == 0.0 ? gpxRect.getLeft() : Math.min(mapRect.getLeft(), gpxRect.getLeft()));
        mapRect.setRight(Math.max(mapRect.getRight(), gpxRect.getRight()));
        mapRect.setTop(Math.max(mapRect.getTop(), gpxRect.getTop()));
        mapRect.setBottom(mapRect.getBottom() == 0.0 ? gpxRect.getBottom() : Math.min(mapRect.getBottom(), gpxRect.getBottom()));
    }

    @Nullable
    public final String capitalizeFirstLetter(@Nullable String s) {
        Object object;
        CharSequence charSequence = s;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string;
            char c = Character.toUpperCase(s.charAt(0));
            if (s.length() > 1) {
                String string2 = s.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = "";
            }
            object = c + string;
        } else {
            object = s;
        }
        return object;
    }
}

