/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.obd;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.osmand.shared.extensions.StringExtensionsKt;
import net.osmand.shared.obd.OBDResponse;
import net.osmand.shared.obd.UnderlyingTransport;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002)*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J)\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\b2\u0006\u0010#\u001a\u00020\bH\u0002J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lnet/osmand/shared/obd/Obd2Connection;", "", "connection", "Lnet/osmand/shared/obd/UnderlyingTransport;", "<init>", "(Lnet/osmand/shared/obd/UnderlyingTransport;)V", "initCommands", "", "", "[Ljava/lang/String;", "log", "Lnet/osmand/shared/util/Logger;", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "runInitCommands", "", "runImpl", "command", "run", "Lnet/osmand/shared/obd/OBDResponse;", "fullCommand", "", "commandType", "Lnet/osmand/shared/obd/Obd2Connection$COMMAND_TYPE;", "toHexValues", "", "buffer", "toDigitValue", "c", "", "removeSideData", "response", "patterns", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "unpackLongFrame", "getSupportedPIDs", "", "COMMAND_TYPE", "FourByteBitSet", "OsmAnd-shared"})
public final class Obd2Connection {
    @NotNull
    private final UnderlyingTransport connection;
    @NotNull
    private final String[] initCommands;
    @NotNull
    private final Logger log;
    private boolean initialized;

    public Obd2Connection(@NotNull UnderlyingTransport connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
        String[] stringArray = new String[]{"ATD", "ATZ", "AT E0", "AT L0", "AT S0", "AT H0", "AT SP 0"};
        this.initCommands = stringArray;
        this.log = LoggerFactory.INSTANCE.getLogger("Obd2Connection");
        try {
            this.runInitCommands();
            this.initialized = true;
        }
        catch (IOException error) {
            this.connection.onInitFailed();
        }
    }

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    private final void runInitCommands() {
        for (String command : this.initCommands) {
            this.runImpl(command);
        }
    }

    private final String runImpl(String command) {
        StringBuilder response = new StringBuilder();
        this.log.debug("runImpl(" + command + ")");
        this.connection.write(StringsKt.encodeToByteArray((String)(command + "\r")));
        while (true) {
            Byte by = this.connection.readByte();
            if (by == null) {
                continue;
            }
            byte value = by;
            char c = (char)value;
            if (c == '>') break;
            if (c == '\r' || c == '\n' || c == ' ' || c == '\t' || c == '.') continue;
            response.append(c);
        }
        String string = response.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String responseValue = string;
        this.log.debug("runImpl() returned " + responseValue);
        return responseValue;
    }

    @NotNull
    public final OBDResponse run(@NotNull String fullCommand, int command, @NotNull COMMAND_TYPE commandType) {
        Intrinsics.checkNotNullParameter((Object)fullCommand, (String)"fullCommand");
        Intrinsics.checkNotNullParameter((Object)((Object)commandType), (String)"commandType");
        this.log.debug("before runImpl");
        String response = this.runImpl(fullCommand);
        this.log.debug("after runImpl");
        String originalResponseValue = response;
        String unspacedCommand = StringsKt.replace$default((String)fullCommand, (String)" ", (String)"", (boolean)false, (int)4, null);
        if (StringsKt.startsWith$default((String)response, (String)unspacedCommand, (boolean)false, (int)2, null)) {
            String string = response.substring(unspacedCommand.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            response = string;
        }
        response = this.unpackLongFrame(response);
        this.log.debug("post-processed response " + response);
        Object object = new String[]{"SEARCHING", "ERROR", "BUS INIT", "BUSINIT", "BUS ERROR", "BUSERROR", "STOPPED"};
        response = this.removeSideData(response, (String[])object);
        this.log.debug("post-processed response without side data " + response);
        switch (response) {
            case "OK": {
                return OBDResponse.Companion.getOK();
            }
            case "?": {
                return OBDResponse.Companion.getQUESTION_MARK();
            }
            case "NODATA": {
                return OBDResponse.Companion.getNO_DATA();
            }
            case "UNABLETOCONNECT": {
                Logger.error$default(this.log, "connection failure", null, 2, null);
                return OBDResponse.Companion.getERROR();
            }
            case "CANERROR": {
                Logger.error$default(this.log, "CAN bus error", null, 2, null);
                return OBDResponse.Companion.getERROR();
            }
        }
        try {
            int[] hexValues = this.toHexValues(response);
            if (hexValues.length < 3 || hexValues[0] != commandType.getCode() || hexValues[1] != command) {
                this.log.debug("Incorrect answer data (size " + hexValues.length + ") for " + fullCommand);
            } else {
                int[] nArray = hexValues;
                int n = 2;
                int n2 = hexValues.length;
                hexValues = ArraysKt.copyOfRange((int[])nArray, (int)n, (int)n2);
            }
            return new OBDResponse(hexValues);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Conversion error: command: '" + fullCommand + "', original response: '" + originalResponseValue + "', processed response: '" + response + "'");
            return OBDResponse.Companion.getERROR();
        }
    }

    public static /* synthetic */ OBDResponse run$default(Obd2Connection obd2Connection, String string, int n, COMMAND_TYPE cOMMAND_TYPE, int n2, Object object) {
        if ((n2 & 4) != 0) {
            cOMMAND_TYPE = COMMAND_TYPE.LIVE;
        }
        return obd2Connection.run(string, n, cOMMAND_TYPE);
    }

    private final int[] toHexValues(String buffer) {
        int[] values = new int[buffer.length() / 2];
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            values[i] = 16 * this.toDigitValue(buffer.charAt(2 * i)) + this.toDigitValue(buffer.charAt(2 * i + 1));
        }
        return values;
    }

    private final int toDigitValue(char c) {
        int n;
        char c2 = c;
        boolean bl = '0' <= c2 ? c2 < ':' : false;
        if (bl) {
            n = c - 48;
        } else if (c2 == 'a' || c2 == 'A') {
            n = 10;
        } else if (c2 == 'b' || c2 == 'B') {
            n = 11;
        } else if (c2 == 'c' || c2 == 'C') {
            n = 12;
        } else if (c2 == 'd' || c2 == 'D') {
            n = 13;
        } else if (c2 == 'e' || c2 == 'E') {
            n = 14;
        } else if (c2 == 'f' || c2 == 'F') {
            n = 15;
        } else {
            throw new IllegalArgumentException(c + " is not a valid hex digit");
        }
        return n;
    }

    private final String removeSideData(String response, String ... patterns) {
        String result = response;
        for (String pattern : patterns) {
            result = StringsKt.replace$default((String)result, (String)pattern, (String)"", (boolean)false, (int)4, null);
        }
        return result;
    }

    private final String unpackLongFrame(String response) {
        if (!StringsKt.contains$default((CharSequence)response, (char)':', (boolean)false, (int)2, null)) {
            return response;
        }
        String string = response.substring(StringsKt.indexOf$default((CharSequence)response, (char)':', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String result = string;
        CharSequence charSequence = result;
        Regex regex = new Regex("[0-9]:");
        String string2 = "";
        result = regex.replace(charSequence, string2);
        return result;
    }

    @NotNull
    public final Set<Integer> getSupportedPIDs() {
        Set result = new LinkedHashSet();
        String[] stringArray = new String[]{"0100", "0120", "0140", "0160"};
        String[] pids = stringArray;
        int basePid = 1;
        for (String pid : pids) {
            OBDResponse responseData = Obd2Connection.run$default(this, pid, 1, null, 4, null);
            if (responseData.getResult().length >= 6) {
                byte byte0 = (byte)responseData.getResult()[2];
                byte byte1 = (byte)responseData.getResult()[3];
                byte byte2 = (byte)responseData.getResult()[4];
                byte byte3 = (byte)responseData.getResult()[5];
                Object[] objectArray = new Object[]{byte0, byte1, byte2, byte3};
                this.log.debug(StringExtensionsKt.format("Supported PID at base " + basePid + " payload %02X%02X%02X%02X", objectArray));
                FourByteBitSet bitSet = new FourByteBitSet(byte0, byte1, byte2, byte3);
                for (int byteIndex = 0; byteIndex < 4; ++byteIndex) {
                    for (int bitIndex = 7; -1 < bitIndex; --bitIndex) {
                        if (!bitSet.getBit(byteIndex, bitIndex)) continue;
                        int command = basePid + 8 * byteIndex + 7 - bitIndex;
                        this.log.debug("Command " + command + " found supported");
                        result.add(command);
                    }
                }
            }
            basePid += 32;
        }
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lnet/osmand/shared/obd/Obd2Connection$COMMAND_TYPE;", "", "code", "", "<init>", "(Ljava/lang/String;II)V", "getCode", "()I", "LIVE", "FREEZE", "IDENTIFICATION", "OsmAnd-shared"})
    public static final class COMMAND_TYPE
    extends Enum<COMMAND_TYPE> {
        private final int code;
        public static final /* enum */ COMMAND_TYPE LIVE = new COMMAND_TYPE(65);
        public static final /* enum */ COMMAND_TYPE FREEZE = new COMMAND_TYPE(66);
        public static final /* enum */ COMMAND_TYPE IDENTIFICATION = new COMMAND_TYPE(73);
        private static final /* synthetic */ COMMAND_TYPE[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private COMMAND_TYPE(int code) {
            this.code = code;
        }

        public final int getCode() {
            return this.code;
        }

        public static COMMAND_TYPE[] values() {
            return (COMMAND_TYPE[])$VALUES.clone();
        }

        public static COMMAND_TYPE valueOf(String value) {
            return Enum.valueOf(COMMAND_TYPE.class, value);
        }

        @NotNull
        public static EnumEntries<COMMAND_TYPE> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cOMMAND_TYPEArray = new COMMAND_TYPE[]{COMMAND_TYPE.LIVE, COMMAND_TYPE.FREEZE, COMMAND_TYPE.IDENTIFICATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/osmand/shared/obd/Obd2Connection$FourByteBitSet;", "", "b0", "", "b1", "b2", "b3", "<init>", "(BBBB)V", "bytes", "", "getByte", "index", "", "getBit", "", "b", "Companion", "OsmAnd-shared"})
    @SourceDebugExtension(value={"SMAP\nObd2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Obd2Connection.kt\nnet/osmand/shared/obd/Obd2Connection$FourByteBitSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
    public static final class FourByteBitSet {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] bytes;
        @NotNull
        private static final int[] masks;

        public FourByteBitSet(byte b0, byte b1, byte b2, byte b3) {
            byte[] byArray = new byte[]{b0, b1, b2, b3};
            this.bytes = byArray;
        }

        private final byte getByte(int index) {
            if (!(0 <= index ? index < 4 : false)) {
                boolean bl = false;
                String string = index + " is not a valid byte index";
                throw new IllegalArgumentException(string.toString());
            }
            return this.bytes[index];
        }

        private final boolean getBit(byte b, int index) {
            if (!(0 <= index ? index < masks.length : false)) {
                boolean bl = false;
                String string = index + " is not a valid bit index";
                throw new IllegalArgumentException(string.toString());
            }
            return (b & masks[index]) != 0;
        }

        public final boolean getBit(int b, int index) {
            return this.getBit(this.getByte(b), index);
        }

        static {
            int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
            masks = nArray;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/osmand/shared/obd/Obd2Connection$FourByteBitSet$Companion;", "", "<init>", "()V", "masks", "", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

