/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.obd;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.osmand.shared.obd.OBDDataField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0007\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/osmand/shared/obd/OBDUtils;", "", "<init>", "()V", "INVALID_RESPONSE_CODE", "", "parseSupportedCommandsResponse", "response", "parseRpmResponse", "Lnet/osmand/shared/obd/OBDDataField;", "", "parseSpeedResponse", "parseIntakeAirTempResponse", "parseAmbientTempResponse", "parseEngineCoolantTempResponse", "parseFuelLevelResponse", "parseBatteryVoltageResponse", "parseFuelTypeResponse", "parseVINResponse", "parseFuelConsumptionRateResponse", "OsmAnd-shared"})
public final class OBDUtils {
    @NotNull
    public static final OBDUtils INSTANCE = new OBDUtils();
    @NotNull
    public static final String INVALID_RESPONSE_CODE = "-1";

    private OBDUtils() {
    }

    @NotNull
    public final String parseSupportedCommandsResponse(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String[] stringArray = new String[]{" "};
        List responseParts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)response)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (responseParts.size() >= 3 && Intrinsics.areEqual(responseParts.get(0), (Object)"41")) {
            Object supportedPIDs = "";
            int n = responseParts.size();
            for (int i = 2; i < n; ++i) {
                int byteValue = Integer.parseInt((String)responseParts.get(i), CharsKt.checkRadix((int)16));
                for (int bitIndex = 0; bitIndex < 8; ++bitIndex) {
                    if ((byteValue & 1 << 7 - bitIndex) == 0) continue;
                    int pidNumber = (i - 2) * 8 + bitIndex + 1;
                    String string = Integer.toString(pidNumber, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    supportedPIDs = (String)supportedPIDs + " " + string;
                }
            }
            return supportedPIDs;
        }
        return INVALID_RESPONSE_CODE;
    }

    @NotNull
    public final OBDDataField<Object> parseRpmResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        int result = (response[0] * 256 + response[1]) / 4;
        return new OBDDataField<Object>(result);
    }

    @NotNull
    public final OBDDataField<Object> parseSpeedResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return !(response.length == 0) ? new OBDDataField<Integer>(response[0]) : new OBDDataField<Integer>(0);
    }

    @NotNull
    public final OBDDataField<Object> parseIntakeAirTempResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        float result = (float)response[0] * 0.39215687f;
        return new OBDDataField<Object>(Float.valueOf(result));
    }

    @NotNull
    public final OBDDataField<Object> parseAmbientTempResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        float result = (float)response[0] * 0.39215687f;
        return new OBDDataField<Object>(Float.valueOf(result));
    }

    @NotNull
    public final OBDDataField<Object> parseEngineCoolantTempResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        float result = (float)response[0] * 0.39215687f;
        return new OBDDataField<Object>(Float.valueOf(result));
    }

    @NotNull
    public final OBDDataField<Object> parseFuelLevelResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        float result = (float)response[0] * 0.39215687f;
        return new OBDDataField<Object>(Float.valueOf(result));
    }

    @NotNull
    public final OBDDataField<Object> parseBatteryVoltageResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        float result = (float)(response[0] * 256 + response[1]) / (float)1000;
        return new OBDDataField<Object>(Float.valueOf(result));
    }

    @NotNull
    public final OBDDataField<Object> parseFuelTypeResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return new OBDDataField<Object>(response[0]);
    }

    @NotNull
    public final OBDDataField<Object> parseVINResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        StringBuilder vin = new StringBuilder();
        int n = response.length;
        for (int i = 1; i < n; ++i) {
            vin.append((char)response[i]);
        }
        return new OBDDataField<Object>(vin);
    }

    @NotNull
    public final OBDDataField<Object> parseFuelConsumptionRateResponse(@NotNull int[] response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        double result = (double)(response[0] * 256 + response[1]) / 20.0;
        return new OBDDataField<Object>(result);
    }
}

