/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.obd;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import net.osmand.shared.extensions.StringExtensionsKt;
import net.osmand.shared.obd.OBDCommand;
import net.osmand.shared.obd.OBDDataComputer;
import net.osmand.shared.obd.OBDDataField;
import net.osmand.shared.obd.OBDResponse;
import net.osmand.shared.obd.Obd2Connection;
import net.osmand.shared.obd.UnderlyingTransport;
import net.osmand.shared.util.KCollectionUtils;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import okio.Buffer;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010!\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0006J\u0006\u0010%\u001a\u00020\"J\u000e\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0006J\u0010\u0010(\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\u0015J\u001a\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\u000b2\b\u0010,\u001a\u0004\u0018\u00010\rJ\u0006\u0010-\u001a\u00020\"J\u0010\u0010\u000e\u001a\u00020\"2\u0006\u0010.\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lnet/osmand/shared/obd/OBDDispatcher;", "", "<init>", "()V", "commandQueue", "", "Lnet/osmand/shared/obd/OBDCommand;", "staleCommandsCache", "", "", "inputStream", "Lokio/Source;", "outputStream", "Lokio/Sink;", "log", "Lnet/osmand/shared/util/Logger;", "job", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "readStatusListener", "Lnet/osmand/shared/obd/OBDDispatcher$OBDReadStatusListener;", "sensorDataCache", "Ljava/util/HashMap;", "Lnet/osmand/shared/obd/OBDDataField;", "obd2Connection", "Lnet/osmand/shared/obd/Obd2Connection;", "useInfoLogging", "", "getUseInfoLogging", "()Z", "setUseInfoLogging", "(Z)V", "startReadObdLooper", "", "addCommand", "commandToRead", "clearCommands", "removeCommand", "commandToStopReading", "setReadStatusListener", "listener", "setReadWriteStreams", "readStream", "writeStream", "stopReading", "msg", "OBDReadStatusListener", "OsmAnd-shared"})
public final class OBDDispatcher {
    @NotNull
    public static final OBDDispatcher INSTANCE = new OBDDispatcher();
    @NotNull
    private static List<? extends OBDCommand> commandQueue = CollectionsKt.emptyList();
    @NotNull
    private static final Map<OBDCommand, String> staleCommandsCache = new HashMap();
    @Nullable
    private static Source inputStream;
    @Nullable
    private static Sink outputStream;
    @NotNull
    private static final Logger log;
    @Nullable
    private static Job job;
    @Nullable
    private static CoroutineScope scope;
    @Nullable
    private static OBDReadStatusListener readStatusListener;
    @NotNull
    private static final HashMap<OBDCommand, OBDDataField<Object>> sensorDataCache;
    @Nullable
    private static Obd2Connection obd2Connection;
    private static boolean useInfoLogging;

    private OBDDispatcher() {
    }

    public final boolean getUseInfoLogging() {
        return useInfoLogging;
    }

    public final void setUseInfoLogging(boolean bl) {
        useInfoLogging = bl;
    }

    private final void startReadObdLooper() {
        job = (Job)JobKt.Job$default(null, (int)1, null);
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getIO();
        Job job = OBDDispatcher.job;
        Intrinsics.checkNotNull((Object)job);
        CoroutineScope coroutineScope = scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)coroutineDispatcher.plus((CoroutineContext)job));
        Intrinsics.checkNotNull((Object)coroutineScope);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        try {
                            OBDDispatcher.access$log(OBDDispatcher.INSTANCE, "Start reading obd with " + OBDDispatcher.access$getInputStream$p() + " and " + OBDDispatcher.access$getOutputStream$p());
                            OBDDispatcher.access$setObd2Connection$p(new Obd2Connection(new UnderlyingTransport(){

                                public void write(byte[] bytes) {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                                        Buffer buffer = new Buffer();
                                        buffer.write(bytes);
                                        Sink sink = OBDDispatcher.access$getOutputStream$p();
                                        if (sink == null) break block0;
                                        sink.write(buffer, buffer.size());
                                    }
                                }

                                public Byte readByte() {
                                    Buffer readBuffer = new Buffer();
                                    Source source = OBDDispatcher.access$getInputStream$p();
                                    return (source != null ? source.read(readBuffer, 1L) == 1L : false) ? Byte.valueOf(readBuffer.readByte()) : null;
                                }

                                public void onInitFailed() {
                                    block0: {
                                        OBDReadStatusListener oBDReadStatusListener = OBDDispatcher.access$getReadStatusListener$p();
                                        if (oBDReadStatusListener == null) break block0;
                                        oBDReadStatusListener.onInitConnectionFailed();
                                    }
                                }
                            }));
                            while (true) {
                                v0 = OBDDispatcher.access$getObd2Connection$p();
                                v1 = v0 != null ? v0.getInitialized() : false;
                                if (!v1) break;
                                try {
                                    for (OBDCommand command : OBDDispatcher.access$getCommandQueue$p()) {
                                        if (command.isStale() && (cachedCommandResponse = (String)OBDDispatcher.access$getStaleCommandsCache$p().get((Object)command)) != null && !Intrinsics.areEqual((Object)cachedCommandResponse, (Object)"-1")) continue;
                                        var5_7 = new Object[]{Boxing.boxInt((int)command.getCommandGroup())};
                                        hexGroupCode = StringExtensionsKt.format("%02X", var5_7);
                                        var6_8 = new Object[]{Boxing.boxInt((int)command.getCommand())};
                                        hexCode = StringExtensionsKt.format("%02X", var6_8);
                                        fullCommand = hexGroupCode + hexCode;
                                        v2 = OBDDispatcher.access$getObd2Connection$p();
                                        Intrinsics.checkNotNull((Object)v2);
                                        commandResult = v2.run(fullCommand, command.getCommand(), command.getCommandType());
                                        if (commandResult.isValid()) {
                                            if (commandResult.getResult().length >= command.getResponseLength()) {
                                                ((Map)OBDDispatcher.access$getSensorDataCache$p()).put(command, command.parseResponse(commandResult.getResult()));
                                                continue;
                                            }
                                            Logger.error$default(OBDDispatcher.access$getLog$p(), "Incorrect response length for command " + command, null, 2, null);
                                            continue;
                                        }
                                        if (!Intrinsics.areEqual((Object)commandResult, (Object)OBDResponse.Companion.getNO_DATA())) continue;
                                        ((Map)OBDDispatcher.access$getSensorDataCache$p()).put(command, OBDDataField.Companion.getNO_DATA());
                                    }
                                }
                                catch (IOException error) {
                                    Logger.error$default(OBDDispatcher.access$getLog$p(), "Run OBD looper error. " + error, null, 2, null);
                                    if (OBDDispatcher.access$getInputStream$p() == null || OBDDispatcher.access$getOutputStream$p() == null) break;
                                    v3 = OBDDispatcher.access$getReadStatusListener$p();
                                    if (v3 == null) ** GOTO lbl46
                                    v3.onIOError();
                                }
lbl46:
                                // 3 sources

                                OBDDataComputer.INSTANCE.acceptValue(OBDDispatcher.access$getSensorDataCache$p());
                            }
                        }
                        catch (CancellationException var2_3) {
                            Logger.error$default(OBDDispatcher.access$getLog$p(), "OBD reading canceled", null, 2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void addCommand(@NotNull OBDCommand commandToRead) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandToRead), (String)"commandToRead");
        if (commandQueue.indexOf((Object)commandToRead) == -1) {
            commandQueue = KCollectionUtils.INSTANCE.addToList((Collection)commandQueue, commandToRead);
        }
    }

    public final void clearCommands() {
        commandQueue = CollectionsKt.emptyList();
    }

    public final void removeCommand(@NotNull OBDCommand commandToStopReading) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandToStopReading), (String)"commandToStopReading");
        commandQueue = KCollectionUtils.INSTANCE.removeFromList((Collection)commandQueue, commandToStopReading);
    }

    public final void setReadStatusListener(@Nullable OBDReadStatusListener listener) {
        readStatusListener = listener;
    }

    public final void setReadWriteStreams(@Nullable Source readStream, @Nullable Sink writeStream) {
        CoroutineScope coroutineScope = scope;
        if (coroutineScope != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
        }
        inputStream = readStream;
        outputStream = writeStream;
        if (readStream != null && writeStream != null) {
            this.startReadObdLooper();
        }
    }

    public final void stopReading() {
        this.log("stop reading");
        this.setReadWriteStreams(null, null);
        this.log("after stop reading");
    }

    private final void log(String msg) {
        if (useInfoLogging) {
            log.info(msg);
        } else {
            log.debug(msg);
        }
    }

    public static final /* synthetic */ void access$log(OBDDispatcher $this, String msg) {
        $this.log(msg);
    }

    public static final /* synthetic */ Source access$getInputStream$p() {
        return inputStream;
    }

    public static final /* synthetic */ Sink access$getOutputStream$p() {
        return outputStream;
    }

    public static final /* synthetic */ void access$setObd2Connection$p(Obd2Connection obd2Connection) {
        OBDDispatcher.obd2Connection = obd2Connection;
    }

    public static final /* synthetic */ OBDReadStatusListener access$getReadStatusListener$p() {
        return readStatusListener;
    }

    public static final /* synthetic */ Obd2Connection access$getObd2Connection$p() {
        return obd2Connection;
    }

    public static final /* synthetic */ List access$getCommandQueue$p() {
        return commandQueue;
    }

    public static final /* synthetic */ Map access$getStaleCommandsCache$p() {
        return staleCommandsCache;
    }

    public static final /* synthetic */ HashMap access$getSensorDataCache$p() {
        return sensorDataCache;
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    static {
        log = LoggerFactory.INSTANCE.getLogger("OBDDispatcher");
        sensorDataCache = new HashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lnet/osmand/shared/obd/OBDDispatcher$OBDReadStatusListener;", "", "onIOError", "", "onInitConnectionFailed", "OsmAnd-shared"})
    public static interface OBDReadStatusListener {
        public void onIOError();

        public void onInitConnectionFailed();
    }
}

