/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.obd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.osmand.shared.data.KLatLon;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.extensions.StringExtensionsKt;
import net.osmand.shared.obd.OBDCommand;
import net.osmand.shared.obd.OBDDataField;
import net.osmand.shared.obd.OBDDispatcher;
import net.osmand.shared.obd.OBDFuelTypeFormatter;
import net.osmand.shared.util.KCollectionUtils;
import net.osmand.shared.util.KMapUtils;
import net.osmand.shared.util.Localization;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00041234B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u001d\u001a\u00020\u001e2\u001a\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020 \u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010!0\u001fJ\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\bJ\u0006\u0010$\u001a\u00020\u001eJ\b\u0010%\u001a\u00020\u001eH\u0002J\u0016\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012J\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u000eJ\b\u0010,\u001a\u00020\u001eH\u0002J#\u0010-\u001a\u0004\u0018\u00010.2\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010!0\u0007H\u0002\u00a2\u0006\u0002\u00100R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00065"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer;", "", "<init>", "()V", "log", "Lnet/osmand/shared/util/Logger;", "locations", "", "Lnet/osmand/shared/obd/OBDDataComputer$OBDLocation;", "getLocations", "()Ljava/util/List;", "setLocations", "(Ljava/util/List;)V", "value", "Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidget;", "widgets", "getWidgets", "timeoutForInstantValuesSeconds", "", "getTimeoutForInstantValuesSeconds", "()I", "setTimeoutForInstantValuesSeconds", "(I)V", "fuelTank", "", "getFuelTank", "()F", "setFuelTank", "(F)V", "acceptValue", "", "", "Lnet/osmand/shared/obd/OBDCommand;", "Lnet/osmand/shared/obd/OBDDataField;", "registerLocation", "l", "compute", "cleanupLocations", "registerWidget", "type", "Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;", "averageTimeSeconds", "removeWidget", "w", "updateRequiredCommands", "averageNumber", "", "values", "(Ljava/util/List;)Ljava/lang/Double;", "OBDLocation", "OBDTypeWidget", "OBDComputerWidgetFormatter", "OBDComputerWidget", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nOBDDataComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OBDDataComputer.kt\nnet/osmand/shared/obd/OBDDataComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,356:1\n1863#2,2:357\n774#2:359\n865#2,2:360\n1557#2:362\n1628#2,3:363\n1#3:366\n*S KotlinDebug\n*F\n+ 1 OBDDataComputer.kt\nnet/osmand/shared/obd/OBDDataComputer\n*L\n87#1:357,2\n169#1:359\n169#1:360,2\n170#1:362\n170#1:363,3\n*E\n"})
public final class OBDDataComputer {
    @NotNull
    public static final OBDDataComputer INSTANCE = new OBDDataComputer();
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("OBDDataComputer");
    @NotNull
    private static List<OBDLocation> locations = CollectionsKt.emptyList();
    @NotNull
    private static List<OBDComputerWidget> widgets = new ArrayList();
    private static int timeoutForInstantValuesSeconds;
    private static float fuelTank;

    private OBDDataComputer() {
    }

    @NotNull
    public final List<OBDLocation> getLocations() {
        return locations;
    }

    public final void setLocations(@NotNull List<OBDLocation> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        locations = list;
    }

    @NotNull
    public final List<OBDComputerWidget> getWidgets() {
        return widgets;
    }

    public final int getTimeoutForInstantValuesSeconds() {
        return timeoutForInstantValuesSeconds;
    }

    public final void setTimeoutForInstantValuesSeconds(int n) {
        timeoutForInstantValuesSeconds = n;
    }

    public final float getFuelTank() {
        return fuelTank;
    }

    public final void setFuelTank(float f) {
        fuelTank = f;
    }

    public final void acceptValue(@NotNull Map<OBDCommand, ? extends OBDDataField<Object>> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        for (OBDComputerWidget widget : widgets) {
            widget.acceptValue(value);
        }
        this.compute();
    }

    public final void registerLocation(@NotNull OBDLocation l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        if (!((Collection)widgets).isEmpty()) {
            locations = KCollectionUtils.INSTANCE.addToList((Collection)locations, l);
            this.cleanupLocations();
        }
    }

    public final void compute() {
        long now = ClockExtensionsKt.currentTimeMillis();
        for (OBDComputerWidget widget : widgets) {
            widget.cleanup(now);
            widget.computeValue();
        }
    }

    private final void cleanupLocations() {
        int inWindow;
        long now = ClockExtensionsKt.currentTimeMillis();
        int window = timeoutForInstantValuesSeconds;
        for (OBDComputerWidget widget : widgets) {
            if (!widget.getType().getLocationNeeded()) continue;
            window = Math.max(window, widget.getAverageTimeSeconds());
        }
        for (inWindow = 0; inWindow < locations.size() && locations.get(inWindow).getTime() < now - (long)(window * 1000); ++inWindow) {
        }
        if (inWindow - 1 > 0) {
            locations = locations.subList(inWindow - 1, locations.size());
        }
    }

    @NotNull
    public final OBDComputerWidget registerWidget(@NotNull OBDTypeWidget type, int averageTimeSeconds) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        OBDComputerWidget widget = new OBDComputerWidget(type, averageTimeSeconds);
        widgets = KCollectionUtils.INSTANCE.addToList((Collection)widgets, widget);
        this.updateRequiredCommands();
        return widget;
    }

    public final void removeWidget(@NotNull OBDComputerWidget w) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        widgets = KCollectionUtils.INSTANCE.removeFromList((Collection)widgets, w);
        this.updateRequiredCommands();
    }

    private final void updateRequiredCommands() {
        OBDDispatcher.INSTANCE.clearCommands();
        Iterable $this$forEach$iv = widgets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OBDComputerWidget widget = (OBDComputerWidget)element$iv;
            boolean bl = false;
            OBDDispatcher.INSTANCE.addCommand(widget.getType().getRequiredCommand());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Double averageNumber(List<? extends OBDDataField<Object>> values) {
        Double d;
        if (!((Collection)values).isEmpty()) {
            void $this$mapTo$iv$iv;
            OBDDataField it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = values;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (OBDDataField)element$iv$iv;
                boolean bl = false;
                if (!(it.getValue() instanceof Number)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (OBDDataField)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object t = it.getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
                collection.add(((Number)t).doubleValue());
            }
            Iterable iterable2 = (List)destination$iv$iv;
            double d2 = 0.0;
            for (Object t : iterable2) {
                void it2;
                double d3 = ((Number)t).doubleValue();
                double d4 = d2;
                boolean bl = false;
                void var13_17 = it2;
                d2 = d4 + var13_17;
            }
            d = d2 / (double)values.size();
        } else {
            d = null;
        }
        return d;
    }

    static {
        fuelTank = 52.0f;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002J1\u0010\u0016\u001a\u00020\u00172\"\u0010\u0018\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u001aj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0010`\u0019H\u0002\u00a2\u0006\u0002\u0010\u001bJ\"\u0010\u001c\u001a\u00020\u001d2\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u001f\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00100\u001eJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidget;", "", "type", "Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;", "averageTimeSeconds", "", "<init>", "(Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;I)V", "getType", "()Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;", "getAverageTimeSeconds", "()I", "setAverageTimeSeconds", "(I)V", "values", "", "Lnet/osmand/shared/obd/OBDDataField;", "value", "cachedVersion", "version", "computeValue", "compute", "calculateFuelConsumption", "", "locValues", "Lkotlin/collections/ArrayList;", "Ljava/util/ArrayList;", "(Ljava/util/ArrayList;)F", "acceptValue", "", "", "Lnet/osmand/shared/obd/OBDCommand;", "cleanup", "now", "", "OsmAnd-shared"})
    public static final class OBDComputerWidget {
        @NotNull
        private final OBDTypeWidget type;
        private int averageTimeSeconds;
        @NotNull
        private List<OBDDataField<Object>> values;
        @Nullable
        private Object value;
        private int cachedVersion;
        private int version;

        public OBDComputerWidget(@NotNull OBDTypeWidget type, int averageTimeSeconds) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.averageTimeSeconds = averageTimeSeconds;
            this.values = new ArrayList();
        }

        @NotNull
        public final OBDTypeWidget getType() {
            return this.type;
        }

        public final int getAverageTimeSeconds() {
            return this.averageTimeSeconds;
        }

        public final void setAverageTimeSeconds(int n) {
            this.averageTimeSeconds = n;
        }

        @Nullable
        public final Object computeValue() {
            if (this.cachedVersion != this.version) {
                int v = this.version;
                this.value = this.compute();
                this.cachedVersion = v;
            }
            return this.value;
        }

        private final Object compute() {
            ArrayList<OBDDataField<Object>> locValues = new ArrayList<OBDDataField<Object>>((Collection)this.values);
            if (locValues.size() > 0 && Intrinsics.areEqual(locValues.get(0), OBDDataField.Companion.getNO_DATA())) {
                return "N/A";
            }
            return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1, 2, 3, 4, 5, 6, 7 -> {
                    if (this.averageTimeSeconds == 0 && locValues.size() > 0) {
                        yield locValues.get(locValues.size() - 1).getValue();
                    }
                    yield INSTANCE.averageNumber(locValues);
                }
                case 8 -> {
                    if (locValues.size() >= 2) {
                        yield Float.valueOf(this.calculateFuelConsumption(locValues));
                    }
                    yield null;
                }
                case 9 -> {
                    if (locValues.size() >= 2) {
                        yield Float.valueOf(INSTANCE.getFuelTank() * this.calculateFuelConsumption(locValues) / (float)100);
                    }
                    yield null;
                }
                case 10 -> {
                    if (locValues.size() >= 2) {
                        OBDDataField<Object> first = locValues.get(0);
                        OBDDataField<Object> last = locValues.get(locValues.size() - 1);
                        if (first.getLocation() != null && last.getLocation() != null) {
                            Object v1 = last.getValue();
                            Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.Float");
                            float v2 = ((Float)v1).floatValue();
                            Object v3 = first.getValue();
                            Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.Float");
                            float diffPerc = v2 - ((Float)v3).floatValue();
                            if (diffPerc > 0.0f) {
                                double dist = 0.0;
                                int var8_8 = locValues.size() - 1;
                                for (int i = 0; i < var8_8; ++i) {
                                    dist += KMapUtils.INSTANCE.getDistance(INSTANCE.getLocations().get(i).getLatLon(), INSTANCE.getLocations().get(i + 1).getLatLon());
                                }
                                if (dist > 0.0) {
                                    Object lastPerc = last.getValue();
                                    (double)(((Number)lastPerc).floatValue() / diffPerc) * dist;
                                }
                            }
                        }
                    }
                    yield null;
                }
                case 11 -> {
                    if (locValues.size() > 0) {
                        Object v4 = locValues.get(locValues.size() - 1).getValue();
                        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type kotlin.Float");
                        yield (Float)v4;
                    }
                    yield null;
                }
                case 12 -> {
                    if (locValues.size() > 0) {
                        float v5 = INSTANCE.getFuelTank();
                        Object v6 = locValues.get(locValues.size() - 1).getValue();
                        Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type kotlin.Float");
                        yield Float.valueOf(v5 * ((Float)v6).floatValue() / (float)100);
                    }
                    yield null;
                }
                case 13 -> {
                    if (locValues.size() > 0) {
                        yield locValues.get(locValues.size() - 1).getValue();
                    }
                    yield null;
                }
                case 14 -> {
                    if (locValues.size() > 0) {
                        yield locValues.get(locValues.size() - 1).getValue();
                    }
                    yield null;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final float calculateFuelConsumption(ArrayList<OBDDataField<Object>> locValues) {
            OBDDataField<Object> oBDDataField = locValues.get(locValues.size() - 2);
            Intrinsics.checkNotNullExpressionValue(oBDDataField, (String)"get(...)");
            OBDDataField<Object> first = oBDDataField;
            OBDDataField<Object> oBDDataField2 = locValues.get(locValues.size() - 1);
            Intrinsics.checkNotNullExpressionValue(oBDDataField2, (String)"get(...)");
            OBDDataField<Object> last = oBDDataField2;
            Object object = first.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            float f = ((Float)object).floatValue();
            Object object2 = last.getValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Float");
            float diffPerc = f - ((Float)object2).floatValue();
            long diffTime = last.getTimestamp() - first.getTimestamp();
            System.out.println((Object)("diftime " + diffTime + "; diffPerc " + diffPerc));
            return diffPerc / (float)diffTime * (float)1000 * (float)3600;
        }

        public final void acceptValue(@NotNull Map<OBDCommand, ? extends OBDDataField<Object>> value) {
            block7: {
                OBDDataField<Object> it;
                block8: {
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    OBDDataField<Object> oBDDataField = value.get((Object)this.type.getRequiredCommand());
                    if (oBDDataField == null) break block7;
                    it = oBDDataField;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it, OBDDataField.Companion.getNO_DATA())) break block8;
                    if (this.values.isEmpty()) {
                        int n = this.version;
                        this.version = n + 1;
                    }
                    Object[] objectArray = new OBDDataField[]{it};
                    this.values = CollectionsKt.mutableListOf((Object[])objectArray);
                    break block7;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                    case 10: {
                        if (!((Collection)INSTANCE.getLocations()).isEmpty()) {
                            it.setLocation((OBDLocation)CollectionsKt.last(INSTANCE.getLocations()));
                        }
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (this.values.isEmpty() || !Intrinsics.areEqual((Object)this.values.get(this.values.size() - 1).getValue(), (Object)it.getValue())) {
                            int n = this.version;
                            this.version = n + 1;
                            this.values.add(it);
                        }
                        break;
                    }
                    default: {
                        int n = this.version;
                        this.version = n + 1;
                        this.values.add(it);
                    }
                }
            }
        }

        public final void cleanup(long now) {
            int inWindow;
            int timeout = this.averageTimeSeconds > 0 ? this.averageTimeSeconds : INSTANCE.getTimeoutForInstantValuesSeconds();
            for (inWindow = 0; inWindow < this.values.size() && this.values.get(inWindow).getTimestamp() < now - (long)(timeout * 1000); ++inWindow) {
            }
            if (inWindow > 0 && inWindow < this.values.size() - 1) {
                this.values = this.values.subList(inWindow, this.values.size());
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OBDTypeWidget.values().length];
                try {
                    nArray[OBDTypeWidget.TEMPERATURE_AMBIENT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.TEMPERATURE_COOLANT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.TEMPERATURE_INTAKE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.SPEED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.BATTERY_VOLTAGE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_CONSUMPTION_RATE_SENSOR.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.RPM.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_CONSUMPTION_RATE_PERCENT_HOUR.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_CONSUMPTION_RATE_LITER_HOUR.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_LEFT_KM.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_LEFT_PERCENT.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_LEFT_LITER.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.FUEL_TYPE.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OBDTypeWidget.VIN.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidgetFormatter;", "", "pattern", "", "<init>", "(Ljava/lang/String;)V", "getPattern", "()Ljava/lang/String;", "format", "v", "OsmAnd-shared"})
    public static class OBDComputerWidgetFormatter {
        @NotNull
        private final String pattern;

        public OBDComputerWidgetFormatter(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        public /* synthetic */ OBDComputerWidgetFormatter(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "%s";
            }
            this(string);
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String format(@Nullable Object v) {
            String string;
            if (v == null) {
                string = "-";
            } else {
                void var2_2;
                String ret = "";
                try {
                    Object[] objectArray = new Object[]{v};
                    ret = StringExtensionsKt.format(this.pattern, objectArray);
                }
                catch (Throwable error) {
                    Logger.error$default(log, error.getMessage(), null, 2, null);
                }
                string = var2_2;
            }
            return string;
        }

        public OBDComputerWidgetFormatter() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer$OBDLocation;", "", "time", "", "latLon", "Lnet/osmand/shared/data/KLatLon;", "<init>", "(JLnet/osmand/shared/data/KLatLon;)V", "getTime", "()J", "getLatLon", "()Lnet/osmand/shared/data/KLatLon;", "OsmAnd-shared"})
    public static final class OBDLocation {
        private final long time;
        @NotNull
        private final KLatLon latLon;

        public OBDLocation(long time, @NotNull KLatLon latLon) {
            Intrinsics.checkNotNullParameter((Object)latLon, (String)"latLon");
            this.time = time;
            this.latLon = latLon;
        }

        public final long getTime() {
            return this.time;
        }

        @NotNull
        public final KLatLon getLatLon() {
            return this.latLon;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\"\u001a\u00020\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!\u00a8\u0006#"}, d2={"Lnet/osmand/shared/obd/OBDDataComputer$OBDTypeWidget;", "", "locationNeeded", "", "requiredCommand", "Lnet/osmand/shared/obd/OBDCommand;", "nameId", "", "formatter", "Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidgetFormatter;", "<init>", "(Ljava/lang/String;IZLnet/osmand/shared/obd/OBDCommand;Ljava/lang/String;Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidgetFormatter;)V", "getLocationNeeded", "()Z", "getRequiredCommand", "()Lnet/osmand/shared/obd/OBDCommand;", "getNameId", "()Ljava/lang/String;", "getFormatter", "()Lnet/osmand/shared/obd/OBDDataComputer$OBDComputerWidgetFormatter;", "SPEED", "RPM", "FUEL_LEFT_KM", "FUEL_LEFT_PERCENT", "FUEL_LEFT_LITER", "FUEL_CONSUMPTION_RATE_PERCENT_HOUR", "FUEL_CONSUMPTION_RATE_LITER_HOUR", "FUEL_CONSUMPTION_RATE_SENSOR", "TEMPERATURE_INTAKE", "TEMPERATURE_AMBIENT", "BATTERY_VOLTAGE", "FUEL_TYPE", "VIN", "TEMPERATURE_COOLANT", "getTitle", "OsmAnd-shared"})
    public static final class OBDTypeWidget
    extends Enum<OBDTypeWidget> {
        private final boolean locationNeeded;
        @NotNull
        private final OBDCommand requiredCommand;
        @NotNull
        private final String nameId;
        @NotNull
        private final OBDComputerWidgetFormatter formatter;
        public static final /* enum */ OBDTypeWidget SPEED = new OBDTypeWidget(false, OBDCommand.OBD_SPEED_COMMAND, "shared_string_speed", new OBDComputerWidgetFormatter("%.0f"));
        public static final /* enum */ OBDTypeWidget RPM = new OBDTypeWidget(false, OBDCommand.OBD_RPM_COMMAND, "obd_rpm", new OBDComputerWidgetFormatter("%d"));
        public static final /* enum */ OBDTypeWidget FUEL_LEFT_KM = new OBDTypeWidget(true, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_left_distance", new OBDComputerWidgetFormatter("%.0f"));
        public static final /* enum */ OBDTypeWidget FUEL_LEFT_PERCENT = new OBDTypeWidget(false, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_left_percent", new OBDComputerWidgetFormatter("%.2f"));
        public static final /* enum */ OBDTypeWidget FUEL_LEFT_LITER = new OBDTypeWidget(false, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_left_liter", new OBDComputerWidgetFormatter("%.2f"));
        public static final /* enum */ OBDTypeWidget FUEL_CONSUMPTION_RATE_PERCENT_HOUR = new OBDTypeWidget(false, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_consumption_rate_percent_hour", new OBDComputerWidgetFormatter("%.0f"));
        public static final /* enum */ OBDTypeWidget FUEL_CONSUMPTION_RATE_LITER_HOUR = new OBDTypeWidget(false, OBDCommand.OBD_FUEL_LEVEL_COMMAND, "obd_fuel_consumption_rate_liter_hour", new OBDComputerWidgetFormatter("%.0f"));
        public static final /* enum */ OBDTypeWidget FUEL_CONSUMPTION_RATE_SENSOR = new OBDTypeWidget(false, OBDCommand.OBD_FUEL_CONSUMPTION_RATE_COMMAND, "obd_fuel_consumption_rate_scanner", new OBDComputerWidgetFormatter("%.2f"));
        public static final /* enum */ OBDTypeWidget TEMPERATURE_INTAKE = new OBDTypeWidget(false, OBDCommand.OBD_AIR_INTAKE_TEMP_COMMAND, "obd_air_intake_temp", new OBDComputerWidgetFormatter("%.0f"));
        public static final /* enum */ OBDTypeWidget TEMPERATURE_AMBIENT = new OBDTypeWidget(false, OBDCommand.OBD_AMBIENT_AIR_TEMPERATURE_COMMAND, "obd_ambient_air_temp", new OBDComputerWidgetFormatter("%.0f"));
        public static final /* enum */ OBDTypeWidget BATTERY_VOLTAGE = new OBDTypeWidget(false, OBDCommand.OBD_BATTERY_VOLTAGE_COMMAND, "obd_battery_voltage", new OBDComputerWidgetFormatter("%.2f"));
        public static final /* enum */ OBDTypeWidget FUEL_TYPE = new OBDTypeWidget(false, OBDCommand.OBD_FUEL_TYPE_COMMAND, "obd_fuel_type", new OBDFuelTypeFormatter());
        public static final /* enum */ OBDTypeWidget VIN = new OBDTypeWidget(false, OBDCommand.OBD_VIN_COMMAND, "obd_vin", new OBDComputerWidgetFormatter("%s"));
        public static final /* enum */ OBDTypeWidget TEMPERATURE_COOLANT = new OBDTypeWidget(false, OBDCommand.OBD_ENGINE_COOLANT_TEMP_COMMAND, "obd_engine_coolant_temp", new OBDComputerWidgetFormatter("%.0f"));
        private static final /* synthetic */ OBDTypeWidget[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private OBDTypeWidget(boolean locationNeeded, OBDCommand requiredCommand, String nameId, OBDComputerWidgetFormatter formatter) {
            this.locationNeeded = locationNeeded;
            this.requiredCommand = requiredCommand;
            this.nameId = nameId;
            this.formatter = formatter;
        }

        public final boolean getLocationNeeded() {
            return this.locationNeeded;
        }

        @NotNull
        public final OBDCommand getRequiredCommand() {
            return this.requiredCommand;
        }

        @NotNull
        public final String getNameId() {
            return this.nameId;
        }

        @NotNull
        public final OBDComputerWidgetFormatter getFormatter() {
            return this.formatter;
        }

        @NotNull
        public final String getTitle() {
            return Localization.INSTANCE.getString(this.nameId);
        }

        public static OBDTypeWidget[] values() {
            return (OBDTypeWidget[])$VALUES.clone();
        }

        public static OBDTypeWidget valueOf(String value) {
            return Enum.valueOf(OBDTypeWidget.class, value);
        }

        @NotNull
        public static EnumEntries<OBDTypeWidget> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = oBDTypeWidgetArray = new OBDTypeWidget[]{OBDTypeWidget.SPEED, OBDTypeWidget.RPM, OBDTypeWidget.FUEL_LEFT_KM, OBDTypeWidget.FUEL_LEFT_PERCENT, OBDTypeWidget.FUEL_LEFT_LITER, OBDTypeWidget.FUEL_CONSUMPTION_RATE_PERCENT_HOUR, OBDTypeWidget.FUEL_CONSUMPTION_RATE_LITER_HOUR, OBDTypeWidget.FUEL_CONSUMPTION_RATE_SENSOR, OBDTypeWidget.TEMPERATURE_INTAKE, OBDTypeWidget.TEMPERATURE_AMBIENT, OBDTypeWidget.BATTERY_VOLTAGE, OBDTypeWidget.FUEL_TYPE, OBDTypeWidget.VIN, OBDTypeWidget.TEMPERATURE_COOLANT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

