/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.primitives;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.SplitMetric;
import net.osmand.shared.gpx.primitives.GpxExtensions;
import net.osmand.shared.gpx.primitives.WptPt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010&\u001a\u00020\u000bJ\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000bJ\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020\u000bJ.\u00100\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000bH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0014\"\u0004\b \u0010\u0016R \u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016\u00a8\u00065"}, d2={"Lnet/osmand/shared/gpx/primitives/TrkSegment;", "Lnet/osmand/shared/gpx/primitives/GpxExtensions;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "generalSegment", "", "getGeneralSegment", "()Z", "setGeneralSegment", "(Z)V", "points", "", "Lnet/osmand/shared/gpx/primitives/WptPt;", "getPoints", "()Ljava/util/List;", "setPoints", "(Ljava/util/List;)V", "renderer", "", "getRenderer", "()Ljava/lang/Object;", "setRenderer", "(Ljava/lang/Object;)V", "routeSegments", "Lnet/osmand/shared/gpx/GpxUtilities$RouteSegment;", "getRouteSegments", "setRouteSegments", "routeTypes", "Lnet/osmand/shared/gpx/GpxUtilities$RouteType;", "getRouteTypes", "setRouteTypes", "isGeneralSegment", "hasRoute", "splitByDistance", "", "Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "meters", "", "joinSegments", "splitByTime", "seconds", "", "split", "metric", "Lnet/osmand/shared/gpx/SplitMetric;", "secondaryMetric", "metricLimit", "OsmAnd-shared"})
public final class TrkSegment
extends GpxExtensions {
    @Nullable
    private String name;
    private boolean generalSegment;
    @NotNull
    private List<WptPt> points = new ArrayList();
    @Nullable
    private Object renderer;
    @NotNull
    private List<GpxUtilities.RouteSegment> routeSegments = new ArrayList();
    @NotNull
    private List<GpxUtilities.RouteType> routeTypes = new ArrayList();

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    public final boolean getGeneralSegment() {
        return this.generalSegment;
    }

    public final void setGeneralSegment(boolean bl) {
        this.generalSegment = bl;
    }

    @NotNull
    public final List<WptPt> getPoints() {
        return this.points;
    }

    public final void setPoints(@NotNull List<WptPt> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.points = list;
    }

    @Nullable
    public final Object getRenderer() {
        return this.renderer;
    }

    public final void setRenderer(@Nullable Object object) {
        this.renderer = object;
    }

    @NotNull
    public final List<GpxUtilities.RouteSegment> getRouteSegments() {
        return this.routeSegments;
    }

    public final void setRouteSegments(@NotNull List<GpxUtilities.RouteSegment> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.routeSegments = list;
    }

    @NotNull
    public final List<GpxUtilities.RouteType> getRouteTypes() {
        return this.routeTypes;
    }

    public final void setRouteTypes(@NotNull List<GpxUtilities.RouteType> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.routeTypes = list;
    }

    public final boolean isGeneralSegment() {
        return this.generalSegment;
    }

    public final boolean hasRoute() {
        return !((Collection)this.routeSegments).isEmpty() && !((Collection)this.routeTypes).isEmpty();
    }

    @NotNull
    public final List<GpxTrackAnalysis> splitByDistance(double meters, boolean joinSegments) {
        return this.split(new SplitMetric.DistanceSplitMetric(), new SplitMetric.TimeSplitMetric(), meters, joinSegments);
    }

    @NotNull
    public final List<GpxTrackAnalysis> splitByTime(int seconds, boolean joinSegments) {
        return this.split(new SplitMetric.TimeSplitMetric(), new SplitMetric.DistanceSplitMetric(), seconds, joinSegments);
    }

    private final List<GpxTrackAnalysis> split(SplitMetric metric, SplitMetric secondaryMetric, double metricLimit, boolean joinSegments) {
        List splitSegments = new ArrayList();
        SplitMetric.Companion.splitSegment(metric, secondaryMetric, metricLimit, splitSegments, this, joinSegments);
        return GpxUtilities.INSTANCE.convert(splitSegments);
    }
}

