/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.primitives;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.osmand.shared.gpx.primitives.Author;
import net.osmand.shared.gpx.primitives.Bounds;
import net.osmand.shared.gpx.primitives.Copyright;
import net.osmand.shared.gpx.primitives.GpxExtensions;
import net.osmand.shared.gpx.primitives.RouteActivity;
import net.osmand.shared.util.KAlgorithms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\b\u0010-\u001a\u0004\u0018\u00010\u0007J\b\u0010.\u001a\u0004\u0018\u00010\u0007J\b\u0010/\u001a\u0004\u0018\u00010\u0007J\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u0004\u0018\u0001032\f\u00104\u001a\b\u0012\u0004\u0012\u00020305J\"\u00106\u001a\u0004\u0018\u0001032\b\u00107\u001a\u0004\u0018\u00010\u00072\f\u00104\u001a\b\u0012\u0004\u0012\u00020305H\u0002J\u001e\u00108\u001a\u0002012\b\u00109\u001a\u0004\u0018\u0001032\f\u00104\u001a\b\u0012\u0004\u0012\u00020305J\u0016\u0010:\u001a\u0004\u0018\u00010\u00072\f\u00104\u001a\b\u0012\u0004\u0012\u00020305J\u0010\u0010;\u001a\u0004\u0018\u00010\u00072\u0006\u0010<\u001a\u00020=J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000705R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006?"}, d2={"Lnet/osmand/shared/gpx/primitives/Metadata;", "Lnet/osmand/shared/gpx/primitives/GpxExtensions;", "<init>", "()V", "source", "(Lnet/osmand/shared/gpx/primitives/Metadata;)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "desc", "getDesc", "setDesc", "link", "getLink", "setLink", "keywords", "getKeywords", "setKeywords", "time", "", "getTime", "()J", "setTime", "(J)V", "author", "Lnet/osmand/shared/gpx/primitives/Author;", "getAuthor", "()Lnet/osmand/shared/gpx/primitives/Author;", "setAuthor", "(Lnet/osmand/shared/gpx/primitives/Author;)V", "copyright", "Lnet/osmand/shared/gpx/primitives/Copyright;", "getCopyright", "()Lnet/osmand/shared/gpx/primitives/Copyright;", "setCopyright", "(Lnet/osmand/shared/gpx/primitives/Copyright;)V", "bounds", "Lnet/osmand/shared/gpx/primitives/Bounds;", "getBounds", "()Lnet/osmand/shared/gpx/primitives/Bounds;", "setBounds", "(Lnet/osmand/shared/gpx/primitives/Bounds;)V", "getArticleTitle", "getArticleLang", "getDescription", "readDescription", "", "getRouteActivity", "Lnet/osmand/shared/gpx/primitives/RouteActivity;", "activities", "", "findRouteActivity", "id", "setRouteActivity", "activity", "getFilteredKeywords", "getKeywordAt", "index", "", "getIndividualKeywords", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Metadata.kt\nnet/osmand/shared/gpx/primitives/Metadata\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n295#3,2:114\n*S KotlinDebug\n*F\n+ 1 Metadata.kt\nnet/osmand/shared/gpx/primitives/Metadata\n*L\n66#1:114,2\n*E\n"})
public final class Metadata
extends GpxExtensions {
    @Nullable
    private String name;
    @Nullable
    private String desc;
    @Nullable
    private String link;
    @Nullable
    private String keywords;
    private long time;
    @Nullable
    private Author author;
    @Nullable
    private Copyright copyright;
    @Nullable
    private Bounds bounds;

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @Nullable
    public final String getDesc() {
        return this.desc;
    }

    public final void setDesc(@Nullable String string) {
        this.desc = string;
    }

    @Nullable
    public final String getLink() {
        return this.link;
    }

    public final void setLink(@Nullable String string) {
        this.link = string;
    }

    @Nullable
    public final String getKeywords() {
        return this.keywords;
    }

    public final void setKeywords(@Nullable String string) {
        this.keywords = string;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    @Nullable
    public final Author getAuthor() {
        return this.author;
    }

    public final void setAuthor(@Nullable Author author) {
        this.author = author;
    }

    @Nullable
    public final Copyright getCopyright() {
        return this.copyright;
    }

    public final void setCopyright(@Nullable Copyright copyright) {
        this.copyright = copyright;
    }

    @Nullable
    public final Bounds getBounds() {
        return this.bounds;
    }

    public final void setBounds(@Nullable Bounds bounds) {
        this.bounds = bounds;
    }

    public Metadata() {
    }

    public Metadata(@NotNull Metadata source) {
        Bounds sourceBounds;
        Copyright sourceCopyright;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.name = source.name;
        this.desc = source.desc;
        this.link = source.link;
        this.keywords = source.keywords;
        this.time = source.time;
        Author sourceAuthor = source.author;
        if (sourceAuthor != null) {
            this.author = new Author(sourceAuthor);
        }
        if ((sourceCopyright = source.copyright) != null) {
            this.copyright = new Copyright(sourceCopyright);
        }
        if ((sourceBounds = source.bounds) != null) {
            this.bounds = new Bounds(sourceBounds);
        }
        this.copyExtensions(source);
    }

    @Nullable
    public final String getArticleTitle() {
        return this.getExtensionsToRead().get("article_title");
    }

    @Nullable
    public final String getArticleLang() {
        return this.getExtensionsToRead().get("article_lang");
    }

    @Nullable
    public final String getDescription() {
        return this.desc;
    }

    public final void readDescription() {
        String readDescription = this.getExtensionsToWrite().remove("desc");
        if (!KAlgorithms.INSTANCE.isEmpty(readDescription)) {
            this.desc = KAlgorithms.INSTANCE.isEmpty(this.desc) ? readDescription : this.desc + "; " + readDescription;
        }
    }

    @Nullable
    public final RouteActivity getRouteActivity(@NotNull List<RouteActivity> activities) {
        Intrinsics.checkNotNullParameter(activities, (String)"activities");
        return this.findRouteActivity(this.getKeywordAt(0), activities);
    }

    private final RouteActivity findRouteActivity(String id, List<RouteActivity> activities) {
        RouteActivity routeActivity;
        String string = id;
        if (string != null) {
            Object v1;
            block3: {
                String it = string;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = activities;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RouteActivity it2 = (RouteActivity)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)id)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            routeActivity = v1;
        } else {
            routeActivity = null;
        }
        return routeActivity;
    }

    public final void setRouteActivity(@Nullable RouteActivity activity, @NotNull List<RouteActivity> activities) {
        Intrinsics.checkNotNullParameter(activities, (String)"activities");
        if (this.keywords != null) {
            String string = this.keywords;
            Intrinsics.checkNotNull((Object)string);
            String[] stringArray = new String[]{","};
            List keywords = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            RouteActivity previousActivity = this.findRouteActivity((String)keywords.get(0), activities);
            int startIndex = previousActivity != null ? 1 : 0;
            Object object = activity;
            if (object == null || (object = ((RouteActivity)object).getId()) == null) {
                object = "";
            }
            StringBuilder keywordsBuilder = new StringBuilder((String)object);
            int n = keywords.size();
            for (int i = startIndex; i < n; ++i) {
                if (((CharSequence)keywordsBuilder).length() > 0) {
                    keywordsBuilder.append(",");
                }
                keywordsBuilder.append((String)keywords.get(i));
            }
            this.keywords = keywordsBuilder.toString();
        } else {
            RouteActivity routeActivity = activity;
            this.keywords = routeActivity != null ? routeActivity.getId() : null;
        }
    }

    @Nullable
    public final String getFilteredKeywords(@NotNull List<RouteActivity> activities) {
        Intrinsics.checkNotNullParameter(activities, (String)"activities");
        List<String> keywords = this.getIndividualKeywords();
        if (!((Collection)keywords).isEmpty()) {
            RouteActivity activity = this.findRouteActivity(keywords.get(0), activities);
            int startIndex = activity != null ? 1 : 0;
            StringBuilder keywordsBuilder = new StringBuilder();
            int n = keywords.size();
            for (int i = startIndex; i < n; ++i) {
                if (((CharSequence)keywordsBuilder).length() > 0) {
                    keywordsBuilder.append(",");
                }
                keywordsBuilder.append(keywords.get(i));
            }
            return keywordsBuilder.toString();
        }
        return null;
    }

    @Nullable
    public final String getKeywordAt(int index) {
        List<String> keywords = this.getIndividualKeywords();
        return !((Collection)keywords).isEmpty() && keywords.size() > index ? keywords.get(index) : null;
    }

    @NotNull
    public final List<String> getIndividualKeywords() {
        List list;
        if (this.keywords != null) {
            String string = this.keywords;
            Intrinsics.checkNotNull((Object)string);
            String[] stringArray = new String[]{","};
            list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

