/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.primitives;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.util.KAlgorithms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013J\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0013J\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u0005J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0000J\u0017\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010&J\u0010\u0010$\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010\u0006J\u0006\u0010'\u001a\u00020\u001bR(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR(\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR(\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\n\u00a8\u0006)"}, d2={"Lnet/osmand/shared/gpx/primitives/GpxExtensions;", "", "<init>", "()V", "extensions", "", "", "getExtensions", "()Ljava/util/Map;", "setExtensions", "(Ljava/util/Map;)V", "deferredExtensions", "getDeferredExtensions", "setDeferredExtensions", "extensionsWriters", "Lnet/osmand/shared/gpx/GpxUtilities$GpxExtensionsWriter;", "getExtensionsWriters", "setExtensionsWriters", "getExtensionsToRead", "", "getExtensionsToWrite", "getDeferredExtensionsToRead", "getDeferredExtensionsToWrite", "getExtensionsWritersToWrite", "getExtensionsWriter", "key", "setExtensionsWriter", "", "extensionsWriter", "removeExtensionsWriter", "copyExtensions", "e", "getColor", "", "defColor", "(Ljava/lang/Integer;)Ljava/lang/Integer;", "setColor", "color", "(Ljava/lang/Integer;)V", "removeColor", "Companion", "OsmAnd-shared"})
public class GpxExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<String, String> extensions;
    @Nullable
    private Map<String, String> deferredExtensions;
    @Nullable
    private Map<String, GpxUtilities.GpxExtensionsWriter> extensionsWriters;
    @NotNull
    public static final String OBF_GPX_EXTENSION_TAG_PREFIX = "gpx_";

    @Nullable
    public final Map<String, String> getExtensions() {
        return this.extensions;
    }

    public final void setExtensions(@Nullable Map<String, String> map) {
        this.extensions = map;
    }

    @Nullable
    public final Map<String, String> getDeferredExtensions() {
        return this.deferredExtensions;
    }

    public final void setDeferredExtensions(@Nullable Map<String, String> map) {
        this.deferredExtensions = map;
    }

    @Nullable
    public final Map<String, GpxUtilities.GpxExtensionsWriter> getExtensionsWriters() {
        return this.extensionsWriters;
    }

    public final void setExtensionsWriters(@Nullable Map<String, GpxUtilities.GpxExtensionsWriter> map) {
        this.extensionsWriters = map;
    }

    @NotNull
    public final Map<String, String> getExtensionsToRead() {
        Map map = this.extensions;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public final Map<String, String> getExtensionsToWrite() {
        if (this.extensions == null) {
            this.extensions = new LinkedHashMap();
        }
        Map<String, String> map = this.extensions;
        Intrinsics.checkNotNull(map);
        return map;
    }

    @NotNull
    public final Map<String, String> getDeferredExtensionsToRead() {
        Map map = this.deferredExtensions;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public final Map<String, String> getDeferredExtensionsToWrite() {
        if (this.deferredExtensions == null) {
            this.deferredExtensions = new LinkedHashMap();
        }
        Map<String, String> map = this.deferredExtensions;
        Intrinsics.checkNotNull(map);
        return map;
    }

    @NotNull
    public final Map<String, GpxUtilities.GpxExtensionsWriter> getExtensionsWritersToWrite() {
        if (this.extensionsWriters == null) {
            this.extensionsWriters = new LinkedHashMap();
        }
        Map<String, GpxUtilities.GpxExtensionsWriter> map = this.extensionsWriters;
        Intrinsics.checkNotNull(map);
        return map;
    }

    @Nullable
    public final GpxUtilities.GpxExtensionsWriter getExtensionsWriter(@Nullable String key) {
        Map<String, GpxUtilities.GpxExtensionsWriter> map = this.extensionsWriters;
        return map != null ? map.get(key) : null;
    }

    public final void setExtensionsWriter(@NotNull String key, @NotNull GpxUtilities.GpxExtensionsWriter extensionsWriter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)extensionsWriter, (String)"extensionsWriter");
        this.getExtensionsWritersToWrite().put(key, extensionsWriter);
    }

    public final void removeExtensionsWriter(@NotNull String key) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Map<String, GpxUtilities.GpxExtensionsWriter> map = this.extensionsWriters;
            if (map == null) break block0;
            map.remove(key);
        }
    }

    public final void copyExtensions(@NotNull GpxExtensions e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Map<String, String> extensionsToRead = e.getExtensionsToRead();
        if (!extensionsToRead.isEmpty()) {
            this.getExtensionsToWrite().putAll(extensionsToRead);
        }
    }

    @Nullable
    public final Integer getColor(@Nullable Integer defColor) {
        String clrValue = null;
        Map<String, String> extensions = this.extensions;
        if (extensions != null) {
            clrValue = extensions.get("color");
            if (clrValue == null) {
                clrValue = extensions.get("colour");
            }
            if (clrValue == null) {
                clrValue = extensions.get("displaycolor");
            }
            if (clrValue == null) {
                clrValue = extensions.get("displaycolour");
            }
        }
        return GpxUtilities.INSTANCE.parseColor(clrValue, defColor);
    }

    public final void setColor(@Nullable Integer color) {
        Integer n = color;
        this.setColor(n != null ? KAlgorithms.INSTANCE.colorToString(n) : null);
    }

    public final void setColor(@Nullable String color) {
        block0: {
            String string = color;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.getExtensionsToWrite().put("color", it);
        }
    }

    public final void removeColor() {
        this.getExtensionsToWrite().remove("color");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/osmand/shared/gpx/primitives/GpxExtensions$Companion;", "", "<init>", "()V", "OBF_GPX_EXTENSION_TAG_PREFIX", "", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

