/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.extensions.StringExtensionsKt;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.TrackItem;
import net.osmand.shared.gpx.data.TrackFolder;
import net.osmand.shared.gpx.data.TracksGroup;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 \u00a8\u0006'"}, d2={"Lnet/osmand/shared/gpx/filters/TrackFolderAnalysis;", "", "folder", "Lnet/osmand/shared/gpx/data/TracksGroup;", "<init>", "(Lnet/osmand/shared/gpx/data/TracksGroup;)V", "tracksCount", "", "getTracksCount", "()I", "setTracksCount", "(I)V", "totalDistance", "", "getTotalDistance", "()F", "setTotalDistance", "(F)V", "timeSpan", "getTimeSpan", "setTimeSpan", "fileSize", "", "getFileSize", "()J", "setFileSize", "(J)V", "diffElevationUp", "", "getDiffElevationUp", "()D", "setDiffElevationUp", "(D)V", "diffElevationDown", "getDiffElevationDown", "setDiffElevationDown", "prepareInformation", "", "Companion", "OsmAnd-shared"})
public final class TrackFolderAnalysis {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int tracksCount;
    private float totalDistance;
    private int timeSpan;
    private long fileSize;
    private double diffElevationUp;
    private double diffElevationDown;
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("TrackFolderAnalysis");

    public TrackFolderAnalysis(@NotNull TracksGroup folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.prepareInformation(folder);
    }

    public final int getTracksCount() {
        return this.tracksCount;
    }

    public final void setTracksCount(int n) {
        this.tracksCount = n;
    }

    public final float getTotalDistance() {
        return this.totalDistance;
    }

    public final void setTotalDistance(float f) {
        this.totalDistance = f;
    }

    public final int getTimeSpan() {
        return this.timeSpan;
    }

    public final void setTimeSpan(int n) {
        this.timeSpan = n;
    }

    public final long getFileSize() {
        return this.fileSize;
    }

    public final void setFileSize(long l) {
        this.fileSize = l;
    }

    public final double getDiffElevationUp() {
        return this.diffElevationUp;
    }

    public final void setDiffElevationUp(double d) {
        this.diffElevationUp = d;
    }

    public final double getDiffElevationDown() {
        return this.diffElevationDown;
    }

    public final void setDiffElevationDown(double d) {
        this.diffElevationDown = d;
    }

    private final void prepareInformation(TracksGroup folder) {
        List items = new ArrayList();
        boolean bl = folder instanceof TrackFolder ? items.addAll((Collection)((TrackFolder)folder).getFlattenedTrackItems()) : items.addAll((Collection)folder.getTrackItems());
        double totalDistanceSum = 0.0;
        double timeSpanSum = 0.0;
        for (TrackItem trackItem : items) {
            GpxDataItem dataItem;
            GpxDataItem gpxDataItem = dataItem = trackItem.getDataItem();
            GpxTrackAnalysis analysis = gpxDataItem != null ? gpxDataItem.getAnalysis() : null;
            if (analysis == null) continue;
            totalDistanceSum += (double)analysis.getTotalDistance();
            this.diffElevationUp += analysis.getDiffElevationUp();
            this.diffElevationDown += analysis.getDiffElevationDown();
            KFile file = trackItem.getFile();
            if (file != null) {
                this.fileSize += file.length();
            }
            if (!analysis.isTimeSpecified()) continue;
            timeSpanSum += (double)analysis.getDurationInMs() / 1000.0;
        }
        this.totalDistance = (float)totalDistanceSum;
        this.timeSpan = (int)timeSpanSum;
        this.tracksCount = items.size();
        Object[] objectArray = new Object[]{Float.valueOf(this.totalDistance)};
        String string = StringExtensionsKt.format("%.2f", objectArray);
        objectArray = new Object[]{this.diffElevationUp};
        String string2 = StringExtensionsKt.format("%.2f", objectArray);
        objectArray = new Object[]{this.diffElevationDown};
        log.info(">>>> " + folder.getName() + " = (tracks: " + this.tracksCount + ", totalDistance: " + string + ", timeSpan: " + this.timeSpan + ", fileSize: " + this.fileSize + ", diffElevationUp: " + string2 + ", diffElevationDown: " + StringExtensionsKt.format("%.2f", objectArray));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/osmand/shared/gpx/filters/TrackFolderAnalysis$Companion;", "", "<init>", "()V", "log", "Lnet/osmand/shared/util/Logger;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

