/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.osmand.shared.api.SQLiteAPI;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxDatabase;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.PlatformUtil;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u001c\u0010\u0011\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ&\u0010\u001e\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,J\u001c\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010.2\u0006\u0010(\u001a\u00020/J*\u00100\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010.2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010.J\u001c\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010.2\u0006\u0010+\u001a\u00020,J\u000e\u00102\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,J\u0018\u00103\u001a\u0004\u0018\u00010\u00012\u0006\u00104\u001a\u0002052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u00106\u001a\u00020'2\u0006\u0010+\u001a\u00020,J\u000e\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lnet/osmand/shared/gpx/GpxDbUtils;", "", "<init>", "()V", "GPX_TABLE_INDEX", "", "GPX_DIR_TABLE_INDEX", "getCreateGpxTableQuery", "getCreateGpxDirTableQuery", "getSelectGpxQuery", "parameter", "Lnet/osmand/shared/gpx/GpxParameter;", "getSelectGpxDirQuery", "getCreateTableQuery", "parameters", "", "tableName", "getSelectQuery", "getGpxIndexQuery", "getGpxDirIndexQuery", "onCreate", "", "db", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteConnection;", "onUpgrade", "database", "Lnet/osmand/shared/gpx/GpxDatabase;", "oldVersion", "", "newVersion", "addIfMissingGpxTableColumn", "columnNamesLC", "", "addGpxTableColumn", "addGpxDirTableColumn", "addTableColumn", "columnName", "columnType", "isAnalyseNeeded", "", "item", "Lnet/osmand/shared/gpx/GpxDataItem;", "getGpxFileDir", "file", "Lnet/osmand/shared/io/KFile;", "getItemParameters", "", "Lnet/osmand/shared/gpx/DataItem;", "convertGpxParameters", "getItemRowsToSearch", "getTableName", "queryColumnValue", "query", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteCursor;", "isGpxFile", "createDataVersion", "analysisVersion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGpxDbUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpxDbUtils.kt\nnet/osmand/shared/gpx/GpxDbUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,275:1\n11102#2:276\n11437#2,3:277\n11102#2:282\n11437#2,3:283\n1863#3,2:280\n1863#3,2:286\n216#4,2:288\n*S KotlinDebug\n*F\n+ 1 GpxDbUtils.kt\nnet/osmand/shared/gpx/GpxDbUtils\n*L\n90#1:276\n90#1:277,3\n166#1:282\n166#1:283,3\n155#1:280,2\n168#1:286,2\n229#1:288,2\n*E\n"})
public final class GpxDbUtils {
    @NotNull
    public static final GpxDbUtils INSTANCE = new GpxDbUtils();
    @NotNull
    private static final String GPX_TABLE_INDEX = "indexNameDir";
    @NotNull
    private static final String GPX_DIR_TABLE_INDEX = "gpxDirIndexNameDir";

    private GpxDbUtils() {
    }

    @NotNull
    public final String getCreateGpxTableQuery() {
        return this.getCreateTableQuery((List)GpxParameter.getEntries(), "gpxTable");
    }

    @NotNull
    public final String getCreateGpxDirTableQuery() {
        return this.getCreateTableQuery(GpxParameter.Companion.getGpxDirParameters(), "gpxDirTable");
    }

    @NotNull
    public final String getSelectGpxQuery() {
        return this.getSelectQuery((List)GpxParameter.getEntries(), "gpxTable");
    }

    @NotNull
    public final String getSelectGpxQuery(@NotNull GpxParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        return this.getSelectQuery(CollectionsKt.listOf((Object)((Object)parameter)), "gpxTable");
    }

    @NotNull
    public final String getSelectGpxDirQuery() {
        return this.getSelectQuery(GpxParameter.Companion.getGpxDirParameters(), "gpxDirTable");
    }

    @NotNull
    public final String getSelectGpxDirQuery(@NotNull GpxParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        return this.getSelectQuery(CollectionsKt.listOf((Object)((Object)parameter)), "gpxDirTable");
    }

    @NotNull
    public final String getCreateTableQuery(@NotNull List<? extends GpxParameter> parameters, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        StringBuilder builder = new StringBuilder("CREATE TABLE IF NOT EXISTS " + tableName + " (");
        Iterator<? extends GpxParameter> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            GpxParameter parameter = iterator.next();
            builder.append(" " + parameter.getColumnName() + " " + parameter.getColumnType());
            StringBuilder stringBuilder = iterator.hasNext() ? builder.append(", ") : builder.append(");");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getSelectQuery(@NotNull List<? extends GpxParameter> parameters, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        StringBuilder builder = new StringBuilder("SELECT ");
        Iterator<? extends GpxParameter> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            GpxParameter parameter = iterator.next();
            builder.append(parameter.getColumnName());
            StringBuilder stringBuilder = iterator.hasNext() ? builder.append(", ") : builder.append(" FROM " + tableName);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getGpxIndexQuery() {
        return "CREATE INDEX IF NOT EXISTS indexNameDir ON gpxTable (" + GpxParameter.FILE_NAME.getColumnName() + ", " + GpxParameter.FILE_DIR.getColumnName() + ");";
    }

    @NotNull
    public final String getGpxDirIndexQuery() {
        return "CREATE INDEX IF NOT EXISTS gpxDirIndexNameDir ON gpxDirTable (" + GpxParameter.FILE_NAME.getColumnName() + ", " + GpxParameter.FILE_DIR.getColumnName() + ");";
    }

    public final void onCreate(@NotNull SQLiteAPI.SQLiteConnection db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        db.execSQL(this.getCreateGpxTableQuery());
        db.execSQL(this.getGpxIndexQuery());
        db.execSQL(this.getCreateGpxDirTableQuery());
        db.execSQL(this.getGpxDirIndexQuery());
    }

    /*
     * WARNING - void declaration
     */
    public final void onUpgrade(@NotNull GpxDatabase database, @NotNull SQLiteAPI.SQLiteConnection db, int oldVersion, int newVersion) {
        Collection collection;
        int n;
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        SQLiteAPI.SQLiteCursor gpxCursor = db.rawQuery("SELECT * FROM gpxTable LIMIT 1", null);
        if (gpxCursor != null) {
            Iterator $this$mapTo$iv$iv;
            String[] $this$map$iv = gpxCursor.getColumnNames();
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var15_20 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                collection.add(string);
            }
            Set columnNames = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.FILE_NAME);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.FILE_DIR);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.TOTAL_DISTANCE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.TOTAL_TRACKS);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.START_TIME);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.END_TIME);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.TIME_SPAN);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.TIME_MOVING);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.TOTAL_DISTANCE_MOVING);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.DIFF_ELEVATION_UP);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.DIFF_ELEVATION_DOWN);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.AVG_ELEVATION);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MIN_ELEVATION);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_ELEVATION);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MIN_SPEED);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_SPEED);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.AVG_SPEED);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.POINTS);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.WPT_POINTS);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.COLOR);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.FILE_LAST_MODIFIED_TIME);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.FILE_LAST_UPLOADED_TIME);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.FILE_CREATION_TIME);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.SPLIT_TYPE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.SPLIT_INTERVAL);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.API_IMPORTED);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.WPT_CATEGORY_NAMES);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.SHOW_AS_MARKERS);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.JOIN_SEGMENTS);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.SHOW_ARROWS);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.SHOW_START_FINISH);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.TRACK_VISUALIZATION_TYPE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.TRACK_3D_WALL_COLORING_TYPE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.TRACK_3D_LINE_POSITION_TYPE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.ADDITIONAL_EXAGGERATION);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.ELEVATION_METERS);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.WIDTH);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.COLORING_TYPE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.COLOR_PALETTE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.SMOOTHING_THRESHOLD);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MIN_FILTER_SPEED);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_FILTER_SPEED);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MIN_FILTER_ALTITUDE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_FILTER_ALTITUDE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_FILTER_HDOP);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.START_LAT);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.START_LON);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.NEAREST_CITY_NAME);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.ACTIVITY_TYPE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_SENSOR_TEMPERATURE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.AVG_SENSOR_TEMPERATURE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_SENSOR_SPEED);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.AVG_SENSOR_SPEED);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_SENSOR_POWER);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.AVG_SENSOR_POWER);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_SENSOR_CADENCE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.AVG_SENSOR_CADENCE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.MAX_SENSOR_HEART_RATE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.AVG_SENSOR_HEART_RATE);
            this.addIfMissingGpxTableColumn(columnNames, db, GpxParameter.DATA_VERSION);
            Iterable $this$forEach$iv = (Iterable)GpxParameter.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GpxParameter parameter = (GpxParameter)((Object)element$iv);
                boolean bl = false;
                String string = parameter.getColumnName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (columnNames.contains(string)) continue;
                INSTANCE.addGpxTableColumn(db, parameter);
            }
        }
        db.execSQL(this.getCreateGpxDirTableQuery());
        SQLiteAPI.SQLiteCursor gpxDirCursor = db.rawQuery("SELECT * FROM gpxDirTable LIMIT 1", null);
        if (gpxDirCursor != null) {
            void $this$mapTo$iv$iv;
            Object element$iv;
            String[] $this$map$iv = gpxDirCursor.getColumnNames();
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                void it;
                void item$iv$iv;
                void bl = item$iv$iv = $this$mapTo$iv$iv[n];
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                collection.add(string);
            }
            Set dirColumnNames = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            Iterable $this$forEach$iv = GpxParameter.Companion.getGpxDirParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                GpxParameter parameter = (GpxParameter)((Object)element$iv2);
                boolean bl = false;
                String string = parameter.getColumnName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (dirColumnNames.contains(string)) continue;
                INSTANCE.addGpxDirTableColumn(db, parameter);
            }
        }
        db.execSQL(this.getGpxIndexQuery());
        db.execSQL(this.getGpxDirIndexQuery());
    }

    private final void addIfMissingGpxTableColumn(Set<String> columnNamesLC, SQLiteAPI.SQLiteConnection db, GpxParameter parameter) {
        String string = parameter.getColumnName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (columnNamesLC.contains(string)) {
            return;
        }
        String string2 = parameter.getColumnName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        columnNamesLC.add(string2);
        this.addGpxTableColumn(db, parameter);
    }

    private final void addGpxTableColumn(SQLiteAPI.SQLiteConnection db, GpxParameter parameter) {
        this.addTableColumn(db, "gpxTable", parameter.getColumnName(), parameter.getColumnType());
    }

    private final void addGpxDirTableColumn(SQLiteAPI.SQLiteConnection db, GpxParameter parameter) {
        this.addTableColumn(db, "gpxDirTable", parameter.getColumnName(), parameter.getColumnType());
    }

    private final void addTableColumn(SQLiteAPI.SQLiteConnection db, String tableName, String columnName, String columnType) {
        db.execSQL("ALTER TABLE " + tableName + " ADD " + columnName + " " + columnType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAnalyseNeeded(@Nullable GpxDataItem item) {
        if (item == null) return true;
        if (!item.hasData()) return true;
        if (item.getAnalysis() == null) return true;
        GpxTrackAnalysis gpxTrackAnalysis = item.getAnalysis();
        Intrinsics.checkNotNull((Object)gpxTrackAnalysis);
        if (gpxTrackAnalysis.getWptCategoryNames() == null) return true;
        GpxTrackAnalysis gpxTrackAnalysis2 = item.getAnalysis();
        Intrinsics.checkNotNull((Object)gpxTrackAnalysis2);
        if (gpxTrackAnalysis2.getLatLonStart() == null) {
            GpxTrackAnalysis gpxTrackAnalysis3 = item.getAnalysis();
            Intrinsics.checkNotNull((Object)gpxTrackAnalysis3);
            if (gpxTrackAnalysis3.getPoints() > 0) return true;
        }
        Object t = item.requireParameter(GpxParameter.FILE_LAST_MODIFIED_TIME);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Long");
        if (((Long)t).longValue() != item.getFile().lastModified()) return true;
        Object t2 = item.requireParameter(GpxParameter.FILE_CREATION_TIME);
        Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type kotlin.Long");
        if ((Long)t2 <= 0L) return true;
        int n = this.createDataVersion(1);
        Object t3 = item.requireParameter(GpxParameter.DATA_VERSION);
        Intrinsics.checkNotNull(t3, (String)"null cannot be cast to non-null type kotlin.Int");
        if (n <= (Integer)t3) return false;
        return true;
    }

    @NotNull
    public final String getGpxFileDir(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.parent();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            KFile gpxDir = PlatformUtil.INSTANCE.getOsmAndContext().getGpxDir();
            if (Intrinsics.areEqual((Object)it, (Object)gpxDir.getPath())) {
                return "";
            }
            KFile relativePath = new KFile(StringsKt.replace$default((String)file.path(), (String)(gpxDir.getPath() + "/"), (String)"", (boolean)false, (int)4, null));
            Path fileDir = file.isDirectory() ? relativePath.getPath() : relativePath.parent();
            String res = String.valueOf(fileDir);
            return Intrinsics.areEqual((Object)res, (Object)".") ? "" : res;
        }
        return "";
    }

    @NotNull
    public final Map<GpxParameter, Object> getItemParameters(@NotNull DataItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item.getParameters();
    }

    @NotNull
    public final Map<String, Object> convertGpxParameters(@NotNull Map<GpxParameter, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        LinkedHashMap map = new LinkedHashMap();
        Map<GpxParameter, ? extends Object> $this$forEach$iv = parameters;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<GpxParameter, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<GpxParameter, ? extends Object> element$iv;
            Map.Entry<GpxParameter, ? extends Object> entry = element$iv = iterator.next();
            boolean bl = false;
            GpxParameter parameter = entry.getKey();
            Object value = entry.getValue();
            ((Map)map).put(parameter.getColumnName(), parameter.convertToDbValue(value));
        }
        return map;
    }

    @NotNull
    public final Map<String, Object> getItemRowsToSearch(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LinkedHashMap map = new LinkedHashMap();
        ((Map)map).put(GpxParameter.FILE_NAME.getColumnName(), file.name());
        ((Map)map).put(GpxParameter.FILE_DIR.getColumnName(), this.getGpxFileDir(file));
        return map;
    }

    @NotNull
    public final String getTableName(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.exists() ? (!file.isDirectory() ? "gpxTable" : "gpxDirTable") : (this.isGpxFile(file) ? "gpxTable" : "gpxDirTable");
    }

    @Nullable
    public final Object queryColumnValue(@NotNull SQLiteAPI.SQLiteCursor query, @NotNull GpxParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        int index = query.getColumnIndex(parameter.getColumnName());
        if (query.isNull(index)) {
            return null;
        }
        return switch (parameter.getColumnType()) {
            case "TEXT" -> query.getString(index);
            case "double" -> query.getDouble(index);
            case "int" -> {
                int value = query.getInt(index);
                if (Intrinsics.areEqual(parameter.getTypeClass(), (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    yield value == 1;
                }
                yield value;
            }
            case "bigint", "long" -> query.getLong(index);
            default -> throw new IllegalArgumentException("Unknown column type " + parameter.getColumnType());
        };
    }

    public final boolean isGpxFile(@NotNull KFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return StringsKt.endsWith$default((String)string, (String)".gpx", (boolean)false, (int)2, null);
    }

    public final int createDataVersion(int analysisVersion) {
        return 28672 + analysisVersion;
    }
}

