/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.ElevationApproximator;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.util.KMapUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0004\b&\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH&J\b\u0010\u000f\u001a\u00020\rH&J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0005J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013J8\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnet/osmand/shared/gpx/ElevationDiffsCalculator;", "", "<init>", "()V", "ELE_THRESHOLD", "", "diffElevationUp", "diffElevationDown", "extremums", "", "Lnet/osmand/shared/gpx/ElevationDiffsCalculator$Extremum;", "getPointDistance", "index", "", "getPointElevation", "getPointsCount", "getDiffElevationUp", "getDiffElevationDown", "getExtremums", "", "getProjectionDist", "x", "y", "fromx", "fromy", "tox", "toy", "findMaximumExtremumBetween", "", "start", "end", "points", "", "calculateElevationDiffs", "Extremum", "Companion", "OsmAnd-shared"})
public abstract class ElevationDiffsCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double ELE_THRESHOLD;
    private double diffElevationUp;
    private double diffElevationDown;
    @NotNull
    private List<Extremum> extremums = new ArrayList();

    public ElevationDiffsCalculator() {
        this.ELE_THRESHOLD = 7.0;
    }

    public abstract double getPointDistance(int var1);

    public abstract double getPointElevation(int var1);

    public abstract int getPointsCount();

    public final double getDiffElevationUp() {
        return this.diffElevationUp;
    }

    public final double getDiffElevationDown() {
        return this.diffElevationDown;
    }

    @NotNull
    public final List<Extremum> getExtremums() {
        return CollectionsKt.toList((Iterable)this.extremums);
    }

    private final double getProjectionDist(double x, double y, double fromx, double fromy, double tox, double toy) {
        double mDist = (fromx - tox) * (fromx - tox) + (fromy - toy) * (fromy - toy);
        double projection = KMapUtils.INSTANCE.scalarMultiplication(fromx, fromy, tox, toy, x, y);
        Pair pair = projection < 0.0 ? new Pair((Object)fromx, (Object)fromy) : (projection >= mDist ? new Pair((Object)tox, (Object)toy) : new Pair((Object)(fromx + (tox - fromx) * (projection / mDist)), (Object)(fromy + (toy - fromy) * (projection / mDist))));
        double prx = ((Number)pair.component1()).doubleValue();
        double pry = ((Number)pair.component2()).doubleValue();
        return Math.sqrt((prx - x) * (prx - x) + (pry - y) * (pry - y));
    }

    private final void findMaximumExtremumBetween(int start, int end, boolean[] points) {
        double firstPointDist = this.getPointDistance(start);
        double firstPointEle = this.getPointElevation(start);
        double endPointEle = this.getPointElevation(end);
        double endPointDist = this.getPointDistance(end);
        int max = start;
        double maxDiff = this.ELE_THRESHOLD;
        for (int i = start + 1; i < end; ++i) {
            double md = this.getProjectionDist(this.getPointDistance(i), this.getPointElevation(i), firstPointDist, firstPointEle, endPointDist, endPointEle);
            if (!(md > maxDiff)) continue;
            max = i;
            maxDiff = md;
        }
        if (max != start) {
            points[max] = true;
            this.findMaximumExtremumBetween(start, max, points);
            this.findMaximumExtremumBetween(max, end, points);
        }
    }

    public final void calculateElevationDiffs() {
        int i;
        int pointsCount = this.getPointsCount();
        if (pointsCount < 2) {
            return;
        }
        boolean[] points = new boolean[pointsCount];
        points[0] = true;
        points[pointsCount - 1] = true;
        this.findMaximumExtremumBetween(0, pointsCount - 1, points);
        this.extremums = new ArrayList();
        int n = points.length;
        for (i = 0; i < n; ++i) {
            if (!points[i]) continue;
            this.extremums.add(new Extremum(this.getPointDistance(i), this.getPointElevation(i)));
        }
        n = this.extremums.size();
        for (i = 1; i < n; ++i) {
            double prevElevation = this.extremums.get(i - 1).getEle();
            double elevation = this.extremums.get(i).getEle();
            double eleDiffSumm = elevation - prevElevation;
            if (eleDiffSumm > 0.0) {
                this.diffElevationUp += eleDiffSumm;
                continue;
            }
            this.diffElevationDown -= eleDiffSumm;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lnet/osmand/shared/gpx/ElevationDiffsCalculator$Companion;", "", "<init>", "()V", "calculateDiffs", "", "points", "", "Lnet/osmand/shared/gpx/primitives/WptPt;", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final void calculateDiffs(@NotNull List<WptPt> points) {
            Intrinsics.checkNotNullParameter(points, (String)"points");
            ElevationApproximator approximator2 = new ElevationApproximator(points){
                final /* synthetic */ List<WptPt> $points;
                {
                    this.$points = $points;
                }

                public double getPointLatitude(int index) {
                    return this.$points.get(index).getLat();
                }

                public double getPointLongitude(int index) {
                    return this.$points.get(index).getLon();
                }

                public double getPointElevation(int index) {
                    return this.$points.get(index).getEle();
                }

                public int getPointsCount() {
                    return this.$points.size();
                }
            };
            approximator2.approximate();
            double[] distances = approximator2.getDistances();
            double[] elevations = approximator2.getElevations();
            if (distances != null && elevations != null) {
                double diffElevationUp = 0.0;
                double diffElevationDown = 0.0;
                ElevationDiffsCalculator elevationDiffsCalc2 = new ElevationDiffsCalculator(distances, elevations){
                    final /* synthetic */ double[] $distances;
                    final /* synthetic */ double[] $elevations;
                    {
                        this.$distances = $distances;
                        this.$elevations = $elevations;
                    }

                    public double getPointDistance(int index) {
                        return this.$distances[index];
                    }

                    public double getPointElevation(int index) {
                        return this.$elevations[index];
                    }

                    public int getPointsCount() {
                        return this.$distances.length;
                    }
                };
                elevationDiffsCalc2.calculateElevationDiffs();
                String string = "GPX points=" + points.size() + " approx points=" + distances.length + " diffUp=" + (diffElevationUp += elevationDiffsCalc2.getDiffElevationUp()) + " diffDown=" + (diffElevationDown += elevationDiffsCalc2.getDiffElevationDown());
                System.out.println((Object)string);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lnet/osmand/shared/gpx/ElevationDiffsCalculator$Extremum;", "", "dist", "", "ele", "<init>", "(DD)V", "getDist", "()D", "getEle", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "OsmAnd-shared"})
    public static final class Extremum {
        private final double dist;
        private final double ele;

        public Extremum(double dist, double ele) {
            this.dist = dist;
            this.ele = ele;
        }

        public final double getDist() {
            return this.dist;
        }

        public final double getEle() {
            return this.ele;
        }

        public final double component1() {
            return this.dist;
        }

        public final double component2() {
            return this.ele;
        }

        @NotNull
        public final Extremum copy(double dist, double ele) {
            return new Extremum(dist, ele);
        }

        public static /* synthetic */ Extremum copy$default(Extremum extremum, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = extremum.dist;
            }
            if ((n & 2) != 0) {
                d2 = extremum.ele;
            }
            return extremum.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "Extremum(dist=" + this.dist + ", ele=" + this.ele + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.dist);
            result = result * 31 + Double.hashCode(this.ele);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Extremum)) {
                return false;
            }
            Extremum extremum = (Extremum)other;
            if (Double.compare(this.dist, extremum.dist) != 0) {
                return false;
            }
            return Double.compare(this.ele, extremum.ele) == 0;
        }
    }
}

