/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J \u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lnet/osmand/shared/ColorPalette;", "", "<init>", "()V", "c", "minVal", "", "maxVal", "(Lnet/osmand/shared/ColorPalette;DD)V", "colors", "", "Lnet/osmand/shared/ColorPalette$ColorValue;", "getColors", "()Ljava/util/List;", "getColorByValue", "", "value", "getIntermediateColor", "min", "max", "percent", "toString", "", "writeColorPalette", "sortPalette", "", "Companion", "ColorValue", "OsmAnd-shared"})
public final class ColorPalette {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ColorValue> colors;
    @NotNull
    private static final Logger LOG = LoggerFactory.INSTANCE.getLogger("ColorPalette");
    private static final int DARK_GREY = Companion.rgbaToDecimal(92, 92, 92, 255);
    private static final int LIGHT_GREY = Companion.rgbaToDecimal(200, 200, 200, 255);
    private static final int GREEN = Companion.rgbaToDecimal(90, 220, 95, 255);
    private static final int YELLOW = Companion.rgbaToDecimal(212, 239, 50, 255);
    private static final int RED = Companion.rgbaToDecimal(243, 55, 77, 255);
    private static final int BLUE_SLOPE = Companion.rgbaToDecimal(0, 0, 255, 255);
    private static final int CYAN_SLOPE = Companion.rgbaToDecimal(0, 255, 255, 255);
    private static final int GREEN_SLOPE = Companion.rgbaToDecimal(46, 185, 0, 255);
    private static final int WHITE = Companion.rgbaToDecimal(255, 255, 255, 255);
    private static final int YELLOW_SLOPE = Companion.rgbaToDecimal(255, 222, 2, 255);
    private static final int RED_SLOPE = Companion.rgbaToDecimal(255, 1, 1, 255);
    private static final int PURPLE_SLOPE = Companion.rgbaToDecimal(130, 1, 255, 255);
    @NotNull
    private static final int[] COLORS;
    @NotNull
    private static final int[] SLOPE_COLORS;
    public static final double SLOPE_MIN_VALUE = -1.0;
    public static final double SLOPE_MAX_VALUE = 1.0;
    @NotNull
    private static final ColorPalette SLOPE_PALETTE;
    @NotNull
    private static final ColorPalette MIN_MAX_PALETTE;

    @NotNull
    public final List<ColorValue> getColors() {
        return this.colors;
    }

    public ColorPalette() {
        this.colors = new ArrayList();
    }

    public ColorPalette(@NotNull ColorPalette c, double minVal, double maxVal) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.colors = new ArrayList();
        for (ColorValue cv : c.colors) {
            double value = cv.getValue() * (maxVal - minVal) + minVal;
            this.colors.add(new ColorValue(value, cv.getClr()));
        }
    }

    public final int getColorByValue(double value) {
        if (Double.isNaN(value)) {
            return LIGHT_GREY;
        }
        int n = this.colors.size() - 1;
        for (int i = 0; i < n; ++i) {
            ColorValue min = this.colors.get(i);
            ColorValue max = this.colors.get(i + 1);
            if (value == min.getValue()) {
                return min.getClr();
            }
            if (!(value >= min.getValue()) || !(value <= max.getValue())) continue;
            double percent = (value - min.getValue()) / (max.getValue() - min.getValue());
            return this.getIntermediateColor(min, max, percent);
        }
        return value <= this.colors.get(0).getValue() ? this.colors.get(0).getClr() : (value >= this.colors.get(this.colors.size() - 1).getValue() ? this.colors.get(this.colors.size() - 1).getClr() : Companion.getTransparentColor());
    }

    private final int getIntermediateColor(ColorValue min, ColorValue max, double percent) {
        double r = (double)min.getR() + percent * (double)(max.getR() - min.getR());
        double g = (double)min.getG() + percent * (double)(max.getG() - min.getG());
        double b = (double)min.getB() + percent * (double)(max.getB() - min.getB());
        double a = (double)min.getA() + percent * (double)(max.getA() - min.getA());
        return Companion.rgbaToDecimal((int)r, (int)g, (int)b, (int)a);
    }

    @NotNull
    public String toString() {
        return this.writeColorPalette();
    }

    @NotNull
    public final String writeColorPalette() {
        StringBuilder bld = new StringBuilder();
        for (ColorValue v : this.colors) {
            bld.append(v.getValue()).append(",");
            bld.append(v.getR()).append(",").append(v.getG()).append(",").append(v.getB()).append(",").append(v.getA()).append("\n");
        }
        String string = bld.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private final void sortPalette() {
        CollectionsKt.sortWith(this.colors, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ColorValue it = (ColorValue)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getValue());
                it = (ColorValue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getValue()));
            }
        });
    }

    static {
        Object object = new int[]{GREEN, YELLOW, RED};
        COLORS = object;
        object = new int[]{CYAN_SLOPE, GREEN_SLOPE, LIGHT_GREY, YELLOW_SLOPE, RED_SLOPE};
        SLOPE_COLORS = object;
        object = new double[7][];
        double[] dArray = new double[]{-1.0, BLUE_SLOPE};
        object[0] = (int)dArray;
        dArray = new double[]{-0.15, CYAN_SLOPE};
        object[1] = (int)dArray;
        dArray = new double[]{-0.05, GREEN_SLOPE};
        object[2] = (int)dArray;
        dArray = new double[]{0.0, LIGHT_GREY};
        object[3] = (int)dArray;
        dArray = new double[]{0.05, YELLOW_SLOPE};
        object[4] = (int)dArray;
        dArray = new double[]{0.15, RED_SLOPE};
        object[5] = (int)dArray;
        dArray = new double[]{1.0, PURPLE_SLOPE};
        object[6] = (int)dArray;
        SLOPE_PALETTE = ColorPalette.Companion.parsePalette((double[][])object);
        object = new double[3][];
        dArray = new double[]{0.0, GREEN};
        object[0] = (int)dArray;
        dArray = new double[]{0.5, YELLOW};
        object[1] = (int)dArray;
        dArray = new double[]{1.0, RED};
        object[2] = (int)dArray;
        MIN_MAX_PALETTE = ColorPalette.Companion.parsePalette((double[][])object);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lnet/osmand/shared/ColorPalette$ColorValue;", "", "value", "", "r", "", "g", "b", "a", "clr", "<init>", "(DIIIII)V", "(DI)V", "getValue", "()D", "getR", "()I", "getG", "getB", "getA", "getClr", "toString", "", "Companion", "OsmAnd-shared"})
    public static final class ColorValue {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double value;
        private final int r;
        private final int g;
        private final int b;
        private final int a;
        private final int clr;

        public ColorValue(double value, int r, int g, int b, int a, int clr) {
            this.value = value;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.clr = clr;
        }

        public /* synthetic */ ColorValue(double d, int n, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n6 & 0x20) != 0) {
                n5 = Companion.rgbaToDecimal(n, n2, n3, n4);
            }
            this(d, n, n2, n3, n4, n5);
        }

        public final double getValue() {
            return this.value;
        }

        public final int getR() {
            return this.r;
        }

        public final int getG() {
            return this.g;
        }

        public final int getB() {
            return this.b;
        }

        public final int getA() {
            return this.a;
        }

        public final int getClr() {
            return this.clr;
        }

        public ColorValue(double value, int clr) {
            this(value, Companion.red(clr), Companion.green(clr), Companion.blue(clr), Companion.alpha(clr), clr);
        }

        @NotNull
        public String toString() {
            return "ColorValue [r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + ", val=" + this.value + "]";
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lnet/osmand/shared/ColorPalette$ColorValue$Companion;", "", "<init>", "()V", "rgba", "Lnet/osmand/shared/ColorPalette$ColorValue;", "value", "", "r", "", "g", "b", "a", "OsmAnd-shared"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ColorValue rgba(double value, int r, int g, int b, int a) {
                return new ColorValue(value, r, g, b, a, 0, 32, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007J\u001b\u00104\u001a\u00020*2\f\u00105\u001a\b\u0012\u0004\u0012\u00020706H\u0002\u00a2\u0006\u0002\u00108J\u0006\u00109\u001a\u00020\u0007J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0002J\u0010\u0010<\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0002J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0002J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0002J\u001e\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020'J\u000e\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020ER\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0011\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0011\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u0011\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u0011\u0010\u001c\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR\u0011\u0010\u001e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\tR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u000e\u0010&\u001a\u00020'X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010,\u00a8\u0006F"}, d2={"Lnet/osmand/shared/ColorPalette$Companion;", "", "<init>", "()V", "LOG", "Lnet/osmand/shared/util/Logger;", "DARK_GREY", "", "getDARK_GREY", "()I", "LIGHT_GREY", "getLIGHT_GREY", "GREEN", "getGREEN", "YELLOW", "getYELLOW", "RED", "getRED", "BLUE_SLOPE", "getBLUE_SLOPE", "CYAN_SLOPE", "getCYAN_SLOPE", "GREEN_SLOPE", "getGREEN_SLOPE", "WHITE", "getWHITE", "YELLOW_SLOPE", "getYELLOW_SLOPE", "RED_SLOPE", "getRED_SLOPE", "PURPLE_SLOPE", "getPURPLE_SLOPE", "COLORS", "", "getCOLORS", "()[I", "SLOPE_COLORS", "getSLOPE_COLORS", "SLOPE_MIN_VALUE", "", "SLOPE_MAX_VALUE", "SLOPE_PALETTE", "Lnet/osmand/shared/ColorPalette;", "getSLOPE_PALETTE", "()Lnet/osmand/shared/ColorPalette;", "MIN_MAX_PALETTE", "getMIN_MAX_PALETTE", "rgbaToDecimal", "r", "g", "b", "a", "parsePalette", "vl", "", "", "([[D)Lnet/osmand/shared/ColorPalette;", "getTransparentColor", "red", "value", "green", "blue", "alpha", "getIntermediateColor", "min", "max", "percent", "parseColorPalette", "file", "Lnet/osmand/shared/io/KFile;", "OsmAnd-shared"})
    @SourceDebugExtension(value={"SMAP\nColorPalette.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorPalette.kt\nnet/osmand/shared/ColorPalette$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,226:1\n1#2:227\n108#3:228\n80#3,22:229\n739#4,9:251\n37#5,2:260\n*S KotlinDebug\n*F\n+ 1 ColorPalette.kt\nnet/osmand/shared/ColorPalette$Companion\n*L\n114#1:228\n114#1:229,22\n118#1:251,9\n119#1:260,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDARK_GREY() {
            return DARK_GREY;
        }

        public final int getLIGHT_GREY() {
            return LIGHT_GREY;
        }

        public final int getGREEN() {
            return GREEN;
        }

        public final int getYELLOW() {
            return YELLOW;
        }

        public final int getRED() {
            return RED;
        }

        public final int getBLUE_SLOPE() {
            return BLUE_SLOPE;
        }

        public final int getCYAN_SLOPE() {
            return CYAN_SLOPE;
        }

        public final int getGREEN_SLOPE() {
            return GREEN_SLOPE;
        }

        public final int getWHITE() {
            return WHITE;
        }

        public final int getYELLOW_SLOPE() {
            return YELLOW_SLOPE;
        }

        public final int getRED_SLOPE() {
            return RED_SLOPE;
        }

        public final int getPURPLE_SLOPE() {
            return PURPLE_SLOPE;
        }

        @NotNull
        public final int[] getCOLORS() {
            return COLORS;
        }

        @NotNull
        public final int[] getSLOPE_COLORS() {
            return SLOPE_COLORS;
        }

        @NotNull
        public final ColorPalette getSLOPE_PALETTE() {
            return SLOPE_PALETTE;
        }

        @NotNull
        public final ColorPalette getMIN_MAX_PALETTE() {
            return MIN_MAX_PALETTE;
        }

        public final int rgbaToDecimal(int r, int g, int b, int a) {
            return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        }

        private final ColorPalette parsePalette(double[][] vl) {
            ColorPalette palette = new ColorPalette();
            int n = ((Object[])vl).length;
            for (int i = 0; i < n; ++i) {
                ColorValue it;
                ColorValue c;
                double[] v = vl[i];
                ColorValue colorValue = v.length == 2 ? new ColorValue(v[0], (int)v[1]) : (v.length == 4 ? new ColorValue(v[0], (int)v[1], (int)v[2], (int)v[3], 255, 0, 32, null) : (c = v.length >= 5 ? new ColorValue(v[0], (int)v[1], (int)v[2], (int)v[3], (int)v[4], 0, 32, null) : null));
                if (c == null) continue;
                boolean bl = false;
                palette.getColors().add(it);
            }
            palette.sortPalette();
            return palette;
        }

        public final int getTransparentColor() {
            return this.rgbaToDecimal(0, 0, 0, 0);
        }

        private final int red(int value) {
            return value >> 16 & 0xFF;
        }

        private final int green(int value) {
            return value >> 8 & 0xFF;
        }

        private final int blue(int value) {
            return value & 0xFF;
        }

        private final int alpha(int value) {
            return value >> 24 & 0xFF;
        }

        public final int getIntermediateColor(int min, int max, double percent) {
            double r = (double)this.red(min) + percent * (double)(this.red(max) - this.red(min));
            double g = (double)this.green(min) + percent * (double)(this.green(max) - this.green(min));
            double b = (double)this.blue(min) + percent * (double)(this.blue(max) - this.blue(min));
            double a = (double)this.alpha(min) + percent * (double)(this.alpha(max) - this.alpha(min));
            return this.rgbaToDecimal((int)r, (int)g, (int)b, (int)a);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ColorPalette parseColorPalette(@NotNull KFile file) throws IOException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ColorPalette palette = new ColorPalette();
            BufferedSource buf = Okio.buffer((Source)file.source());
            String line = null;
            while ((line = buf.readUtf8Line()) != null) {
                void $this$toTypedArray$iv;
                List list;
                Collection $this$dropLastWhile$iv;
                String t;
                String $this$trim$iv = line;
                boolean $i$f$trim22 = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                int $i$f$trim = 0;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (StringsKt.startsWith$default((String)(t = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"#", (boolean)false, (int)2, null)) continue;
                Object $i$f$trim22 = t;
                $this$trim$iv$iv = new Regex(",");
                $i$f$trim = 0;
                $i$f$trim22 = $this$trim$iv$iv.split((CharSequence)$i$f$trim22, $i$f$trim);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] values = thisCollection$iv.toArray(new String[0]);
                if (values.length < 4) continue;
                try {
                    ColorValue rgba = ColorValue.Companion.rgba(Double.parseDouble(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]), values.length >= 4 ? Integer.parseInt(values[4]) : 255);
                    palette.getColors().add(rgba);
                }
                catch (NumberFormatException e) {
                    LOG.error(e.getMessage(), e);
                }
            }
            palette.sortPalette();
            return palette;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

