/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.handler;

import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;

public class QuoteTagHandler
extends TagHandler {
    public QuoteTagHandler() {
        super(true);
    }

    @Override
    public boolean isBlockHandler(TagContext context) {
        return !context.getParent().isTag("blockquote");
    }

    @Override
    protected void begin(TagContext context) {
        int quoteDepth = context.getTagStack().getQuoteDepth();
        if (quoteDepth == 0) {
            context.getScannerContext().beginQuot(context.getParams());
        }
        context.getScannerContext().beginQuotLine(++quoteDepth);
        context.getTagStack().setQuoteDepth(quoteDepth);
    }

    @Override
    protected void end(TagContext context) {
        int quoteDepth = context.getTagStack().getQuoteDepth();
        if (--quoteDepth < 0) {
            quoteDepth = 0;
        }
        context.getScannerContext().endQuotLine();
        if (quoteDepth == 0) {
            context.getScannerContext().endQuot();
        }
        context.getTagStack().setQuoteDepth(quoteDepth);
    }
}

