/*
 * Decompiled with CFR 0.152.
 */
package rtree.join;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rtree.Element;
import rtree.LeafElement;
import rtree.NonLeafElement;
import rtree.Rect;
import rtree.join.CompElmtX;
import rtree.join.CompRectX;
import rtree.join.IntersectPred;
import rtree.join.Predicate;

public class SweepLine {
    IntersectPred intPred = new IntersectPred();
    Predicate pred = null;

    public SweepLine() {
    }

    public SweepLine(Predicate pred) {
        this.pred = pred;
    }

    public void setPredicate(Predicate pred) {
        this.pred = pred;
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    public void sort(Rect[] rects) {
        Arrays.sort(rects, new CompRectX());
    }

    public void sort(Element[] elmts) {
        Arrays.sort(elmts, new CompElmtX());
    }

    public List intersects(Rect rect, Element[] elmts) {
        if (elmts == null || elmts.length < 1) {
            return null;
        }
        Element dummy = elmts[0] instanceof LeafElement ? new LeafElement(rect, 128L) : new NonLeafElement(rect, 128L);
        Element[] dummyArr = new Element[]{dummy};
        return this.sortedIntersectionTest(dummyArr, elmts);
    }

    public List intersects(Element[] ltElmts, Element[] rtElmts) {
        this.sort(ltElmts);
        this.sort(rtElmts);
        return this.sortedIntersectionTest(ltElmts, rtElmts);
    }

    public List sortedIntersectionTest(Element[] ltElmts, Element[] rtElmts) {
        int i = 0;
        int j = 0;
        ArrayList pairs = new ArrayList();
        while (i < ltElmts.length && ltElmts[i] != null && j < rtElmts.length && rtElmts[j] != null) {
            if (ltElmts[i].getRect().getMinX() < rtElmts[j].getRect().getMinX()) {
                if (ltElmts[i] instanceof NonLeafElement) {
                    this.intPred.relate(ltElmts[i], j, rtElmts, pairs, 0);
                } else {
                    this.pred.relate(ltElmts[i], j, rtElmts, pairs, 0);
                }
                ++i;
                continue;
            }
            if (rtElmts[j] instanceof NonLeafElement) {
                this.intPred.relate(rtElmts[j], i, ltElmts, pairs, 1);
            } else {
                this.pred.relate(rtElmts[j], i, ltElmts, pairs, 1);
            }
            ++j;
        }
        return pairs;
    }
}

