/*
 * Decompiled with CFR 0.152.
 */
package rtree.join;

import java.util.ArrayList;
import java.util.List;
import rtree.Element;
import rtree.IllegalValueException;
import rtree.LeafElement;
import rtree.Node;
import rtree.NonLeafElement;
import rtree.RTree;
import rtree.Rect;
import rtree.join.JoinException;
import rtree.join.Pair;
import rtree.join.PairElmt;
import rtree.join.Predicate;
import rtree.join.SweepLine;

public class Join {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private RTree ltTree = null;
    private RTree rtTree = null;
    private Pair p = null;
    SweepLine spLine = new SweepLine();

    public Join(RTree left, RTree right, Pair p, Predicate pred) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Join : Argument null");
        }
        this.ltTree = left;
        this.rtTree = right;
        this.p = p;
        this.spLine.setPredicate(pred);
    }

    public void setPairType(Pair p) {
        if (p != null) {
            this.p = p;
        }
    }

    public List relate() throws JoinException {
        try {
            this.ltTree.getFileHdr().lockRead();
            this.rtTree.getFileHdr().lockRead();
            ArrayList vct = new ArrayList();
            long ltRoot = this.ltTree.getFileHdr().getRootIndex();
            long rtRoot = this.rtTree.getFileHdr().getRootIndex();
            if (ltRoot == -999L || rtRoot == -999L) {
                ArrayList arrayList = vct;
                return arrayList;
            }
            Node ltRootNd = this.ltTree.getReadNode(ltRoot);
            Node rtRootNd = this.rtTree.getReadNode(rtRoot);
            this.relateRec(ltRootNd, rtRootNd, ltRootNd.getNodeMBR().intersection(rtRootNd.getNodeMBR()), vct);
            ArrayList arrayList = vct;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JoinException("Join.intersectsInt : " + e.getMessage());
        }
        finally {
            this.ltTree.getFileHdr().lockRead();
            this.rtTree.getFileHdr().lockRead();
        }
    }

    private void relateRec(Node ltNode, Node rtNode, Rect intsect, List ret) throws Exception {
        if (ltNode == null || rtNode == null) {
            throw new IllegalValueException("Join.intersectRec : Argument(s) null");
        }
        Element[] ltElmts = ltNode.getAllElements();
        Element[] rtElmts = rtNode.getAllElements();
        if (ltNode.getElementType() == 2 && rtNode.getElementType() == 1) {
            ret.addAll(this.joinMismatch(ltElmts, rtElmts, 0));
        } else if (ltNode.getElementType() == 1 && rtNode.getElementType() == 2) {
            ret.addAll(this.joinMismatch(rtElmts, ltElmts, 1));
        } else {
            ltElmts = this.filterRect(ltElmts, intsect);
            rtElmts = this.filterRect(rtElmts, intsect);
            List pairs = this.spLine.sortedIntersectionTest(ltElmts, rtElmts);
            for (int i = 0; i < pairs.size(); ++i) {
                PairElmt intPair = (PairElmt)pairs.get(i);
                if (intPair.getLtElmt() instanceof NonLeafElement && intPair.getRtElmt() instanceof NonLeafElement) {
                    Node newLtNode = this.ltTree.getReadNode(intPair.getLtPtr());
                    Node newRtNode = this.rtTree.getReadNode(intPair.getRtPtr());
                    this.relateRec(newLtNode, newRtNode, newLtNode.getNodeMBR().intersection(newRtNode.getNodeMBR()), ret);
                    continue;
                }
                if (!(intPair.getLtElmt() instanceof LeafElement) || !(intPair.getRtElmt() instanceof LeafElement)) continue;
                ret.add(this.p.paired(intPair.getLtElmt(), intPair.getRtElmt()));
            }
        }
    }

    private List joinMismatch(Element[] nlElmts, Element[] lfElmts, int side) throws Exception {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < nlElmts.length && nlElmts[i] != null; ++i) {
            for (int j = 0; j < lfElmts.length && lfElmts[j] != null; ++j) {
                if (!nlElmts[i].getRect().overlaps(lfElmts[j].getRect())) continue;
                if (side == 0) {
                    ret.addAll(this.windowQuery(this.ltTree.getReadNode(nlElmts[i].getPtr()), (LeafElement)lfElmts[j], side));
                    continue;
                }
                ret.addAll(this.windowQuery(this.rtTree.getReadNode(nlElmts[i].getPtr()), (LeafElement)lfElmts[j], side));
            }
        }
        return ret;
    }

    private List windowQuery(Node nlNode, LeafElement lfElmt, int side) throws Exception {
        RTree nlTree = null;
        nlTree = side == 0 ? this.ltTree : this.rtTree;
        ArrayList<Pair> list = new ArrayList<Pair>();
        Element[] elmts = nlNode.getAllElements();
        int totElements = nlNode.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (!this.spLine.getPredicate().relateMismatch(elmts[i], lfElmt, side)) continue;
            if (elmts[i].getElementType() == 2) {
                list.addAll(this.windowQuery(nlTree.getReadNode(elmts[i].getPtr()), lfElmt, side));
                continue;
            }
            if (side == 0) {
                list.add(this.p.paired(elmts[i], lfElmt));
                continue;
            }
            list.add(this.p.paired(lfElmt, elmts[i]));
        }
        return list;
    }

    private Element[] filterRect(Element[] elmts, Rect rect) throws Exception {
        Element[] ret = new Element[elmts.length];
        int j = 0;
        for (int i = 0; i < elmts.length && elmts[i] != null; ++i) {
            if (!rect.overlaps(elmts[i].getRect())) continue;
            ret[j++] = elmts[i];
        }
        return ret;
    }
}

