/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import rtree.ABL;
import rtree.CachedNodes;
import rtree.Element;
import rtree.ElementNotFoundException;
import rtree.FileHdr;
import rtree.IllegalValueException;
import rtree.LeafElement;
import rtree.Node;
import rtree.NodeFullException;
import rtree.NodeReadException;
import rtree.NodeWriteException;
import rtree.NonLeafElement;
import rtree.Point;
import rtree.RTreeException;
import rtree.RTreeInsertException;
import rtree.ReadNode;
import rtree.Rect;
import rtree.join.IntersectPred;
import rtree.join.PairElmt;
import rtree.join.SweepLine;

public class RTree {
    protected String fileName;
    static Map fileList;
    protected FileHdr fileHdr;
    public static CachedNodes chdNodes;

    public static void clearCache() {
        chdNodes = new CachedNodes();
        fileList = new HashMap();
        CachedNodes.clearFileNamesMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTree(String fileName) throws RTreeException {
        try {
            this.fileName = fileName;
            if (fileList == null) {
                fileList = new HashMap();
            }
            Map map = fileList;
            synchronized (map) {
                if (fileList.get(fileName) != null) {
                    this.fileHdr = ((Header)RTree.fileList.get((Object)fileName)).flHdr;
                    return;
                }
                fileList.put(fileName, new Header(new FileHdr(1020, fileName), fileName));
                this.fileHdr = ((Header)RTree.fileList.get((Object)fileName)).flHdr;
                if (chdNodes == null) {
                    chdNodes = new CachedNodes();
                }
            }
        }
        catch (Exception e) {
            throw new RTreeException("RTree.RTree: " + e.getMessage());
        }
    }

    void updateHdr() throws RTreeException, IOException, FileNotFoundException, NodeWriteException {
        Header tmp = (Header)fileList.get(this.fileName);
        if (tmp != null) {
            this.fileHdr.update(this.fileName);
        }
    }

    public Node getReadNode(long index) throws RTreeException {
        try {
            return chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, index, this.fileHdr);
        }
        catch (Exception e) {
            throw new RTreeException("RTree.getSortedNode : " + e.getMessage());
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileHdr getFileHdr() {
        return this.fileHdr;
    }

    public void flush() throws RTreeException {
        this.fileHdr.lockWrite();
        try {
            this.fileHdr.flush();
            chdNodes.flush();
        }
        catch (Exception e) {
            throw new RTreeException(e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    protected Node adjustTree(Node[] nodes, long slotIndex) throws RTreeException {
        try {
            if (nodes[0].getParent() == slotIndex) {
                if (nodes[1] != null) {
                    Node newRoot = this.fileHdr.isWriteThr() ? new Node(this.fileHdr.getFile(), this.fileName, slotIndex, 2, ((Header)RTree.fileList.get((Object)this.fileName)).flHdr) : chdNodes.getNode(this.fileHdr.getFile(), this.fileName, slotIndex, 2, ((Header)RTree.fileList.get((Object)this.fileName)).flHdr, nodes[0]);
                    NonLeafElement branchA = new NonLeafElement(nodes[0].getNodeMBR(), nodes[0].getNodeIndex());
                    NonLeafElement branchB = new NonLeafElement(nodes[1].getNodeMBR(), nodes[1].getNodeIndex());
                    newRoot.insertElement(branchB);
                    newRoot.insertElement(branchA);
                    return newRoot;
                }
                return null;
            }
            Node[] insertedNode = new Node[2];
            Node parentN = this.fileHdr.isWriteThr() ? new Node(this.fileHdr.getFile(), this.fileName, nodes[0].getParent(), this.fileHdr) : chdNodes.getNode(this.fileHdr.getFile(), this.fileName, nodes[0].getParent(), this.fileHdr);
            int parentElmtIndex = parentN.getElementIndex(nodes[0].getNodeIndex());
            parentN.modifyElement(parentElmtIndex, nodes[0].getNodeMBR());
            insertedNode[0] = parentN;
            insertedNode[1] = null;
            if (nodes[1] != null) {
                NonLeafElement elmtNN = new NonLeafElement(nodes[1].getNodeMBR(), nodes[1].getNodeIndex());
                try {
                    parentN.insertElement(elmtNN);
                    insertedNode[0] = parentN;
                    insertedNode[1] = null;
                }
                catch (NodeFullException e) {
                    insertedNode = parentN.splitNode(elmtNN, -999L);
                }
            }
            return this.adjustTree(insertedNode, slotIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException("RTree.adjustTree: " + e.getMessage());
        }
    }

    public void insert(Element elmt) throws RTreeInsertException {
        this.fileHdr.lockWrite();
        Node node = null;
        try {
            node = this.chooseLeaf(elmt);
            Node[] newNodes = new Node[2];
            try {
                node.insertElement(elmt);
                newNodes[0] = node;
                newNodes[1] = null;
            }
            catch (NodeFullException e) {
                newNodes = node.splitNode(elmt, -999L);
            }
            this.adjustTree(newNodes, -999L);
        }
        catch (Exception e) {
            throw new RTreeInsertException("RTree.insert: " + e.getMessage() + " for " + Thread.currentThread());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private Node chooseLeaf(Element elmt) throws IllegalValueException, RTreeException {
        try {
            long root = this.fileHdr.getRootIndex();
            Node node = null;
            node = this.fileHdr.isWriteThr() ? new Node(this.fileHdr.getFile(), this.fileName, root, this.fileHdr) : chdNodes.getNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr);
            switch (node.getElementType()) {
                case 1: {
                    break;
                }
                case 2: {
                    Element nextElmt;
                    while ((nextElmt = node.getLeastEnlargement(elmt)).getElementType() != 1) {
                        if (this.fileHdr.isWriteThr()) {
                            node = new Node(this.fileHdr.getFile(), this.fileName, nextElmt.getPtr(), this.fileHdr);
                            continue;
                        }
                        node = chdNodes.getNode(this.fileHdr.getFile(), this.fileName, nextElmt.getPtr(), this.fileHdr);
                    }
                    break;
                }
                default: {
                    throw new IllegalValueException("RTree.chooseLeaf: Node corrupt, Illegal element type in node");
                }
            }
            return node;
        }
        catch (IllegalValueException e) {
            throw new IllegalValueException("RTree.chooseLeaf: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException("RTree.chooseLeaf: " + e.getMessage());
        }
    }

    public void delete(LeafElement elmt) throws RTreeException, ElementNotFoundException {
        block12: {
            this.fileHdr.lockWrite();
            if (elmt == null) {
                throw new RTreeException("RTree.delete: Rect is null");
            }
            try {
                if (this.fileHdr.isWriteThr()) {
                    chdNodes.removeAll();
                }
                long root = this.fileHdr.getRootIndex();
                Node delNode = this.fileHdr.isWriteThr() ? this.findLeaf(new Node(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), elmt) : this.findLeaf(chdNodes.getNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), elmt);
                if (delNode != null) {
                    Element[] elmts = delNode.getAllElements();
                    int totElmts = delNode.getTotalElements();
                    int childIndex = -999;
                    for (int i = 0; i < totElmts; ++i) {
                        if (!elmts[i].getRect().encloses(elmt.getRect()) || elmts[i].getPtr() != elmt.getPtr()) continue;
                        childIndex = i;
                        break;
                    }
                    if (childIndex == -999) {
                        throw new ElementNotFoundException("RTree.delete: Element not in tree");
                    }
                    delNode.deleteElement(childIndex, false);
                    Stack stack = new Stack();
                    this.condenseTree(delNode, stack);
                    Node rootNode = this.fileHdr.isWriteThr() ? new Node(this.fileHdr.getFile(), this.fileName, this.fileHdr.getRootIndex(), this.fileHdr) : chdNodes.getNode(this.fileHdr.getFile(), this.fileName, this.fileHdr.getRootIndex(), this.fileHdr);
                    if (rootNode.getTotalElements() == 1 && rootNode.getElementType() == 2) {
                        long childPtr = rootNode.getElement(0).getPtr();
                        Node child = this.fileHdr.isWriteThr() ? new Node(this.fileHdr.getFile(), this.fileName, childPtr, this.fileHdr) : chdNodes.getNode(this.fileHdr.getFile(), this.fileName, childPtr, this.fileHdr);
                        child.setParent(-999L);
                        rootNode.deleteNode();
                    }
                    break block12;
                }
                throw new ElementNotFoundException("RTree.delete: Element not in tree");
            }
            catch (Exception e) {
                if (e instanceof ElementNotFoundException) {
                    throw (ElementNotFoundException)e;
                }
                throw new RTreeException("RTree.delete: " + e.getMessage());
            }
            finally {
                this.fileHdr.unlock();
            }
        }
    }

    private void condenseTree(Node node, Stack stack) throws Exception {
        if (node.getParent() == -999L) {
            while (!stack.empty()) {
                Node nd = (Node)stack.pop();
                List v = this.trvsRPost(nd, true);
                for (int i = 0; i < v.size(); ++i) {
                    this.insert((LeafElement)v.get(i));
                }
            }
            return;
        }
        Node parentN = this.fileHdr.isWriteThr() ? new Node(this.fileHdr.getFile(), this.fileName, node.getParent(), this.fileHdr) : chdNodes.getNode(this.fileHdr.getFile(), this.fileName, node.getParent(), this.fileHdr);
        int parentElmtIdx = parentN.getElementIndex(node.getNodeIndex());
        if (node.getTotalElements() < 20) {
            parentN.deleteElement(parentElmtIdx, false);
            stack.push(node);
        } else {
            parentN.modifyElement(parentElmtIdx, node.getNodeMBR());
        }
        this.condenseTree(parentN, stack);
    }

    private Node findLeaf(Node node, LeafElement elmt) throws IllegalValueException, FileNotFoundException, IOException, NodeReadException, NodeWriteException {
        if (node == null || elmt == null) {
            throw new IllegalValueException("RTree.findLeaf: Node is null");
        }
        Node nd = null;
        Element[] allElmt = node.getAllElements();
        int totElements = node.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (allElmt[i].getRect().disjoint(elmt.getRect())) continue;
            if (allElmt[i].getElementType() == 2) {
                nd = this.fileHdr.isWriteThr() ? this.findLeaf(new Node(this.fileHdr.getFile(), this.fileName, allElmt[i].getPtr(), this.fileHdr), elmt) : this.findLeaf(chdNodes.getNode(this.fileHdr.getFile(), this.fileName, allElmt[i].getPtr(), this.fileHdr), elmt);
                if (nd == null) continue;
                return nd;
            }
            if (!allElmt[i].getRect().equals(elmt.getRect()) || allElmt[i].getPtr() != elmt.getPtr()) continue;
            return node;
        }
        return null;
    }

    public List overlaps(Rect rect) throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        if (rect == null) {
            throw new RTreeException("RTree.overlaps: Rect is null");
        }
        long root = this.fileHdr.getRootIndex();
        try {
            List ret;
            ReadNode node = chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr);
            List list = ret = this.getRPostOvrlap(node, rect);
            return list;
        }
        catch (Exception e) {
            throw new RTreeException("RTree.overlaps: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List getRPostOvrlap(Node node, Rect rect) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null || rect == null) {
            throw new IllegalValueException("RTree.getRPostOvrlap: Node is null");
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (!elmts[i].getRect().overlaps(rect)) continue;
            if (elmts[i].getElementType() == 2) {
                list.addAll(this.getRPostOvrlap(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), rect));
                continue;
            }
            list.add(elmts[i]);
        }
        return list;
    }

    public List overlapsSweep(Rect rect) throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        if (rect == null) {
            throw new RTreeException("RTree.overlaps: Rect is null");
        }
        long root = this.fileHdr.getRootIndex();
        try {
            List list = this.getRPostOvrlapSweep(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), rect);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException("RTree.overlaps: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List getRPostOvrlapSweep(Node node, Rect rect) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null || rect == null) {
            throw new IllegalValueException("RTree.getRPostOvrlap: Node is null");
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Element[] elmts = node.getAllElements();
        SweepLine spLine = new SweepLine(new IntersectPred());
        List pairs = spLine.intersects(rect, elmts);
        for (int i = 0; i < pairs.size(); ++i) {
            Element intElmt = ((PairElmt)pairs.get(i)).getRtElmt();
            if (intElmt.getElementType() == 2) {
                list.addAll(this.getRPostOvrlapSweep(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, intElmt.getPtr(), this.fileHdr), rect));
                continue;
            }
            list.add(intElmt);
        }
        return list;
    }

    public List nonDisjoint(Rect rect) throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        if (rect == null) {
            throw new RTreeException("RTree.nonDisjoint: Rect is null");
        }
        long root = this.fileHdr.getRootIndex();
        try {
            List list = this.getRPostIntsect(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), rect);
            return list;
        }
        catch (Exception e) {
            throw new RTreeException("RTree.nonDisjoint: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List getRPostIntsect(Node node, Rect rect) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null || rect == null) {
            throw new IllegalValueException("RTree.getRPostIntsect: Node is null");
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (elmts[i].getRect().disjoint(rect)) continue;
            if (elmts[i].getElementType() == 2) {
                list.addAll(this.getRPostIntsect(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), rect));
                continue;
            }
            list.add(elmts[i]);
        }
        return list;
    }

    public List containedBy(Rect rect) throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        if (rect == null) {
            throw new RTreeException("RTree.containedBy: Rect is null");
        }
        long root = this.fileHdr.getRootIndex();
        try {
            List list = this.getRPostContBy(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), rect);
            return list;
        }
        catch (Exception e) {
            throw new RTreeException("RTree.containedBy: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List getRPostContBy(Node node, Rect rect) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null || rect == null) {
            throw new IllegalValueException("RTree.getRPostContBy: Node is null");
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (!rect.overlaps(elmts[i].getRect())) continue;
            if (elmts[i].getElementType() == 2) {
                list.addAll(this.getRPostContBy(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), rect));
                continue;
            }
            if (!elmts[i].getRect().containedBy(rect)) continue;
            list.add(elmts[i]);
        }
        return list;
    }

    public List equal(Rect rect) throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        if (rect == null) {
            throw new RTreeException("RTree.equal: Rect is null");
        }
        long root = this.fileHdr.getRootIndex();
        try {
            List list = this.getRPostEqual(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), rect);
            return list;
        }
        catch (Exception e) {
            throw new RTreeException("RTree.equal: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List getRPostEqual(Node node, Rect rect) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null || rect == null) {
            throw new IllegalValueException("RTree.getRPostEqual: Node is null");
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (!rect.overlaps(elmts[i].getRect())) continue;
            if (elmts[i].getElementType() == 2) {
                list.addAll(this.getRPostEqual(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), rect));
                continue;
            }
            if (!elmts[i].getRect().equals(rect)) continue;
            list.add(elmts[i]);
        }
        return list;
    }

    public List meet(Rect rect) throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        if (rect == null) {
            throw new RTreeException("RTree.meet: Rect is null");
        }
        long root = this.fileHdr.getRootIndex();
        try {
            List list = this.getRPostMeet(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), rect);
            return list;
        }
        catch (Exception e) {
            throw new RTreeException("RTree.meet: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List getRPostMeet(Node node, Rect rect) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null || rect == null) {
            throw new IllegalValueException("RTree.meet: Node is null");
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (rect.disjoint(elmts[i].getRect())) continue;
            if (elmts[i].getElementType() == 2) {
                list.addAll(this.getRPostMeet(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), rect));
                continue;
            }
            if (!elmts[i].getRect().meet(rect)) continue;
            list.add(elmts[i]);
        }
        return list;
    }

    public List contains(Rect rect) throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        if (rect == null) {
            throw new RTreeException("RTree.contains: Rect is null");
        }
        long root = this.fileHdr.getRootIndex();
        try {
            List list = this.getRPostContains(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), rect);
            return list;
        }
        catch (Exception e) {
            throw new RTreeException("RTree.contains: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List getRPostContains(Node node, Rect rect) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null || rect == null) {
            throw new IllegalValueException("RTree.getRPostContains: Node is null");
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (!rect.overlaps(elmts[i].getRect())) continue;
            if (elmts[i].getElementType() == 2) {
                list.addAll(this.getRPostContains(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), rect));
                continue;
            }
            if (!elmts[i].getRect().contains(rect)) continue;
            list.add(elmts[i]);
        }
        return list;
    }

    public List getAllElements() throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        long root = this.fileHdr.getRootIndex();
        try {
            List list = this.trvsRPost(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), false);
            return list;
        }
        catch (Exception e) {
            throw new RTreeException("RTree.getAllElements: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List trvsRPost(Node node, boolean del) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null) {
            throw new IllegalValueException("RTree.getRPostOvrlap: Node is null");
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        for (int i = 0; i < totElements; ++i) {
            if (elmts[i].getElementType() == 2) {
                list.addAll(this.trvsRPost(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), del));
                continue;
            }
            list.add(elmts[i]);
        }
        if (del) {
            node.deleteNode();
        }
        return list;
    }

    public void printTree() throws RTreeException, FileNotFoundException {
        this.fileHdr.lockRead();
        long root = this.fileHdr.getRootIndex();
        try {
            this.trvsRPrePrint(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr));
        }
        catch (Exception e) {
            throw new RTreeException("RTree.printTree: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rect getTreeMBR() {
        this.fileHdr.lockRead();
        try {
            long root = this.fileHdr.getRootIndex();
            ReadNode node = chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr);
            Rect rect = ((Node)node).getNodeMBR();
            return rect;
        }
        catch (Exception e) {
            Rect rect = null;
            return rect;
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    public void deleteAllElements() throws RTreeException {
        this.fileHdr.lockWrite();
        try {
            chdNodes.removeAll();
            this.fileHdr.resetHeader();
        }
        catch (Exception e) {
            throw new RTreeException("RTree.deleteAllElements : " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private void trvsRPrePrint(Node node) throws IllegalValueException, FileNotFoundException, NodeReadException, IOException, NodeWriteException {
        if (node == null) {
            throw new IllegalValueException("RTree.trvsRPrePrint: Node is null");
        }
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        System.out.println(node.toString());
        for (int i = 0; i < totElements; ++i) {
            if (elmts[i].getElementType() != 2) continue;
            this.trvsRPrePrint(chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr));
        }
    }

    public ABL[] nearestSearch(Point pt, long range, int n) throws RTreeException, IllegalValueException {
        this.fileHdr.lockRead();
        if (pt == null || range < 0L || n <= 0) {
            throw new IllegalValueException("RTree.nearestSearch: Illegal arguments");
        }
        try {
            long root = this.fileHdr.getRootIndex();
            ABL[] elmts = new ABL[n];
            Nearest nrstDist = new Nearest();
            nrstDist.value = range;
            ABL[] aBLArray = this.INNSearch((Node)chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), pt, elmts, nrstDist);
            return aBLArray;
        }
        catch (IllegalValueException e) {
            throw new IllegalValueException(e.getMessage());
        }
        catch (Exception e) {
            throw new RTreeException("RTree.nearestSearch: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private ABL[] INNSearch(Node node, Point pt, ABL[] nrstElements, Nearest nrstDist) throws IllegalValueException, FileNotFoundException, IOException, NodeReadException, RTreeException, NodeWriteException {
        int i;
        if (node == null) {
            throw new IllegalValueException("RTree.INNSearch: Node is null");
        }
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        if (totElements == 0) {
            return null;
        }
        if (node.getElementType() == 1) {
            for (int i2 = 0; i2 < totElements; ++i2) {
                long lfDist = Rect.minDist(pt, elmts[i2].getRect());
                if (lfDist > nrstDist.value) continue;
                ABL newElmt = new ABL(new LeafElement(elmts[i2].getRect(), elmts[i2].getPtr()), lfDist);
                this.insertArray(nrstElements, newElmt, nrstDist);
            }
            return nrstElements;
        }
        ABL[] abl = new ABL[totElements];
        for (i = 0; i < abl.length; ++i) {
            abl[i] = new ABL(new NonLeafElement(elmts[i].getRect(), elmts[i].getPtr()), Rect.minDist(pt, elmts[i].getRect()));
        }
        abl[0].mergeSort(abl);
        for (i = 0; i < abl.length; ++i) {
            if (abl[i].minDist > nrstDist.value) continue;
            nrstElements = this.INNSearch((Node)chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), pt, nrstElements, nrstDist);
        }
        return nrstElements;
    }

    protected void insertArray(ABL[] arr, ABL elmt, Nearest nrstDist) throws RTreeException {
        try {
            ABL temp = null;
            ABL temp1 = null;
            int i = arr.length - 1;
            if (arr[0] == null || arr.length == 1) {
                arr[0] = (ABL)elmt.clone();
            } else {
                while (i < arr.length && i >= 0) {
                    if (arr[--i] == null || arr[i].minDist > elmt.minDist && (i != 0 || elmt.minDist >= arr[i].minDist)) continue;
                    if (i == 0 && elmt.minDist < arr[i].minDist) {
                        --i;
                    }
                    temp = elmt;
                    while (++i < arr.length) {
                        if (arr[i] != null) {
                            temp1 = arr[i];
                            arr[i] = (ABL)temp.clone();
                            temp = temp1;
                            continue;
                        }
                        arr[i] = (ABL)temp.clone();
                        break;
                    }
                    break;
                }
            }
            if (arr[arr.length - 1] != null) {
                nrstDist.value = arr[arr.length - 1].minDist;
            }
        }
        catch (Exception e) {
            throw new RTreeException("RTree.insertArray: " + e.getMessage());
        }
    }

    public List nearestSearch(Point pt, long range) throws RTreeException, IllegalValueException {
        this.fileHdr.lockRead();
        if (pt == null || range < 0L) {
            throw new IllegalValueException("RTree.nearestSearch: Point null or int less than one");
        }
        try {
            long root = this.fileHdr.getRootIndex();
            List elmts = new ArrayList();
            List list = elmts = this.INNSearch((Node)chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, root, this.fileHdr), pt, elmts, range);
            return list;
        }
        catch (IllegalValueException e) {
            throw new IllegalValueException(e.getMessage());
        }
        catch (Exception e) {
            throw new RTreeException("RTree.nearestSearch: " + e.getMessage());
        }
        finally {
            this.fileHdr.unlock();
        }
    }

    private List INNSearch(Node node, Point pt, List nrstElements, long nrstDist) throws IllegalValueException, FileNotFoundException, IOException, NodeReadException, Exception {
        int i;
        if (node == null) {
            throw new IllegalValueException("RTree.INNSearch: Node is null");
        }
        Element[] elmts = node.getAllElements();
        int totElements = node.getTotalElements();
        if (totElements == 0) {
            return null;
        }
        if (node.getElementType() == 1) {
            for (int i2 = 0; i2 < totElements; ++i2) {
                long lfDist = Rect.minDist(pt, elmts[i2].getRect());
                if (lfDist > nrstDist) continue;
                ABL newElmt = new ABL(new LeafElement(elmts[i2].getRect(), elmts[i2].getPtr()), lfDist);
                int j = 0;
                for (j = 0; j < nrstElements.size() && ((ABL)nrstElements.get((int)j)).minDist <= newElmt.minDist; ++j) {
                }
                nrstElements.add(j, newElmt);
            }
            return nrstElements;
        }
        ABL[] abl = new ABL[totElements];
        for (i = 0; i < abl.length; ++i) {
            abl[i] = new ABL(new NonLeafElement(elmts[i].getRect(), elmts[i].getPtr()), Rect.minDist(pt, elmts[i].getRect()));
        }
        abl[0].mergeSort(abl);
        for (i = 0; i < abl.length; ++i) {
            if (abl[i].minDist > nrstDist) continue;
            nrstElements = this.INNSearch((Node)chdNodes.getReadNode(this.fileHdr.getFile(), this.fileName, elmts[i].getPtr(), this.fileHdr), pt, nrstElements, nrstDist);
        }
        return nrstElements;
    }

    public synchronized int getHeight() {
        int totNodes = this.fileHdr.getTotalNodes();
        if (totNodes <= 1) {
            return 1;
        }
        if (totNodes <= 170) {
            return 2;
        }
        return 3;
    }

    class Header {
        FileHdr flHdr;
        String fileName;

        Header(FileHdr flH, String name) {
            this.fileName = name;
            this.flHdr = flH;
        }
    }

    protected class Nearest {
        public long value;

        protected Nearest() {
        }
    }
}

