/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import rtree.Element;
import rtree.FileHdr;
import rtree.LeafElement;
import rtree.Node;
import rtree.NonLeafElement;
import rtree.RTree;

public class Pack {
    public static final int BUFFER_SIZE = 65536;

    public synchronized int packTree(List elmts, String newFile) {
        try {
            if (elmts.size() <= 40) {
                RTree rtree = new RTree(newFile);
                for (int i = 0; i < elmts.size(); ++i) {
                    rtree.insert((LeafElement)elmts.get(i));
                }
                rtree.flush();
                return 0;
            }
            return this.packTree(elmts.toArray(new Element[elmts.size()]), new RTree(newFile), newFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
    }

    public synchronized int packTree(RTree rtree, String newFile) {
        try {
            if (rtree == null) {
                throw new IllegalArgumentException("PackTree.packTree: rtree null");
            }
            List elmts = rtree.getAllElements();
            int ret = this.packTree(elmts.toArray(new Element[elmts.size()]), rtree, newFile);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int packTree(Element[] elmts, RTree rtree, String newFile) {
        try {
            int i;
            File tmpPckFile = File.createTempFile("pack", null);
            RandomAccessFile rFile = new RandomAccessFile(tmpPckFile.getAbsolutePath(), "rw");
            if (newFile.equalsIgnoreCase(rtree.getFileName())) {
                rtree.getFileHdr().lockWrite();
            }
            RTree.chdNodes.removeAll();
            if (elmts.length <= 40) {
                int n = 1;
                return n;
            }
            System.out.println("Pack.packTree : Size of elmts: " + elmts.length);
            this.packRec(rFile, tmpPckFile, elmts, elmts.length);
            File fo = new File(newFile);
            if (fo.exists()) {
                fo.delete();
                fo.createNewFile();
            }
            FileInputStream fis = new FileInputStream(tmpPckFile);
            FileOutputStream fos = new FileOutputStream(fo);
            byte[] b = new byte[65536];
            while ((i = fis.read(b)) != -1) {
                fos.write(b, 0, i);
            }
            fos.close();
            fis.close();
            rFile.close();
            if (!tmpPckFile.delete()) {
                tmpPckFile.deleteOnExit();
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("rtree.RTree.pack: Could not pack rtree, the destination file may be corrupted.");
            int n = 2;
            return n;
        }
        finally {
            RTree rTree = rtree;
            synchronized (rTree) {
                block32: {
                    try {
                        rtree.updateHdr();
                        if (newFile.equalsIgnoreCase(rtree.getFileName())) {
                            rtree.getFileHdr().unlock();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Pack.packTree : The pack tree is made but some other error hs occured. It is recomended to restart the application");
                        if (!newFile.equalsIgnoreCase(rtree.getFileName())) break block32;
                        rtree.getFileHdr().unlock();
                    }
                }
            }
        }
    }

    private void packRec(RandomAccessFile rFile, File tmpPckFile, Element[] elmts, int length) throws Exception {
        int i;
        Double temp = new Double(40.0);
        temp = new Double(Math.ceil((double)length / temp));
        temp = new Double(Math.ceil(Math.sqrt(temp)));
        int S = temp.intValue();
        Slice[] sls = new Slice[S];
        NonLeafElement.twoWayMerge(elmts, 0, length - 1, 0);
        int start = 0;
        for (i = 0; i < S; ++i) {
            int end = start + S * 40 <= length ? start + (S * 40 - 1) : length - 1;
            sls[i] = new Slice(start, end);
            start = end + 1;
        }
        for (i = 0; i < S; ++i) {
            NonLeafElement.twoWayMerge(elmts, sls[i].start, sls[i].end, 1);
        }
        int newLength = this.writePckFile(rFile, tmpPckFile, elmts, sls);
        if (newLength == 1) {
            return;
        }
        this.packRec(rFile, tmpPckFile, elmts, newLength);
    }

    private int writePckFile(RandomAccessFile rFile, File tmpPckFile, Element[] elmts, Slice[] sls) throws Exception {
        FileHdr hdr = new FileHdr(1020, tmpPckFile.getAbsolutePath());
        hdr.setBufferPolicy(true);
        int netNodes = 0;
        int l = 0;
        for (int i = 0; i < sls.length; ++i) {
            int length = sls[i].end - sls[i].start + 1;
            Double totNodes = new Double(length);
            totNodes = new Double(Math.ceil(totNodes / 40.0));
            netNodes += totNodes.intValue();
            for (int j = 0; j < totNodes.intValue(); ++j) {
                Node node = new Node(rFile, tmpPckFile.getAbsolutePath(), -999L, elmts[sls[i].start].getElementType(), hdr);
                ArrayList<Element> list = new ArrayList<Element>(40);
                for (int k = 0; k < 40 && sls[i].start <= sls[i].end; ++k) {
                    list.add(elmts[sls[i].start++]);
                }
                node.insertElement(list.toArray(new Element[list.size()]), true);
                NonLeafElement nlf = new NonLeafElement(node.getNodeMBR(), node.getNodeIndex());
                elmts[l++] = (NonLeafElement)nlf.clone();
            }
        }
        return netNodes;
    }

    class Slice {
        int start;
        int end;

        Slice(int start, int stop) {
            this.start = start;
            this.end = stop;
        }
    }

    class Int {
        int val;

        Int(int val) {
            this.val = val;
        }
    }
}

