/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import rtree.Element;
import rtree.FileHdr;
import rtree.IllegalValueException;
import rtree.LeafElement;
import rtree.NodeEmptyException;
import rtree.NodeFullException;
import rtree.NodeReadException;
import rtree.NodeWriteException;
import rtree.NonLeafElement;
import rtree.RTree;
import rtree.RTreeException;
import rtree.Rect;
import rtree.StackOverflowException;
import rtree.StackUnderflowException;
import rtree.join.CompElmtX;

public class Node
implements Cloneable {
    public static final int MAX = 40;
    public static final int MIN = 20;
    public static final int CACHE_SIZE = 100000;
    static final int NODE_HDR_SIZE = 20;
    static final int FILE_HDR_SIZE = 4096;
    static final int NODE_SIZE = 4096;
    static final int NODE_BODY_SIZE = 4076;
    static final int FREE_LIST_LIMIT = 1020;
    static final int INTEGER_SIZE = 4;
    static final int LONG_SIZE = 8;
    public static final int LEAF_NODE = 1;
    public static final int NONLEAF_NODE = 2;
    public static final int NOT_DEFINED = -999;
    public static final long NOT_DEFINED_LONG = -999L;
    static final int READ = 0;
    static final int WRITE = 1;
    static final int NONE = 2;
    protected RandomAccessFile file;
    protected String fileName;
    protected boolean dirty;
    protected long nodeIndex;
    protected boolean sorted;
    protected Element[] elements;
    protected FileHdr fileHdr;
    protected Rect nodeMBR;
    protected int totalElements;
    protected long parent;
    protected int elementSize;
    protected int elementType;

    protected Node() {
        this.dirty = false;
    }

    protected Node(RandomAccessFile file, String fileName, long prnt, int elmtType, FileHdr flHdr) throws IOException, NodeWriteException {
        block7: {
            this.dirty = false;
            this.file = file;
            this.fileHdr = flHdr;
            this.fileName = fileName;
            this.elements = new Element[40];
            this.nodeMBR = new Rect();
            int size = elmtType == 2 ? NonLeafElement.sizeInBytes() : LeafElement.sizeInBytes();
            try {
                if (this.fileHdr.getRootIndex() == -999L) {
                    this.fileHdr.writeFileHeader(1, 0L);
                    this.nodeIndex = 0L;
                    this.writeNodeHeader(this.fileHdr.rootIndex, 0, -999L, size, elmtType);
                    break block7;
                }
                try {
                    this.nodeIndex = this.fileHdr.pop();
                }
                catch (StackUnderflowException e) {
                    this.nodeIndex = this.fileHdr.totalNodes++;
                }
                if (prnt == -999L) {
                    this.fileHdr.writeFileHeader(this.fileHdr.totalNodes, this.nodeIndex);
                } else {
                    this.fileHdr.writeFileHeader(this.fileHdr.totalNodes, this.fileHdr.rootIndex);
                }
                this.writeNodeHeader(this.nodeIndex, 0, prnt, size, elmtType);
            }
            catch (IOException e) {
                throw new IOException("Node.Node(new) : " + e.getMessage());
            }
        }
    }

    protected Node(RandomAccessFile file, String fileName, long ndIndex, FileHdr flHdr) throws FileNotFoundException, IOException, NodeReadException, NodeWriteException {
        this.dirty = false;
        this.fileHdr = flHdr;
        this.file = file;
        this.fileName = fileName;
        this.elements = new Element[40];
        this.nodeMBR = new Rect();
        if (this.fileHdr.getRootIndex() == -999L) {
            try {
                this.fileHdr.writeFileHeader(1, 0L);
                this.nodeIndex = 0L;
                this.writeNodeHeader(this.fileHdr.rootIndex, 0, -999L, LeafElement.sizeInBytes(), 1);
            }
            catch (IOException e) {
                throw new IOException("Node.constructor : Can't write to fileHeader and/or node " + e.getMessage());
            }
        } else {
            if (4096L + 4096L * ndIndex > file.length()) {
                throw new NodeReadException("Node.Node.: nodeIndex is out of bound");
            }
            this.nodeIndex = ndIndex;
            this.refreshNode();
        }
    }

    protected Node(RandomAccessFile file, String fileName, long nodeIndex, boolean sorted, Element[] elmts, FileHdr fileHdr, int totalElements, long parent, int elmtSize, int elmtType, boolean dirty, Rect nodeMBR) {
        this.dirty = false;
        try {
            this.file = file;
            this.dirty = dirty;
            this.fileName = new String(fileName.toCharArray());
            this.nodeIndex = nodeIndex;
            this.sorted = sorted;
            this.nodeMBR = new Rect(nodeMBR);
            this.elements = new Element[elmts.length];
            for (int i = 0; i < elmts.length; ++i) {
                if (elmts[i] == null) continue;
                this.elements[i] = elmtType == 1 ? new LeafElement(new Rect(elmts[i].getRect()), elmts[i].getPtr()) : new NonLeafElement(new Rect(elmts[i].getRect()), elmts[i].getPtr());
            }
            this.fileHdr = fileHdr;
            this.totalElements = totalElements;
            this.parent = parent;
            this.elementSize = elmtSize;
            this.elementType = elmtType;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object clone() {
        return new Node(this.file, this.fileName, this.nodeIndex, this.sorted, this.elements, this.fileHdr, this.totalElements, this.parent, this.elementSize, this.elementType, this.dirty, this.nodeMBR);
    }

    private Element readElement(long index) throws NodeReadException {
        if (index < 0L || index > 39L || (long)this.totalElements > index + 1L) {
            throw new NodeReadException("Node.readElement: Index value not correct");
        }
        try {
            byte[] data = new byte[4096];
            this.seekCurrNode();
            this.file.read(data);
            DataInputStream ds = new DataInputStream(new ByteArrayInputStream(data));
            int skipValue = 20 + this.elementSize * (int)index;
            if (ds.skipBytes(skipValue) != skipValue) {
                throw new NodeReadException("Can't read buffer: Header or index wrong");
            }
            int minX = ds.readInt();
            int minY = ds.readInt();
            int maxX = ds.readInt();
            int maxY = ds.readInt();
            Rect Rectangle2 = new Rect(minX, minY, maxX, maxY);
            if (this.elementType == 1) {
                long ptr = ds.readLong();
                return new LeafElement(Rectangle2, ptr);
            }
            long nodePtr = ds.readLong();
            return new NonLeafElement(Rectangle2, nodePtr);
        }
        catch (Exception e) {
            throw new NodeReadException("Node.readElement: " + e.getMessage());
        }
    }

    public void deleteElement(int index, boolean force) throws IllegalValueException, NodeWriteException {
        if (index > this.totalElements - 1) {
            throw new IllegalValueException("Node.deleteElement: index out of bound");
        }
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        int j = -1;
        try {
            int i;
            this.nodeMBR = new Rect();
            ByteArrayOutputStream bs = null;
            DataOutputStream ds = null;
            if (this.fileHdr.isWriteThr() || force) {
                bs = new ByteArrayOutputStream(4096);
                ds = new DataOutputStream(bs);
                if (index < 0) {
                    ds.writeInt(this.totalElements);
                } else {
                    ds.writeInt(this.totalElements - 1);
                }
                ds.writeLong(this.parent);
                ds.writeInt(this.elementSize);
                ds.writeInt(this.elementType);
            }
            for (i = 0; i < this.totalElements; ++i) {
                if (i != index) {
                    this.nodeMBR.expandToInclude(this.elements[i].getRect());
                    if (!this.fileHdr.isWriteThr() && !force) continue;
                    ds.writeInt(this.elements[i].getRect().getMinX());
                    ds.writeInt(this.elements[i].getRect().getMinY());
                    ds.writeInt(this.elements[i].getRect().getMaxX());
                    ds.writeInt(this.elements[i].getRect().getMaxY());
                    ds.writeLong(this.elements[i].getPtr());
                    continue;
                }
                j = i;
            }
            if (this.fileHdr.isWriteThr() || force) {
                bs.flush();
                ds.flush();
                this.seekCurrNode();
                this.file.write(bs.toByteArray());
                this.setDirty(false);
            } else {
                this.setDirty(true);
                for (i = 0; i < this.totalElements; ++i) {
                    if (i != index) {
                        this.nodeMBR.expandToInclude(this.elements[i].getRect());
                        continue;
                    }
                    j = i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NodeWriteException("Node.deleteElement Can't delete element. Rtree may be corrupted.");
        }
        try {
            if (j != -1) {
                --this.totalElements;
                if (this.totalElements > 0) {
                    System.arraycopy(this.elements, j + 1, this.elements, j, this.totalElements - j);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Node.deleteElement : Error while updating local variable...reading back from file..");
            try {
                this.refreshNode();
                System.out.println("...successful");
            }
            catch (IOException ex) {
                this.setDirty(true);
                System.out.println("..node corrupted, rebuild tree  ...quitting");
                throw new NodeWriteException("Node.deleteElement : Can't delete element");
            }
        }
    }

    public void insertElement(Element elmt) throws NodeWriteException, NodeFullException {
        if (this.totalElements == 40) {
            throw new NodeFullException("Node.insertElement: Node full");
        }
        if (this.totalElements > 0) {
            if (elmt.getElementType() != this.elementType) {
                throw new NodeWriteException("Node.insertElement: Wrong element type");
            }
            if ((this.totalElements + 1) * this.elementSize > 4076) {
                throw new NodeWriteException("Node.insertElement: Node size is becoming more than allowed");
            }
            if (this.fileHdr.isWriteThr()) {
                RTree.chdNodes.remove(this.fileName, this.nodeIndex);
            }
            this.writeLastElement(elmt);
        } else {
            this.writeLastElement(elmt);
        }
        if (elmt.getElementType() == 2) {
            try {
                Node child = null;
                if (this.fileHdr.isWriteThr()) {
                    child = new Node(this.file, this.fileName, elmt.getPtr(), this.fileHdr);
                    RTree.chdNodes.remove(this.fileName, child.getNodeIndex());
                } else {
                    child = RTree.chdNodes.getNode(this.file, this.fileName, elmt.getPtr(), this.fileHdr);
                }
                child.setParent(this.nodeIndex);
            }
            catch (Exception e) {
                throw new NodeWriteException("Node.insertElement: " + e.getMessage());
            }
        }
    }

    private void writeLastElement(Element elmt) throws NodeWriteException {
        int oldElementSize = this.elementSize;
        int oldElementType = this.elementType;
        int oldTotalElements = this.totalElements;
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        try {
            if (elmt instanceof LeafElement) {
                this.elementSize = LeafElement.sizeInBytes();
                this.elementType = 1;
            } else {
                this.elementSize = NonLeafElement.sizeInBytes();
                this.elementType = 2;
            }
            if (this.fileHdr.isWriteThr()) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream(this.elementSize);
                DataOutputStream ds = new DataOutputStream(bs);
                ds.writeInt(elmt.getRect().getMinX());
                ds.writeInt(elmt.getRect().getMinY());
                ds.writeInt(elmt.getRect().getMaxX());
                ds.writeInt(elmt.getRect().getMaxY());
                ds.writeLong(elmt.getPtr());
                bs.flush();
                ds.flush();
                this.seekLastElement();
                this.file.write(bs.toByteArray());
                this.setDirty(false);
            } else {
                this.setDirty(true);
            }
            this.writeNodeHeader(this.nodeIndex, this.totalElements + 1, this.parent, this.elementSize, this.elementType);
            this.elements[this.totalElements - 1] = elmt;
            this.nodeMBR.expandToInclude(elmt.getRect());
        }
        catch (Exception e) {
            this.elementSize = oldElementSize;
            this.elementType = oldElementType;
            this.totalElements = oldTotalElements;
            throw new NodeWriteException("Node.writeLastElement: Can't write element to file");
        }
    }

    public void insertElement(Element[] elmts, boolean updateChldrn) throws NodeWriteException, NodeFullException {
        if (this.totalElements == 40) {
            throw new NodeFullException("Node.insertElement: Node full or not adequate space");
        }
        if (this.totalElements > 0) {
            if (elmts[0].getElementType() != this.elementType) {
                throw new NodeWriteException("Node.insertElement: Wrong element type");
            }
            if ((this.totalElements + elmts.length) * this.elementSize > 4076) {
                throw new NodeWriteException("Node.insertElement: Node size is becoming more than allowed");
            }
            if (this.fileHdr.isWriteThr()) {
                RTree.chdNodes.remove(this.fileName, this.nodeIndex);
            }
            this.writeLastElements(elmts);
        } else {
            this.writeLastElements(elmts);
        }
        if (!updateChldrn) {
            return;
        }
        if (elmts[0].getElementType() == 2) {
            try {
                for (int i = 0; i < elmts.length; ++i) {
                    if (elmts[i].getPtr() == -999L) continue;
                    Node child = null;
                    if (this.fileHdr.isWriteThr()) {
                        child = new Node(this.file, this.fileName, elmts[i].getPtr(), this.fileHdr);
                        RTree.chdNodes.remove(this.fileName, child.getNodeIndex());
                    } else {
                        child = RTree.chdNodes.getNode(this.file, this.fileName, elmts[i].getPtr(), this.fileHdr);
                    }
                    child.setParent(this.nodeIndex);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NodeWriteException("Node.insertElement: " + e.getMessage());
            }
        }
    }

    private void writeLastElements(Element[] elmts) throws NodeWriteException {
        int oldElementSize = this.elementSize;
        int oldElementType = this.elementType;
        int oldTotalElements = this.totalElements;
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        try {
            int i;
            if (elmts[0] instanceof LeafElement) {
                this.elementSize = LeafElement.sizeInBytes();
                this.elementType = 1;
            } else {
                this.elementSize = NonLeafElement.sizeInBytes();
                this.elementType = 2;
            }
            ByteArrayOutputStream bs = null;
            DataOutputStream ds = null;
            if (this.fileHdr.isWriteThr()) {
                this.setDirty(false);
                bs = new ByteArrayOutputStream(4096);
                ds = new DataOutputStream(bs);
                this.writeNodeHeader(this.nodeIndex, this.totalElements + elmts.length, this.parent, this.elementSize, this.elementType, ds);
                for (i = 0; i < oldTotalElements; ++i) {
                    ds.writeInt(this.elements[i].getRect().getMinX());
                    ds.writeInt(this.elements[i].getRect().getMinY());
                    ds.writeInt(this.elements[i].getRect().getMaxX());
                    ds.writeInt(this.elements[i].getRect().getMaxY());
                    ds.writeLong(this.elements[i].getPtr());
                }
            } else {
                this.writeNodeHeader(this.nodeIndex, this.totalElements + elmts.length, this.parent, this.elementSize, this.elementType, ds);
                this.setDirty(true);
            }
            for (i = 0; i < elmts.length; ++i) {
                this.nodeMBR.expandToInclude(elmts[i].getRect());
                this.elements[oldTotalElements + i] = elmts[i];
                if (!this.fileHdr.isWriteThr()) continue;
                ds.writeInt(elmts[i].getRect().getMinX());
                ds.writeInt(elmts[i].getRect().getMinY());
                ds.writeInt(elmts[i].getRect().getMaxX());
                ds.writeInt(elmts[i].getRect().getMaxY());
                ds.writeLong(elmts[i].getPtr());
            }
            if (this.fileHdr.isWriteThr()) {
                bs.flush();
                ds.flush();
                this.seekNode(this.nodeIndex);
                this.file.write(bs.toByteArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.elementSize = oldElementSize;
            this.elementType = oldElementType;
            this.totalElements = oldTotalElements;
            try {
                this.writeNodeHeader(this.nodeIndex, this.totalElements + elmts.length, this.parent, this.elementSize, this.elementType);
            }
            catch (Exception ex) {
                throw new NodeWriteException(ex.getMessage());
            }
            throw new NodeWriteException("Node.writeLastElement: Can't write element to file");
        }
    }

    private void seekCurrNode() throws IOException {
        this.file.seek(4096L + this.nodeIndex * 4096L);
    }

    private void seekNode(long nodeIdx) throws IOException {
        this.file.seek(4096L + nodeIdx * 4096L);
    }

    private void seekLastElement() throws IOException {
        this.file.seek(4096L + this.nodeIndex * 4096L + 20L + (long)(this.elementSize * this.totalElements));
    }

    private void seekElement(int elmtIndex) throws IOException {
        this.file.seek(4096L + this.nodeIndex * 4096L + 20L + (long)(this.elementSize * elmtIndex));
    }

    private void seekElementPtr(int elmtIndex) throws IOException {
        this.file.seek(4096L + this.nodeIndex * 4096L + 20L + (long)(this.elementSize * elmtIndex) + (long)Rect.sizeInBytes());
    }

    public int getElementType() {
        return this.elementType;
    }

    private void writeNodeHeader(long nodeIdx, int totElmt, long prnt, int elmtSz, int elmtTp) throws IOException, NodeWriteException {
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        if (this.fileHdr.isWriteThr()) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(4096);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeInt(totElmt);
            ds.writeLong(prnt);
            ds.writeInt(elmtSz);
            ds.writeInt(elmtTp);
            bs.flush();
            ds.flush();
            this.seekNode(nodeIdx);
            this.file.write(bs.toByteArray());
            this.setDirty(false);
        } else {
            this.setDirty(true);
        }
        this.totalElements = totElmt;
        this.parent = prnt;
        this.elementSize = elmtSz;
        this.elementType = elmtTp;
    }

    private void writeNodeHeader(long nodeIdx, int totElmt, long prnt, int elmtSz, int elmtTp, DataOutputStream ds) throws IOException, NodeWriteException {
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        if (this.fileHdr.isWriteThr()) {
            ds.writeInt(totElmt);
            ds.writeLong(prnt);
            ds.writeInt(elmtSz);
            ds.writeInt(elmtTp);
            ds.flush();
            this.setDirty(true);
        } else {
            this.setDirty(true);
        }
        this.totalElements = totElmt;
        this.parent = prnt;
        this.elementSize = elmtSz;
        this.elementType = elmtTp;
    }

    public long getNodeIndex() {
        return this.nodeIndex;
    }

    private void refreshNode() throws IOException {
        try {
            byte[] data = new byte[4096];
            this.seekCurrNode();
            this.file.read(data);
            DataInputStream ds = new DataInputStream(new ByteArrayInputStream(data));
            this.totalElements = ds.readInt();
            this.parent = ds.readLong();
            this.elementSize = ds.readInt();
            this.elementType = ds.readInt();
            if (this.totalElements <= 0) {
                return;
            }
            if (this.totalElements < 1) {
                return;
            }
            this.nodeMBR = new Rect();
            for (int i = 0; i < this.totalElements; ++i) {
                int minX = ds.readInt();
                int minY = ds.readInt();
                int maxX = ds.readInt();
                int maxY = ds.readInt();
                Rect rectangle = new Rect(minX, minY, maxX, maxY);
                this.nodeMBR.expandToInclude(rectangle);
                if (this.elementType == 1) {
                    long ptr = ds.readLong();
                    this.elements[i] = new LeafElement(rectangle, ptr);
                    continue;
                }
                if (this.elementType != 2) continue;
                long nodePtr = ds.readLong();
                this.elements[i] = new NonLeafElement(rectangle, nodePtr);
            }
            ds.close();
        }
        catch (Exception e) {
            throw new IOException("Node.refreshNode : Can't read from node header " + e.getMessage());
        }
    }

    Rect[] getAllRectangles() throws IllegalValueException {
        if (this.totalElements == 0) {
            throw new IllegalValueException("Node.getAllRectangles: No elements in the node");
        }
        Rect[] rects = new Rect[this.totalElements];
        for (int i = 0; i < this.totalElements; ++i) {
            rects[i] = this.elements[i].getRect();
        }
        return rects;
    }

    public Element getLeastEnlargement(Element elmt) throws NodeEmptyException, IllegalValueException, NodeWriteException {
        if (elmt == null) {
            throw new IllegalValueException("Node.getBestFitElement : Element is null");
        }
        if (this.totalElements <= 0) {
            throw new NodeEmptyException("Node.getBestFitElement : Node does not have any elements");
        }
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        int leastArea = this.elements[0].getRect().getResultingMBR(elmt.getRect()).getArea();
        leastArea -= this.elements[0].getRect().getArea();
        Element retElmt = this.elementType == 1 ? new LeafElement(this.elements[0].getRect(), this.elements[0].getPtr()) : new NonLeafElement(this.elements[0].getRect(), this.elements[0].getPtr());
        for (int i = 1; i < this.totalElements; ++i) {
            int area = this.elements[i].getRect().getResultingMBR(elmt.getRect()).getArea();
            if (leastArea > (area -= this.elements[i].getRect().getArea())) {
                leastArea = area;
                if (this.elementType == 1) {
                    retElmt = new LeafElement(this.elements[i].getRect(), this.elements[i].getPtr());
                    continue;
                }
                retElmt = new NonLeafElement(this.elements[i].getRect(), this.elements[i].getPtr());
                continue;
            }
            if (leastArea != area || retElmt.getRect().getArea() < this.elements[i].getRect().getArea()) continue;
            leastArea = area;
            retElmt = this.elementType == 1 ? new LeafElement(this.elements[i].getRect(), this.elements[i].getPtr()) : new NonLeafElement(this.elements[i].getRect(), this.elements[i].getPtr());
        }
        return retElmt;
    }

    boolean isInsertPossible() {
        return this.totalElements < 40;
    }

    public Node[] splitNode(Element elmtM1, long slotIndex) throws RTreeException, NodeWriteException {
        if (this.totalElements < 40 || elmtM1.getElementType() != this.elementType) {
            throw new RTreeException("Node.splitNode: Node is not full or new element is of wrong type");
        }
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        try {
            Node nodeB;
            Node nodeA;
            int rem = this.totalElements + 1;
            Element[] elmtPlusOne = new Element[rem];
            System.arraycopy(this.elements, 0, elmtPlusOne, 0, rem - 1);
            elmtPlusOne[this.totalElements] = elmtM1;
            int[] elmtsGone = new int[rem];
            for (int i = 0; i < elmtsGone.length; ++i) {
                elmtsGone[i] = 1;
            }
            int elmtsInA = 0;
            int elmtsInB = 0;
            int[] seeds = this.quadPickSeeds(elmtPlusOne);
            int elmtType = elmtPlusOne[0].getElementType();
            if (this.fileHdr.isWriteThr()) {
                nodeA = new Node(this.file, this.fileName, this.parent, elmtType, this.fileHdr);
                nodeB = new Node(this.file, this.fileName, this.parent, elmtType, this.fileHdr);
            } else {
                nodeA = RTree.chdNodes.getNode(this.file, this.fileName, this.parent, elmtType, this.fileHdr);
                nodeB = RTree.chdNodes.getNode(this.file, this.fileName, this.parent, elmtType, this.fileHdr);
            }
            nodeA.insertElement(elmtPlusOne[seeds[0]]);
            nodeB.insertElement(elmtPlusOne[seeds[1]]);
            Rect mbrA = elmtPlusOne[seeds[0]].getRect();
            Rect mbrB = elmtPlusOne[seeds[1]].getRect();
            ++elmtsInA;
            elmtsGone[seeds[0]] = 0;
            ++elmtsInB;
            elmtsGone[seeds[1]] = 0;
            rem -= 2;
            while (rem > 0) {
                int i;
                if (20 - elmtsInA == rem) {
                    for (i = 0; i < elmtsGone.length; ++i) {
                        if (elmtsGone[i] != 1) continue;
                        nodeA.insertElement(elmtPlusOne[i]);
                        elmtsGone[i] = 0;
                        ++elmtsInA;
                        --rem;
                    }
                    continue;
                }
                if (20 - elmtsInB == rem) {
                    for (i = 0; i < elmtsGone.length; ++i) {
                        if (elmtsGone[i] != 1) continue;
                        nodeB.insertElement(elmtPlusOne[i]);
                        elmtsGone[i] = 0;
                        ++elmtsInB;
                        --rem;
                    }
                    continue;
                }
                i = -1;
                try {
                    while (++i < elmtsGone.length && elmtsGone[i] == 0) {
                    }
                }
                catch (Exception e) {
                    System.out.println("Node.splitNode: trouble in paradise");
                }
                Rect newMBRA = elmtPlusOne[i].getRect().getResultingMBR(mbrA);
                Rect newMBRB = elmtPlusOne[i].getRect().getResultingMBR(mbrB);
                int newAreaA = newMBRA.getArea() - mbrA.getArea();
                int newAreaB = newMBRB.getArea() - mbrB.getArea();
                if (newAreaA < newAreaB) {
                    nodeA.insertElement(elmtPlusOne[i]);
                    elmtsGone[i] = 0;
                    ++elmtsInA;
                    --rem;
                    mbrA = newMBRA;
                    continue;
                }
                if (newAreaA > newAreaB) {
                    nodeB.insertElement(elmtPlusOne[i]);
                    elmtsGone[i] = 0;
                    ++elmtsInB;
                    --rem;
                    mbrB = newMBRB;
                    continue;
                }
                if (mbrA.getArea() < mbrB.getArea()) {
                    nodeA.insertElement(elmtPlusOne[i]);
                    elmtsGone[i] = 0;
                    ++elmtsInA;
                    --rem;
                    mbrA = newMBRA;
                    continue;
                }
                if (mbrA.getArea() > mbrB.getArea()) {
                    nodeB.insertElement(elmtPlusOne[i]);
                    elmtsGone[i] = 0;
                    ++elmtsInB;
                    --rem;
                    mbrB = newMBRB;
                    continue;
                }
                if (elmtsInA < elmtsInB) {
                    nodeA.insertElement(elmtPlusOne[i]);
                    elmtsGone[i] = 0;
                    ++elmtsInA;
                    --rem;
                    mbrA = newMBRA;
                    continue;
                }
                if (elmtsInA > elmtsInB) {
                    nodeB.insertElement(elmtPlusOne[i]);
                    elmtsGone[i] = 0;
                    ++elmtsInB;
                    --rem;
                    mbrB = newMBRB;
                    continue;
                }
                nodeA.insertElement(elmtPlusOne[i]);
                elmtsGone[i] = 0;
                ++elmtsInA;
                --rem;
                mbrA = newMBRA;
            }
            if (this.parent != slotIndex) {
                Node parentN = null;
                parentN = this.fileHdr.isWriteThr() ? new Node(this.file, this.fileName, this.parent, this.fileHdr) : RTree.chdNodes.getNode(this.file, this.fileName, this.parent, this.fileHdr);
                if (this.fileHdr.isWriteThr()) {
                    RTree.chdNodes.remove(this.fileName, this.parent);
                }
                int parentElmtIndex = parentN.getElementIndex(this.nodeIndex);
                parentN.modifyElement(parentElmtIndex, nodeA.getNodeIndex());
            }
            Node[] ret = new Node[]{nodeA, nodeB};
            this.deleteNode();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RTreeException("Node.nodeSplit : " + e.getMessage());
        }
    }

    private int[] lnrPickSeeds(Element[] elmts) throws IllegalValueException {
        int Ypair;
        if (elmts.length <= 1) {
            throw new IllegalValueException("Node.lnrPickSeed : PickSeed not possible as there are no elements");
        }
        Rect mbr = elmts[0].getRect();
        for (int i = 1; i < elmts.length; ++i) {
            mbr = elmts[i].getRect().getResultingMBR(mbr);
        }
        int hlsX = Integer.MIN_VALUE;
        int hlsY = Integer.MIN_VALUE;
        int lhsX = Integer.MAX_VALUE;
        int lhsY = Integer.MAX_VALUE;
        int hlsIdxX = Integer.MAX_VALUE;
        int hlsIdxY = Integer.MAX_VALUE;
        int lhsIdxX = Integer.MAX_VALUE;
        int lhsIdxY = Integer.MAX_VALUE;
        for (int i = 0; i < elmts.length; ++i) {
            if (elmts[i].getRect().getMinX() >= hlsX) {
                hlsX = elmts[i].getRect().getMinX();
                hlsIdxX = i;
            }
            if (elmts[i].getRect().getMinY() >= hlsY) {
                hlsY = elmts[i].getRect().getMinY();
                hlsIdxY = i;
            }
            if (elmts[i].getRect().getMaxX() <= lhsX) {
                lhsX = elmts[i].getRect().getMaxX();
                lhsIdxX = i;
            }
            if (elmts[i].getRect().getMaxY() > lhsY) continue;
            lhsY = elmts[i].getRect().getMaxY();
            lhsIdxY = i;
        }
        int[] retIdx = new int[2];
        int Xpair = Math.abs(lhsX - hlsX) / mbr.getWidth();
        if (Xpair > (Ypair = Math.abs(lhsY - hlsY) / mbr.getHeight())) {
            if (hlsIdxX == lhsIdxX) {
                hlsIdxX = hlsIdxX != 0 ? 0 : 1;
            }
            retIdx[0] = hlsIdxX;
            retIdx[1] = lhsIdxX;
        } else if (Xpair < Ypair) {
            if (hlsIdxY == lhsIdxY) {
                hlsIdxY = hlsIdxY != 0 ? 0 : 1;
            }
            retIdx[0] = hlsIdxY;
            retIdx[1] = lhsIdxY;
        } else if (Math.abs(lhsX - hlsX) >= Math.abs(lhsY - hlsY)) {
            if (hlsIdxX == lhsIdxX) {
                hlsIdxX = hlsIdxX != 0 ? 0 : 1;
            }
            retIdx[0] = hlsIdxX;
            retIdx[1] = lhsIdxX;
        } else {
            if (hlsIdxY == lhsIdxY) {
                hlsIdxY = hlsIdxY != 0 ? 0 : 1;
            }
            retIdx[0] = hlsIdxY;
            retIdx[1] = lhsIdxY;
        }
        return retIdx;
    }

    private int[] quadPickSeeds(Element[] elmts) throws IllegalValueException {
        if (elmts.length <= 1) {
            throw new IllegalValueException("Node.quadPickSeed : PickSeed not possible as there are no elements");
        }
        int[] retIdx = new int[2];
        int mostIneff = Integer.MIN_VALUE;
        for (int i = 0; i < elmts.length; ++i) {
            for (int j = i + 1; j < elmts.length; ++j) {
                Rect seedRect = Rect.getResultingMBR(elmts[i].getRect(), elmts[j].getRect());
                int arr = seedRect.getArea() - elmts[i].getRect().getArea() - elmts[j].getRect().getArea();
                if (arr <= mostIneff) continue;
                retIdx[0] = i;
                retIdx[1] = j;
                mostIneff = arr;
            }
        }
        return retIdx;
    }

    public long getParent() {
        return this.parent;
    }

    public int getElementIndex(long ptr) {
        if (this.totalElements < 1) {
            return -999;
        }
        for (int i = 0; i < this.totalElements; ++i) {
            if (this.elements[i].getPtr() != ptr) continue;
            return i;
        }
        System.out.println("Node.getElementIndex: Element not found, returning NOT_DEFINED");
        return -999;
    }

    public void modifyElement(int index, Element elmt) throws IllegalValueException, IOException, NodeWriteException {
        if (index > this.totalElements || index < 0 || elmt == null) {
            throw new IllegalValueException("Node.modifyElmtMBR : index out of bound or MBR is null");
        }
        if (elmt.getElementType() != this.elementType) {
            throw new IllegalValueException("Node.modifyElmtMBR : Element of wrong type");
        }
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        if (this.fileHdr.isWriteThr()) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(this.elementSize);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeInt(elmt.getRect().getMinX());
            ds.writeInt(elmt.getRect().getMinY());
            ds.writeInt(elmt.getRect().getMaxX());
            ds.writeInt(elmt.getRect().getMaxY());
            ds.writeLong(elmt.getPtr());
            bs.flush();
            ds.flush();
            this.seekElement(index);
            this.file.write(bs.toByteArray());
            this.setDirty(false);
        } else {
            this.setDirty(true);
        }
        this.elements[index].setRect(elmt.getRect());
        this.elements[index].setPtr(elmt.getPtr());
        if (elmt.getRect().contains(this.elements[index].getRect())) {
            this.nodeMBR.expandToInclude(elmt.getRect());
        } else {
            this.refreshNodeMBR();
        }
    }

    public void modifyElement(int index, long pointer) throws IllegalValueException, IOException, NodeWriteException {
        if (index > this.totalElements || index < 0) {
            try {
                throw new IllegalValueException("Node.modifyElmtMBR : index out of bound for node " + this.nodeIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        if (this.fileHdr.isWriteThr()) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(8);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeLong(pointer);
            bs.flush();
            ds.flush();
            this.seekElementPtr(index);
            this.file.write(bs.toByteArray());
            this.setDirty(false);
        } else {
            this.setDirty(true);
        }
        this.elements[index].setPtr(pointer);
    }

    public void modifyElement(int index, Rect rect) throws IllegalValueException, IOException, NodeWriteException {
        if (index > this.totalElements || index < 0) {
            throw new IllegalValueException("Node.modifyElmtMBR : index out of bound or MBR is null");
        }
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        if (this.fileHdr.isWriteThr()) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(Rect.sizeInBytes());
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeInt(rect.getMinX());
            ds.writeInt(rect.getMinY());
            ds.writeInt(rect.getMaxX());
            ds.writeInt(rect.getMaxY());
            bs.flush();
            ds.flush();
            this.seekElement(index);
            this.file.write(bs.toByteArray());
            this.setDirty(false);
        } else {
            this.setDirty(true);
        }
        this.elements[index].setRect(rect);
        if (rect.contains(this.elements[index].getRect())) {
            this.nodeMBR.expandToInclude(rect);
        } else {
            this.refreshNodeMBR();
        }
    }

    public Rect getNodeMBR() throws IllegalValueException {
        if (this.totalElements < 1) {
            throw new IllegalValueException("Node.getNodeMBR: Node empty");
        }
        return this.nodeMBR;
    }

    private void refreshNodeMBR() {
        this.nodeMBR = new Rect();
        for (int i = 0; i < this.totalElements; ++i) {
            this.nodeMBR.expandToInclude(this.elements[i].getRect());
        }
    }

    public void setParent(long prnt) throws IOException, NodeWriteException {
        if (prnt == -999L) {
            this.fileHdr.writeFileHeader(this.fileHdr.totalNodes, this.nodeIndex);
        }
        if (this.fileHdr.isWriteThr()) {
            RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        }
        this.writeNodeHeader(this.nodeIndex, this.totalElements, prnt, this.elementSize, this.elementType);
    }

    public String toString() {
        String ret = "\n\t***Node at Index: " + Long.toString(this.nodeIndex) + "***";
        ret = ret + "\nLocal Variables-";
        ret = ret + "\n\tnodeIndex: " + Long.toString(this.nodeIndex);
        if (this.totalElements <= 0) {
            ret = ret + "\n\tnodeMBR: isNull";
        }
        ret = ret + "\nFile Header-";
        ret = ret + "\n\ttotalNodes: " + Integer.toString(this.fileHdr.totalNodes);
        ret = ret + "\n\trootIndex: " + Long.toString(this.fileHdr.rootIndex);
        ret = ret + "\nNode Header-";
        ret = ret + "\n\ttotalElements: " + Integer.toString(this.totalElements);
        ret = ret + "\n\tparent: " + Long.toString(this.parent);
        ret = ret + "\n\telementSize:" + Integer.toString(this.elementSize);
        ret = ret + "\n\telementType:" + Integer.toString(this.elementType);
        for (int i = 0; i < this.totalElements; ++i) {
            ret = ret + this.elements[i].toString();
        }
        return ret;
    }

    public int getTotalElements() {
        return this.totalElements;
    }

    public Element[] getAllElements() {
        return this.elements;
    }

    Element getElement(int index) throws IllegalValueException {
        if (index < 0 || index > this.totalElements - 1) {
            throw new IllegalValueException("Node.getElement Index out of bound");
        }
        return this.elements[index];
    }

    public void deleteNode() throws NodeWriteException {
        this.setDirty(false);
        RTree.chdNodes.remove(this.fileName, this.nodeIndex);
        try {
            this.fileHdr.push(this.nodeIndex);
        }
        catch (StackOverflowException stackOverflowException) {
        }
        catch (IOException ex) {
            throw new NodeWriteException(ex.getMessage());
        }
    }

    void sweepSort() {
        if (this.elements != null && this.elements.length > 1 && !this.sorted) {
            Arrays.sort(this.elements, 0, this.totalElements, new CompElmtX());
            this.sorted = true;
        }
    }

    public boolean flush() throws NodeWriteException {
        try {
            if (this.dirty && !this.fileHdr.isWriteThr()) {
                this.deleteElement(-1, true);
                this.setDirty(false);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NodeWriteException(e.getMessage());
        }
    }

    void setDirty(boolean val) {
        if (val) {
            this.sorted = false;
        }
        this.dirty = val;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

