/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import rtree.BufferHeader;
import rtree.FileHdr;
import rtree.IllegalValueException;
import rtree.Node;
import rtree.NodeReadException;
import rtree.NodeValue;
import rtree.NodeWriteException;
import rtree.ReadNode;
import rtree.seeded.SdNode;

public class CachedNodes {
    private static final int NODE = 0;
    private static final int SDNODE = 1;
    Hashtable cache;
    BufferHeader buffHeader;
    int size = 100000;
    static Map<String, Integer> fileNamesMap = new LinkedHashMap<String, Integer>();

    CachedNodes() {
        this.cache = new Hashtable(100001, 1.0f);
        this.buffHeader = new BufferHeader(100000, this.cache);
        this.size = 100000;
    }

    CachedNodes(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("CachedNodes:: size is less than zero");
        }
        this.cache = new Hashtable(size + 1, 1.0f);
        this.buffHeader = new BufferHeader(size, this.cache);
        this.size = size;
    }

    public synchronized void setCacheSize(int size) throws NodeWriteException {
        if (size < 0) {
            throw new IllegalArgumentException("CachedNodes:: size is less than zero");
        }
        this.removeAll();
        this.cache = new Hashtable(size + 1, 1.0f);
        this.buffHeader = new BufferHeader(size, this.cache);
        this.size = size;
    }

    public synchronized int getSize() {
        return this.cache.size();
    }

    private Node getNode(RandomAccessFile file, String fileName, long lndIndex, FileHdr flHdr, int type) throws IllegalValueException, NodeReadException, FileNotFoundException, IOException, NodeWriteException {
        int ndIndex = (int)lndIndex;
        int key = this.calKey(fileName, ndIndex);
        NodeValue node = (NodeValue)this.cache.get(new Integer(key));
        if (node == null) {
            Node nNode = type == 0 ? new Node(file, fileName, ndIndex, flHdr) : new SdNode(file, fileName, ndIndex, flHdr);
            key = this.calKey(fileName, (int)nNode.getNodeIndex());
            nNode.sweepSort();
            if (this.cache.size() < 100000) {
                this.buffHeader.put(key, nNode);
            } else if (this.cache.size() == 100000) {
                this.buffHeader.replace(key, nNode);
            }
            return nNode;
        }
        this.buffHeader.update(key);
        node.node.sweepSort();
        return node.node;
    }

    private Node getNode(RandomAccessFile file, String fileName, long parentIndex, int elmtType, FileHdr flHdr, int type) throws IllegalValueException, NodeReadException, FileNotFoundException, IOException, NodeWriteException {
        Node nNode = type == 0 ? new Node(file, fileName, parentIndex, elmtType, flHdr) : new SdNode(file, fileName, parentIndex, elmtType, flHdr);
        int key = this.calKey(fileName, (int)nNode.getNodeIndex());
        nNode.sweepSort();
        if (this.cache.size() < 100000) {
            this.buffHeader.put(key, nNode);
        } else if (this.cache.size() == 100000) {
            this.buffHeader.replace(key, nNode);
        }
        return nNode;
    }

    public synchronized SdNode getSdNode(RandomAccessFile file, String fileName, long lndIndex, FileHdr flHdr) throws IllegalValueException, NodeReadException, FileNotFoundException, IOException, NodeWriteException {
        return (SdNode)this.getNode(file, fileName, lndIndex, flHdr, 1);
    }

    public synchronized SdNode getSdNode(RandomAccessFile file, String fileName, long parentIndex, int elmtType, FileHdr flHdr) throws IllegalValueException, NodeReadException, FileNotFoundException, IOException, NodeWriteException {
        return (SdNode)this.getNode(file, fileName, parentIndex, elmtType, flHdr, 1);
    }

    public synchronized Node getNode(RandomAccessFile file, String fileName, long lndIndex, FileHdr flHdr) throws IllegalValueException, NodeReadException, FileNotFoundException, IOException, NodeWriteException {
        return this.getNode(file, fileName, lndIndex, flHdr, 0);
    }

    public synchronized Node getNode(RandomAccessFile file, String fileName, long parentIndex, int elmtType, FileHdr flHdr) throws IllegalValueException, NodeReadException, FileNotFoundException, IOException, NodeWriteException {
        return this.getNode(file, fileName, parentIndex, elmtType, flHdr, 0);
    }

    public synchronized Node getNode(RandomAccessFile file, String fileName, long parentIndex, int elmtType, FileHdr flHdr, Node type) throws IllegalValueException, NodeReadException, FileNotFoundException, IOException, NodeWriteException {
        if (type instanceof SdNode) {
            return this.getNode(file, fileName, parentIndex, elmtType, flHdr, 1);
        }
        return this.getNode(file, fileName, parentIndex, elmtType, flHdr, 0);
    }

    public synchronized ReadNode getReadNode(RandomAccessFile file, String fileName, long lndIndex, FileHdr flHdr) throws IllegalValueException, NodeReadException, FileNotFoundException, IOException, NodeWriteException {
        return ReadNode.makeReadNode(this.getNode(file, fileName, lndIndex, flHdr));
    }

    synchronized void flush() throws NodeWriteException {
        this.buffHeader.flush();
    }

    synchronized void remove(String fileName, long ndIndex) throws NodeWriteException {
        int key = this.calKey(fileName, (int)ndIndex);
        this.buffHeader.remove(key);
    }

    synchronized void removeAll() throws NodeWriteException {
        this.buffHeader.reset();
    }

    static void clearFileNamesMap() {
        fileNamesMap.clear();
    }

    int calKey(String fileName, int idx) {
        if (fileName != null) {
            Integer i = fileNamesMap.get(fileName);
            if (i == null) {
                if (fileNamesMap.size() > 1023) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                fileNamesMap.put(fileName, fileNamesMap.size());
                i = fileNamesMap.get(fileName);
            }
            return (idx << 10) + i;
        }
        System.out.println("CachedNodes.calKey: fileName null");
        return 0;
    }
}

