/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.util.Hashtable;
import rtree.Node;
import rtree.NodeValue;
import rtree.NodeWriteException;

class BufferHeader {
    int recent;
    int last;
    int size;
    Hashtable cache;

    BufferHeader(int size, Hashtable ch) {
        this.cache = ch;
        this.size = size;
    }

    void flush() throws NodeWriteException {
        for (NodeValue node : this.cache.values()) {
            node.node.flush();
        }
    }

    void put(int key, Node node) {
        try {
            if (this.cache.containsKey(new Integer(key))) {
                this.update(key);
                return;
            }
            if (this.cache.size() == this.size) {
                this.replace(key, node);
                return;
            }
            if (this.cache.size() == 0) {
                this.last = key;
                this.cache.put(new Integer(key), new NodeValue(node, key, key));
            } else {
                NodeValue tmpPrev = (NodeValue)this.cache.remove(new Integer(this.recent));
                if (this.last == this.recent) {
                    this.cache.put(new Integer(key), new NodeValue(node, tmpPrev.next, tmpPrev.next));
                    this.cache.put(new Integer(this.recent), new NodeValue(tmpPrev.node, key, key));
                } else {
                    NodeValue tmpPNext = (NodeValue)this.cache.remove(new Integer(tmpPrev.next));
                    this.cache.put(new Integer(key), new NodeValue(node, tmpPrev.next, this.recent));
                    this.cache.put(new Integer(tmpPrev.next), new NodeValue(tmpPNext.node, tmpPNext.next, key));
                    this.cache.put(new Integer(this.recent), new NodeValue(tmpPrev.node, key, tmpPrev.prev));
                }
            }
            this.recent = key;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void replace(int key, Node node) throws NodeWriteException {
        try {
            if (this.cache.containsKey(new Integer(key))) {
                this.update(key);
                return;
            }
            if (this.cache.size() < this.size) {
                this.put(key, node);
                return;
            }
            NodeValue lastNode = (NodeValue)this.cache.remove(new Integer(this.last));
            lastNode.node.flush();
            NodeValue pNode = (NodeValue)this.cache.remove(new Integer(lastNode.prev));
            NodeValue nNode = (NodeValue)this.cache.remove(new Integer(lastNode.next));
            this.cache.put(new Integer(key), new NodeValue(node, lastNode.next, lastNode.prev));
            this.cache.put(new Integer(lastNode.prev), new NodeValue(pNode.node, key, pNode.prev));
            this.cache.put(new Integer(lastNode.next), new NodeValue(nNode.node, nNode.next, key));
            this.recent = key;
            this.last = lastNode.next;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void update(int key) {
        try {
            if (key != this.recent) {
                NodeValue node = (NodeValue)this.cache.remove(new Integer(key));
                if (node == null) {
                    System.out.println("CachedNodes.update: unlikely flow");
                    return;
                }
                if (key == this.last) {
                    this.last = node.next;
                    this.cache.put(new Integer(key), new NodeValue(node.node, node.next, node.prev));
                } else {
                    NodeValue nextNode = (NodeValue)this.cache.remove(new Integer(node.next));
                    if (this.recent != node.next) {
                        NodeValue rcntNode = (NodeValue)this.cache.remove(new Integer(this.recent));
                        rcntNode.next = key;
                        this.cache.put(new Integer(this.recent), new NodeValue(rcntNode.node, rcntNode.next, rcntNode.prev));
                    } else {
                        nextNode.next = key;
                    }
                    this.cache.put(new Integer(node.next), new NodeValue(nextNode.node, nextNode.next, node.prev));
                    NodeValue prevNode = (NodeValue)this.cache.remove(new Integer(node.prev));
                    if (this.last != node.prev) {
                        NodeValue lastNode = (NodeValue)this.cache.remove(new Integer(this.last));
                        lastNode.prev = key;
                        this.cache.put(new Integer(this.last), new NodeValue(lastNode.node, lastNode.next, lastNode.prev));
                    } else {
                        prevNode.prev = key;
                    }
                    this.cache.put(new Integer(node.prev), new NodeValue(prevNode.node, node.next, prevNode.prev));
                    this.cache.put(new Integer(key), new NodeValue(node.node, this.last, this.recent));
                }
            }
            this.recent = key;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void remove(int key) throws NodeWriteException {
        try {
            NodeValue node = (NodeValue)this.cache.remove(new Integer(key));
            if (this.cache.size() != 0 && node != null) {
                node.node.flush();
                if (this.cache.size() == 1) {
                    NodeValue oNode = (NodeValue)this.cache.remove(new Integer(node.prev));
                    this.cache.put(new Integer(node.prev), new NodeValue(oNode.node, node.prev, node.prev));
                    this.recent = this.last = node.prev;
                } else {
                    node.node.flush();
                    NodeValue pNode = (NodeValue)this.cache.remove(new Integer(node.prev));
                    NodeValue nNode = (NodeValue)this.cache.remove(new Integer(node.next));
                    this.cache.put(new Integer(node.prev), new NodeValue(pNode.node, node.next, pNode.prev));
                    this.cache.put(new Integer(node.next), new NodeValue(nNode.node, nNode.next, node.prev));
                    if (key == this.recent) {
                        this.recent = node.prev;
                    }
                    if (key == this.last) {
                        this.last = node.next;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void reset() throws NodeWriteException {
        this.flush();
        this.cache.clear();
    }
}

