/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.wikidata;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import org.apache.commons.logging.Log;

public class ArticleMapper
implements JsonDeserializer<Article> {
    private static final long ERROR_BATCH_SIZE = 5000L;
    private static int errorCount;
    private static final Log log;
    public static final String[] PROP_IMAGE;
    public static final String PROP_COMMON_CAT = "P373";
    private final String PROP_COMMON_COORDS = "P625";

    public Article deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Article article;
        block12: {
            article = new Article();
            try {
                JsonElement links;
                JsonObject obj = (JsonObject)json;
                JsonElement oClaims = obj.get("claims");
                if (oClaims instanceof JsonObject) {
                    JsonObject ccDataValue;
                    JsonArray propCommonCat;
                    JsonObject coordinatesDataValue;
                    JsonObject claims = obj.getAsJsonObject("claims");
                    JsonArray propCoords = claims.getAsJsonArray("P625");
                    if (propCoords != null && (coordinatesDataValue = propCoords.get(0).getAsJsonObject().getAsJsonObject("mainsnak").getAsJsonObject("datavalue")) != null) {
                        JsonObject coordinates = coordinatesDataValue.getAsJsonObject("value");
                        double lat = coordinates.getAsJsonPrimitive("latitude").getAsDouble();
                        double lon = coordinates.getAsJsonPrimitive("longitude").getAsDouble();
                        article.setLat(lat);
                        article.setLon(lon);
                    }
                    JsonArray propImage = null;
                    for (JsonObject property : PROP_IMAGE) {
                        propImage = claims.getAsJsonArray((String)property);
                        if (propImage == null) continue;
                        JsonObject imageDataValue = propImage.get(0).getAsJsonObject().getAsJsonObject("mainsnak").getAsJsonObject("datavalue");
                        if (imageDataValue == null) break;
                        String image = imageDataValue.getAsJsonPrimitive("value").getAsString();
                        article.setImage(image);
                        article.setImageProp((String)property);
                        break;
                    }
                    if ((propCommonCat = claims.getAsJsonArray(PROP_COMMON_CAT)) != null && (ccDataValue = propCommonCat.get(0).getAsJsonObject().getAsJsonObject("mainsnak").getAsJsonObject("datavalue")) != null) {
                        String commonCat = ccDataValue.getAsJsonPrimitive("value").getAsString();
                        article.setCommonCat(commonCat);
                    }
                }
                if ((links = obj.get("sitelinks")) != null) {
                    ArrayList<SiteLink> siteLinks = new ArrayList<SiteLink>();
                    if (links instanceof JsonObject) {
                        for (Map.Entry entry : ((JsonObject)links).getAsJsonObject().entrySet()) {
                            String lang = ((String)entry.getKey()).replace("wiki", "");
                            if (lang.equals("commons")) continue;
                            String title = ((JsonElement)entry.getValue()).getAsJsonObject().getAsJsonPrimitive("title").getAsString();
                            siteLinks.add(new SiteLink(lang, title));
                        }
                    } else if (links instanceof JsonArray && ((JsonArray)links).size() > 0) {
                        throw new IllegalArgumentException();
                    }
                    article.setSiteLinks(siteLinks);
                }
            }
            catch (Exception e) {
                if ((long)(++errorCount) == 5000L) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if ((long)errorCount % 5000L != 0L) break block12;
                log.error((Object)String.format("Error json pages %s (total %d)", json.toString(), errorCount));
            }
        }
        return article;
    }

    static {
        log = PlatformUtil.getLog(ArticleMapper.class);
        PROP_IMAGE = new String[]{"P18", "P180"};
    }

    public static class Article {
        private List<SiteLink> siteLinks = new ArrayList<SiteLink>();
        private double lat;
        private double lon;
        private String image;
        private String imageProp;
        private String commonCat;

        public List<SiteLink> getSiteLinks() {
            return this.siteLinks;
        }

        public double getLon() {
            return this.lon;
        }

        public double getLat() {
            return this.lat;
        }

        public String getImage() {
            return this.image;
        }

        public String getCommonCat() {
            return this.commonCat;
        }

        public void setLon(double lon) {
            this.lon = lon;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public void setSiteLinks(List<SiteLink> siteLinks) {
            this.siteLinks = siteLinks;
        }

        public void setImage(String img) {
            this.image = img;
        }

        public void setCommonCat(String cc) {
            this.commonCat = cc;
        }

        public String getImageProp() {
            return this.imageProp;
        }

        public void setImageProp(String imageProp) {
            this.imageProp = imageProp;
        }
    }

    static class SiteLink {
        String lang;
        String title;

        public SiteLink(String lang, String title) {
            this.lang = lang;
            this.title = title;
        }
    }
}

