/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.osmand.PlatformUtil;
import net.osmand.impl.FileProgressImplementation;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.util.SqlInsertValuesReader;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class CommonsWikimediaPreparation {
    public static final String COMMONSWIKI_ARTICLES_GZ = "commonswiki-latest-pages-articles.xml.gz";
    public static final String COMMONSWIKI_CATEGORYLINKS_GZ = "commonswiki-latest-categorylinks.sql.gz";
    public static final String COMMONSWIKI_SQLITE = "wikidata_commons_osm.sqlitedb";
    public static final String CATEGORY_NAMESPACE = "14";
    public static final String FILE_NAMESPACE = "6";
    public static final String DEPICT_KEY = "[[d:Special:EntityPage/";
    public static final String DEPICT_KEY_END = "]]";
    private static final Log log = PlatformUtil.getLog(CommonsWikimediaPreparation.class);
    private final HashSet<String> filter = new HashSet<String>(){
        {
            this.add("GFDL");
            this.add("GFDL_en");
            this.add("Files_with_no_machine-readable_source");
            this.add("Self-published_work");
            this.add("Files_with_no_machine-readable_author");
            this.add("Media_missing_infobox_template");
            this.add("License_migration_redundant");
            this.add("License_migration_completed");
            this.add("Assumed_own_work");
        }
    };
    private Map<String, Long> categoryCashe = new HashMap<String, Long>();

    public static void main(String[] args) {
        String folder = "";
        String mode = "";
        String database = "";
        for (String arg : args) {
            String val = arg.substring(arg.indexOf("=") + 1);
            if (arg.startsWith("--dir=")) {
                folder = val;
                continue;
            }
            if (arg.startsWith("--mode=")) {
                mode = val;
                continue;
            }
            if (!arg.startsWith("--result_db=")) continue;
            database = val;
        }
        if (mode.isEmpty() || folder.isEmpty()) {
            throw new RuntimeException("Correct arguments weren't supplied");
        }
        String commonWikiArticles = folder + COMMONSWIKI_ARTICLES_GZ;
        String categoryLinksSql = folder + COMMONSWIKI_CATEGORYLINKS_GZ;
        Object sqliteFileName = database.isEmpty() ? folder + COMMONSWIKI_SQLITE : database;
        CommonsWikimediaPreparation p = new CommonsWikimediaPreparation();
        try {
            switch (mode) {
                case "parse-commonswiki-articles": {
                    p.parseCommonArticles(commonWikiArticles, (String)sqliteFileName);
                    break;
                }
                case "parse-categorylinks-sql": {
                    p.parseCategoryLinksSQL(categoryLinksSql, (String)sqliteFileName);
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    private void parseCommonArticles(String articles, String sqliteFileName) throws ParserConfigurationException, SAXException, IOException, SQLException {
        SAXParser sx = SAXParserFactory.newInstance().newSAXParser();
        FileProgressImplementation progress = new FileProgressImplementation("Read commonswiki articles file", new File(articles));
        InputStream streamFile = progress.openFileInputStream();
        InputSource is = CommonsWikimediaPreparation.getInputSource(streamFile);
        CommonsWikiHandler handler = new CommonsWikiHandler(sx, progress, new File(sqliteFileName));
        sx.parse(is, (DefaultHandler)handler);
        handler.finish();
    }

    private static InputSource getInputSource(InputStream streamFile) throws IOException {
        GZIPInputStream zis = new GZIPInputStream(streamFile);
        InputStreamReader reader = new InputStreamReader((InputStream)zis, "UTF-8");
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        return is;
    }

    private void parseCategoryLinksSQL(String sqlFile, String sqliteFileName) throws SQLException, IOException {
        CategoryLinksSqlHandler handler = new CategoryLinksSqlHandler(new File(sqliteFileName));
        SqlInsertValuesReader.readInsertValuesFile(sqlFile, (SqlInsertValuesReader.InsertValueProcessor)handler);
        handler.finish();
    }

    private class CommonsWikiHandler
    extends DefaultHandler {
        private final SAXParser saxParser;
        private DBDialect dialect = DBDialect.SQLITE;
        private Connection conn;
        private PreparedStatement prepDepict;
        private PreparedStatement prepContent;
        private int[] depictBatch = new int[]{0};
        private int[] contentBatch = new int[]{0};
        private boolean page = false;
        private boolean idPage = false;
        private StringBuilder ctext = null;
        private final StringBuilder title = new StringBuilder();
        private final StringBuilder comment = new StringBuilder();
        private final StringBuilder format = new StringBuilder();
        private final StringBuilder ns = new StringBuilder();
        private final StringBuilder id = new StringBuilder();
        private FileProgressImplementation progress;
        public static final int BATCH_SIZE = 5000;

        CommonsWikiHandler(SAXParser saxParser, FileProgressImplementation progress, File sqliteFile) throws SQLException {
            this.saxParser = saxParser;
            this.progress = progress;
            this.conn = this.dialect.getDatabaseConnection(sqliteFile.getAbsolutePath(), log);
            log.info((Object)"========= CREATE TABLES common_depict, common_content =========");
            this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS common_depict(id long, depict_qid long, depict_type text)");
            this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS common_content(id long, name text, ns int)");
            this.conn.createStatement().execute("DELETE FROM common_depict");
            this.conn.createStatement().execute("DELETE FROM common_content");
            this.prepDepict = this.conn.prepareStatement("INSERT INTO common_depict(id, depict_qid, depict_type) VALUES (?, ?, ?)");
            this.prepContent = this.conn.prepareStatement("INSERT INTO common_content(id, name, ns) VALUES (?, ?, ?)");
        }

        public void finish() throws SQLException {
            System.out.println("Create indexes");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_common_depict_index on common_depict(id)");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS qid_common_depict_index on common_depict(depict_qid)");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_common_content on common_content(id)");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS category_name_common_content on common_content(name)");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_ns_common_content on common_content(id, ns)");
            this.prepDepict.executeBatch();
            this.prepContent.executeBatch();
            if (!this.conn.getAutoCommit()) {
                this.conn.commit();
            }
            this.prepDepict.close();
            this.prepContent.close();
            this.conn.close();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String name;
            String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
            if (!this.page) {
                this.page = name.equals("page");
            } else if (name.equals("title")) {
                this.title.setLength(0);
                this.ctext = this.title;
            } else if (name.equals("comment")) {
                this.comment.setLength(0);
                this.ctext = this.comment;
            } else if (name.equals("format")) {
                this.format.setLength(0);
                this.ctext = this.format;
            } else if (name.equals("ns")) {
                this.ns.setLength(0);
                this.ctext = this.ns;
            } else if (name.equals("id") && !this.idPage) {
                this.id.setLength(0);
                this.ctext = this.id;
                this.idPage = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.page && this.ctext != null) {
                this.ctext.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            String name;
            String string = name = this.saxParser.isNamespaceAware() ? localName : qName;
            if (this.page) {
                switch (name) {
                    case "page": {
                        this.page = false;
                        this.idPage = false;
                        this.progress.update();
                        break;
                    }
                    case "title": 
                    case "format": 
                    case "ns": 
                    case "comment": 
                    case "id": {
                        this.ctext = null;
                        break;
                    }
                    case "text": {
                        String nameSpace = this.ns.toString();
                        if (!CommonsWikimediaPreparation.FILE_NAMESPACE.equals(nameSpace) && !CommonsWikimediaPreparation.CATEGORY_NAMESPACE.equals(nameSpace)) break;
                        try {
                            String n = this.title.toString().replace("File:", "");
                            n = n.replace("Category:", "");
                            this.prepContent.setLong(1, Long.parseLong(this.id.toString()));
                            this.prepContent.setString(2, n);
                            this.prepContent.setInt(3, Integer.parseInt(nameSpace));
                            this.addBatch(this.prepContent, this.contentBatch);
                            if (!CommonsWikimediaPreparation.FILE_NAMESPACE.equals(nameSpace) || !this.comment.toString().contains(CommonsWikimediaPreparation.DEPICT_KEY)) break;
                            String depictType = null;
                            String depictQid = null;
                            int l = CommonsWikimediaPreparation.DEPICT_KEY.length();
                            String c = this.comment.toString();
                            int s = c.indexOf(CommonsWikimediaPreparation.DEPICT_KEY);
                            int e = c.indexOf(CommonsWikimediaPreparation.DEPICT_KEY_END, s + l);
                            if (s != -1 && e != -1) {
                                depictType = c.substring(s + l, e);
                                s = c.indexOf(CommonsWikimediaPreparation.DEPICT_KEY, e);
                                e = c.indexOf(CommonsWikimediaPreparation.DEPICT_KEY_END, s + l);
                                if (s != -1 && e != -1) {
                                    depictQid = c.substring(s + l, e);
                                }
                            }
                            if (depictQid == null) break;
                            this.prepDepict.setLong(1, Long.parseLong(this.id.toString()));
                            this.prepDepict.setLong(2, Long.parseLong(depictQid.substring(1)));
                            this.prepDepict.setString(3, depictType);
                            this.addBatch(this.prepDepict, this.depictBatch);
                            break;
                        }
                        catch (SQLException throwables) {
                            throwables.printStackTrace();
                        }
                    }
                }
            }
        }

        public void addBatch(PreparedStatement prep, int[] bt) throws SQLException {
            prep.addBatch();
            bt[0] = bt[0] + 1;
            int batch = bt[0];
            if (batch > 5000) {
                prep.executeBatch();
                bt[0] = 0;
            }
        }
    }

    private class CategoryLinksSqlHandler
    implements SqlInsertValuesReader.InsertValueProcessor {
        private DBDialect dialect = DBDialect.SQLITE;
        private Connection conn;
        private PreparedStatement prepCategory;
        private PreparedStatement selectPrep;
        private PreparedStatement selectCatPrep;
        private int[] categoryBatch = new int[]{0};
        public static final int BATCH_SIZE = 5000;
        private long cnt = 0L;

        CategoryLinksSqlHandler(File sqliteFile) throws SQLException {
            this.conn = this.dialect.getDatabaseConnection(sqliteFile.getAbsolutePath(), log);
            log.info((Object)"========= CREATE TABLE common_category_links =========");
            this.conn.createStatement().execute("CREATE TABLE IF NOT EXISTS common_category_links(id long, category_id long)");
            this.conn.createStatement().execute("DELETE FROM common_category_links");
            this.prepCategory = this.conn.prepareStatement("INSERT INTO common_category_links(id, category_id) VALUES (?, ?)");
            this.selectPrep = this.conn.prepareStatement("SELECT count(*) as cnt FROM common_content WHERE common_content.id=? AND common_content.ns=6");
            this.selectCatPrep = this.conn.prepareStatement("SELECT common_content.id FROM common_content WHERE common_content.name=? AND common_content.ns=14");
        }

        @Override
        public void process(List<String> vs) {
            long id = Long.parseLong(vs.get(0));
            String catName = vs.get(1);
            String cl_type = vs.get(6);
            if (!cl_type.equals("file") || CommonsWikimediaPreparation.this.filter.contains(catName) || catName.startsWith("CC-") || catName.startsWith("PD-")) {
                return;
            }
            try {
                this.selectPrep.setLong(1, id);
                ResultSet rs = this.selectPrep.executeQuery();
                int count = 0;
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                this.selectPrep.clearParameters();
                if (count > 0) {
                    long catId = 0L;
                    if (CommonsWikimediaPreparation.this.categoryCashe.containsKey(catName)) {
                        catId = CommonsWikimediaPreparation.this.categoryCashe.get(catName);
                    } else {
                        this.selectCatPrep.setString(1, catName.replace("_", " "));
                        rs = this.selectCatPrep.executeQuery();
                        if (rs.next()) {
                            catId = rs.getLong(1);
                            CommonsWikimediaPreparation.this.categoryCashe.put(catName, catId);
                        }
                        this.selectCatPrep.clearParameters();
                    }
                    if (catId > 0L) {
                        this.prepCategory.setLong(1, id);
                        this.prepCategory.setLong(2, catId);
                        this.addBatch(this.prepCategory, this.categoryBatch);
                    }
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            ++this.cnt;
            if (this.cnt % 100000L == 0L) {
                System.out.println(this.cnt + " id:" + id + " cat:" + catName);
            }
            if (CommonsWikimediaPreparation.this.categoryCashe.size() > 1000) {
                CommonsWikimediaPreparation.this.categoryCashe.clear();
            }
        }

        public void addBatch(PreparedStatement prep, int[] bt) throws SQLException {
            prep.addBatch();
            bt[0] = bt[0] + 1;
            int batch = bt[0];
            if (batch > 5000) {
                prep.executeBatch();
                bt[0] = 0;
            }
        }

        public void finish() throws SQLException {
            System.out.println("Create indexes");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS id_common_category_links_index on common_category_links(id)");
            this.conn.createStatement().execute("CREATE INDEX IF NOT EXISTS category_id_common_category_links on common_category_links(category_id)");
            this.prepCategory.executeBatch();
            if (!this.conn.getAutoCommit()) {
                this.conn.commit();
            }
            this.prepCategory.close();
            this.selectPrep.close();
            this.conn.close();
        }
    }
}

