/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;
import net.osmand.data.QuadRect;
import net.osmand.data.Ring;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;

public class WeatherPrepareRasterSqliteRegions {
    private static final Log LOG = PlatformUtil.getLog(WeatherPrepareRasterSqliteRegions.class);
    private static boolean SKIP_EXISTING = false;
    private static String EXTENSION = ".tifsqlite";
    private static boolean ZIP = false;
    private static int ZOOM = 4;
    private static final int BATCH_SIZE = 100;
    private static int GEN_HOURS_BACK = 4;
    private static String REGIONS_FOLDER = "regions";
    private static String SOURCES_FORECAST = "gfs,ecmwf";
    private static final long MASK1 = 0xFFFFFF00L;
    private static final long SHIFT_1 = 8L;
    private static final long MASK2 = 0xFFFFFF00000000L;
    private static final long SHIFT_2 = 32L;
    private static final long MASK3 = 255L;
    private static final long SHIFT_3 = 0L;

    public static void main(String[] args) throws IOException {
        File weatherFolder = new File(args[0]);
        boolean dryRun = false;
        String filter = null;
        String prefix = "Weather_";
        for (int i = 1; i < args.length; ++i) {
            if ("--dry-run".equals(args[i])) {
                dryRun = true;
                continue;
            }
            if ("--zip".equals(args[i])) {
                ZIP = true;
                continue;
            }
            if ("--skip-existing".equals(args[i])) {
                SKIP_EXISTING = true;
                continue;
            }
            if (args[i].startsWith("--zoom=")) {
                ZOOM = Integer.parseInt(args[i].substring("--zoom=".length()));
                continue;
            }
            if (args[i].startsWith("--include-hours-before-now=")) {
                GEN_HOURS_BACK = Integer.parseInt(args[i].substring("--include-hours-before-now=".length()));
                continue;
            }
            if (args[i].startsWith("--extension=")) {
                EXTENSION = args[i].substring("--extension=".length());
                continue;
            }
            if (args[i].startsWith("--sources=")) {
                SOURCES_FORECAST = args[i].substring("--sources=".length());
                continue;
            }
            if (args[i].startsWith("--filter=")) {
                filter = args[i].substring("--filter=".length());
                continue;
            }
            if (!args[i].startsWith("--prefix=")) continue;
            prefix = args[i].substring("--prefix=".length());
        }
        OsmandRegions or = new OsmandRegions();
        BinaryMapIndexReader fl = or.prepareFile();
        Map allCountries = or.cacheAllCountries(false);
        BinaryMapIndexReader.MapIndex mapIndex = (BinaryMapIndexReader.MapIndex)fl.getMapIndexes().get(0);
        int boundaryTag = mapIndex.getRule("osmand_region", "boundary");
        int cnt = 1;
        int proc = 1;
        HashSet<String> failedCountries = new HashSet<String>();
        for (String fullName : allCountries.keySet()) {
            boolean hasParentBoundaries;
            ++proc;
            if (filter != null && !fullName.contains(filter)) continue;
            WorldRegion region = or.getRegionData(fullName);
            BinaryMapDataObject rc = WeatherPrepareRasterSqliteRegions.getBoundary(or, allCountries, boundaryTag, region);
            boolean bl = hasParentBoundaries = WeatherPrepareRasterSqliteRegions.getBoundary(or, allCountries, boundaryTag, region.getSuperregion()) != null && !region.getSuperregion().getRegionId().equals("northamerica_us") && !region.getSuperregion().getRegionId().equals("northamerica_canada");
            if (rc == null || hasParentBoundaries) continue;
            Object dname = region.getRegionDownloadName();
            if (dname == null) {
                String superRegion = region.getSuperregion().getRegionId();
                dname = fullName.substring(superRegion.length() + 1) + "_" + superRegion;
            }
            System.out.println(String.format("\nRegion %s processed %d [%d/%d]", dname, cnt++, proc, allCountries.size()));
            try {
                WeatherPrepareRasterSqliteRegions.process(rc, (List)allCountries.get(fullName), (String)dname, weatherFolder, prefix, dryRun);
            }
            catch (Exception e) {
                failedCountries.add(fullName);
                e.printStackTrace();
            }
        }
        try {
            WeatherPrepareRasterSqliteRegions.processWorld(weatherFolder, prefix, dryRun);
        }
        catch (Exception e) {
            failedCountries.add("world");
            e.printStackTrace();
        }
        if (!failedCountries.isEmpty()) {
            throw new IllegalStateException("Failed countries " + failedCountries);
        }
    }

    private static void processWorld(File weatherFolder, String prefix, boolean dryRun) throws Exception {
        String dwName = prefix + "World" + EXTENSION;
        File targetFile = new File(new File(weatherFolder, REGIONS_FOLDER), dwName);
        File targetFileGZip = new File(new File(weatherFolder, REGIONS_FOLDER), dwName + ".zip");
        if (!SKIP_EXISTING) {
            targetFile.delete();
            targetFileGZip.delete();
        }
        if (targetFile.exists() || targetFileGZip.exists()) {
            System.out.println("Already processed " + dwName);
            return;
        }
        TreeSet<Long> regionTileNames = new TreeSet<Long>();
        if (dryRun) {
            return;
        }
        int tileX = 0;
        while ((double)tileX < MapUtils.getPowZoom((double)ZOOM)) {
            int tileY = 0;
            while ((double)tileY < MapUtils.getPowZoom((double)ZOOM)) {
                regionTileNames.add(WeatherPrepareRasterSqliteRegions.pack(tileX, tileY, ZOOM));
                ++tileY;
            }
            ++tileX;
        }
        WeatherPrepareRasterSqliteRegions.procRegion(weatherFolder, regionTileNames, targetFile);
        WeatherPrepareRasterSqliteRegions.zipFile(targetFile, targetFileGZip);
    }

    private static void zipFile(File targetFile, File targetFileGZip) throws IOException, FileNotFoundException {
        if (ZIP) {
            ZipOutputStream zous = new ZipOutputStream(new FileOutputStream(targetFileGZip));
            zous.putNextEntry(new ZipEntry(targetFile.getName()));
            FileInputStream fin = new FileInputStream(targetFile);
            Algorithms.streamCopy((InputStream)fin, (OutputStream)zous);
            ((InputStream)fin).close();
            zous.close();
            targetFile.delete();
        }
    }

    private static BinaryMapDataObject getBoundary(OsmandRegions or, Map<String, LinkedList<BinaryMapDataObject>> allCountries, int boundaryTag, WorldRegion region) {
        if (region == null) {
            return null;
        }
        LinkedList<BinaryMapDataObject> lst = allCountries.get(region.getRegionId());
        BinaryMapDataObject rc = null;
        if (lst == null) {
            return null;
        }
        for (BinaryMapDataObject r : lst) {
            if (r.containsType(boundaryTag) || r.getPointsLength() <= 1) continue;
            rc = r;
            break;
        }
        return rc;
    }

    private static void process(BinaryMapDataObject country, List<BinaryMapDataObject> boundaries, String downloadName, File weatherFolder, String prefix, boolean dryRun) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        String name = country.getName();
        String dwName = prefix + Algorithms.capitalizeFirstLetterAndLowercase((String)downloadName) + EXTENSION;
        File targetFile = new File(new File(weatherFolder, REGIONS_FOLDER), dwName);
        File targetFileGZip = new File(new File(weatherFolder, REGIONS_FOLDER), dwName + ".zip");
        if (!SKIP_EXISTING) {
            targetFile.delete();
            targetFileGZip.delete();
        }
        if (targetFile.exists() || targetFileGZip.exists()) {
            System.out.println("Already processed " + name);
            return;
        }
        TreeSet<Long> regionTileNames = new TreeSet<Long>();
        WeatherPrepareRasterSqliteRegions.calculateRegionBoundaries(country, boundaries, name, regionTileNames);
        if (dryRun) {
            return;
        }
        WeatherPrepareRasterSqliteRegions.procRegion(weatherFolder, regionTileNames, targetFile);
        WeatherPrepareRasterSqliteRegions.zipFile(targetFile, targetFileGZip);
    }

    private static void calculateRegionBoundaries(BinaryMapDataObject country, List<BinaryMapDataObject> boundaries, String name, Set<Long> regionTileNames) {
        QuadRect qr = new QuadRect(180.0, -90.0, -180.0, 90.0);
        MultipolygonBuilder bld = new MultipolygonBuilder();
        if (boundaries != null) {
            for (BinaryMapDataObject o : boundaries) {
                bld.addOuterWay(WeatherPrepareRasterSqliteRegions.convertToWay(o));
                WeatherPrepareRasterSqliteRegions.updateBbox(o, qr);
            }
        } else {
            bld.addOuterWay(WeatherPrepareRasterSqliteRegions.convertToWay(country));
            WeatherPrepareRasterSqliteRegions.updateBbox(country, qr);
        }
        Multipolygon polygon = bld.build();
        int rightLon = (int)Math.floor(MapUtils.getTileNumberX((float)ZOOM, (double)qr.right));
        int leftLon = (int)Math.floor(MapUtils.getTileNumberX((float)ZOOM, (double)qr.left));
        int bottomLat = (int)Math.floor(MapUtils.getTileNumberY((float)ZOOM, (double)qr.bottom));
        int topLat = (int)Math.floor(MapUtils.getTileNumberY((float)ZOOM, (double)qr.top));
        boolean onetile = leftLon == rightLon && bottomLat == topLat;
        for (int tileX = leftLon; tileX <= rightLon; ++tileX) {
            for (int tileY = topLat; tileY <= bottomLat; ++tileY) {
                double blat;
                boolean isOut;
                double llon = MapUtils.getLongitudeFromTile((double)ZOOM, (double)tileX);
                double rlon = MapUtils.getLongitudeFromTile((double)ZOOM, (double)(tileX + 1));
                double tlat = MapUtils.getLatitudeFromTile((float)ZOOM, (double)tileY);
                boolean bl = isOut = !polygon.containsPoint(tlat / 2.0 + (blat = MapUtils.getLatitudeFromTile((float)ZOOM, (double)(tileY + 1))) / 2.0, llon / 2.0 + rlon / 2.0) && !onetile;
                if (isOut) {
                    LatLon bl2 = new LatLon(blat, llon);
                    LatLon br = new LatLon(blat, rlon);
                    LatLon tr = new LatLon(tlat, rlon);
                    LatLon tl = new LatLon(tlat, llon);
                    for (Ring r : polygon.getOuterRings()) {
                        List border = r.getBorder();
                        Node prev = (Node)border.get(border.size() - 1);
                        for (int i = 0; i < border.size() && isOut; ++i) {
                            Node n = (Node)border.get(i);
                            if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)tr, (LatLon)tl)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)tr, (LatLon)br)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)bl2, (LatLon)tl)) {
                                isOut = false;
                            } else if (MapAlgorithms.linesIntersect((LatLon)prev.getLatLon(), (LatLon)n.getLatLon(), (LatLon)br, (LatLon)bl2)) {
                                isOut = false;
                            }
                            prev = n;
                        }
                        if (isOut) continue;
                        break;
                    }
                }
                if (isOut) continue;
                int x = tileX;
                int y = tileY;
                regionTileNames.add(WeatherPrepareRasterSqliteRegions.pack(tileX, tileY, ZOOM));
                x >>= 1;
                y >>= 1;
            }
        }
        System.out.println();
        System.out.println("-----------------------------");
        System.out.println("PROCESSING " + name + " lon [" + leftLon + " - " + rightLon + "] lat [" + bottomLat + " - " + topLat + "] TOTAL " + regionTileNames.size() + " tiles ");
    }

    private static void procRegion(File weatherFolder, Set<Long> regionTileNames, File targetFile) throws SQLException, IOException, FileNotFoundException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmm");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(11, -GEN_HOURS_BACK);
        Date filterTime = cal.getTime();
        int batch = 0;
        try (Connection targetConn = DBDialect.SQLITE.getDatabaseConnection(targetFile.getAbsolutePath(), LOG);){
            WeatherPrepareRasterSqliteRegions.prepareNewWeatherFile(targetConn, false, ZOOM, ZOOM);
            PreparedStatement psinsnew = targetConn.prepareStatement("INSERT INTO tiles(x, y, z, s, image, time, source, forecastdate) VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
            for (String source : SOURCES_FORECAST.split(",")) {
                File srcFile = new File(weatherFolder, source + "/tiff");
                if (!srcFile.exists()) continue;
                for (File dtFolder : srcFile.listFiles()) {
                    Date forecastdate;
                    block12: {
                        if (!dtFolder.isDirectory()) continue;
                        try {
                            forecastdate = dateFormat.parse(dtFolder.getName());
                            if (forecastdate.before(filterTime)) {
                            }
                            break block12;
                        }
                        catch (ParseException e) {
                            LOG.info((Object)("Error parsing folder name: " + e.getMessage() + " - " + dtFolder.getName()));
                        }
                        continue;
                    }
                    for (long s : regionTileNames) {
                        int maxI;
                        int x = WeatherPrepareRasterSqliteRegions.unpack1(s);
                        int y = WeatherPrepareRasterSqliteRegions.unpack2(s);
                        int z = WeatherPrepareRasterSqliteRegions.unpack3(s);
                        File imageGzip = new File(dtFolder, z + "_" + x + "_" + ((maxI = (1 << z) - 1) - y) + ".tiff.gz");
                        byte[] image = Algorithms.readBytesFromInputStream((InputStream)new GZIPInputStream(new FileInputStream(imageGzip)));
                        if (image == null) continue;
                        psinsnew.setInt(1, x);
                        psinsnew.setInt(2, y);
                        psinsnew.setInt(3, z);
                        psinsnew.setString(4, dtFolder.getName() + ":" + source);
                        psinsnew.setBytes(5, image);
                        psinsnew.setLong(6, imageGzip.lastModified());
                        psinsnew.setString(7, source);
                        psinsnew.setLong(8, forecastdate.getTime());
                        psinsnew.addBatch();
                        if (batch++ < 100) continue;
                        batch = 0;
                        psinsnew.executeBatch();
                    }
                }
            }
            psinsnew.executeBatch();
            psinsnew.close();
        }
    }

    private static void prepareNewWeatherFile(Connection newFile, boolean bigPlanet, int minZoom, int maxZoom) throws SQLException {
        Statement statement = newFile.createStatement();
        statement.execute("CREATE TABLE tiles (x int, y int, z int, s int, image blob, time long, source, forecastdate long, PRIMARY KEY (x,y,z,s))");
        statement.execute("CREATE INDEX IND on tiles (x,y,z,s)");
        statement.execute("CREATE TABLE info(tilenumbering,minzoom,maxzoom,timecolumn,gentime,url,rule,referer)");
        statement.close();
        PreparedStatement pStatement = newFile.prepareStatement("INSERT INTO INFO(tilenumbering,minzoom,maxzoom,timecolumn,gentime) VALUES(?,?,?,?,?)");
        String tileNumbering = bigPlanet ? "BigPlanet" : "simple";
        pStatement.setString(1, tileNumbering);
        int minNormalZoom = bigPlanet ? 17 - maxZoom : minZoom;
        int maxNormalZoom = bigPlanet ? 17 - minZoom : maxZoom;
        pStatement.setInt(2, minNormalZoom);
        pStatement.setInt(3, maxNormalZoom);
        pStatement.setString(4, "yes");
        pStatement.setLong(5, System.currentTimeMillis());
        pStatement.execute();
    }

    private static long pack(int r1, int r2, int r3) {
        long l = 0L;
        l |= (long)r1 << 8 & 0xFFFFFF00L;
        l |= (long)r2 << 32 & 0xFFFFFF00000000L;
        if (WeatherPrepareRasterSqliteRegions.unpack3(l |= (long)r3 << 0 & 0xFFL) != r3 || WeatherPrepareRasterSqliteRegions.unpack2(l) != r2 || WeatherPrepareRasterSqliteRegions.unpack1(l) != r1) {
            throw new IllegalStateException();
        }
        return l;
    }

    private static int unpack3(long l) {
        return (int)((l & 0xFFL) >> 0);
    }

    private static int unpack2(long l) {
        return (int)((l & 0xFFFFFF00000000L) >> 32);
    }

    private static int unpack1(long l) {
        return (int)((l & 0xFFFFFF00L) >> 8);
    }

    private static Way convertToWay(BinaryMapDataObject o) {
        Way w = new Way(-1L);
        for (int i = 0; i < o.getPointsLength(); ++i) {
            double lat = MapUtils.get31LatitudeY((int)o.getPoint31YTile(i));
            double lon = MapUtils.get31LongitudeX((int)o.getPoint31XTile(i));
            w.addNode(new Node(lat, lon, -1L));
        }
        return w;
    }

    private static void updateBbox(BinaryMapDataObject country, QuadRect qr) {
        for (int i = 0; i < country.getPointsLength(); ++i) {
            double lat = MapUtils.get31LatitudeY((int)country.getPoint31YTile(i));
            double lon = MapUtils.get31LongitudeX((int)country.getPoint31XTile(i));
            qr.left = Math.min(lon, qr.left);
            qr.right = Math.max(lon, qr.right);
            qr.top = Math.max(lat, qr.top);
            qr.bottom = Math.min(lat, qr.bottom);
        }
    }
}

