/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class SqlInsertValuesReader {
    public static void readInsertValuesFile(String fileName, InsertValueProcessor p) throws IOException {
        InputStream fis = new FileInputStream(fileName);
        if (fileName.endsWith("gz")) {
            fis = new GZIPInputStream(fis);
        }
        SqlInsertValuesReader.readInsertValuesFile(fis, p);
    }

    public static void readInsertValuesFile(InputStream fis, InsertValueProcessor p) throws IOException {
        int cnt;
        InputStreamReader read = new InputStreamReader(fis, "UTF-8");
        char[] cbuf = new char[1000];
        Object buf = "";
        ArrayList<String> insValues = new ArrayList<String>();
        boolean values = false;
        boolean openInsValues = false;
        boolean openWord = false;
        while ((cnt = read.read(cbuf)) >= 0) {
            String str = new String(cbuf, 0, cnt);
            buf = (String)buf + str;
            boolean processed = true;
            block3: while (processed) {
                processed = false;
                if (!values) {
                    int ind = ((String)buf).indexOf("VALUES");
                    if (ind == -1) continue;
                    buf = ((String)buf).substring(ind + "VALUES".length());
                    values = true;
                    processed = true;
                    continue;
                }
                if (!openInsValues) {
                    int ind = ((String)buf).indexOf("(");
                    if (ind == -1) continue;
                    buf = ((String)buf).substring(ind + 1);
                    openInsValues = true;
                    insValues.clear();
                    processed = true;
                    continue;
                }
                if (!openWord) {
                    StringBuilder number = new StringBuilder(100);
                    for (int k = 0; k < ((String)buf).length(); ++k) {
                        char ch = ((String)buf).charAt(k);
                        if (ch == '\'') {
                            openWord = true;
                            processed = true;
                        } else if (ch == ')') {
                            if (number.toString().trim().length() > 0) {
                                insValues.add(number.toString().trim());
                            }
                            try {
                                p.process(insValues);
                            }
                            catch (Exception e) {
                                System.err.println(e.getMessage() + " " + insValues);
                            }
                            openInsValues = false;
                            processed = true;
                        } else if (ch == ',') {
                            if (number.toString().trim().length() > 0) {
                                insValues.add(number.toString().trim());
                            }
                            processed = true;
                        } else {
                            number.append(ch);
                        }
                        if (!processed) continue;
                        buf = ((String)buf).substring(k + 1);
                        continue block3;
                    }
                    continue;
                }
                if (!openWord) continue;
                StringBuilder word = new StringBuilder(100);
                boolean escape = false;
                for (int k = 0; k < ((String)buf).length(); ++k) {
                    char ch = ((String)buf).charAt(k);
                    if (escape) {
                        word.append(ch);
                        escape = false;
                        continue;
                    }
                    if (ch == '\'') {
                        insValues.add(word.toString());
                        processed = true;
                        openWord = false;
                        buf = ((String)buf).substring(k + 1);
                        continue block3;
                    }
                    if (ch == '\\') {
                        escape = true;
                        continue;
                    }
                    word.append(ch);
                }
            }
        }
        read.close();
    }

    public static interface InsertValueProcessor {
        public void process(List<String> var1);
    }
}

