/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DockerClientBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.osmand.MapCreatorVersion;
import net.osmand.PlatformUtil;
import net.osmand.binary.MapZooms;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.util.Algorithms;
import net.osmand.util.CountryOcbfGeneration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import rtree.RTree;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.model.DescribeJobsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobsResponse;
import software.amazon.awssdk.services.batch.model.JobDetail;
import software.amazon.awssdk.services.batch.model.JobStatus;
import software.amazon.awssdk.services.batch.model.SubmitJobRequest;
import software.amazon.awssdk.services.batch.model.SubmitJobResponse;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class IndexBatchCreator {
    private static final int INMEM_LIMIT = 2000;
    private static final long TIMEOUT_TO_CHECK_AWS = 15000L;
    private static final long TIMEOUT_TO_CHECK_DOCKER = 15000L;
    protected static final Log log = PlatformUtil.getLog(IndexBatchCreator.class);
    public static final String GEN_LOG_EXT = ".gen.log";
    File skipExistingIndexes;
    MapZooms mapZooms = null;
    Integer zoomWaySmoothness = null;
    File osmDirFiles;
    File indexDirFiles;
    File workDir;
    String srtmDir;
    List<LocalPendingGeneration> localPendingGenerations = new ArrayList<LocalPendingGeneration>();
    List<ExternalJobDefinition> externalJobQueues = new ArrayList<ExternalJobDefinition>();
    List<AwsPendingGeneration> awsPendingGenerations = new ArrayList<AwsPendingGeneration>();
    List<AwsPendingGeneration> awsFailedGenerations = new ArrayList<AwsPendingGeneration>();
    int awsStatushash = 0;
    int awsSucceeded = 0;
    int awsFailed = 0;
    DockerClient dockerClient;
    int dockerSlots = 4;
    Map<ExternalJobDefinition, List<DockerPendingGeneration>> dockerPendingGenerations = new ConcurrentHashMap<ExternalJobDefinition, List<DockerPendingGeneration>>();
    List<DockerPendingGeneration> dockerFailedGenerations = new ArrayList<DockerPendingGeneration>();
    boolean indexPOI = false;
    boolean indexTransport = false;
    boolean indexAddress = false;
    boolean indexMap = false;
    boolean indexRouting = false;
    boolean indexByProximity = true;
    private String wget;
    private DBDialect osmDbDialect;
    private String renderingTypesFile;
    private SimpleDateFormat sdf;
    private static final int DOWNLOAD_DEBUG = 0x100000;
    private static final int BUFFER_SIZE = 32768;
    private static final int SLEEP_SEC = 1;

    public static void main(String[] args) throws Exception {
        FileInputStream stream;
        IndexBatchCreator creator = new IndexBatchCreator();
        if (args == null || args.length == 0) {
            System.out.println("Please specify -local parameter or path to batch.xml configuration file as 1 argument.");
            throw new IllegalArgumentException("Please specify -local parameter or path to batch.xml configuration file as 1 argument.");
        }
        String name = args[0];
        try {
            stream = new FileInputStream(name);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("XML configuration file not found : " + name, e);
        }
        List<RegionCountries> countriesToProcess = null;
        try {
            Document params = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            countriesToProcess = creator.setupProcess(params);
        }
        catch (Exception e) {
            System.out.println("XML configuration file could not be read from " + name);
            log.error((Object)("XML configuration file could not be read from " + name + ": " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            IndexBatchCreator.safeClose(stream, "Error closing stream for " + name);
        }
        creator.runBatch(countriesToProcess);
    }

    public List<RegionCountries> setupProcess(Document doc) throws SAXException, IOException, ParserConfigurationException, XmlPullParserException {
        String dir;
        NodeList list = doc.getElementsByTagName("process");
        if (list.getLength() != 1) {
            throw new IllegalArgumentException("You should specify exactly 1 process element!");
        }
        Element process = (Element)list.item(0);
        IndexCreator.REMOVE_POI_DB = true;
        String file = process.getAttribute("skipExistingIndexesAt");
        if (file != null && new File(file).exists()) {
            this.skipExistingIndexes = new File(file);
        }
        this.wget = process.getAttribute("wget");
        this.indexPOI = Boolean.parseBoolean(process.getAttribute("indexPOI"));
        this.indexMap = Boolean.parseBoolean(process.getAttribute("indexMap"));
        this.indexRouting = process.getAttribute("indexRouting") == null || process.getAttribute("indexRouting").equalsIgnoreCase("true");
        this.indexTransport = Boolean.parseBoolean(process.getAttribute("indexTransport"));
        this.indexAddress = Boolean.parseBoolean(process.getAttribute("indexAddress"));
        this.indexByProximity = Boolean.parseBoolean(process.getAttribute("indexByProximity"));
        this.parseProcessAttributes(process);
        list = doc.getElementsByTagName("process_attributes");
        if (list.getLength() == 1) {
            this.parseProcessAttributes((Element)list.item(0));
        }
        if ((dir = process.getAttribute("directory_for_osm_files")) == null || !new File(dir).exists()) {
            throw new IllegalArgumentException("Please specify directory with .osm or .osm.bz2 files as directory_for_osm_files (attribute)" + dir);
        }
        this.osmDirFiles = new File(dir);
        this.srtmDir = process.getAttribute("directory_for_srtm_files");
        dir = process.getAttribute("directory_for_index_files");
        if (dir == null || !new File(dir).exists()) {
            throw new IllegalArgumentException("Please specify directory with generated index files  as directory_for_index_files (attribute)");
        }
        this.workDir = this.indexDirFiles = new File(dir);
        dir = process.getAttribute("directory_for_generation");
        if (dir != null && new File(dir).exists()) {
            this.workDir = new File(dir);
        }
        this.parseJobDefinitions(process.getElementsByTagName("external"), this.externalJobQueues);
        ArrayList<RegionCountries> countriesToDownload = new ArrayList<RegionCountries>();
        this.parseCountriesToDownload(doc, countriesToDownload);
        return countriesToDownload;
    }

    private void parseJobDefinitions(NodeList nodeList, List<ExternalJobDefinition> jobQueues) {
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Element external = (Element)nodeList.item(j);
            if (!Algorithms.isEmpty((CharSequence)external.getAttribute("dockerSlots"))) {
                this.dockerSlots = Integer.parseInt(external.getAttribute("dockerSlots"));
            }
            NodeList jobs = external.getElementsByTagName("job");
            for (int k = 0; k < jobs.getLength(); ++k) {
                Element jbe = (Element)jobs.item(k);
                ExternalJobDefinition jd = new ExternalJobDefinition();
                jd.definition = jbe.getAttribute("definition");
                if (!Algorithms.isEmpty((CharSequence)jbe.getAttribute("slotsPerJob"))) {
                    jd.slotsPerJob = Integer.parseInt(jbe.getAttribute("slotsPerJob"));
                }
                jd.name = jbe.getAttribute("name");
                jd.type = jbe.getAttribute("type");
                jd.queue = jbe.getAttribute("queue");
                if (!Algorithms.isEmpty((CharSequence)jbe.getAttribute("sizeUpToMB"))) {
                    jd.sizeUpToMB = Integer.parseInt(jbe.getAttribute("sizeUpToMB"));
                }
                NodeList params = jbe.getElementsByTagName("parameter");
                for (int l = 0; l < params.getLength(); ++l) {
                    Element jbep = (Element)params.item(l);
                    jd.params.put(jbep.getAttribute("k"), jbep.getAttribute("v"));
                }
                NodeList filters = jbe.getElementsByTagName("filter");
                for (int l = 0; l < filters.getLength(); ++l) {
                    Element f = (Element)filters.item(l);
                    if (!Algorithms.isEmpty((CharSequence)f.getAttribute("exclude"))) {
                        jd.excludedRegions.add(f.getAttribute("exclude").toLowerCase());
                    }
                    if (Algorithms.isEmpty((CharSequence)f.getAttribute("excludePattern"))) continue;
                    jd.excludePatterns.add(f.getAttribute("excludePattern").toLowerCase());
                }
                jd.name = jbe.getAttribute("name");
                jobQueues.add(jd);
            }
        }
    }

    private void parseCountriesToDownload(Document doc, List<RegionCountries> countriesToDownload) throws IOException, XmlPullParserException {
        NodeList regions = doc.getElementsByTagName("regions");
        for (int i = 0; i < regions.getLength(); ++i) {
            Element el = (Element)regions.item(i);
            if (Boolean.parseBoolean(el.getAttribute("skip"))) continue;
            RegionCountries countries = new RegionCountries();
            countries.siteToDownload = el.getAttribute("siteToDownload");
            if (countries.siteToDownload == null) continue;
            countries.namePrefix = el.getAttribute("region_prefix");
            if (countries.namePrefix == null) {
                countries.namePrefix = "";
            }
            countries.nameSuffix = el.getAttribute("region_suffix");
            if (countries.nameSuffix == null) {
                countries.nameSuffix = "";
            }
            NodeList nRegionsList = el.getElementsByTagName("regionList");
            for (int j = 0; j < nRegionsList.getLength(); ++j) {
                Element nregionList = (Element)nRegionsList.item(j);
                String url = nregionList.getAttribute("url");
                if (url == null) continue;
                String filterStartWith = nregionList.getAttribute("filterStartsWith");
                String filterContains = nregionList.getAttribute("filterContains");
                CountryOcbfGeneration ocbfGeneration = new CountryOcbfGeneration();
                log.warn((Object)("Download region list from " + url));
                CountryOcbfGeneration.CountryRegion regionStructure = ocbfGeneration.parseRegionStructure(new URL(url).openStream());
                Iterator<CountryOcbfGeneration.CountryRegion> it = regionStructure.iterator();
                int total = 0;
                int before = countries.regionNames.size();
                while (it.hasNext()) {
                    CountryOcbfGeneration.CountryRegion cr = it.next();
                    if (cr.getDownloadName().contains("_basemap") || !cr.map || cr.jointMap) continue;
                    ++total;
                    if (!Algorithms.isEmpty((CharSequence)filterStartWith) && !cr.getDownloadName().toLowerCase().startsWith(filterStartWith.toLowerCase()) || !Algorithms.isEmpty((CharSequence)filterContains) && !cr.getDownloadName().toLowerCase().contains(filterContains.toLowerCase())) continue;
                    RegionSpecificData dt = new RegionSpecificData();
                    dt.downloadName = cr.getDownloadName();
                    countries.regionNames.put(dt.downloadName, dt);
                }
                log.warn((Object)String.format("Accepted %d from %d", countries.regionNames.size() - before, total));
            }
            NodeList ncountries = el.getElementsByTagName("region");
            log.info((Object)("Region to download " + countries.siteToDownload));
            for (int j = 0; j < ncountries.getLength(); ++j) {
                String dname;
                Element ncountry = (Element)ncountries.item(j);
                String name = ncountry.getAttribute("name");
                RegionSpecificData data = new RegionSpecificData();
                data.indexSRTM = ncountry.getAttribute("indexSRTM") == null || ncountry.getAttribute("indexSRTM").equalsIgnoreCase("true");
                String index = ncountry.getAttribute("index");
                if (index != null && index.length() > 0) {
                    data.indexAddress = index.contains("address");
                    data.indexMap = index.contains("map");
                    data.indexTransport = index.contains("transport");
                    data.indexRouting = index.contains("routing");
                    data.indexPOI = index.contains("poi");
                }
                String string = data.downloadName = (dname = ncountry.getAttribute("downloadName")) == null || dname.length() == 0 ? name : dname;
                if (name == null || Boolean.parseBoolean(ncountry.getAttribute("skip"))) continue;
                countries.regionNames.put(name, data);
            }
            countriesToDownload.add(countries);
        }
    }

    private void parseProcessAttributes(Element process) {
        String zooms = process.getAttribute("mapZooms");
        this.mapZooms = zooms == null || zooms.length() == 0 ? MapZooms.getDefault() : MapZooms.parseZooms((String)zooms);
        String szoomWaySmoothness = process.getAttribute("zoomWaySmoothness");
        if (szoomWaySmoothness != null && !szoomWaySmoothness.isEmpty()) {
            this.zoomWaySmoothness = Integer.parseInt(szoomWaySmoothness);
        }
        this.renderingTypesFile = process.getAttribute("renderingTypesFile");
        String osmDbDialect = process.getAttribute("osmDbDialect");
        if (osmDbDialect != null && osmDbDialect.length() > 0) {
            try {
                this.osmDbDialect = DBDialect.valueOf(osmDbDialect.toUpperCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public void runBatch(List<RegionCountries> countriesToDownload) {
        LinkedHashSet<String> alreadyGeneratedFiles = new LinkedHashSet<String>();
        if (!countriesToDownload.isEmpty()) {
            this.downloadFilesAndGenerateIndex(countriesToDownload, alreadyGeneratedFiles);
        }
        this.generateLocalFolderIndexes(alreadyGeneratedFiles);
        new Thread(new Runnable(){

            @Override
            public void run() {
                IndexBatchCreator.this.waitAwsJobsToFinish(60000L);
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                IndexBatchCreator.this.waitDockerJobsToFinish(30000L);
            }
        }).start();
        log.info((Object)("Generate local " + this.localPendingGenerations.size() + " maps"));
        for (LocalPendingGeneration lp : this.localPendingGenerations) {
            this.generateLocalIndex(lp.file, lp.regionName, lp.mapFileName, lp.rdata, alreadyGeneratedFiles);
        }
        this.waitAwsJobsToFinish(15000L);
        this.waitDockerJobsToFinish(15000L);
        log.info((Object)"GENERATING INDEXES FINISHED ");
        if (this.awsFailedGenerations.size() > 0) {
            throw new IllegalStateException("There are " + this.awsFailedGenerations.size() + " aws failed generations");
        }
        if (this.dockerFailedGenerations.size() > 0) {
            throw new IllegalStateException("There are " + this.dockerFailedGenerations.size() + " docker  failed generations");
        }
    }

    private void waitDockerJobsToFinish(long timeout) {
        while (true) {
            int total = 0;
            ArrayList<String> names = new ArrayList<String>();
            for (List<DockerPendingGeneration> l : this.dockerPendingGenerations.values()) {
                total += l.size();
                for (DockerPendingGeneration d : l) {
                    if (d.container == null) continue;
                    names.add(d.name);
                }
            }
            if (total == 0) {
                return;
            }
            log.warn((Object)String.format("Waiting %d docker jobs to complete, running %d: %s", total, names.size(), names));
            this.waitDockerJobsIteration();
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private synchronized void waitDockerJobsIteration() {
        if (this.dockerClient == null) {
            this.dockerClient = DockerClientBuilder.getInstance().build();
        }
        int allocation = this.dockerSlots;
        ArrayList<List<DockerPendingGeneration>> all = new ArrayList<List<DockerPendingGeneration>>(this.dockerPendingGenerations.values());
        List<DockerPendingGeneration> queue = this.createQueueEquallyDistributed(all);
        Iterator<DockerPendingGeneration> it = queue.iterator();
        while (it.hasNext() && allocation > 0) {
            DockerPendingGeneration p = it.next();
            allocation -= p.jd.slotsPerJob;
            if (p.container == null) {
                p.container = this.dockerClient.createContainerCmd(p.image).withBinds(p.binds).withCmd(p.cmd).withEnv(p.envs).withName(p.name).exec();
                this.dockerClient.startContainerCmd(p.container.getId()).exec();
                continue;
            }
            try {
                InspectContainerResponse res = this.dockerClient.inspectContainerCmd(p.container.getId()).exec();
                if (res.getState().getRunning().booleanValue()) continue;
                Long l = res.getState().getExitCodeLong();
                if (l == null || l != 0L) {
                    this.dockerFailedGenerations.add(p);
                } else {
                    log.info((Object)String.format("Finished %s container %s at %s (started %s).", this.getDuration(res.getState()), res.getName(), res.getState().getFinishedAt(), res.getState().getStartedAt()));
                    this.dockerClient.removeContainerCmd(p.container.getId()).exec();
                }
                allocation += p.jd.slotsPerJob;
                it.remove();
                this.dockerPendingGenerations.get(p.jd).remove(p);
            }
            catch (RuntimeException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.dockerPendingGenerations.get(p.jd).remove(p);
            }
        }
    }

    private List<DockerPendingGeneration> createQueueEquallyDistributed(List<List<DockerPendingGeneration>> all) {
        ArrayList<DockerPendingGeneration> queue = new ArrayList<DockerPendingGeneration>();
        boolean added = true;
        int ind = 0;
        while (added) {
            added = false;
            for (int i = 0; i < all.size(); ++i) {
                List<DockerPendingGeneration> lst = all.get(i);
                if (ind >= lst.size()) continue;
                queue.add(lst.get(ind));
                added = true;
            }
            ++ind;
        }
        return queue;
    }

    private String getDuration(InspectContainerResponse.ContainerState state) {
        if (this.sdf == null) {
            this.sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
        try {
            long finish = this.sdf.parse(state.getFinishedAt()).getTime();
            long start = this.sdf.parse(state.getStartedAt()).getTime();
            long s = (finish - start) / 1000L;
            return String.format("%d:%02d:%02d", s / 3600L, s % 3600L / 60L, s % 60L);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private void waitAwsJobsToFinish(long timeout) {
        log.info((Object)String.format("Waiting %d aws jobs to complete...", this.awsPendingGenerations.size()));
        while (this.awsPendingGenerations.size() > 0) {
            this.waitAwsJobsIteration();
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void waitAwsJobsIteration() {
        LinkedHashMap<String, JobDetail> awsStatus = new LinkedHashMap<String, JobDetail>();
        ArrayList<String> jobIds = new ArrayList<String>();
        for (AwsPendingGeneration p : this.awsPendingGenerations) {
            jobIds.add(p.response.jobId());
            if (jobIds.size() <= 50) continue;
            this.getJobStatus(jobIds, awsStatus);
            jobIds.clear();
        }
        this.getJobStatus(jobIds, awsStatus);
        Iterator<AwsPendingGeneration> it = this.awsPendingGenerations.iterator();
        int readytorun = 0;
        int running = 0;
        int starting = 0;
        while (it.hasNext()) {
            AwsPendingGeneration gen = it.next();
            JobDetail status = (JobDetail)awsStatus.get(gen.response.jobId());
            if (status == null) continue;
            JobStatus js = JobStatus.fromValue((String)status.statusAsString());
            if (js == JobStatus.RUNNABLE) {
                ++readytorun;
                continue;
            }
            if (js == JobStatus.RUNNING) {
                ++running;
                continue;
            }
            if (js == JobStatus.STARTING) {
                ++starting;
                continue;
            }
            if (js == JobStatus.SUCCEEDED) {
                ++this.awsSucceeded;
                try {
                    S3Client client = (S3Client)S3Client.builder().build();
                    String s3url = gen.s3Url;
                    if (s3url.startsWith("s3://")) {
                        s3url = s3url.substring("s3://".length());
                    }
                    int i = s3url.indexOf(47);
                    String bucket = s3url.substring(0, i);
                    String key = s3url.substring(i + 1);
                    GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
                    ResponseInputStream obj = client.getObject(request);
                    FileOutputStream fous = new FileOutputStream(new File(this.indexDirFiles, gen.targetFileName));
                    Algorithms.streamCopy((InputStream)obj, (OutputStream)fous);
                    obj.close();
                    fous.close();
                    it.remove();
                }
                catch (Exception e) {
                    log.error((Object)String.format("Error retrieving result from S3 %s: %s", gen.s3Url, e.getMessage()), (Throwable)e);
                }
                continue;
            }
            if (js != JobStatus.FAILED) continue;
            ++this.awsFailed;
            it.remove();
            this.awsFailedGenerations.add(gen);
            log.error((Object)String.format("! Failed generation %s, job id %s: %s", gen.targetFileName, status.jobId(), status.statusReason()));
        }
        int hash = this.awsPendingGenerations.size() + readytorun * 7 + starting * 11 + running * 17 + this.awsSucceeded * 41 + this.awsFailed * 107;
        if (this.awsStatushash != hash) {
            log.info((Object)String.format("Pending %d aws jobs: ready to run %d, starting %d running %d - succeeded %d, failed %d ...", this.awsPendingGenerations.size(), readytorun, starting, running, this.awsSucceeded, this.awsFailed));
            this.awsStatushash = hash;
        }
    }

    private void getJobStatus(List<String> jobIds, Map<String, JobDetail> awsStatus) {
        try {
            BatchClient client = (BatchClient)BatchClient.builder().build();
            DescribeJobsResponse response = client.describeJobs((DescribeJobsRequest)DescribeJobsRequest.builder().jobs(jobIds).build());
            for (JobDetail jd : response.jobs()) {
                awsStatus.put(jd.jobId(), jd);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error retrieving status for batch jobs:" + e.getMessage()), (Throwable)e);
        }
    }

    protected void downloadFilesAndGenerateIndex(List<RegionCountries> countriesToDownload, Set<String> alreadyGeneratedFiles) {
        for (RegionCountries regionCountries : countriesToDownload) {
            String prefix = regionCountries.namePrefix;
            String site = regionCountries.siteToDownload;
            String suffix = regionCountries.nameSuffix;
            for (String name : regionCountries.regionNames.keySet()) {
                RegionSpecificData regionSpecificData = regionCountries.regionNames.get(name);
                name = name.toLowerCase();
                String url = MessageFormat.format(site, regionSpecificData.downloadName);
                String regionName = prefix + name;
                String fileName = Algorithms.capitalizeFirstLetterAndLowercase((String)(prefix + name + suffix));
                if (this.skipExistingIndexes != null) {
                    File bmif = new File(this.skipExistingIndexes, fileName + "_2.obf");
                    File bmifz = new File(this.skipExistingIndexes, bmif.getName() + ".zip");
                    if (bmif.exists() || bmifz.exists()) continue;
                }
                log.warn((Object)("----------- Get " + fileName + " " + url + " ----------"));
                File toSave = this.downloadFile(url, fileName);
                if (toSave == null) continue;
                this.generateIndex(toSave, regionName, regionSpecificData, alreadyGeneratedFiles);
            }
        }
    }

    protected File downloadFile(String url, String regionName) {
        if (!url.startsWith("http")) {
            return new File(url);
        }
        String ext = ".osm";
        if (url.endsWith(".osm.bz2")) {
            ext = ".osm.bz2";
        } else if (url.endsWith(".pbf")) {
            ext = ".osm.pbf";
        }
        File toIndex = null;
        File saveTo = new File(this.osmDirFiles, regionName + ext);
        toIndex = this.wget == null || this.wget.trim().length() == 0 ? this.internalDownload(url, saveTo) : this.wgetDownload(url, saveTo);
        if (toIndex == null) {
            saveTo.delete();
        }
        return toIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File wgetDownload(String url, File toSave) {
        Process wgetProc;
        Closeable wgetInput;
        block10: {
            File file;
            BufferedReader wgetOutput = null;
            wgetInput = null;
            wgetProc = null;
            try {
                String line;
                log.info((Object)("Executing " + this.wget + " " + url + " -O " + toSave.getCanonicalPath()));
                ProcessBuilder exec = new ProcessBuilder(this.wget, "--read-timeout=5", "--progress=dot:binary", url, "-O", toSave.getCanonicalPath());
                exec.redirectErrorStream(true);
                wgetProc = exec.start();
                wgetOutput = new BufferedReader(new InputStreamReader(wgetProc.getInputStream()));
                while ((line = wgetOutput.readLine()) != null) {
                    log.info((Object)("wget output:" + line));
                }
                int exitValue = wgetProc.waitFor();
                wgetProc = null;
                if (exitValue != 0) {
                    log.error((Object)("Wget exited with error code: " + exitValue));
                    IndexBatchCreator.safeClose(wgetOutput, "");
                    break block10;
                }
                file = toSave;
                IndexBatchCreator.safeClose(wgetOutput, "");
            }
            catch (IOException e) {
                log.error((Object)("Input/output exception " + toSave.getName() + " downloading from " + url + "using wget: " + this.wget), (Throwable)e);
                return null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (InterruptedException e2) {
                    log.error((Object)("Interrupted exception " + toSave.getName() + " downloading from " + url + "using wget: " + this.wget), (Throwable)e2);
                    return null;
                }
            }
            finally {
                IndexBatchCreator.safeClose(wgetOutput, "");
                IndexBatchCreator.safeClose(wgetInput, "");
                if (wgetProc != null) {
                    wgetProc.destroy();
                }
            }
            IndexBatchCreator.safeClose(wgetInput, "");
            if (wgetProc == null) return file;
            wgetProc.destroy();
            return file;
        }
        IndexBatchCreator.safeClose(wgetInput, "");
        if (wgetProc == null) return null;
        wgetProc.destroy();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File internalDownload(String url, File toSave) {
        int count = 0;
        int downloaded = 0;
        int mbDownloaded = 0;
        byte[] buffer = new byte[32768];
        FileOutputStream ostream = null;
        InputStream stream = null;
        try {
            ostream = new FileOutputStream(toSave);
            stream = new URL(url).openStream();
            log.info((Object)("Downloading country " + toSave.getName() + " from " + url));
            while ((count = stream.read(buffer)) != -1) {
                ((OutputStream)ostream).write(buffer, 0, count);
                if ((downloaded += count) <= 0x100000) continue;
                downloaded -= 0x100000;
                log.info((Object)(++mbDownloaded + " megabytes downloaded of " + toSave.getName()));
            }
            File file = toSave;
            return file;
        }
        catch (IOException e) {
            log.error((Object)("Input/output exception " + toSave.getName() + " downloading from " + url), (Throwable)e);
        }
        finally {
            IndexBatchCreator.safeClose(ostream, "Input/output exception " + toSave.getName() + " to close stream ");
            IndexBatchCreator.safeClose(stream, "Input/output exception " + url + " to close stream ");
        }
        return null;
    }

    private static void safeClose(Closeable ostream, String message) {
        if (ostream != null) {
            try {
                ostream.close();
            }
            catch (Exception e) {
                log.error((Object)message, (Throwable)e);
            }
        }
    }

    protected void generateLocalFolderIndexes(Set<String> alreadyGeneratedFiles) {
        for (File f : this.getSortedFiles(this.osmDirFiles)) {
            if (alreadyGeneratedFiles.contains(f.getName()) || !f.getName().endsWith(".osm.bz2") && !f.getName().endsWith(".osm") && !f.getName().endsWith(".osm.pbf")) continue;
            if (this.skipExistingIndexes != null) {
                int i = f.getName().indexOf(".osm");
                String name = Algorithms.capitalizeFirstLetterAndLowercase((String)f.getName().substring(0, i));
                File bmif = new File(this.skipExistingIndexes, name + "_2.obf.zip");
                log.info((Object)("Check if " + bmif.getAbsolutePath() + " exists"));
                if (bmif.exists()) continue;
            }
            this.generateIndex(f, null, null, alreadyGeneratedFiles);
        }
    }

    protected boolean generateIndex(File file, String regionName, RegionSpecificData rdata, Set<String> alreadyGeneratedFiles) {
        String fileMapName = file.getName();
        int i = file.getName().indexOf(46);
        if (i > -1) {
            fileMapName = Algorithms.capitalizeFirstLetterAndLowercase((String)file.getName().substring(0, i));
        }
        regionName = Algorithms.isEmpty((CharSequence)regionName) ? fileMapName : Algorithms.capitalizeFirstLetterAndLowercase((String)regionName);
        String targetMapFileName = fileMapName + "_2.obf";
        for (ExternalJobDefinition jd : this.externalJobQueues) {
            boolean exclude = false;
            if (jd.sizeUpToMB > 0 && file.length() > (long)(jd.sizeUpToMB * 1024 * 1024)) {
                exclude = true;
            } else if (jd.excludedRegions.contains(fileMapName.toLowerCase())) {
                exclude = true;
            } else {
                for (String t : jd.excludePatterns) {
                    if (!fileMapName.contains(t)) continue;
                    exclude = true;
                    break;
                }
            }
            if (exclude) continue;
            if (jd.type.equals("aws")) {
                log.warn((Object)"-------------------------------------------");
                log.warn((Object)("----------- Generate on AWS " + file.getName() + "\n\n\n"));
                try {
                    this.generateAwsIndex(jd, file, targetMapFileName, rdata, alreadyGeneratedFiles);
                    return true;
                }
                catch (RuntimeException e) {
                    log.error((Object)("----------- FAILED Generation on AWS go to local " + file.getName() + " " + e.getMessage()), (Throwable)e);
                    continue;
                }
            }
            if (!jd.type.equals("docker")) continue;
            log.warn((Object)"-------------------------------------------");
            log.warn((Object)("----------- Generate on Docker " + file.getName() + "\n\n\n"));
            try {
                this.generateDockerIndex(jd, file, targetMapFileName, rdata, alreadyGeneratedFiles);
                return true;
            }
            catch (RuntimeException e) {
                log.error((Object)("----------- FAILED Generation on Docker " + file.getName() + " " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        log.warn((Object)"-------------------------------------------");
        log.warn((Object)("----------- Scheduled on local " + file.getName() + "\n\n\n"));
        LocalPendingGeneration lp = new LocalPendingGeneration();
        lp.file = file;
        lp.regionName = regionName;
        lp.mapFileName = targetMapFileName;
        lp.rdata = rdata;
        this.localPendingGenerations.add(lp);
        return false;
    }

    private void generateDockerIndex(ExternalJobDefinition jd, File file, String targetFileName, RegionSpecificData rdata, Set<String> alreadyGeneratedFiles) {
        String fileParam = file.getName().substring(0, file.getName().indexOf(46));
        String currentMonth = new SimpleDateFormat("yyyy-MM").format(new Date());
        String name = MessageFormat.format(jd.name, fileParam, currentMonth, targetFileName);
        alreadyGeneratedFiles.add(file.getName());
        Iterator<Map.Entry<String, String>> it = jd.params.entrySet().iterator();
        boolean srtmRun = !Algorithms.isEmpty((CharSequence)this.srtmDir) && (rdata == null || rdata.indexSRTM);
        DockerPendingGeneration p = new DockerPendingGeneration();
        p.jd = jd;
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String vl = MessageFormat.format(e.getValue(), fileParam, currentMonth, targetFileName);
            if (e.getKey().equals("image")) {
                p.image = vl;
                continue;
            }
            if (e.getKey().startsWith("cmd")) {
                p.cmd.add(vl);
                continue;
            }
            if (!e.getKey().startsWith("env")) continue;
            p.envs.add(vl);
        }
        log.info((Object)("Submit docker request : " + name));
        if (p.image == null || p.cmd.isEmpty()) {
            throw new IllegalArgumentException("Can't start docker container Image or cmd is empty ");
        }
        if (srtmRun) {
            p.cmd.add("--srtm=/home/srtm");
            p.binds.add(new Bind(this.srtmDir, new Volume("/home/srtm")));
        }
        p.cmd.add("--upload");
        p.cmd.add("/home/result/" + targetFileName);
        p.binds.add(new Bind(this.indexDirFiles.getAbsolutePath(), new Volume("/home/result")));
        p.name = name;
        ArrayList<DockerPendingGeneration> lst = new ArrayList<DockerPendingGeneration>();
        if (this.dockerPendingGenerations.containsKey(jd)) {
            lst.addAll((Collection)this.dockerPendingGenerations.get(jd));
        }
        lst.add(p);
        this.dockerPendingGenerations.put(jd, lst);
    }

    private void generateAwsIndex(ExternalJobDefinition jd, File file, String targetFileName, RegionSpecificData rdata, Set<String> alreadyGeneratedFiles) {
        String fileParam = file.getName().substring(0, file.getName().indexOf(46));
        String currentMonth = new SimpleDateFormat("yyyy-MM").format(new Date());
        String name = MessageFormat.format(jd.name, fileParam, currentMonth, targetFileName);
        String queue = MessageFormat.format(jd.queue, fileParam, currentMonth, targetFileName);
        String definition = MessageFormat.format(jd.definition, fileParam, currentMonth, targetFileName);
        alreadyGeneratedFiles.add(file.getName());
        BatchClient client = (BatchClient)BatchClient.builder().build();
        SubmitJobRequest.Builder pr = SubmitJobRequest.builder().jobName(name).jobQueue(queue).jobDefinition(definition);
        LinkedHashMap<String, String> pms = new LinkedHashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = jd.params.entrySet().iterator();
        String uploadedS3File = null;
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String vl = MessageFormat.format(e.getValue(), fileParam, currentMonth, targetFileName);
            pms.put(e.getKey(), vl);
            if (!e.getKey().equals("upload")) continue;
            uploadedS3File = vl;
        }
        pr.parameters(pms);
        SubmitJobRequest req = (SubmitJobRequest)pr.build();
        log.info((Object)("Submit aws request (sleep 1s): " + req));
        AwsPendingGeneration p = new AwsPendingGeneration();
        p.response = client.submitJob(req);
        p.s3Url = uploadedS3File;
        p.targetFileName = targetFileName;
        log.info((Object)("Got response: " + p.response));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (p.s3Url != null) {
            this.awsPendingGenerations.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateLocalIndex(File file, String regionName, String mapFileName, RegionSpecificData rdata, Set<String> alreadyGeneratedFiles) {
        try {
            boolean worldMaps;
            boolean indByProximity;
            RTree.clearCache();
            DBDialect osmDb = this.osmDbDialect;
            if (file.length() / 1024L / 1024L > 2000L && osmDb == DBDialect.SQLITE_IN_MEMORY) {
                log.warn((Object)"Switching SQLITE in memory dialect to SQLITE");
                osmDb = DBDialect.SQLITE;
            }
            boolean indAddr = this.indexAddress && (rdata == null || rdata.indexAddress);
            boolean indPoi = this.indexPOI && (rdata == null || rdata.indexPOI);
            boolean indTransport = this.indexTransport && (rdata == null || rdata.indexTransport);
            boolean indMap = this.indexMap && (rdata == null || rdata.indexMap);
            boolean indRouting = this.indexRouting && (rdata == null || rdata.indexRouting);
            boolean bl = indByProximity = this.indexByProximity && (rdata == null || rdata.indexByProximity);
            if (!(indAddr || indPoi || indTransport || indMap || indRouting)) {
                log.warn((Object)("! Skip country " + file.getName() + " because nothing to index !"));
                return;
            }
            IndexCreatorSettings settings = new IndexCreatorSettings();
            settings.indexMap = indMap;
            settings.indexAddress = indAddr;
            settings.indexPOI = indPoi;
            settings.indexTransport = indTransport;
            settings.indexRouting = indRouting;
            settings.indexByProximity = indByProximity;
            if (this.zoomWaySmoothness != null) {
                settings.zoomWaySmoothness = this.zoomWaySmoothness;
            }
            if (worldMaps = regionName.toLowerCase().contains("world")) {
                if (regionName.toLowerCase().contains("basemap")) {
                    return;
                }
                if (regionName.toLowerCase().contains("seamarks")) {
                    settings.keepOnlySeaObjects = true;
                    settings.indexTransport = false;
                    settings.indexAddress = false;
                }
            } else if (!Algorithms.isEmpty((CharSequence)this.srtmDir) && (rdata == null || rdata.indexSRTM)) {
                settings.srtmDataFolderUrl = this.srtmDir;
            }
            IndexCreator indexCreator = new IndexCreator(this.workDir, settings);
            indexCreator.setDialects(osmDb, osmDb);
            indexCreator.setLastModifiedDate(file.lastModified());
            indexCreator.setRegionName(regionName);
            indexCreator.setMapFileName(mapFileName);
            try {
                alreadyGeneratedFiles.add(file.getName());
                Jdk14Logger warningsAboutMapData = null;
                File logFileName = new File(this.workDir, mapFileName + GEN_LOG_EXT);
                FileHandler fh = null;
                try {
                    FileOutputStream fout = new FileOutputStream(logFileName);
                    fout.write((new Date() + "\n").getBytes());
                    fout.write((MapCreatorVersion.APP_MAP_CREATOR_FULL_NAME + "\n").getBytes());
                    fout.close();
                    fh = new FileHandler(logFileName.getAbsolutePath(), 10000000, 1, true);
                    fh.setFormatter(new SimpleFormatter());
                    fh.setLevel(Level.ALL);
                    Jdk14Logger jdk14Logger = new Jdk14Logger("tempLogger");
                    jdk14Logger.getLogger().setLevel(Level.ALL);
                    jdk14Logger.getLogger().setUseParentHandlers(false);
                    jdk14Logger.getLogger().addHandler(fh);
                    warningsAboutMapData = jdk14Logger;
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (fh != null) {
                    LogManager.getLogManager().getLogger("").addHandler(fh);
                }
                try {
                    indexCreator.generateIndexes(file, new ConsoleProgressImplementation(1.0), null, this.mapZooms, new MapRenderingTypesEncoder(this.renderingTypesFile, file.getName()), (Log)warningsAboutMapData);
                }
                finally {
                    if (fh != null) {
                        fh.close();
                        LogManager.getLogManager().getLogger("").removeHandler(fh);
                    }
                }
                File generated = new File(this.workDir, mapFileName);
                File dest = new File(this.indexDirFiles, generated.getName());
                if (!generated.renameTo(dest)) {
                    FileOutputStream fout = new FileOutputStream(dest);
                    FileInputStream fin = new FileInputStream(generated);
                    Algorithms.streamCopy((InputStream)fin, (OutputStream)fout);
                    fin.close();
                    fout.close();
                }
                File copyLog = new File(this.indexDirFiles, logFileName.getName());
                FileOutputStream fout = new FileOutputStream(copyLog);
                FileInputStream fin = new FileInputStream(logFileName);
                Algorithms.streamCopy((InputStream)fin, (OutputStream)fout);
                fin.close();
                fout.close();
            }
            catch (Exception e) {
                log.error((Object)("Exception generating indexes for " + file.getName()), (Throwable)e);
            }
        }
        catch (OutOfMemoryError e) {
            System.gc();
            log.error((Object)"OutOfMemory", (Throwable)e);
        }
        System.gc();
    }

    protected File[] getSortedFiles(File dir) {
        File[] listFiles = dir.listFiles();
        Arrays.sort(listFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return listFiles;
    }

    private static class ExternalJobDefinition {
        Map<String, String> params = new LinkedHashMap<String, String>();
        String name;
        String type;
        String queue;
        int slotsPerJob = 1;
        String definition;
        int sizeUpToMB = -1;
        Set<String> excludedRegions = new TreeSet<String>();
        List<String> excludePatterns = new ArrayList<String>();

        private ExternalJobDefinition() {
        }
    }

    public static class RegionCountries {
        String namePrefix = "";
        String nameSuffix = "";
        Map<String, RegionSpecificData> regionNames = new LinkedHashMap<String, RegionSpecificData>();
        String siteToDownload = "";
    }

    private static class RegionSpecificData {
        public String downloadName;
        public boolean indexSRTM = true;
        public boolean indexPOI = true;
        public boolean indexTransport = true;
        public boolean indexAddress = true;
        public boolean indexMap = true;
        public boolean indexRouting = true;
        public boolean indexByProximity = true;

        private RegionSpecificData() {
        }
    }

    private static class LocalPendingGeneration {
        public String mapFileName;
        public File file;
        public String regionName;
        public RegionSpecificData rdata;

        private LocalPendingGeneration() {
        }
    }

    private static class DockerPendingGeneration {
        public ExternalJobDefinition jd;
        public List<String> cmd = new ArrayList<String>();
        public String image;
        public String name;
        public List<Bind> binds = new ArrayList<Bind>();
        public List<String> envs = new ArrayList<String>();
        public CreateContainerResponse container;

        private DockerPendingGeneration() {
        }
    }

    private static class AwsPendingGeneration {
        SubmitJobResponse response;
        String s3Url;
        String targetFileName;

        private AwsPendingGeneration() {
        }
    }
}

