/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.travel;

import gnu.trove.list.array.TIntArrayList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.gpx.GPXFile;
import net.osmand.gpx.GPXUtilities;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.osmand.wiki.WikivoyageOSMTags;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlSerializer;

public class WikivoyageGenOSM {
    public static final String CAT_SEE = "see";
    public static final String CAT_NATURAL = "natural";
    public static final String CAT_MARKER = "marker";
    public static final String CAT_SLEEP = "sleep";
    public static final String CAT_EAT = "eat";
    public static final String CAT_DO = "do";
    public static final String CAT_GO = "go";
    public static final String CAT_DRINK = "drink";
    public static final String CAT_BUY = "buy";
    public static final String CAT_OTHER = "other";
    private static final double ARTICLE_NO_COORDS_LAT = 0.0;
    private static final double ARTICLE_NO_COORDS_LON = 0.0;
    private static final double ARTICLE_NO_COORDS_DELTA = 1.0;
    private static final Log log = PlatformUtil.getLog(WikivoyageGenOSM.class);
    private static final NumberFormat latLonFormat = new DecimalFormat("0.00#####", new DecimalFormatSymbols());
    private static final String LANG = "LANG";
    private static final String TITLE = "TITLE";
    private static final boolean WRITE_POINTS_COLLECTION = false;
    static long NODE_ID = -1000L;
    static Map<String, Integer> categories = new HashMap<String, Integer>();
    static Map<String, String> categoriesExample = new HashMap<String, String>();
    private static Map<String, String> wptCategories;

    public static void main(String[] args) throws SQLException, IOException {
        File f = new File("/Users/victorshcherb/osmand/maps/wikivoyage/wikivoyage.sqlite");
        WikivoyageGenOSM.genWikivoyageOsm(f, new File(f.getParentFile(), "wikivoyage.osm.gz"), 10000);
    }

    public static void genWikivoyageOsm(File wikivoyageFile, List<String> genOsm) throws SQLException, IOException {
        ArrayList<WikivoyageOutputFile> outs = new ArrayList<WikivoyageOutputFile>();
        for (String s : genOsm) {
            int t = s.indexOf(58);
            WikivoyageOutputFile out = new WikivoyageOutputFile(new File(s.substring(t + 1)));
            if (t > 0) {
                String[] keys = s.substring(0, t).split(",");
                out.filter = true;
                for (String k : keys) {
                    if (!k.startsWith("Q")) continue;
                    int type = 0;
                    String id = k.substring(1);
                    if (id.endsWith("%")) {
                        id = id.substring(0, id.length() - 1);
                        type = -1;
                    } else if (id.endsWith(".")) {
                        id = id.substring(0, id.length() - 1);
                        type = 1;
                    }
                    out.qids.add(id);
                    out.qidsType.add(type);
                }
                System.out.printf("Write to %s : %s - %s\n", out.outputFile.getName(), out.qids, out.qidsType);
            }
            outs.add(out);
        }
        WikivoyageGenOSM.genWikivoyageOsm(wikivoyageFile, outs, -1);
    }

    public static void genWikivoyageOsm(File wikivoyageFile, File outFile, int LIMIT) throws SQLException, IOException {
        ArrayList<WikivoyageOutputFile> outs = new ArrayList<WikivoyageOutputFile>();
        if (outFile != null) {
            outs.add(new WikivoyageOutputFile(outFile));
        }
        WikivoyageGenOSM.genWikivoyageOsm(wikivoyageFile, outs, LIMIT);
    }

    public static void genWikivoyageOsm(File wikivoyageFile, List<WikivoyageOutputFile> outs, int LIMIT) throws SQLException, IOException {
        DBDialect dialect = DBDialect.SQLITE;
        Connection connection = dialect.getDatabaseConnection(wikivoyageFile.getCanonicalPath(), log);
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery("select trip_id, title, lang, lat, lon, content_gz, gpx_gz, image_title, banner_title, src_banner_title, is_part_of, is_parent_of, aggregated_part_of, agg_part_of_wid, contents_json from travel_articles order by trip_id asc");
        int count = 0;
        int totalArticles = 0;
        int emptyLocation = 0;
        int emptyContent = 0;
        CombinedWikivoyageArticle combinedArticle = new CombinedWikivoyageArticle();
        while (rs.next()) {
            long tripId;
            int rind = 1;
            if (((tripId = rs.getLong(rind++)) != combinedArticle.tripId || combinedArticle.tripId == 0L) && combinedArticle.tripId != -1L) {
                boolean res = false;
                for (WikivoyageOutputFile out : outs) {
                    if (!out.accept(combinedArticle)) continue;
                    res |= WikivoyageGenOSM.combineAndSave(combinedArticle, out.serializer);
                }
                if (res) {
                    ++totalArticles;
                }
                combinedArticle.clear();
            }
            combinedArticle.tripId = tripId;
            String title = rs.getString(rind++);
            String lang = rs.getString(rind++);
            double lat = rs.getDouble(rind++);
            double lon = rs.getDouble(rind++);
            String content = Algorithms.gzipToString((byte[])rs.getBytes(rind++));
            GZIPInputStream bytesStream = new GZIPInputStream(new ByteArrayInputStream(rs.getBytes(rind++)));
            GPXFile gpxFile = GPXUtilities.loadGPXFile((InputStream)bytesStream);
            String imageTitle = rs.getString(rind++);
            String bannerTitle = rs.getString(rind++);
            String srcBannerTitle = rs.getString(rind++);
            String isPartOf = rs.getString(rind++);
            String isParentOf = rs.getString(rind++);
            String isAggrPartOf = rs.getString(rind++);
            String isAggrPartOfWid = rs.getString(rind++);
            String contentJson = rs.getString(rind);
            combinedArticle.addArticle(lang, title, gpxFile, lat, lon, content, imageTitle, Algorithms.isEmpty((CharSequence)srcBannerTitle) ? bannerTitle : srcBannerTitle, isPartOf, isParentOf, isAggrPartOf, isAggrPartOfWid, contentJson);
            if (gpxFile == null || gpxFile.isPointsEmpty()) {
                if (lat == 0.0 && lon == 0.0) {
                    ++emptyLocation;
                } else {
                    ++emptyContent;
                }
            }
            if (count >= LIMIT && LIMIT != -1) break;
            ++count;
        }
        for (WikivoyageOutputFile out : outs) {
            if (out.accept(combinedArticle)) {
                WikivoyageGenOSM.combineAndSave(combinedArticle, out.serializer);
            }
            out.close();
        }
        ArrayList<String> l = new ArrayList<String>(categories.keySet());
        Collections.sort(l, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return Integer.compare(categories.get(s1), categories.get(s2));
            }
        });
        int total = 0;
        for (String s : l) {
            total += categories.get(s).intValue();
        }
        for (String s : l) {
            int cnt = categories.get(s);
            System.out.println(String.format("%#.2f%% %s  %d %s", (double)cnt * 100.0 / (double)total, s, cnt, categoriesExample.get(s)));
        }
        System.out.println(String.format("Total saved articles: %d", totalArticles));
        System.out.println(String.format("Empty article (no gpx): %d no points in article + %d no location page articles (total points %d) ", emptyContent, emptyLocation, total));
    }

    private static void tagValue(XmlSerializer serializer, String tag, String value) throws IOException {
        if (Algorithms.isEmpty((CharSequence)value)) {
            return;
        }
        serializer.startTag(null, "tag");
        serializer.attribute(null, "k", tag);
        serializer.attribute(null, "v", value);
        serializer.endTag(null, "tag");
    }

    private static boolean combineAndSave(CombinedWikivoyageArticle article, XmlSerializer serializer) throws IOException {
        article.updateCategoryCounts();
        long idStart = NODE_ID;
        LatLon mainArticlePoint = article.latlons.get(0);
        List<GPXUtilities.WptPt> points = new ArrayList<GPXUtilities.WptPt>();
        for (int i = 0; i < article.size(); ++i) {
            String lng = article.langs.get(i);
            GPXFile file = article.points.get(i);
            String titleId = article.titles.get(i);
            if (mainArticlePoint == null) {
                mainArticlePoint = article.latlons.get(i);
            }
            for (GPXUtilities.WptPt p : file.getPoints()) {
                if (p.lat >= 90.0 || p.lat <= -90.0 || p.lon >= 180.0 || p.lon <= -180.0) continue;
                p.getExtensionsToWrite().put(LANG, lng);
                p.getExtensionsToWrite().put(TITLE, titleId);
                points.add(p);
                if (mainArticlePoint != null) continue;
                mainArticlePoint = new LatLon(p.getLatitude(), p.getLongitude());
            }
        }
        if (mainArticlePoint == null) {
            Random rnd = new Random();
            double lat = 0.0 + (rnd.nextDouble() - 0.5) * 1.0;
            double lon = 0.0 + (rnd.nextDouble() - 0.5) * 1.0;
            mainArticlePoint = new LatLon(lat, lon);
        }
        points = WikivoyageGenOSM.sortPoints(mainArticlePoint, points);
        serializer.startTag(null, "node");
        long mainArticleid = NODE_ID--;
        serializer.attribute(null, "id", "" + mainArticleid);
        serializer.attribute(null, "action", "modify");
        serializer.attribute(null, "version", "1");
        serializer.attribute(null, "lat", WikivoyageGenOSM.formatLat(mainArticlePoint.getLatitude()));
        serializer.attribute(null, "lon", WikivoyageGenOSM.formatLon(mainArticlePoint.getLongitude()));
        WikivoyageGenOSM.tagValue(serializer, "route", "point");
        WikivoyageGenOSM.tagValue(serializer, "route_type", "article");
        WikivoyageGenOSM.addArticleTags(article, serializer, true);
        serializer.endTag(null, "node");
        for (GPXUtilities.WptPt p : points) {
            long id;
            String category = WikivoyageGenOSM.simplifyWptCategory(p.category, CAT_OTHER);
            serializer.startTag(null, "node");
            --NODE_ID;
            serializer.attribute(null, "id", "" + id);
            serializer.attribute(null, "action", "modify");
            serializer.attribute(null, "version", "1");
            serializer.attribute(null, "lat", WikivoyageGenOSM.formatLat(p.lat));
            serializer.attribute(null, "lon", WikivoyageGenOSM.formatLat(p.lon));
            WikivoyageGenOSM.tagValue(serializer, "route", "point");
            WikivoyageGenOSM.tagValue(serializer, "route_type", "article_point");
            WikivoyageGenOSM.tagValue(serializer, "category", category);
            String lng = (String)p.getExtensionsToRead().get(LANG);
            WikivoyageGenOSM.tagValue(serializer, "lang:" + lng, "yes");
            WikivoyageGenOSM.addPointTags(article, serializer, p, "");
            WikivoyageGenOSM.tagValue(serializer, "route_source", "wikivoyage");
            WikivoyageGenOSM.tagValue(serializer, "route_id", "Q" + article.tripId);
            serializer.endTag(null, "node");
        }
        return true;
    }

    private static String formatLon(double lon) {
        return latLonFormat.format(lon);
    }

    private static String formatLat(double lat) {
        if (lat < -85.0511) {
            lat = -84.5511;
        }
        if (lat > 85.0511) {
            lat = 84.5511;
        }
        return latLonFormat.format(lat);
    }

    private static void addArticleTags(CombinedWikivoyageArticle article, XmlSerializer serializer, boolean addDescription) throws IOException {
        WikivoyageGenOSM.tagValue(serializer, "route_id", "Q" + article.tripId);
        WikivoyageGenOSM.tagValue(serializer, "route_source", "wikivoyage");
        for (int it = 0; it < article.langs.size(); ++it) {
            String lng = article.langs.get(it);
            String title = article.titles.get(it);
            WikivoyageGenOSM.tagValue(serializer, "route_name:" + lng, title);
            WikivoyageGenOSM.tagValue(serializer, "name:" + lng, title);
            WikivoyageGenOSM.tagValue(serializer, "image_title:" + lng, article.imageTitles.get(it));
            WikivoyageGenOSM.tagValue(serializer, "is_part:" + lng, article.partsOf.get(it));
            WikivoyageGenOSM.tagValue(serializer, "is_aggr_part:" + lng, article.aggrPartsOf.get(it));
            WikivoyageGenOSM.tagValue(serializer, "is_parent_of:" + lng, article.parentOf.get(it));
            WikivoyageGenOSM.tagValue(serializer, "content_json:" + lng, article.jsonContents.get(it));
            if (!addDescription) continue;
            WikivoyageGenOSM.tagValue(serializer, "description:" + lng, article.contents.get(it));
        }
    }

    private static void addPointTags(CombinedWikivoyageArticle article, XmlSerializer serializer, GPXUtilities.WptPt p, String lngSuffix) throws IOException {
        String title = (String)p.getExtensionsToRead().get(TITLE);
        WikivoyageGenOSM.tagValue(serializer, "description" + lngSuffix, p.desc);
        WikivoyageGenOSM.tagValue(serializer, "name" + lngSuffix, p.name);
        WikivoyageGenOSM.tagValue(serializer, "route_name" + lngSuffix, title);
        for (WikivoyageOSMTags tg : WikivoyageOSMTags.values()) {
            String v = (String)p.getExtensionsToRead().get(tg.tag());
            if (Algorithms.isEmpty((CharSequence)v)) continue;
            WikivoyageGenOSM.tagValue(serializer, tg.tag() + lngSuffix, v);
        }
        if (!Algorithms.isEmpty((CharSequence)p.link)) {
            WikivoyageGenOSM.tagValue(serializer, "url" + lngSuffix, p.link);
        }
        if (!Algorithms.isEmpty((CharSequence)p.comment)) {
            WikivoyageGenOSM.tagValue(serializer, "note" + lngSuffix, p.comment);
        }
        if (lngSuffix.isEmpty()) {
            int color;
            if (!Algorithms.isEmpty((CharSequence)p.getIconName())) {
                WikivoyageGenOSM.tagValue(serializer, "gpx_icon", p.getIconName());
            }
            if (!Algorithms.isEmpty((CharSequence)p.getBackgroundType())) {
                WikivoyageGenOSM.tagValue(serializer, "gpx_bg", p.getBackgroundType());
            }
            if ((color = p.getColor(Integer.valueOf(0)).intValue()) != 0) {
                WikivoyageGenOSM.tagValue(serializer, "colour", MapRenderingTypesEncoder.formatColorToPalette(Algorithms.colorToString((int)color), false));
                WikivoyageGenOSM.tagValue(serializer, "colour_int", Algorithms.colorToString((int)color));
            }
        }
    }

    private static List<GPXUtilities.WptPt> sortPoints(LatLon pnt, List<GPXUtilities.WptPt> points) {
        ArrayList<GPXUtilities.WptPt> res = new ArrayList<GPXUtilities.WptPt>();
        GPXUtilities.WptPt p = null;
        while ((p = WikivoyageGenOSM.peakClosest(pnt, points)) != null) {
            res.add(p);
            pnt = new LatLon(p.getLatitude(), p.getLongitude());
        }
        return res;
    }

    private static GPXUtilities.WptPt peakClosest(LatLon pnt, List<GPXUtilities.WptPt> points) {
        GPXUtilities.WptPt r = null;
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < points.size(); ++i) {
            double ds = MapUtils.getDistance((LatLon)pnt, (double)points.get(i).getLatitude(), (double)points.get(i).getLongitude());
            if (!(ds < d)) continue;
            d = ds;
            r = points.get(i);
        }
        points.remove(r);
        return r;
    }

    public static String simplifyWptCategory(String category, String defaultCat) {
        String cat;
        if (category == null) {
            category = "";
        }
        category = category.toLowerCase();
        if (wptCategories == null) {
            wptCategories = WikivoyageGenOSM.buildCategories();
        }
        if ((cat = wptCategories.get(category)) != null) {
            return cat;
        }
        for (String key : wptCategories.keySet()) {
            if (!category.endsWith(" " + key) && !category.startsWith(key + ",") && !category.contains(" " + key + ",")) continue;
            return wptCategories.get(key);
        }
        if (category.isEmpty()) {
            return CAT_OTHER;
        }
        if (defaultCat != null) {
            return defaultCat;
        }
        return category;
    }

    private static Map<String, String> buildCategories() {
        LinkedHashMap<String, String> categories = new LinkedHashMap<String, String>();
        categories.put("\u05de\u05d5\u05e7\u05d3\u05d9", CAT_OTHER);
        categories.put("tourist information", CAT_OTHER);
        categories.put(CAT_OTHER, CAT_OTHER);
        categories.put(CAT_GO, CAT_GO);
        categories.put("aller", CAT_DO);
        categories.put("around", CAT_DO);
        categories.put(CAT_DO, CAT_DO);
        categories.put("university", CAT_OTHER);
        categories.put("port", CAT_OTHER);
        categories.put("post", CAT_OTHER);
        categories.put("pharmacy", CAT_OTHER);
        categories.put("hospital", CAT_OTHER);
        categories.put("train", CAT_OTHER);
        categories.put("bus", CAT_OTHER);
        categories.put("police", CAT_OTHER);
        categories.put("embassy", CAT_OTHER);
        categories.put("bank", CAT_OTHER);
        categories.put("library", CAT_OTHER);
        categories.put("office", CAT_OTHER);
        categories.put("school", CAT_OTHER);
        categories.put("town hall", CAT_OTHER);
        categories.put("airport", CAT_OTHER);
        categories.put("surgery", CAT_OTHER);
        categories.put("clinic", CAT_OTHER);
        categories.put("municipality", CAT_OTHER);
        categories.put("cinema", CAT_DO);
        categories.put("aquarium", CAT_DO);
        categories.put("theater", CAT_DO);
        categories.put("swimming pool", CAT_DO);
        categories.put("swimming", CAT_DO);
        categories.put("beach", CAT_DO);
        categories.put("amusement park", CAT_DO);
        categories.put("golf", CAT_DO);
        categories.put("club", CAT_DO);
        categories.put("sports", CAT_DO);
        categories.put("music", CAT_DO);
        categories.put("spa", CAT_DO);
        categories.put("\u0627\u0646\u062c\u0627\u0645\u200c\u062f\u0627\u062f\u0646", CAT_DO);
        categories.put("mall", CAT_BUY);
        categories.put("market", CAT_BUY);
        categories.put("shop", CAT_BUY);
        categories.put("supermarket", CAT_BUY);
        categories.put(CAT_BUY, CAT_BUY);
        categories.put(CAT_NATURAL, CAT_NATURAL);
        categories.put("veja", CAT_SEE);
        categories.put("voir", CAT_SEE);
        categories.put("zoo", CAT_SEE);
        categories.put("temple", CAT_SEE);
        categories.put("mosque", CAT_SEE);
        categories.put("synagogue", CAT_SEE);
        categories.put("monastery", CAT_SEE);
        categories.put("church", CAT_SEE);
        categories.put("palace", CAT_SEE);
        categories.put("building", CAT_SEE);
        categories.put("ch\u00e2teau", CAT_SEE);
        categories.put("museum", CAT_SEE);
        categories.put("attraction", CAT_SEE);
        categories.put("gallery", CAT_SEE);
        categories.put("memorial", CAT_SEE);
        categories.put("archaeological site", CAT_SEE);
        categories.put("fort", CAT_SEE);
        categories.put("monument", CAT_SEE);
        categories.put("castle", CAT_SEE);
        categories.put("park", CAT_SEE);
        categories.put("\u062f\u06cc\u062f\u0646", CAT_SEE);
        categories.put("tower", CAT_SEE);
        categories.put("cave", CAT_SEE);
        categories.put("botanical garden", CAT_SEE);
        categories.put("square", CAT_SEE);
        categories.put("cathedral", CAT_SEE);
        categories.put("lake", CAT_SEE);
        categories.put("landmark", CAT_SEE);
        categories.put("cemetery", CAT_SEE);
        categories.put("garden", CAT_SEE);
        categories.put("arts centre", CAT_SEE);
        categories.put("national park", CAT_SEE);
        categories.put("waterfall", CAT_SEE);
        categories.put("viewpoint", CAT_SEE);
        categories.put("mountain", CAT_SEE);
        categories.put("mill", CAT_SEE);
        categories.put("house", CAT_SEE);
        categories.put("ruins", CAT_SEE);
        categories.put(CAT_SEE, CAT_SEE);
        categories.put("restaurant", CAT_EAT);
        categories.put("cafe", CAT_EAT);
        categories.put("bakery", CAT_EAT);
        categories.put("manger", CAT_EAT);
        categories.put("coma", CAT_EAT);
        categories.put("\u05d0\u05d5\u05db\u05dc", CAT_EAT);
        categories.put("bistro", CAT_EAT);
        categories.put("snack bar", CAT_EAT);
        categories.put(CAT_EAT, CAT_EAT);
        categories.put("beer garden", CAT_DRINK);
        categories.put("bar", CAT_DRINK);
        categories.put("brewery", CAT_DRINK);
        categories.put("\u05e9\u05ea\u05d9\u05d9\u05d4", CAT_DRINK);
        categories.put("discotheque", CAT_DRINK);
        categories.put("\u0646\u0648\u0634\u06cc\u062f\u0646", CAT_DRINK);
        categories.put("pub", CAT_DRINK);
        categories.put(CAT_DRINK, CAT_DRINK);
        categories.put("destination", CAT_MARKER);
        categories.put("listing", CAT_MARKER);
        categories.put("destinationlist", CAT_MARKER);
        categories.put("\u05e8\u05e9\u05d9\u05de\u05d4", CAT_MARKER);
        categories.put(CAT_MARKER, CAT_MARKER);
        categories.put("hotel", CAT_SLEEP);
        categories.put("motel", CAT_SLEEP);
        categories.put("\u05dc\u05d9\u05e0\u05d4", CAT_SLEEP);
        categories.put("hostel", CAT_SLEEP);
        categories.put("se loger", CAT_SLEEP);
        categories.put("guest house", CAT_SLEEP);
        categories.put("campsite", CAT_SLEEP);
        categories.put("holiday flat", CAT_SLEEP);
        categories.put("alpine hut", CAT_SLEEP);
        categories.put("youth hostel", CAT_SLEEP);
        categories.put("caravan site", CAT_SLEEP);
        categories.put("appartment", CAT_SLEEP);
        categories.put("\u062e\u0648\u0627\u0628\u06cc\u062f\u0646", CAT_SLEEP);
        categories.put("boarding house", CAT_SLEEP);
        categories.put("hotel garni", CAT_SLEEP);
        categories.put("durma", CAT_SLEEP);
        categories.put(CAT_SLEEP, CAT_SLEEP);
        categories.put("city", CAT_MARKER);
        categories.put("vicinity", CAT_MARKER);
        categories.put("village", CAT_MARKER);
        categories.put("town", CAT_MARKER);
        return categories;
    }

    private static class WikivoyageOutputFile {
        File outputFile;
        boolean filter = false;
        List<String> qids = new ArrayList<String>();
        TIntArrayList qidsType = new TIntArrayList();
        XmlSerializer serializer;
        OutputStream outputStream = null;

        public WikivoyageOutputFile(File outFile) throws IllegalArgumentException, IllegalStateException, IOException {
            this.outputFile = outFile;
            this.outputStream = new FileOutputStream(this.outputFile);
            if (this.outputFile.getName().endsWith(".gz")) {
                this.outputStream = new GZIPOutputStream(this.outputStream);
            }
            this.serializer = PlatformUtil.newSerializer();
            this.serializer.setOutput((Writer)new OutputStreamWriter(this.outputStream));
            this.serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            this.serializer.startDocument("UTF-8", Boolean.valueOf(true));
            this.serializer.startTag(null, "osm");
            this.serializer.attribute(null, "version", "0.6");
        }

        public boolean accept(CombinedWikivoyageArticle combinedArticle) {
            if (!this.filter) {
                return true;
            }
            if (combinedArticle.tripId > 0L) {
                if ("1200957".equals("" + combinedArticle.tripId)) {
                    return true;
                }
                for (int tp = 0; tp < this.qids.size(); ++tp) {
                    if (!this.qids.get(tp).equals("" + combinedArticle.tripId)) continue;
                    return true;
                }
            }
            for (String aggWid : combinedArticle.aggrPartsOfWid) {
                String[] wids = aggWid.split(",");
                boolean match = false;
                block2: for (int tp = 0; tp < this.qids.size() && !match; ++tp) {
                    for (int i = 0; i < wids.length && !match; ++i) {
                        if (!this.qids.get(tp).equals(wids[i])) continue;
                        int tpMatch = this.qidsType.get(tp);
                        if (tpMatch < 0) {
                            match = true;
                            break block2;
                        }
                        if (tpMatch <= 0 || i != 0) break block2;
                        match = true;
                        break block2;
                    }
                }
                if (!match) continue;
                return true;
            }
            return false;
        }

        public void close() throws IOException {
            this.serializer.endTag(null, "osm");
            this.serializer.flush();
            this.outputStream.close();
        }
    }

    private static class CombinedWikivoyageArticle {
        long tripId = -1L;
        List<String> titles = new ArrayList<String>();
        List<LatLon> latlons = new ArrayList<LatLon>();
        List<String> langs = new ArrayList<String>();
        List<String> contents = new ArrayList<String>();
        List<GPXFile> points = new ArrayList<GPXFile>();
        List<String> imageTitles = new ArrayList<String>();
        List<String> partsOf = new ArrayList<String>();
        List<String> parentOf = new ArrayList<String>();
        List<String> aggrPartsOf = new ArrayList<String>();
        List<String> aggrPartsOfWid = new ArrayList<String>();
        List<String> jsonContents = new ArrayList<String>();

        private CombinedWikivoyageArticle() {
        }

        public void addArticle(String lang, String title, GPXFile gpxFile, double lat, double lon, String content, String imageTitle, String bannerTitle, String partOf, String isParentOf, String aggrPartOf, String aggrPartOfWid, String contentJson) {
            int ind = this.size();
            if (lang.equals("en")) {
                ind = 0;
            }
            this.points.add(ind, gpxFile);
            this.titles.add(ind, title);
            this.langs.add(ind, lang);
            LatLon ll = null;
            if (lat != 0.0 && lon != 0.0) {
                ll = new LatLon(lat, lon);
            }
            this.latlons.add(ind, ll);
            this.contents.add(ind, content);
            this.imageTitles.add(ind, bannerTitle);
            this.partsOf.add(ind, partOf);
            this.parentOf.add(ind, isParentOf);
            this.aggrPartsOf.add(ind, aggrPartOf);
            this.aggrPartsOfWid.add(ind, aggrPartOfWid);
            this.jsonContents.add(ind, contentJson);
        }

        public void clear() {
            this.titles.clear();
            this.langs.clear();
            this.points.clear();
            this.contents.clear();
            this.latlons.clear();
            this.imageTitles.clear();
            this.partsOf.clear();
            this.aggrPartsOf.clear();
            this.aggrPartsOfWid.clear();
            this.parentOf.clear();
            this.jsonContents.clear();
        }

        public int size() {
            return this.langs.size();
        }

        public void updateCategoryCounts() {
            ArrayList<String> cats = new ArrayList<String>();
            ArrayList<CallSite> names = new ArrayList<CallSite>();
            int i = 0;
            for (GPXFile f : this.points) {
                for (GPXUtilities.WptPt p : f.getPoints()) {
                    String cat = WikivoyageGenOSM.simplifyWptCategory(p.category, null);
                    cats.add(cat);
                    names.add((CallSite)((Object)(this.langs.get(i) + " " + this.titles.get(i) + " " + p.name)));
                }
                ++i;
            }
            for (i = 0; i < cats.size(); ++i) {
                String cat = (String)cats.get(i);
                Integer nt = categories.get(cat);
                if (nt == null) {
                    categoriesExample.put(cat, (String)names.get(i));
                }
                categories.put(cat, nt == null ? 1 : nt + 1);
            }
        }
    }
}

