/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.tester;

import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.osmand.router.tester.RandomRouteEntry;
import net.osmand.router.tester.RandomRouteResult;

class RandomRouteReport {
    private String text;
    private String html;
    private String htmlDomain;
    private boolean car2phase;
    private double deviationRed;
    private double deviationYellow;

    RandomRouteReport(long runTime, int nObf, int nRoutes, double red, double yellow, String htmlDomain, boolean car2phase) {
        this.deviationRed = red;
        this.deviationYellow = yellow;
        this.htmlDomain = htmlDomain;
        this.car2phase = car2phase;
        String dt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(Calendar.getInstance().getTime());
        this.text = String.format("%s Random Route Tester (%d obf files, %d routes, %d seconds) %s\n\n", dt, nObf, nRoutes, runTime / 1000L, car2phase ? "[car_2phase_mode]" : "");
        this.html = "<html><head><style>table, th, td { border: 1px solid silver; border-collapse: collapse; }</style></head><body>\n" + this.text + "<br><table border=1>\n";
    }

    static String getMapCreatorProfileParams(RandomRouteEntry entry) {
        return (entry.profile + "," + entry.params.toString()).replaceAll("[\\[ \\]]", "").replaceAll(":", "=").replaceAll(",$", "");
    }

    static String resultPrimaryText(int n, RandomRouteResult primary) {
        String mapCreatorProfileParams = RandomRouteReport.getMapCreatorProfileParams(primary.entry);
        return String.format("%d:%s cost=%.2f dist=%.2f segments=%d seconds=%.1f via=%d profile=%s", n, primary.type, primary.cost, Float.valueOf(primary.distance), primary.visitedSegments, Float.valueOf((float)primary.runTime / 1000.0f), primary.entry.via.size(), mapCreatorProfileParams);
    }

    String resultPrimaryHtml(int n, RandomRouteResult primary) {
        String mapCreatorProfileParams = RandomRouteReport.getMapCreatorProfileParams(primary.entry);
        String start = String.format("%f,%f", primary.entry.start.getLatitude(), primary.entry.start.getLongitude());
        String finish = String.format("%f,%f", primary.entry.finish.getLatitude(), primary.entry.finish.getLongitude());
        String url = primary.toURL(this.htmlDomain, this.car2phase);
        String sCost = primary.cost > 0.0 ? String.format("%.2f", primary.cost) : "zero";
        String colorCost = this.costDistHtmlColor(primary.cost);
        String sDistance = primary.distance > 0.0f ? String.format("%.2f", Float.valueOf(primary.distance)) : "zero";
        String colorDistance = this.costDistHtmlColor(primary.distance);
        return "<tr align=center>" + String.format("<td><a href=\"%s\" target=_blank>%s</a></td>", url, primary.type) + String.format("<td><font color=%s>%s</font></td>", colorCost, sCost) + String.format("<td><font color=%s>%s</font></td>", colorDistance, sDistance) + String.format("<td>%d</td>", primary.visitedSegments) + String.format("<td>%.1f</td>", Float.valueOf((float)primary.runTime / 1000.0f)) + String.format("<td>%s</td>", start) + String.format("<td>%s</td>", finish) + String.format("<td>%d</td>", primary.entry.via.size()) + String.format("<td>%s</td>", mapCreatorProfileParams) + "</tr>\n";
    }

    void resultPrimary(int n, RandomRouteResult primary) {
        this.text = this.text + RandomRouteReport.resultPrimaryText(n, primary) + "\n";
        this.html = this.html + this.resultPrimaryHtml(n, primary);
    }

    void resultCompare(int n, RandomRouteResult result, RandomRouteResult primary) {
        double dDistance;
        double dCost;
        String url = result.toURL(this.htmlDomain, this.car2phase);
        double d = dCost = primary.cost > 0.0 ? (result.cost / primary.cost - 1.0) * 100.0 : 0.0;
        String sCost = Math.abs(dCost) < this.deviationYellow && result.cost > 0.0 ? "ok" : (result.cost > 0.0 ? String.format("%s%.2f%%", dCost > 0.0 ? "+" : "", dCost) : "zero");
        String colorCost = this.deviationHtmlColor(dCost, result.cost);
        double d2 = dDistance = primary.distance > 0.0f ? (double)((result.distance / primary.distance - 1.0f) * 100.0f) : 0.0;
        String sDistance = Math.abs(dDistance) < this.deviationYellow && result.distance > 0.0f ? "ok" : (result.distance > 0.0f ? String.format("%s%.2f%%", dDistance > 0.0 ? "+" : "", dDistance) : "zero");
        String colorDistance = this.deviationHtmlColor(dDistance, result.distance);
        this.html = this.html + "<tr align=center>" + String.format("<td><a href=\"%s\" target=_blank>%s</a></td>", url, result.type) + String.format("<td><font color=%s>%s</font></td>", colorCost, sCost) + String.format("<td><font color=%s>%s</font></td>", colorDistance, sDistance) + String.format("<td>%d</td>", result.visitedSegments) + String.format("<td>%.1f</td>", Float.valueOf((float)result.runTime / 1000.0f)) + String.format("<td colspan=4>&nbsp;</td>", new Object[0]) + "</tr>\n";
        this.text = this.text + String.format("%d:%s cost %s dist %s segments=%d seconds=%.1f\n", n, result.type, sCost, sDistance, result.visitedSegments, Float.valueOf((float)result.runTime / 1000.0f));
    }

    void entryOpen(int n) {
        this.html = this.html + "<tr>" + String.format("<th>%d</th>", n) + "<th>cost</th><th>dist</th><th>vis</th><th>s</th><th>start</th><th>finish</th><th>via</th><th>profile</th></tr>\n";
    }

    void entryClose() {
        this.text = this.text + "\n";
        this.html = this.html + "<tr><td colspan=10>&nbsp;</td></tr>\n";
    }

    private String costDistHtmlColor(double n) {
        return n > 0.0 ? "green" : "red";
    }

    private String deviationHtmlColor(double percent, double value) {
        if (value <= 0.0) {
            return "red";
        }
        if (Math.abs(percent) >= this.deviationRed) {
            return "red";
        }
        if (Math.abs(percent) >= this.deviationYellow) {
            return "orange";
        }
        return "green";
    }

    void flush(String htmlFileName) throws IOException {
        FileWriter writer = new FileWriter(htmlFileName);
        this.html = this.html + "</table><br>\ncost - cost of all segments (seconds)<br>\ndist - distance of geometry (meters)<br>\nvis - count of visited segments<br>\ns - route calc time (seconds)<br>\nvia - number of inter points<br>\n</body></html>\n";
        System.err.printf("\n%s", this.text);
        writer.write(this.html);
        writer.close();
    }
}

