/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.HHRoutingDB;
import net.osmand.router.HHRoutingSubGraphCreator;
import net.osmand.router.HHRoutingUtilities;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class HHRoutingPreparationDB
extends HHRoutingDB {
    static final Log LOG = PlatformUtil.getLog(HHRoutingPreparationDB.class);
    protected PreparedStatement insSegment;
    protected PreparedStatement insGeometry;
    protected PreparedStatement insPoint;
    protected PreparedStatement updDualPoint;
    protected PreparedStatement deletePoint;
    protected PreparedStatement insVisitedPoints;
    protected PreparedStatement updateRegionBoundaries;
    protected PreparedStatement insertRegionBoundaries;
    protected PreparedStatement insLongRoads;
    private int maxPointDBID;
    private int maxClusterID;

    public HHRoutingPreparationDB(File dbFile) throws SQLException {
        super(dbFile, DBDialect.SQLITE.getDatabaseConnection(dbFile.getAbsolutePath(), LOG));
        if (!this.compactDB) {
            Statement st = this.conn.createStatement();
            st.execute("CREATE TABLE IF NOT EXISTS routeLongRoads(id, regionId, roadId, startIndex, points, PRIMARY key (id))");
            st.execute("CREATE TABLE IF NOT EXISTS routeRegions(id, name, filePointer, size, filename, left, right, top, bottom, PRIMARY key (id))");
            st.execute("CREATE TABLE IF NOT EXISTS routeRegionPoints(id, pntId, clusterId)");
            st.execute("CREATE INDEX IF NOT EXISTS routeRegionPointsIndex on routeRegionPoints(id)");
            this.insPoint = this.conn.prepareStatement("INSERT INTO points(idPoint, pointGeoUniDir, pointGeoId, clusterId, fileDbId, roadId, start, end, sx31, sy31, ex31, ey31, tagValues)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            this.insLongRoads = this.conn.prepareStatement("INSERT INTO routeLongRoads (id, regionId, roadId, startIndex, points) VALUES (?, ?, ?, ?, ? )");
            this.insVisitedPoints = this.conn.prepareStatement("INSERT INTO routeRegionPoints (id, pntId, clusterId) VALUES (?, ?, ?)");
            this.updateRegionBoundaries = this.conn.prepareStatement("UPDATE routeRegions SET left = ?, right = ?, top = ? , bottom = ? where id = ?");
            this.insertRegionBoundaries = this.conn.prepareStatement("INSERT INTO routeRegions(left, right, top, bottom, id) VALUES (?, ?, ?, ?, ?)");
            this.updDualPoint = this.conn.prepareStatement("UPDATE points SET dualIdPoint = ?, dualClusterId = ? WHERE idPoint = ?");
            this.deletePoint = this.conn.prepareStatement("DELETE FROM points WHERE idPoint = ?");
        }
    }

    public List<NetworkLongRoad> loadNetworkLongRoads() throws SQLException {
        ArrayList<NetworkLongRoad> res = new ArrayList<NetworkLongRoad>();
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT id, roadId, startIndex, points from routeLongRoads");
        while (rs.next()) {
            byte[] bytes = rs.getBytes(4);
            int l = bytes.length / 8;
            int[] pointsX = new int[l];
            int[] pointsY = new int[l];
            for (int k = 0; k < l; ++k) {
                pointsX[k] = Algorithms.parseIntFromBytes((byte[])bytes, (int)(k * 8));
                pointsY[k] = Algorithms.parseIntFromBytes((byte[])bytes, (int)(k * 8 + 4));
            }
            NetworkLongRoad r = new NetworkLongRoad(rs.getLong(2), rs.getInt(3), pointsX, pointsY);
            r.dbId = rs.getInt(1);
            res.add(r);
        }
        rs.close();
        s.close();
        return res;
    }

    public int loadNetworkPoints(TLongObjectHashMap<NetworkBorderPoint> networkPointsCluster) throws SQLException {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT pointGeoUniDir, pointGeoId, idPoint, clusterId, roadId, start, end, sx31, sy31, ex31, ey31, fileDbId, tagValues FROM points ");
        while (rs.next()) {
            long pointGeoUniDir = rs.getLong(1);
            if (!networkPointsCluster.containsKey(pointGeoUniDir)) {
                networkPointsCluster.put(pointGeoUniDir, (Object)new NetworkBorderPoint(pointGeoUniDir));
            }
            long roadId = rs.getLong(5);
            int st = rs.getInt(6);
            int end = rs.getInt(7);
            int sx = rs.getInt(8);
            int sy = rs.getInt(9);
            int ex = rs.getInt(10);
            int ey = rs.getInt(11);
            String[] tagValues = Algorithms.deserializeStringArray((String)rs.getString(13));
            HHRoutingSubGraphCreator.RouteSegmentBorderPoint bp = new HHRoutingSubGraphCreator.RouteSegmentBorderPoint(roadId, st, end, sx, sy, ex, ey, tagValues);
            bp.pointDbId = rs.getInt(3);
            bp.clusterDbId = rs.getInt(4);
            bp.fileDbId = rs.getInt(12);
            ((NetworkBorderPoint)networkPointsCluster.get(pointGeoUniDir)).set(rs.getLong(2), bp);
            this.maxPointDBID = Math.max(bp.pointDbId, this.maxPointDBID);
            this.maxClusterID = Math.max(bp.clusterDbId, this.maxClusterID);
        }
        this.maxClusterID = Math.max(this.maxClusterID, this.getMaxClusterId());
        rs.close();
        s.close();
        return this.maxClusterID;
    }

    private int getMaxClusterId() throws SQLException {
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select max(clusterId) from routeRegionPoints");
        if (rs.next()) {
            return rs.getInt(1) + 1;
        }
        rs.close();
        s.close();
        return 0;
    }

    public static void compact(File source, File target) throws SQLException, IOException {
        target.delete();
        System.out.printf("Compacting %s -> %s...\n", source.getName(), target.getName());
        Connection src = DBDialect.SQLITE.getDatabaseConnection(source.getAbsolutePath(), LOG);
        Connection tgt = DBDialect.SQLITE.getDatabaseConnection(target.getAbsolutePath(), LOG);
        Statement st = tgt.createStatement();
        String columnNames = "pointGeoId, idPoint, clusterId, dualIdPoint, dualClusterId, chInd, roadId, start, end, sx31, sy31, ex31, ey31, tagValues";
        int columnSize = columnNames.split(",").length;
        st.execute("CREATE TABLE IF NOT EXISTS profiles(profile, id, params)");
        st.execute("CREATE TABLE IF NOT EXISTS points(" + columnNames + ",  PRIMARY key (idPoint))");
        st.execute("CREATE TABLE IF NOT EXISTS segments(id, profile, ins, outs, PRIMARY key (id, profile))");
        PreparedStatement pIns = tgt.prepareStatement("INSERT INTO profiles(profile, id, params) VALUES (?, ?, ?)");
        TIntArrayList profiles = new TIntArrayList();
        ResultSet profileSet = src.createStatement().executeQuery("select profile, id, params from profiles");
        while (profileSet.next()) {
            pIns.setString(1, profileSet.getString(1));
            pIns.setInt(2, profileSet.getInt(2));
            pIns.setString(3, profileSet.getString(3));
            pIns.execute();
            profiles.add(profileSet.getInt(2));
        }
        Object insPnts = "";
        for (int k = 0; k < columnSize; ++k) {
            if (k > 0) {
                insPnts = (String)insPnts + ",";
            }
            insPnts = (String)insPnts + "?";
        }
        HHRoutingDB sourceDB = new HHRoutingDB(source, src);
        TLongObjectHashMap pointsById = sourceDB.loadNetworkPoints((short)0, NetworkDBPointPrep.class);
        TIntObjectHashMap outPoints = HHRoutePlanner.groupByClusters((TLongObjectHashMap)pointsById, (boolean)true);
        TIntObjectHashMap inPoints = HHRoutePlanner.groupByClusters((TLongObjectHashMap)pointsById, (boolean)false);
        pIns = tgt.prepareStatement("INSERT INTO points(" + columnNames + ") VALUES (" + (String)insPnts + ")");
        ResultSet rs = src.createStatement().executeQuery(" select " + columnNames + " from points");
        while (rs.next()) {
            for (int i = 0; i < columnSize - 1; ++i) {
                pIns.setObject(i + 1, rs.getObject(i + 1));
            }
            pIns.setBytes(columnSize, Algorithms.stringToGzip((String)rs.getString(columnSize)));
            pIns.addBatch();
        }
        pIns.executeBatch();
        for (int profile : profiles.toArray()) {
            PreparedStatement sIns = tgt.prepareStatement("INSERT INTO segments(id, profile, ins, outs)  VALUES (?, ?, ?, ?)");
            PreparedStatement selOut = src.prepareStatement(" select idConnPoint, dist, shortcut from segments where idPoint = ? and profile = " + profile);
            PreparedStatement selIn = src.prepareStatement(" select idPoint, dist, shortcut from segments where idConnPoint = ? and profile = " + profile);
            for (NetworkDBPointPrep p : pointsById.valueCollection()) {
                selIn.setInt(1, p.index);
                selOut.setInt(1, p.index);
                sIns.setInt(1, p.index);
                sIns.setInt(2, profile);
                sIns.setBytes(3, HHRoutingPreparationDB.prepareSegments(selIn, (TLongObjectHashMap<NetworkDBPointPrep>)pointsById, (List)inPoints.get(p.clusterId)));
                sIns.setBytes(4, HHRoutingPreparationDB.prepareSegments(selOut, (TLongObjectHashMap<NetworkDBPointPrep>)pointsById, (List)outPoints.get(p.dualPoint.clusterId)));
                sIns.addBatch();
            }
            sIns.executeBatch();
        }
        tgt.close();
    }

    private static byte[] prepareSegments(PreparedStatement selIn, TLongObjectHashMap<NetworkDBPointPrep> pointsById, List<NetworkDBPointPrep> pnts) throws SQLException, IOException {
        TByteArrayList tbs = new TByteArrayList();
        ResultSet q = selIn.executeQuery();
        BinaryMapIndexWriter bmiw = new BinaryMapIndexWriter(null, null);
        for (NetworkDBPointPrep p : pnts) {
            p.distSegment = 0;
        }
        while (q.next()) {
            int conn = q.getInt(1);
            int distInt = (int)Math.max(1.0f, q.getFloat(2) * 10.0f);
            HHRouteDataStructure.NetworkDBPoint connPoint = (HHRouteDataStructure.NetworkDBPoint)pointsById.get((long)conn);
            int ind = Collections.binarySearch(pnts, connPoint, indexComparator);
            if (ind < 0) {
                throw new IllegalStateException();
            }
            pnts.get((int)ind).distSegment = distInt;
        }
        for (NetworkDBPointPrep p : pnts) {
            bmiw.writeRawVarint32(tbs, p.distSegment);
        }
        return tbs.toArray();
    }

    public void recreateSegments() throws SQLException {
        Statement st = this.conn.createStatement();
        st.execute("DELETE FROM segments");
        st.execute("DELETE FROM profiles");
        st.execute("DELETE FROM geometry");
        st.close();
    }

    public void updatePointsCHInd(Collection<NetworkDBPointPrep> pnts) throws SQLException {
        PreparedStatement updCHInd = this.conn.prepareStatement("UPDATE  points SET chInd = ? where idPoint = ?");
        int ind = 0;
        for (NetworkDBPointPrep p : pnts) {
            updCHInd.setLong(1, p.chFinalInd);
            updCHInd.setLong(2, p.index);
            updCHInd.addBatch();
            if (ind++ % 10000 != 0) continue;
            updCHInd.executeBatch();
        }
        updCHInd.executeBatch();
        updCHInd.close();
    }

    public void insertProcessedRegion(NetworkRouteRegion networkRouteRegion, TLongObjectHashMap<NetworkBorderPoint> borderPoints, List<NetworkLongRoad> roads) throws SQLException {
        this.insertBorderPoints(borderPoints);
        int ins = this.insertVisitedPoints(networkRouteRegion);
        if (ins > 0) {
            this.updateRegionBbox(networkRouteRegion);
        }
        this.updateLongRoads(networkRouteRegion, roads);
    }

    public void cleanupRegionForReprocessing(NetworkRouteRegion networkRouteRegion, TLongObjectHashMap<NetworkBorderPoint> borderPoints, List<NetworkLongRoad> longRoads) throws SQLException {
        Iterator<NetworkLongRoad> it = longRoads.iterator();
        while (it.hasNext()) {
            NetworkLongRoad r = it.next();
            if (r.dbId >= 0) continue;
            it.remove();
        }
        TLongObjectIterator its = borderPoints.iterator();
        while (its.hasNext()) {
            its.advance();
            NetworkBorderPoint npnt = (NetworkBorderPoint)its.value();
            if (npnt.positiveObj != null && !npnt.positiveObj.inserted) {
                npnt.positiveObj = null;
            }
            if (npnt.negativeObj != null && !npnt.negativeObj.inserted) {
                npnt.negativeObj = null;
            }
            if (npnt.positiveObj != null || npnt.negativeObj != null) continue;
            its.remove();
        }
    }

    private void updateLongRoads(NetworkRouteRegion networkRouteRegion, List<NetworkLongRoad> roads) throws SQLException {
        int max = -1;
        for (NetworkLongRoad r : roads) {
            max = Math.max(r.dbId, max);
        }
        for (NetworkLongRoad r : roads) {
            if (r.dbId >= 0) continue;
            r.dbId = ++max;
            this.insLongRoads.setInt(1, r.dbId);
            this.insLongRoads.setInt(2, networkRouteRegion.id);
            this.insLongRoads.setLong(3, r.roadId);
            this.insLongRoads.setInt(4, r.startIndex);
            byte[] ar = new byte[r.pointsX.length * 8];
            for (int k = 0; k < r.pointsX.length; ++k) {
                Algorithms.putIntToBytes((byte[])ar, (int)(k * 8), (int)r.pointsX[k]);
                Algorithms.putIntToBytes((byte[])ar, (int)(k * 8 + 4), (int)r.pointsY[k]);
            }
            this.insLongRoads.setBytes(5, ar);
            this.insLongRoads.execute();
        }
    }

    private void updateRegionBbox(NetworkRouteRegion networkRouteRegion) throws SQLException {
        PreparedStatement p = networkRouteRegion.id < 0 ? this.insertRegionBoundaries : this.updateRegionBoundaries;
        QuadRect r = networkRouteRegion.rect;
        p.setDouble(1, r.left);
        p.setDouble(2, r.right);
        p.setDouble(3, r.top);
        p.setDouble(4, r.bottom);
        p.setInt(5, networkRouteRegion.id);
        p.execute();
    }

    private int insertVisitedPoints(NetworkRouteRegion networkRouteRegion) throws SQLException {
        int ind = 0;
        if (networkRouteRegion.visitedVertices.size() == 0) {
            return ind;
        }
        TLongIntIterator it = networkRouteRegion.visitedVertices.iterator();
        while (it.hasNext()) {
            it.advance();
            this.insVisitedPoints.setLong(1, networkRouteRegion.id);
            this.insVisitedPoints.setLong(2, it.key());
            this.insVisitedPoints.setInt(3, it.value());
            this.insVisitedPoints.addBatch();
            if (ind++ % 10000 != 0) continue;
            this.insVisitedPoints.executeBatch();
        }
        this.insVisitedPoints.executeBatch();
        return ind;
    }

    private void insertBorderPoints(TLongObjectHashMap<NetworkBorderPoint> borderPoints) throws SQLException {
        int batchInsPoint = 0;
        for (NetworkBorderPoint npnt : borderPoints.valueCollection()) {
            boolean ins = false;
            if (npnt.positiveObj != null && !npnt.positiveObj.inserted) {
                this.insPoint(npnt.positiveObj);
                npnt.positiveObj.inserted = true;
                ins = true;
                ++batchInsPoint;
            }
            if (npnt.negativeObj != null && !npnt.negativeObj.inserted) {
                this.insPoint(npnt.negativeObj);
                npnt.negativeObj.inserted = true;
                ins = true;
                ++batchInsPoint;
            }
            if (ins && npnt.positiveObj != null && npnt.negativeObj != null) {
                this.updDualPoint.setInt(1, npnt.negativeObj.pointDbId);
                this.updDualPoint.setInt(2, npnt.negativeObj.clusterDbId);
                this.updDualPoint.setInt(3, npnt.positiveObj.pointDbId);
                this.updDualPoint.addBatch();
                this.updDualPoint.setInt(1, npnt.positiveObj.pointDbId);
                this.updDualPoint.setInt(2, npnt.positiveObj.clusterDbId);
                this.updDualPoint.setInt(3, npnt.negativeObj.pointDbId);
                this.updDualPoint.addBatch();
                ++batchInsPoint;
            }
            if (batchInsPoint <= 10000) continue;
            batchInsPoint = 0;
            this.insPoint.executeBatch();
            this.updDualPoint.executeBatch();
        }
        if (batchInsPoint > 0) {
            this.insPoint.executeBatch();
            this.updDualPoint.executeBatch();
        }
    }

    private void insPoint(HHRoutingSubGraphCreator.RouteSegmentBorderPoint obj) throws SQLException {
        int p = 1;
        this.insPoint.setInt(p++, obj.pointDbId);
        this.insPoint.setLong(p++, obj.unidirId);
        this.insPoint.setLong(p++, obj.uniqueId);
        this.insPoint.setInt(p++, obj.clusterDbId);
        this.insPoint.setInt(p++, obj.fileDbId);
        this.insPoint.setLong(p++, obj.roadId);
        this.insPoint.setInt(p++, obj.segmentStart);
        this.insPoint.setInt(p++, obj.segmentEnd);
        this.insPoint.setInt(p++, obj.sx);
        this.insPoint.setInt(p++, obj.sy);
        this.insPoint.setInt(p++, obj.ex);
        this.insPoint.setInt(p++, obj.ey);
        this.insPoint.setString(p++, Algorithms.serializeStringArray((String[])obj.tagValues));
        this.insPoint.addBatch();
    }

    public void deleteShortcuts() throws SQLException {
        Statement st = this.conn.createStatement();
        st.execute("DELETE from segments where shortcut > 0");
        st.execute("DELETE from geometry where shortcut > 0");
        st.close();
    }

    public void insertSegments(List<HHRouteDataStructure.NetworkDBSegment> segments, int routingProfile) throws SQLException {
        if (this.insSegment == null) {
            this.insSegment = this.conn.prepareStatement("INSERT INTO segments(idPoint, idConnPoint, dist, shortcut, profile) VALUES(?, ?, ?, ?, ?)");
        }
        if (this.insGeometry == null) {
            this.insGeometry = this.conn.prepareStatement("INSERT INTO geometry(idPoint, idConnPoint, shortcut, geometry, profile) VALUES(?, ?, ?, ?, ?)");
        }
        int ind = 0;
        for (HHRouteDataStructure.NetworkDBSegment s : segments) {
            this.insSegment.setLong(1, s.start.index);
            this.insSegment.setLong(2, s.end.index);
            this.insSegment.setDouble(3, s.dist);
            this.insSegment.setInt(4, s.shortcut ? 1 : 0);
            this.insSegment.setInt(5, routingProfile);
            this.insSegment.addBatch();
            if (s.getGeometry().size() > 0) {
                List geometry = s.getGeometry();
                coordinates = new byte[8 * geometry.size()];
                for (t = 0; t < geometry.size(); ++t) {
                    LatLon l = (LatLon)geometry.get(t);
                    Algorithms.putIntToBytes((byte[])coordinates, (int)(8 * t), (int)MapUtils.get31TileNumberX((double)l.getLongitude()));
                    Algorithms.putIntToBytes((byte[])coordinates, (int)(8 * t + 4), (int)MapUtils.get31TileNumberY((double)l.getLatitude()));
                }
                this.insGeometry.setBytes(4, coordinates);
            } else if (s instanceof NetworkDBSegmentPrep && ((NetworkDBSegmentPrep)s).segmentsStartEnd.size() > 0) {
                NetworkDBSegmentPrep ps = (NetworkDBSegmentPrep)s;
                coordinates = new byte[4 * ps.segmentsStartEnd.size() + 8];
                Algorithms.putIntToBytes((byte[])coordinates, (int)0, (int)0);
                Algorithms.putIntToBytes((byte[])coordinates, (int)4, (int)0);
                for (t = 0; t < ps.segmentsStartEnd.size(); ++t) {
                    Algorithms.putIntToBytes((byte[])coordinates, (int)(4 * t + 8), (int)ps.segmentsStartEnd.getQuick(t));
                }
                this.insGeometry.setBytes(4, coordinates);
            }
            this.insGeometry.setLong(1, s.start.index);
            this.insGeometry.setLong(2, s.end.index);
            this.insGeometry.setInt(3, s.shortcut ? 1 : 0);
            this.insGeometry.setInt(5, routingProfile);
            this.insGeometry.addBatch();
            if (ind++ % 10000 != 0) continue;
            this.insSegment.executeBatch();
            this.insGeometry.executeBatch();
        }
        this.insSegment.executeBatch();
        this.insGeometry.executeBatch();
    }

    public void insertRegions(List<NetworkRouteRegion> regions) throws SQLException {
        PreparedStatement check = this.conn.prepareStatement("SELECT id, left, top, right, bottom from routeRegions where name = ? ");
        PreparedStatement ins = this.conn.prepareStatement("INSERT INTO routeRegions(id, name, filePointer, size, filename, left, right, top, bottom)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");
        int ind = 0;
        for (NetworkRouteRegion nr : regions) {
            check.setString(1, nr.region.getName());
            ResultSet ls = check.executeQuery();
            if (ls.next()) {
                nr.id = ls.getInt(1);
                nr.rect = new QuadRect(ls.getDouble(2), ls.getDouble(3), ls.getDouble(4), ls.getDouble(5));
                ind = Math.max(ind, nr.id);
                continue;
            }
            nr.id = -1;
        }
        for (NetworkRouteRegion nr : regions) {
            if (nr.id >= 0) continue;
            int p = 1;
            nr.id = ind++;
            ins.setLong(p++, nr.id);
            ins.setString(p++, nr.region.getName());
            ins.setLong(p++, nr.region.getFilePointer());
            ins.setLong(p++, nr.region.getLength());
            ins.setString(p++, nr.file.getName());
            ins.setDouble(p++, nr.rect.left);
            ins.setDouble(p++, nr.rect.right);
            ins.setDouble(p++, nr.rect.top);
            ins.setDouble(p++, nr.rect.bottom);
            ins.addBatch();
        }
        ins.executeBatch();
        ins.close();
    }

    public void deleteMergePoints(HHRoutingSubGraphCreator.RouteSegmentBorderPoint negMerge) {
        try {
            this.insVisitedPoints.setLong(1, negMerge.fileDbId);
            this.insVisitedPoints.setLong(2, negMerge.unidirId);
            this.insVisitedPoints.setInt(3, negMerge.clusterDbId);
            this.insVisitedPoints.addBatch();
            this.insVisitedPoints.executeBatch();
            this.deletePoint.setInt(1, negMerge.pointDbId);
            this.deletePoint.addBatch();
            this.deletePoint.executeBatch();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void mergePoints(HHRoutingSubGraphCreator.RouteSegmentBorderPoint main, HHRoutingSubGraphCreator.RouteSegmentBorderPoint newMainOpp) {
        try {
            newMainOpp.pointDbId = ++this.maxPointDBID;
            this.insPoint(newMainOpp);
            this.insPoint.executeBatch();
            this.updDualPoint.setInt(1, newMainOpp.pointDbId);
            this.updDualPoint.setInt(2, newMainOpp.clusterDbId);
            this.updDualPoint.setInt(3, main.pointDbId);
            this.updDualPoint.addBatch();
            this.updDualPoint.setInt(1, main.pointDbId);
            this.updDualPoint.setInt(2, main.clusterDbId);
            this.updDualPoint.setInt(3, newMainOpp.pointDbId);
            this.updDualPoint.addBatch();
            this.updDualPoint.executeBatch();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void loadMidPointsIndex(TLongObjectHashMap<NetworkDBPointPrep> pntsMap, Collection<NetworkDBPointPrep> pointsList, boolean update) throws SQLException {
        Statement s = this.conn.createStatement();
        for (NetworkDBPointPrep p : pointsList) {
            p.midSaved = false;
        }
        PreparedStatement ps = this.conn.prepareStatement("UPDATE midpoints SET maxMidDepth = ?, proc = ? where ind = ?");
        int batch = 0;
        ResultSet rs = s.executeQuery("SELECT ind, maxMidDepth, proc  FROM midpoints ");
        while (rs.next()) {
            int ind = rs.getInt(1);
            NetworkDBPointPrep pnt = (NetworkDBPointPrep)((Object)pntsMap.get((long)ind));
            boolean upd = false;
            if (pnt.midMaxDepth > rs.getInt(2)) {
                upd = true;
            } else {
                pnt.midMaxDepth = rs.getInt(2);
            }
            if (pnt.midProc == 1 && rs.getInt(3) == 0) {
                upd = true;
            } else {
                pnt.midProc = rs.getInt(3);
            }
            if (upd) {
                ps.setLong(1, pnt.midMaxDepth);
                ps.setLong(2, pnt.midProc);
                ps.setLong(3, pnt.index);
                ps.addBatch();
                if (batch++ > 1000) {
                    batch = 0;
                    ps.executeBatch();
                }
            }
            pnt.midSaved = true;
        }
        ps.executeBatch();
        ps = this.conn.prepareStatement("INSERT INTO midpoints(ind, maxMidDepth, proc) VALUES(?, ?, ?)");
        batch = 0;
        for (NetworkDBPointPrep p : pointsList) {
            if (p.midSaved || p.midMaxDepth <= 0 && p.midProc <= 0) continue;
            ps.setLong(1, p.index);
            ps.setLong(2, p.midMaxDepth);
            ps.setLong(3, p.midProc);
            ps.addBatch();
            if (batch++ <= 1000) continue;
            batch = 0;
            ps.executeBatch();
        }
        ps.executeBatch();
    }

    public int prepareBorderPointsToInsert(int fileId, List<HHRoutingSubGraphCreator.RouteSegmentBorderPoint> borderPoints, TLongObjectHashMap<NetworkBorderPoint> pointDbInd) {
        int clusterIndex = ++this.maxClusterID;
        for (HHRoutingSubGraphCreator.RouteSegmentBorderPoint obj : borderPoints) {
            if (!pointDbInd.containsKey(obj.unidirId)) {
                pointDbInd.put(obj.unidirId, (Object)new NetworkBorderPoint(obj.unidirId));
            }
            NetworkBorderPoint npnt = (NetworkBorderPoint)pointDbInd.get(obj.unidirId);
            obj.pointDbId = ++this.maxPointDBID;
            obj.clusterDbId = clusterIndex;
            obj.fileDbId = fileId;
            npnt.set(obj.unidirId, obj);
        }
        return clusterIndex;
    }

    public boolean hasVisitedPoints(NetworkRouteRegion nrouteRegion) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("SELECT pntId FROM routeRegionPoints WHERE id = ? ");
        ps.setLong(1, nrouteRegion.id);
        ResultSet rs = ps.executeQuery();
        boolean has = false;
        if (rs.next()) {
            has = true;
        }
        rs.close();
        ps.close();
        return has;
    }

    public TLongIntHashMap loadVisitedVertices(int id) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement("SELECT pntId, clusterId FROM routeRegionPoints WHERE id = ? ");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        TLongIntHashMap pnts = new TLongIntHashMap();
        while (rs.next()) {
            pnts.put(rs.getLong(1), rs.getInt(2));
        }
        rs.close();
        return pnts;
    }

    public static class NetworkLongRoad {
        public int dbId = -1;
        public final long roadId;
        public final int startIndex;
        public final int[] pointsY;
        public final int[] pointsX;
        public List<NetworkLongRoad> connected = new ArrayList<NetworkLongRoad>();
        public TLongHashSet points = new TLongHashSet();

        public NetworkLongRoad(long roadId, int startIndex, int[] pointsX, int[] pointsY) {
            this.roadId = roadId;
            this.startIndex = startIndex;
            this.pointsX = pointsX;
            this.pointsY = pointsY;
            for (int k = 0; k < pointsX.length; ++k) {
                this.points.add(MapUtils.interleaveBits((long)pointsX[k], (long)pointsY[k]));
            }
        }

        public QuadRect getQuadRect() {
            QuadRect qr = null;
            for (int k = 0; k < this.pointsX.length; ++k) {
                double lat = MapUtils.get31LatitudeY((int)this.pointsY[k]);
                double lon = MapUtils.get31LongitudeX((int)this.pointsX[k]);
                qr = HHRoutingUtilities.expandLatLonRect(qr, lon, lat, lon, lat);
            }
            return qr;
        }

        public void addConnected(List<NetworkLongRoad> longRoads) {
            for (NetworkLongRoad r : longRoads) {
                if (this == r) continue;
                boolean intersects = false;
                for (long pnt : r.points.toArray()) {
                    if (!this.points.contains(pnt)) continue;
                    intersects = true;
                    break;
                }
                if (!intersects) continue;
                this.connected.add(r);
            }
        }

        public String toString() {
            return String.format("Long road %d index %d", this.roadId / 64L, this.startIndex);
        }
    }

    static class NetworkBorderPoint {
        long unidirId;
        HHRoutingSubGraphCreator.RouteSegmentBorderPoint positiveObj;
        HHRoutingSubGraphCreator.RouteSegmentBorderPoint negativeObj;

        public NetworkBorderPoint(long unidirId) {
            this.unidirId = unidirId;
        }

        public void set(long geoId, HHRoutingSubGraphCreator.RouteSegmentBorderPoint obj) {
            if (obj.isPositive()) {
                if (this.positiveObj != null) {
                    String msg = String.format("Geoid %d was already assigned %d (%d) in cluster %d (%d)  %s", geoId, obj.pointDbId, this.positiveObj.pointDbId, obj.clusterDbId, this.positiveObj.clusterDbId, obj);
                    throw new IllegalStateException(msg);
                }
                this.positiveObj = obj;
            } else {
                if (this.negativeObj != null) {
                    String msg = String.format("Geoid %d was already assigned %d (%d) in cluster %d (%d)  %s", geoId, obj.pointDbId, this.negativeObj.pointDbId, obj.clusterDbId, this.negativeObj.clusterDbId, obj);
                    throw new IllegalStateException(msg);
                }
                this.negativeObj = obj;
            }
        }
    }

    public static class NetworkDBPointPrep
    extends HHRouteDataStructure.NetworkDBPoint {
        int distSegment;
        int chIndexEdgeDiff;
        int chFinalInd;
        int chIndexCnt;
        boolean midSaved;
        int midMaxDepth;
        int midProc;
        int midDepth;
        int midPrevMaxDepth;
        public int[] tagValuesInts = null;
    }

    static class NetworkRouteRegion {
        int id = 0;
        BinaryMapRouteReaderAdapter.RouteRegion region;
        File file;
        int points = 0;
        TLongIntHashMap visitedVertices;
        QuadRect rect;
        QuadRect calcRect;

        public NetworkRouteRegion(BinaryMapRouteReaderAdapter.RouteRegion r, File f, QuadRect qrect) {
            this.region = r;
            this.rect = this.region != null ? new QuadRect(this.region.getLeftLongitude(), this.region.getTopLatitude(), this.region.getRightLongitude(), this.region.getBottomLatitude()) : (qrect != null ? qrect : new QuadRect(-180.0, 85.0, 180.0, -85.0));
            this.file = f;
        }

        public QuadRect getCalcBbox() {
            if (this.calcRect == null) {
                return this.rect;
            }
            QuadRect qr = new QuadRect();
            qr.left = MapUtils.get31LongitudeX((int)((int)this.calcRect.left));
            qr.right = MapUtils.get31LongitudeX((int)((int)this.calcRect.right));
            qr.top = MapUtils.get31LatitudeY((int)((int)this.calcRect.top));
            qr.bottom = MapUtils.get31LatitudeY((int)((int)this.calcRect.bottom));
            return qr;
        }

        public void updateBbox(int x31, int y31) {
            if (this.calcRect == null) {
                this.calcRect = new QuadRect();
                this.calcRect.right = this.calcRect.left = (double)x31;
                this.calcRect.top = this.calcRect.bottom = (double)y31;
            } else {
                if ((double)x31 < this.calcRect.left) {
                    this.calcRect.left = x31;
                } else if ((double)x31 > this.calcRect.right) {
                    this.calcRect.right = x31;
                }
                if ((double)y31 < this.calcRect.top) {
                    this.calcRect.top = y31;
                } else if ((double)y31 > this.calcRect.bottom) {
                    this.calcRect.bottom = y31;
                }
            }
        }

        public int getPoints() {
            return this.points < 0 ? this.visitedVertices.size() : this.points;
        }

        public boolean intersects(NetworkRouteRegion nrouteRegion, double d) {
            QuadRect qr = new QuadRect(Math.max(-180.0, this.rect.left - d), Math.min(85.0, this.rect.top + d), Math.min(180.0, this.rect.right + d), Math.max(-85.0, this.rect.bottom - d));
            return QuadRect.intersects((QuadRect)qr, (QuadRect)nrouteRegion.rect);
        }

        public void unload() {
            if (this.visitedVertices != null && this.visitedVertices.size() > 100000) {
                this.points = this.visitedVertices.size();
                this.visitedVertices = null;
            }
        }

        public TLongIntHashMap loadVisitedVertices(HHRoutingPreparationDB networkDB) throws SQLException {
            if (this.points >= 0) {
                if (this.visitedVertices != null && this.visitedVertices.size() > 0) {
                    throw new IllegalStateException();
                }
                this.visitedVertices = networkDB.loadVisitedVertices(this.id);
                this.points = -1;
                HHRoutingUtilities.logf("Loaded visited vertices for %s - %d.", this.region.getName(), this.visitedVertices.size());
            }
            return this.visitedVertices;
        }

        public String getName() {
            return this.region == null ? "Worldwide" : this.region.getName();
        }
    }

    static class NetworkDBSegmentPrep
    extends HHRouteDataStructure.NetworkDBSegment {
        TIntArrayList segmentsStartEnd = new TIntArrayList();

        public NetworkDBSegmentPrep(HHRouteDataStructure.NetworkDBPoint start, HHRouteDataStructure.NetworkDBPoint end, double dist, boolean direction, boolean shortcut) {
            super(start, end, dist, direction, shortcut);
        }
    }
}

