/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import com.google.protobuf.CodedInputStream;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.set.hash.TLongHashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.QuadRect;
import net.osmand.map.OsmandRegions;
import net.osmand.obf.BinaryInspector;
import net.osmand.obf.preparation.AbstractIndexPartCreator;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.IndexVectorMapCreator;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutingPreparationDB;
import net.osmand.router.HHRoutingUtilities;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import rtree.Element;
import rtree.IllegalValueException;
import rtree.LeafElement;
import rtree.Node;
import rtree.RTree;
import rtree.RTreeException;
import rtree.RTreeInsertException;
import rtree.Rect;

public class HHRoutingOBFWriter {
    static final Log LOG = PlatformUtil.getLog(HHRoutingOBFWriter.class);
    private static final int BLOCK_SEGMENTS_AVG_BLOCKS_SIZE = 10;
    private static final int BLOCK_SEGMENTS_AVG_BUCKET_SIZE = 7;
    public static final int BUFFER_SIZE = 0x100000;
    protected static boolean PREINDEX_POINTS_BY_COUNTRIES = true;
    protected static boolean WRITE_TAG_VALUES = true;
    protected static int THREAD_POOL = 1;
    protected static boolean VALIDATE_CLUSTER_SIZE = false;
    private static final String IGNORE_ROUTE = "route_";
    private static final String IGNORE_ROAD = "road_";
    private static final String IGNORE_OSMAND_ELE = "osmand_ele_";
    private static final String IGNORE_TURN_LANES = "turn:lanes";
    private static final String IGNORE_DESCRIPTION = ":description";
    private static final String IGNORE_NOTE = ":note";
    TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint> points;
    private HHRoutingPreparationDB db;
    private long edition;
    private File dbFile;
    private String profile;
    private String[] profileParams;
    private int[] dbProfileParamsKeys;

    public static void main(String[] args) throws IOException, SQLException, IllegalValueException {
        File dbFile = null;
        File obfPolyFile = null;
        File outFolder = null;
        boolean updateExistingFiles = false;
        if (args.length == 0) {
            updateExistingFiles = true;
            String mapName = "Germany_car.chdb";
            String polyFile = null;
            polyFile = "_split";
            obfPolyFile = new File(System.getProperty("maps.dir"), polyFile);
            dbFile = new File(System.getProperty("maps.dir"), mapName);
        } else {
            for (String arg : args) {
                if (arg.startsWith("--db=")) {
                    dbFile = new File(arg.substring("--db=".length()));
                    continue;
                }
                if (arg.startsWith("--threads=")) {
                    THREAD_POOL = Integer.parseInt(arg.substring("--threads=".length()));
                    continue;
                }
                if (arg.startsWith("--outfolder=")) {
                    outFolder = new File(arg.substring("--outfolder=".length()));
                    continue;
                }
                if (arg.startsWith("--update-existing-files")) {
                    updateExistingFiles = true;
                    continue;
                }
                if (!arg.startsWith("--obf=")) continue;
                obfPolyFile = new File(arg.substring("--obf=".length()));
            }
        }
        new HHRoutingOBFWriter(dbFile).writeFile(obfPolyFile, outFolder, updateExistingFiles);
    }

    public HHRoutingOBFWriter(File dbFile) throws SQLException {
        this.dbFile = dbFile;
        this.edition = dbFile.lastModified();
        this.db = new HHRoutingPreparationDB(dbFile);
        this.points = this.db.loadNetworkPoints((short)0, HHRouteDataStructure.NetworkDBPoint.class);
        this.profile = this.db.getRoutingProfile();
        TIntObjectHashMap routingProfiles = this.db.getRoutingProfiles();
        int pInd = 0;
        this.profileParams = new String[routingProfiles.size()];
        this.dbProfileParamsKeys = new int[routingProfiles.size()];
        int[] nArray = routingProfiles.keys();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int p;
            this.dbProfileParamsKeys[pInd] = p = nArray[i];
            this.profileParams[pInd] = (String)routingProfiles.get(p);
            ++pInd;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeFile(File obfPolyFileIn, File outFolder, boolean updateExistingFiles) throws IOException, SQLException, IllegalValueException {
        ExecutorService service;
        block38: {
            List<Runnable> runnable;
            if (THREAD_POOL > 1) {
                System.err.println("Threads > 1 are not supported cause of current R-Tree limitations ");
                THREAD_POOL = 1;
            }
            if (obfPolyFileIn == null) {
                File outFile = new File(this.dbFile.getParentFile(), this.dbFile.getName().substring(0, this.dbFile.getName().lastIndexOf(46)) + ".obf");
                if (outFile.exists()) {
                    outFile.delete();
                }
                TLongObjectHashMap<NetworkDBPointWrite> pnts = HHRoutingOBFWriter.convertPoints(this.points);
                this.writeObfFileByBbox(HHRoutingOBFWriter.toList(pnts), pnts, outFile, new QuadRect(), null);
                return;
            }
            if (outFolder == null) {
                outFolder = obfPolyFileIn.isDirectory() ? obfPolyFileIn : obfPolyFileIn.getParentFile();
            }
            OsmandRegions or = new OsmandRegions();
            or.prepareFile();
            Map downloadNames = or.cacheAllCountries();
            ArrayList<File> obfPolyFiles = new ArrayList<File>();
            if (obfPolyFileIn.isDirectory()) {
                for (File o : obfPolyFileIn.listFiles()) {
                    if (o.getName().toLowerCase().contains("world") || !o.getName().endsWith(".road.obf") && !o.getName().endsWith("_2.obf")) continue;
                    obfPolyFiles.add(o);
                }
            } else {
                obfPolyFiles.add(obfPolyFileIn);
            }
            LinkedHashMap<Object, TLongArrayList> pointsByDownloadName = new LinkedHashMap<Object, TLongArrayList>();
            int index = 0;
            System.out.printf("Indexing points %d...\n", this.points.size());
            if (PREINDEX_POINTS_BY_COUNTRIES) {
                for (HHRouteDataStructure.NetworkDBPoint p : this.points.valueCollection()) {
                    List lst = or.query(p.midX(), p.midY());
                    if (++index % 100000 == 0) {
                        System.out.printf("Indexed %d of %d - %s \n", index, this.points.size(), new Date());
                    }
                    for (BinaryMapDataObject b : lst) {
                        if (!OsmandRegions.contain((BinaryMapDataObject)b, (int)p.midX(), (int)p.midY())) continue;
                        String dw = or.getDownloadName(b);
                        if (!pointsByDownloadName.containsKey(dw)) {
                            pointsByDownloadName.put(dw, new TLongArrayList());
                        }
                        ((TLongArrayList)pointsByDownloadName.get(dw)).add((long)p.index);
                    }
                }
            } else {
                for (File obfPolyFile : obfPolyFiles) {
                    String countryName = this.getCountryName(obfPolyFile);
                    LinkedList boundaries = (LinkedList)downloadNames.get(countryName);
                    TLongArrayList lst = new TLongArrayList();
                    block13: for (HHRouteDataStructure.NetworkDBPoint p : this.points.valueCollection()) {
                        if (++index % 100000 == 0) {
                            System.out.printf("Indexed %d of %d - %s \n", index, this.points.size(), new Date());
                        }
                        if (boundaries == null) continue;
                        Iterator iterator = boundaries.iterator();
                        while (iterator.hasNext()) {
                            BinaryMapDataObject b = (BinaryMapDataObject)iterator.next();
                            if (!OsmandRegions.contain((BinaryMapDataObject)b, (int)p.midX(), (int)p.midY())) continue;
                            lst.add((long)p.index);
                            continue block13;
                        }
                    }
                    pointsByDownloadName.put(countryName, lst);
                }
            }
            service = Executors.newFixedThreadPool(THREAD_POOL);
            ArrayList<Future<String>> results = new ArrayList<Future<String>>();
            TLongObjectHashMap<NetworkDBPointWrite> wPoints = null;
            for (File obfPolyFile : obfPolyFiles) {
                File outFile = new File(outFolder, obfPolyFile.getName().substring(0, obfPolyFile.getName().lastIndexOf(46)) + ".hh.obf");
                if (updateExistingFiles) {
                    outFile = obfPolyFile;
                }
                outFile.getParentFile().mkdirs();
                QuadRect bbox31 = new QuadRect();
                TLongArrayList filteredPoints = null;
                String countryName = this.getCountryName(obfPolyFile);
                if (or.getRegionDataByDownloadName(countryName) != null) {
                    filteredPoints = (TLongArrayList)pointsByDownloadName.get(countryName);
                    if (filteredPoints == null) {
                        System.out.printf("Skip %s as it has no points\n", countryName);
                        continue;
                    }
                } else {
                    BinaryMapIndexReader reader = new BinaryMapIndexReader(new RandomAccessFile(obfPolyFile, "r"), obfPolyFile);
                    for (BinaryMapIndexReader.MapIndex mi : reader.getMapIndexes()) {
                        for (BinaryMapIndexReader.MapRoot rt : mi.getRoots()) {
                            bbox31.expand((double)rt.getLeft(), (double)rt.getTop(), (double)rt.getRight(), (double)rt.getBottom());
                        }
                    }
                    reader.close();
                    System.out.printf("Using polygon for %s %.5f %.5f - %.5f %.5f\n", outFile.getName(), MapUtils.get31LongitudeX((int)((int)bbox31.left)), MapUtils.get31LatitudeY((int)((int)bbox31.top)), MapUtils.get31LongitudeX((int)((int)bbox31.right)), MapUtils.get31LatitudeY((int)((int)bbox31.bottom)));
                }
                if (THREAD_POOL > 1) {
                    AugmentObfTask task = new AugmentObfTask(this, outFile, bbox31, filteredPoints);
                    results.add(service.submit(task));
                    continue;
                }
                if (wPoints == null) {
                    wPoints = HHRoutingOBFWriter.convertPoints(this.points);
                }
                String log = this.writeObfFileByBbox(HHRoutingOBFWriter.toList(wPoints), wPoints, outFile, bbox31, filteredPoints);
                HHRoutingUtilities.logf(log.trim(), new Object[0]);
            }
            service.shutdown();
            try {
                while (!results.isEmpty()) {
                    Thread.sleep(3000L);
                    Iterator it = results.iterator();
                    while (it.hasNext()) {
                        Future future = (Future)it.next();
                        if (!future.isDone()) continue;
                        String res = (String)future.get();
                        HHRoutingUtilities.logf(res.trim(), new Object[0]);
                        it.remove();
                    }
                }
                runnable = service.shutdownNow();
                if (results.isEmpty()) break block38;
            }
            catch (InterruptedException e) {
                try {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                    catch (ExecutionException e2) {
                        e2.printStackTrace();
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    List<Runnable> runnable2 = service.shutdownNow();
                    if (!results.isEmpty()) {
                        HHRoutingUtilities.logf("!!! %d runnable were not executed: exception occurred", runnable2 == null ? 0 : runnable2.size());
                    }
                    try {
                        service.awaitTermination(5L, TimeUnit.MINUTES);
                        throw throwable;
                    }
                    catch (InterruptedException e3) {
                        e3.printStackTrace();
                        throw new RuntimeException(e3);
                    }
                }
            }
            HHRoutingUtilities.logf("!!! %d runnable were not executed: exception occurred", runnable == null ? 0 : runnable.size());
        }
        try {
            service.awaitTermination(5L, TimeUnit.MINUTES);
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static TLongObjectHashMap<NetworkDBPointWrite> convertPoints(TLongObjectHashMap<HHRouteDataStructure.NetworkDBPoint> dbPoints) {
        final TLongObjectHashMap points = new TLongObjectHashMap();
        dbPoints.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<HHRouteDataStructure.NetworkDBPoint>(){

            public boolean execute(long a, HHRouteDataStructure.NetworkDBPoint b) {
                points.put(a, (Object)new NetworkDBPointWrite(b));
                return true;
            }
        });
        return points;
    }

    public static List<NetworkDBPointWrite> toList(TLongObjectHashMap<NetworkDBPointWrite> ctxPoints) {
        final ArrayList<NetworkDBPointWrite> lst = new ArrayList<NetworkDBPointWrite>(ctxPoints.size());
        ctxPoints.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<NetworkDBPointWrite>(){

            public boolean execute(long a, NetworkDBPointWrite b) {
                lst.add(b);
                return true;
            }
        });
        return lst;
    }

    private String getCountryName(File obfPolyFile) {
        return obfPolyFile.getName().substring(0, obfPolyFile.getName().lastIndexOf(95)).toLowerCase();
    }

    private List<String> prepareTagValuesDictionary(List<NetworkDBPointWrite> points) {
        final HashMap<CallSite, Integer> tagDict = new HashMap<CallSite, Integer>();
        for (NetworkDBPointWrite p : points) {
            if (p.pnt.tagValues == null || p.includeFlag == 0) continue;
            for (BinaryMapIndexReader.TagValuePair entry : p.pnt.tagValues) {
                String key = entry.tag;
                if (key.startsWith(IGNORE_ROUTE) || key.startsWith(IGNORE_TURN_LANES) || key.startsWith(IGNORE_ROAD) || key.startsWith(IGNORE_OSMAND_ELE) || key.contains(IGNORE_NOTE) || key.contains(IGNORE_DESCRIPTION)) continue;
                String keyValue = entry.tag + "=" + entry.value;
                Integer n = (Integer)tagDict.get(keyValue);
                if (n == null) {
                    n = 0;
                }
                tagDict.put((CallSite)((Object)keyValue), n + 1);
            }
        }
        ArrayList<String> tagDictList = new ArrayList<String>(tagDict.keySet());
        Collections.sort(tagDictList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return -Integer.compare((Integer)tagDict.get(o1), (Integer)tagDict.get(o2));
            }
        });
        HashMap<String, Integer> finalTagDict = new HashMap<String, Integer>();
        for (int i = 0; i < tagDictList.size(); ++i) {
            finalTagDict.put((String)tagDictList.get(i), i);
        }
        for (NetworkDBPointWrite p : points) {
            if (p.pnt.tagValues == null || p.pnt.tagValues.size() <= 0) continue;
            TIntArrayList lst = new TIntArrayList();
            for (BinaryMapIndexReader.TagValuePair entry : p.pnt.tagValues) {
                String keyValue = entry.tag + "=" + entry.value;
                Integer ind = (Integer)finalTagDict.get(keyValue);
                if (ind == null) continue;
                lst.add(ind.intValue());
            }
            p.tagValuesInts = lst.toArray();
        }
        return tagDictList;
    }

    private String writeObfFileByBbox(List<NetworkDBPointWrite> points, TLongObjectHashMap<NetworkDBPointWrite> pntsMap, File outFile, QuadRect bbox31, TLongArrayList filteredPoints) throws SQLException, IOException, IllegalValueException {
        StringBuilder log = new StringBuilder();
        String rTreeFile = outFile.getAbsolutePath() + ".rtree";
        String rpTreeFile = outFile.getAbsolutePath() + ".rptree";
        try {
            BinaryMapIndexReader reader = null;
            File writeFile = outFile;
            if (outFile.exists()) {
                reader = new BinaryMapIndexReader(new RandomAccessFile(outFile, "rw"), outFile);
                long profileEdition = -1L;
                for (BinaryHHRouteReaderAdapter.HHRouteRegion h : reader.getHHRoutingIndexes()) {
                    if (!h.profile.equals(this.profile)) continue;
                    profileEdition = h.edition;
                    break;
                }
                if (this.edition == profileEdition) {
                    log.append(String.format("Skip file %s as same hh routing profile (%s) already exist", outFile.getName(), new Date(this.edition)));
                    String string = log.toString();
                    return string;
                }
                log.append((profileEdition > 0L ? "Replace" : "Augment") + " file with hh routing: " + outFile.getName()).append("\n");
                writeFile = new File(outFile.getParentFile(), outFile.getName() + ".tmp");
            }
            for (NetworkDBPointWrite p : points) {
                p.includeFlag = 0;
                p.localId = 0;
                p.tagValuesInts = null;
            }
            ValidateClusterSizeStructure vc = null;
            if (VALIDATE_CLUSTER_SIZE) {
                vc = new ValidateClusterSizeStructure(points);
            }
            RTree routeTree = new RTree(rTreeFile);
            String logRes = this.preparePointsToWrite(routeTree, points, pntsMap, bbox31, filteredPoints);
            log.append(logRes);
            RTree packRTree = AbstractIndexPartCreator.packRtreeFile(routeTree, rTreeFile, rpTreeFile);
            long rootIndex = packRTree.getFileHdr().getRootIndex();
            Node root = packRTree.getReadNode(rootIndex);
            Rect rootBounds = IndexVectorMapCreator.calcBounds(root);
            List<String> tagValuesDictionary = null;
            if (WRITE_TAG_VALUES) {
                tagValuesDictionary = this.prepareTagValuesDictionary(points);
            }
            long timestamp = reader != null ? reader.getDateCreated() : this.edition;
            BinaryMapIndexWriter bmiw = new BinaryMapIndexWriter(new RandomAccessFile(writeFile, "rw"), timestamp);
            if (reader != null) {
                byte[] BUFFER_TO_READ = new byte[0x100000];
                for (int i = 0; i < reader.getIndexes().size(); ++i) {
                    BinaryIndexPart part = (BinaryIndexPart)reader.getIndexes().get(i);
                    if (part instanceof BinaryHHRouteReaderAdapter.HHRouteRegion && ((BinaryHHRouteReaderAdapter.HHRouteRegion)part).profile.equals(this.profile)) continue;
                    bmiw.getCodedOutStream().writeTag(part.getFieldNumber(), 6);
                    BinaryInspector.writeInt(bmiw.getCodedOutStream(), part.getLength());
                    BinaryInspector.copyBinaryPart(bmiw.getCodedOutStream(), BUFFER_TO_READ, reader.getRaf(), part.getFilePointer(), part.getLength());
                }
            }
            boolean allowLongSize = false;
            if (this.profileParams.length * points.size() > 16000000) {
                allowLongSize = true;
            }
            bmiw.startHHRoutingIndex(this.edition, this.profile, tagValuesDictionary, allowLongSize, this.profileParams);
            if (rootBounds != null) {
                int i;
                long fp = bmiw.getFilePointer();
                List<NetworkDBPointWrite> pntsList = this.writeBinaryRouteTree(root, rootBounds, packRTree, bmiw, pntsMap, new int[]{0});
                long size = bmiw.getFilePointer() - fp;
                if (vc != null) {
                    vc.validateClusterSizeMatch(this.db, pntsList);
                }
                pntsList.sort(new Comparator<NetworkDBPointWrite>(){

                    @Override
                    public int compare(NetworkDBPointWrite o1, NetworkDBPointWrite o2) {
                        return Integer.compare(o1.localId, o2.localId);
                    }
                });
                ArrayList<Integer> blocks = new ArrayList<Integer>();
                int numberOfBlocks = (pntsList.size() - 1) / 7 + 1;
                while (numberOfBlocks > 1) {
                    blocks.add(numberOfBlocks);
                    numberOfBlocks = (numberOfBlocks - 1) / 10 + 1;
                }
                Collections.reverse(blocks);
                ArrayList<Integer> ranges = new ArrayList<Integer>();
                for (i = 0; i < blocks.size(); ++i) {
                    ranges.add((pntsList.size() - 1) / (Integer)blocks.get(i) + 1);
                }
                fp = bmiw.getFilePointer();
                log.append(String.format("Tree of points %d: ranges - %s, number of subblocks - %s\n", points.size(), ranges, blocks));
                for (i = 0; i < this.dbProfileParamsKeys.length; ++i) {
                    this.writeSegments(this.db, i, this.dbProfileParamsKeys[i], bmiw, pntsList, ranges, 0);
                }
                long size2 = bmiw.getFilePointer() - fp;
                log.append(String.format("Points size %d bytes, segments size %d bytes \n", size, size2));
            }
            bmiw.endHHRoutingIndex();
            bmiw.close();
            RandomAccessFile file = packRTree.getFileHdr().getFile();
            file.close();
            if (reader != null) {
                reader.close();
                writeFile.renameTo(outFile);
            }
        }
        catch (RTreeException | RTreeInsertException e) {
            throw new IOException(e);
        }
        finally {
            new File(rTreeFile).delete();
            new File(rpTreeFile).delete();
        }
        RTree.clearCache();
        return log.toString();
    }

    private String preparePointsToWrite(final RTree routeTree, List<NetworkDBPointWrite> points, final TLongObjectHashMap<NetworkDBPointWrite> pntsMap, QuadRect bbox31, TLongArrayList filteredPoints) throws RTreeInsertException, IllegalValueException {
        StringBuilder log = new StringBuilder();
        if (filteredPoints != null) {
            filteredPoints.forEach(new TLongProcedure(){

                public boolean execute(long value) {
                    NetworkDBPointWrite p = (NetworkDBPointWrite)pntsMap.get(value);
                    p.includeFlag = 1;
                    try {
                        routeTree.insert(new LeafElement(new Rect(p.pnt.midX(), p.pnt.midY(), p.pnt.midX(), p.pnt.midY()), p.pnt.index));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return true;
                }
            });
        } else {
            boolean initialState = bbox31.hasInitialState();
            for (NetworkDBPointWrite p : points) {
                if (!initialState && !bbox31.contains((double)p.pnt.midX(), (double)p.pnt.midY(), (double)p.pnt.midX(), (double)p.pnt.midY())) continue;
                p.includeFlag = 1;
                routeTree.insert(new LeafElement(new Rect(p.pnt.midX(), p.pnt.midY(), p.pnt.midX(), p.pnt.midY()), p.pnt.index));
            }
        }
        String str = this.addIncompletePointsToFormClusters("Prepare ", points, routeTree);
        log.append(str);
        for (NetworkDBPointWrite pnt : points) {
            if (pnt.includeFlag != 2) continue;
            pnt.includeFlag = 1;
        }
        str = this.addIncompletePointsToFormClusters("Final ", points, routeTree);
        log.append(str);
        return log.toString();
    }

    private String addIncompletePointsToFormClusters(String msg, Collection<NetworkDBPointWrite> points, RTree routeTree) throws RTreeInsertException, IllegalValueException {
        TLongHashSet clusterDualPointsForInNeeded = new TLongHashSet();
        TLongHashSet clusterPointsForOutNeeded = new TLongHashSet();
        for (NetworkDBPointWrite pnt : points) {
            if (pnt.includeFlag <= 0) continue;
            clusterPointsForOutNeeded.add((long)pnt.pnt.dualPoint.clusterId);
            clusterDualPointsForInNeeded.add((long)pnt.pnt.clusterId);
        }
        int pointsInc = 0;
        int partial = 0;
        int completeInc = 0;
        for (NetworkDBPointWrite p : points) {
            ++pointsInc;
            if (p.includeFlag <= 0) {
                if (!clusterPointsForOutNeeded.contains((long)p.pnt.dualPoint.clusterId) && !clusterDualPointsForInNeeded.contains((long)p.pnt.clusterId)) continue;
                ++partial;
                if (p.includeFlag == 0) {
                    routeTree.insert(new LeafElement(new Rect(p.pnt.midX(), p.pnt.midY(), p.pnt.midX(), p.pnt.midY()), p.pnt.index));
                }
                p.includeFlag = 2;
                continue;
            }
            ++completeInc;
        }
        return String.format("%s - total points %d: included %d (complete clusters), %d (partial clusters) \n", msg, pointsInc, completeInc, partial);
    }

    private void writeSegments(HHRoutingPreparationDB db, int profile, int dbProfile, BinaryMapIndexWriter writer, List<NetworkDBPointWrite> pntsList, List<Integer> ranges, int shift) throws IOException, SQLException {
        writer.startHHRouteBlockSegments(shift, pntsList.size(), profile);
        if (ranges.size() > 0) {
            int range = ranges.get(0);
            for (int i = 0; i < pntsList.size(); i += range) {
                int start = i;
                int end = Math.min(i + range, pntsList.size());
                this.writeSegments(db, profile, dbProfile, writer, pntsList.subList(start, end), ranges.subList(1, ranges.size()), shift + start);
            }
        } else {
            for (NetworkDBPointWrite p : pntsList) {
                if (shift != p.localId) {
                    throw new IllegalStateException(shift + " != " + p.localId);
                }
                byte[][] res = new byte[2][];
                if (p.includeFlag <= 1) {
                    db.loadSegmentPointInternalSync(p.pnt.index, dbProfile, res);
                } else {
                    res[1] = res[0] = new byte[0];
                }
                writer.writePointSegments(res[0], res[1]);
                ++shift;
            }
        }
        writer.endHHRouteBlockSegments();
    }

    private List<NetworkDBPointWrite> writeBinaryRouteTree(Node parent, Rect re, RTree r, BinaryMapIndexWriter writer, TLongObjectHashMap<NetworkDBPointWrite> points, int[] pntId) throws IOException, RTreeException {
        Element[] es = parent.getAllElements();
        writer.startHHRouteTreeElement(re.getMinX(), re.getMaxX(), re.getMinY(), re.getMaxY());
        ArrayList<NetworkDBPointWrite> l = new ArrayList<NetworkDBPointWrite>();
        boolean leaf = false;
        for (int i = 0; i < parent.getTotalElements(); ++i) {
            Element e = es[i];
            if (e.getElementType() != 1) {
                if (leaf) {
                    throw new IllegalStateException();
                }
                Node chNode = r.getReadNode(e.getPtr());
                List<NetworkDBPointWrite> ps = this.writeBinaryRouteTree(chNode, e.getRect(), r, writer, points, pntId);
                l.addAll(ps);
                continue;
            }
            leaf = true;
            NetworkDBPointWrite pnt = (NetworkDBPointWrite)points.get(e.getPtr());
            if (pnt.includeFlag > 0) {
                pntId[0] = pntId[0] + 1;
                pnt.localId = pnt.localId;
                l.add(pnt);
                continue;
            }
            System.out.println("Deleted point " + pnt.pnt);
        }
        if (l.size() > 0 && leaf) {
            writer.writeHHRoutePoints(l);
        }
        writer.endRouteTreeElement();
        return l;
    }

    private static class AugmentObfTask
    implements Callable<String> {
        private static ThreadLocal<TLongObjectHashMap<NetworkDBPointWrite>> context = new ThreadLocal();
        private static ThreadLocal<List<NetworkDBPointWrite>> contextList = new ThreadLocal();
        private File outFile;
        private QuadRect bbox31;
        private TLongArrayList filteredPoints;
        private HHRoutingOBFWriter writer;

        public AugmentObfTask(HHRoutingOBFWriter writer, File outFile, QuadRect bbox31, TLongArrayList filteredPoints) {
            this.writer = writer;
            this.outFile = outFile;
            this.bbox31 = bbox31;
            this.filteredPoints = filteredPoints;
        }

        @Override
        public String call() throws Exception {
            TLongObjectHashMap<NetworkDBPointWrite> ctxPoints = context.get();
            List<NetworkDBPointWrite> ctxPointsList = contextList.get();
            if (ctxPoints == null || ctxPoints.size() != this.writer.points.size() || ctxPointsList == null || ctxPointsList.size() != this.writer.points.size()) {
                ctxPoints = HHRoutingOBFWriter.convertPoints(this.writer.points);
                ctxPointsList = HHRoutingOBFWriter.toList(ctxPoints);
                context.set(ctxPoints);
            }
            return this.writer.writeObfFileByBbox(ctxPointsList, ctxPoints, this.outFile, this.bbox31, this.filteredPoints);
        }
    }

    public static class NetworkDBPointWrite {
        public HHRouteDataStructure.NetworkDBPoint pnt;
        public int[] tagValuesInts;
        public int includeFlag;
        public int localId;

        public NetworkDBPointWrite(HHRouteDataStructure.NetworkDBPoint pnt) {
            this.pnt = pnt;
        }
    }

    private static class ValidateClusterSizeStructure {
        TLongObjectHashMap<List<NetworkDBPointWrite>> validateClusterIn = new TLongObjectHashMap();
        TLongObjectHashMap<List<NetworkDBPointWrite>> validateClusterOut = new TLongObjectHashMap();

        public ValidateClusterSizeStructure(List<NetworkDBPointWrite> points) {
            for (NetworkDBPointWrite p : points) {
                if (this.validateClusterIn.get((long)p.pnt.clusterId) == null) {
                    this.validateClusterIn.put((long)p.pnt.clusterId, new ArrayList());
                }
                if (this.validateClusterOut.get((long)p.pnt.dualPoint.clusterId) == null) {
                    this.validateClusterOut.put((long)p.pnt.dualPoint.clusterId, new ArrayList());
                }
                ((List)this.validateClusterIn.get((long)p.pnt.clusterId)).add(p);
                ((List)this.validateClusterOut.get((long)p.pnt.dualPoint.clusterId)).add(p);
            }
        }

        private void validateClusterSizeMatch(HHRoutingPreparationDB db, List<NetworkDBPointWrite> pntsList) throws SQLException, IOException {
            for (NetworkDBPointWrite p : pntsList) {
                if (p.includeFlag != 1) continue;
                byte[][] res = new byte[2][];
                db.loadSegmentPointInternalSync(p.pnt.index, 0, res);
                int sizeIn = 0;
                int sizeOut = 0;
                ByteArrayInputStream str = new ByteArrayInputStream(res[0]);
                while (str.available() > 0) {
                    CodedInputStream.readRawVarint32((InputStream)str);
                    ++sizeIn;
                }
                str = new ByteArrayInputStream(res[1]);
                while (str.available() > 0) {
                    CodedInputStream.readRawVarint32((InputStream)str);
                    ++sizeOut;
                }
                int sizeTIn = 0;
                int sizeTOut = 0;
                for (NetworkDBPointWrite l : (List)this.validateClusterIn.get((long)p.pnt.clusterId)) {
                    if (l.includeFlag > 0) {
                        ++sizeTIn;
                        continue;
                    }
                    throw new IllegalStateException(String.format("Into %s <- %s is missing", p, l));
                }
                for (NetworkDBPointWrite l : (List)this.validateClusterOut.get((long)p.pnt.dualPoint.clusterId)) {
                    if (l.includeFlag > 0) {
                        ++sizeTOut;
                        continue;
                    }
                    throw new IllegalStateException(String.format("From %s -> %s is missing", p, l));
                }
                if (sizeTIn == sizeIn && sizeOut == sizeTOut) continue;
                throw new IllegalArgumentException(String.format("Point [%d] %d  in %d>=%d out %d>=%d\n ", p.includeFlag, p.pnt.index, sizeIn, sizeTIn, sizeOut, sizeTOut));
            }
        }
    }
}

