/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.render;

import gnu.trove.list.array.TIntArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.osmand.NativeJavaRendering;
import net.osmand.binary.MapZooms;
import net.osmand.map.TileSourceManager;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class OsmAndTestStyleRenderer {
    public static void main(String[] args) throws Exception {
        OsmAndTestStyleRendererParams pms = new OsmAndTestStyleRendererParams();
        for (String a : args) {
            Object s;
            if ((a = a.trim()).startsWith("-native=")) {
                pms.nativeLib = a.substring("-native=".length());
                continue;
            }
            if (a.startsWith("-fonts=")) {
                pms.fontsFolder = a.substring("-fonts=".length());
                continue;
            }
            if (a.startsWith("-obf=")) {
                pms.obf = new File(a.substring("-obf=".length()));
                continue;
            }
            if (a.equals("-overwrite")) {
                pms.overwrite = true;
                continue;
            }
            if (a.startsWith("-part=")) {
                s = a.substring("-part=".length()).split("/");
                pms.partTotal = Integer.parseInt(s[0]) - 1;
                pms.total = Integer.parseInt(s[1]);
                continue;
            }
            if (a.startsWith("-bbox=")) {
                String[] bbox = a.substring("-bbox=".length()).split(",");
                pms.leftLon = Double.parseDouble(bbox[0]);
                pms.bottomLat = Double.parseDouble(bbox[1]);
                pms.rightLon = Double.parseDouble(bbox[2]);
                pms.topLat = Double.parseDouble(bbox[3]);
                continue;
            }
            if (a.startsWith("-zoom=")) {
                s = a.substring("-zoom=".length());
                pms.zooms = MapZooms.parseZooms((String)s);
                continue;
            }
            if (a.startsWith("-output=")) {
                pms.outputDir = new File(a.substring("-output=".length()));
                pms.outputDir.mkdirs();
                continue;
            }
            if (a.startsWith("-raster=")) {
                pms.tilesource.add(TileSourceGenTemplate.raster(a.substring("-raster=".length())));
                continue;
            }
            if (!a.startsWith("-vector=")) continue;
            pms.tilesource.add(TileSourceGenTemplate.vector(a.substring("-vector=".length())));
        }
        if (pms.tilesource.size() == 0) {
            pms.tilesource.add(TileSourceGenTemplate.echo("https://tile.osmand.net/hd/{z}/{x}/{y}.png"));
        }
        if (pms.zooms == null) {
            System.out.println("Please specify --zoom");
            return;
        }
        if (pms.leftLon == pms.rightLon || pms.topLat == pms.bottomLat) {
            System.out.println("Please specify --bbox in format 'leftlon,bottomlat,rightlon,toplat'");
            return;
        }
        pms.nsr = NativeJavaRendering.getDefault(pms.nativeLib, null, pms.fontsFolder);
        if (pms.nsr != null && pms.obf != null) {
            if (pms.obf.isFile()) {
                pms.nsr.initMapFile(pms.obf.getAbsolutePath(), true);
            } else {
                pms.nsr.initFilesInDir(pms.obf);
            }
        }
        TIntArrayList zooms = new TIntArrayList();
        for (int k = 0; k < pms.zooms.getLevels().size(); ++k) {
            for (int z = pms.zooms.getLevel(k).getMinZoom(); z <= pms.zooms.getLevel(k).getMaxZoom(); ++z) {
                zooms.add(z);
            }
        }
        for (int z : zooms.toArray()) {
            int leftx = (int)Math.floor(MapUtils.getTileNumberX((float)z, (double)pms.leftLon));
            int rightx = (int)Math.ceil(MapUtils.getTileNumberX((float)z, (double)pms.rightLon));
            int topY = (int)Math.floor(MapUtils.getTileNumberY((float)z, (double)pms.topLat));
            int bottomY = (int)Math.ceil(MapUtils.getTileNumberY((float)z, (double)pms.bottomLat));
            int cnt = (rightx - leftx + 1) * (bottomY - topY + 1);
            int ind = 0;
            if (pms.total == 1) {
                System.out.printf("Generating %d tiles zoom %d ...\n", cnt, z);
            } else {
                System.out.printf("Generating %d tiles zoom %d - part %d / %d ...\n", cnt /= pms.total, z, pms.partTotal + 1, pms.total);
            }
            for (int x = leftx; x <= rightx; ++x) {
                for (int y = topY; y <= bottomY; ++y) {
                    if (!pms.overwrite && pms.total > 1 && (x + y + z) % pms.total != pms.partTotal) continue;
                    System.out.printf("Generating  %.2f%% (%d / %d tiles) %d/%d/%d...\n", (double)(++ind) * 100.0 / (double)cnt, ind, cnt, z, x, y);
                    OsmAndTestStyleRenderer.downloadTiles(x, y, z, pms);
                }
            }
        }
    }

    private static void downloadTiles(int x, int y, int zoom, OsmAndTestStyleRendererParams pms) throws Exception {
        int ind = 0;
        File outFile = null;
        File txtFile = null;
        try {
            for (TileSourceGenTemplate t : pms.tilesource) {
                Object suffix = t.suffix == null ? "" + ++ind : t.suffix;
                String textTileExt = t.textTile == null ? null : t.textTile;
                String ext = t.getExt();
                outFile = new File(pms.outputDir, OsmAndTestStyleRenderer.formatTile(zoom, x, y, (String)suffix, ext));
                outFile.getParentFile().mkdirs();
                if (outFile.exists() && !pms.overwrite) continue;
                if (textTileExt != null) {
                    txtFile = new File(pms.outputDir, OsmAndTestStyleRenderer.formatTile(zoom, x, y, (String)suffix, textTileExt));
                    System.out.println("  Save text to tile " + txtFile.getName());
                } else {
                    txtFile = null;
                }
                if (t.vector) {
                    NativeJavaRendering.RenderingImageContext ctx = new NativeJavaRendering.RenderingImageContext(MapUtils.getLatitudeFromTile((float)zoom, (double)((double)y + 0.5)), MapUtils.getLongitudeFromTile((double)zoom, (double)((double)x + 0.5)), t.vectorSize, t.vectorSize, zoom, t.vectorSize / 256);
                    String props = "density=1";
                    if (!Algorithms.stringsEqual((String)t.vectorStyle, (String)pms.selectedVectorStyle)) {
                        pms.nsr.loadRuleStorage(t.vectorStyle, props);
                        pms.selectedVectorStyle = t.vectorStyle;
                    } else {
                        pms.nsr.setRenderingProps(props);
                    }
                    if (txtFile != null) {
                        ctx.saveTextTile = true;
                    }
                    BufferedImage img = pms.nsr.renderImage(ctx).getImage();
                    ImageIO.write((RenderedImage)img, ext, outFile);
                    if (txtFile == null || Algorithms.isEmpty((CharSequence)ctx.context.textTile)) continue;
                    FileWriter fr = new FileWriter(txtFile);
                    fr.write(ctx.context.textTile);
                    fr.close();
                    continue;
                }
                String template = TileSourceManager.TileSourceTemplate.normalizeUrl((String)t.url);
                int bingQuadKeyParamIndex = template.indexOf("{q}");
                if (bingQuadKeyParamIndex != -1) {
                    template = template.replace("{q}", TileSourceManager.TileSourceTemplate.eqtBingQuadKey((int)zoom, (int)x, (int)y));
                }
                String tileUrl = MessageFormat.format(template, "" + zoom, "" + x, "" + y);
                System.out.println("  Downloading " + tileUrl + " ...");
                if (!t.isFile() || pms.outputDir == null) continue;
                URL url = new URL(tileUrl);
                URLConnection cn = url.openConnection();
                FileOutputStream fous = new FileOutputStream(outFile);
                Algorithms.streamCopy((InputStream)cn.getInputStream(), (OutputStream)fous);
                fous.close();
            }
        }
        catch (Exception e) {
            System.err.printf("Error dealing with tile %s \n", outFile != null ? outFile.getAbsolutePath() : zoom + "/" + x + "/" + y);
            throw e;
        }
    }

    private static String formatTile(int zoom, int x, int y, String suffix, String ext) {
        return String.format("%d/%d/%d_%s.%s", zoom, x, y, suffix, ext);
    }

    private static class OsmAndTestStyleRendererParams {
        double topLat = 0.0;
        double leftLon = 0.0;
        double bottomLat = 0.0;
        double rightLon = 0.0;
        boolean overwrite = false;
        MapZooms zooms;
        int partTotal = 1;
        int total = 1;
        String nativeLib = null;
        String fontsFolder;
        File obf = null;
        File outputDir = null;
        List<TileSourceGenTemplate> tilesource = new ArrayList<TileSourceGenTemplate>();
        NativeJavaRendering nsr;
        String selectedVectorStyle = "";

        private OsmAndTestStyleRendererParams() {
        }
    }

    protected static class TileSourceGenTemplate {
        String url = null;
        boolean echo = false;
        boolean vector = false;
        String vectorStyle = "";
        int vectorSize = 256;
        String suffix;
        String textTile;

        protected TileSourceGenTemplate() {
        }

        public static TileSourceGenTemplate raster(String rasterTemplate) {
            TileSourceGenTemplate t = new TileSourceGenTemplate();
            Map<String, String> params = TileSourceGenTemplate.getParams(rasterTemplate);
            t.url = params.get("url");
            t.suffix = params.get("suffix");
            return t;
        }

        public static TileSourceGenTemplate echo(String rasterTemplate) {
            TileSourceGenTemplate t = new TileSourceGenTemplate();
            Map<String, String> params = TileSourceGenTemplate.getParams(rasterTemplate);
            t.url = params.get("url");
            t.suffix = params.get("suffix");
            t.echo = true;
            return t;
        }

        public static TileSourceGenTemplate vector(String input) {
            TileSourceGenTemplate t = new TileSourceGenTemplate();
            Map<String, String> params = TileSourceGenTemplate.getParams(input);
            t.vector = true;
            t.vectorStyle = params.get("style");
            t.suffix = params.get("suffix");
            t.textTile = params.get("text");
            if (params.containsKey("size")) {
                t.vectorSize = Integer.parseInt(params.get("size"));
            }
            return t;
        }

        private static Map<String, String> getParams(String input) {
            HashMap<String, String> parms = new HashMap<String, String>();
            for (String a : input.split("::")) {
                int indexOf = a.indexOf("-");
                if (indexOf <= 0) continue;
                parms.put(a.substring(0, indexOf), a.substring(indexOf + 1));
            }
            return parms;
        }

        public boolean isFile() {
            return !this.echo;
        }

        public String getExt() {
            if (this.vector) {
                return "png";
            }
            String ext = this.url.substring(this.url.lastIndexOf(46) + 1);
            if (ext.indexOf("?") != -1) {
                ext = ext.substring(0, ext.indexOf(63));
            }
            return ext;
        }
    }
}

