/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.util.Algorithms;

public class RelationTagsPropagation {
    static final String SPLIT_VALUE = "SPLITVL";
    private static final String RELATION_SORT_TAG = "relation_sort:";
    private Map<Entity.EntityId, PropagateEntityTags> propogatedTags = new LinkedHashMap<Entity.EntityId, PropagateEntityTags>();

    private Map<String, String> processNameTags(Map<String, String> relationTags, MapRenderingTypesEncoder renderingTypes, Map<String, String> relationNameTags, Map<String, String> relationNames, MapRenderingTypesEncoder.EntityConvertApplyType at) {
        if (relationNames != null) {
            for (Map.Entry<String, String> e : relationNames.entrySet()) {
                String sourceTag = e.getKey();
                String targetTag = e.getValue();
                String vl = relationTags.get(sourceTag);
                if (Algorithms.isEmpty((CharSequence)vl)) continue;
                MapRenderingTypes.MapRulType rt = renderingTypes.getRuleType(sourceTag, null, at);
                if (rt != null) {
                    renderingTypes.checkOrCreateTextRule(targetTag, rt);
                }
                relationNameTags.put(targetTag, vl);
            }
        }
        return relationNameTags;
    }

    private List<RelationRulePropagation> processRelationTags(MapRenderingTypesEncoder renderingTypes, Map<String, String> relationTags, MapRenderingTypesEncoder.EntityConvertApplyType at) {
        ArrayList<RelationRulePropagation> res = null;
        for (Map.Entry<String, String> ev : relationTags.entrySet()) {
            String value;
            String key = ev.getKey();
            MapRenderingTypes.MapRulType rule = renderingTypes.getRuleType(key, value = ev.getValue(), false, false);
            if (rule == null || !rule.relation && !rule.relationGroup) continue;
            RelationRulePropagation rrp = new RelationRulePropagation();
            if (res == null) {
                res = new ArrayList<RelationRulePropagation>();
            }
            res.add(rrp);
            if (rule.relation) {
                rrp.relationAdditionalTags.put(key, value);
                rrp.relationGroupKeyString = key;
                rrp.relationGroupValueString = value;
                this.processNameTags(relationTags, renderingTypes, rrp.relationNameTags, rule.relationNames, at);
                continue;
            }
            if (!rule.relationGroup) continue;
            String mainTag = Algorithms.isEmpty((CharSequence)value) ? key : key + "_" + value;
            rrp.relationAdditionalTags.put(mainTag, "");
            rrp.relationGroupKeyString = mainTag;
            Object sortValue = "";
            if (rule.relationSortTags != null) {
                for (Map.Entry sortTag : rule.relationSortTags.entrySet()) {
                    String vl = relationTags.get(sortTag.getKey());
                    int index = ((List)sortTag.getValue()).indexOf(vl);
                    if (index < 0) {
                        index = ((List)sortTag.getValue()).size();
                    }
                    char ch = (char)(97 + index);
                    sortValue = (String)sortValue + ch;
                }
            }
            rrp.relationGroupValueString = sortValue;
            this.processNameTags(relationTags, renderingTypes, rrp.relationNameTags, rule.relationNames, at);
            if (rule.additionalTags != null) {
                for (Map.Entry atag : rule.additionalTags.entrySet()) {
                    MapRenderingTypes.MapRulType rt;
                    String tvalue = relationTags.get(atag.getKey());
                    if (Algorithms.isEmpty((CharSequence)tvalue) || (rt = renderingTypes.getRuleType((String)atag.getKey(), tvalue, at)) == null) continue;
                    renderingTypes.checkOrCreateAdditional((String)atag.getValue(), tvalue, rt);
                    rrp.relationAdditionalTags.put((String)atag.getValue(), tvalue);
                }
            }
            if (rule.relationGroupAdditionalTags == null && rule.relationGroupNameTags == null) continue;
            PropagateTagGroup gr = new PropagateTagGroup();
            gr.orderValue = sortValue;
            gr.groupKey = Algorithms.isEmpty((CharSequence)rule.relationGroupPrefix) ? mainTag : rule.relationGroupPrefix;
            this.processNameTags(relationTags, renderingTypes, gr.tags, rule.relationGroupNameTags, at);
            if (rule.relationGroupAdditionalTags != null) {
                for (Map.Entry atag : rule.relationGroupAdditionalTags.entrySet()) {
                    String tvalue = relationTags.get(atag.getKey());
                    if (Algorithms.isEmpty((CharSequence)tvalue)) continue;
                    gr.tags.put((String)atag.getValue(), tvalue);
                }
            }
            if (gr.tags.isEmpty()) continue;
            rrp.relationGroups.add(gr);
        }
        return res;
    }

    public void handleRelationPropogatedTags(Relation relation, MapRenderingTypesEncoder renderingTypes, OsmDbAccessorContext ctx, MapRenderingTypesEncoder.EntityConvertApplyType at) throws SQLException {
        Map<String, String> relationTags = relation.getTags();
        relationTags = renderingTypes.transformTags(relationTags, Entity.EntityType.RELATION, at);
        List<RelationRulePropagation> lst = this.processRelationTags(renderingTypes, relationTags = this.addRelationIdForRoutes(relationTags, relation), at);
        if (lst != null) {
            if (ctx != null) {
                ctx.loadEntityRelation(relation);
            }
            for (Relation.RelationMember ids : relation.getMembers()) {
                PropagateEntityTags entityTags = this.getPropogateTagForEntity(ids.getEntityId());
                for (RelationRulePropagation p : lst) {
                    String sortKey = RELATION_SORT_TAG + p.relationGroupKeyString;
                    if (!entityTags.putThroughTags.containsKey(sortKey) || p.relationGroupValueString.compareTo(entityTags.putThroughTags.get(sortKey)) < 0) {
                        entityTags.putThroughTags.put(sortKey, p.relationGroupValueString);
                        entityTags.putThroughTags.putAll(p.relationAdditionalTags);
                    }
                    if (p.relationNameTags.size() > 0) {
                        for (Map.Entry entry : p.relationNameTags.entrySet()) {
                            String key = (String)entry.getKey();
                            String oldValue = entityTags.putThroughTags.get(key);
                            String res = RelationTagsPropagation.sortAndAttachUniqueValue(oldValue, (String)entry.getValue());
                            entityTags.putThroughTags.put(key, res);
                        }
                    }
                    for (PropagateTagGroup propagateTagGroup : p.relationGroups) {
                        if (!entityTags.relationGroupTags.containsKey(propagateTagGroup.groupKey)) {
                            entityTags.relationGroupTags.put(propagateTagGroup.groupKey, new ArrayList());
                        }
                        entityTags.relationGroupTags.get(propagateTagGroup.groupKey).add(propagateTagGroup);
                    }
                }
            }
        }
    }

    public Map<String, String> addRelationIdForRoutes(Map<String, String> tags, Relation relation) {
        if (tags.containsKey(OSMSettings.OSMTagKey.ROUTE.getValue())) {
            tags = new LinkedHashMap<String, String>(tags);
            tags.put(OSMSettings.OSMTagKey.RELATION_ID.getValue(), String.valueOf(relation.getId()));
        }
        return tags;
    }

    public PropagateEntityTags getPropogateTagForEntity(Entity.EntityId entityId) {
        if (!this.propogatedTags.containsKey(entityId)) {
            this.propogatedTags.put(entityId, new PropagateEntityTags());
        }
        return this.propogatedTags.get(entityId);
    }

    public Map<String, String> addPropogatedTags(MapRenderingTypesEncoder renderingTypes, MapRenderingTypesEncoder.EntityConvertApplyType tp, Entity e, Map<String, String> tags) {
        Entity.EntityId eid = Entity.EntityId.valueOf((Entity)e);
        PropagateEntityTags proptags = this.propogatedTags.get(eid);
        if (proptags != null) {
            tags = new LinkedHashMap<String, String>(tags);
            for (Map.Entry<String, String> ts : proptags.putThroughTags.entrySet()) {
                if (tags.get(ts.getKey()) != null) continue;
                String vl = ts.getValue();
                if (vl != null) {
                    vl = vl.replaceAll(SPLIT_VALUE, ", ");
                }
                tags.put(ts.getKey(), vl);
            }
            for (List<PropagateTagGroup> groups : proptags.relationGroupTags.values()) {
                groups.sort(new Comparator<PropagateTagGroup>(){

                    @Override
                    public int compare(PropagateTagGroup o1, PropagateTagGroup o2) {
                        return o1.orderValue.compareTo(o2.orderValue);
                    }
                });
                int mod = 1;
                for (PropagateTagGroup g : groups) {
                    String groupPart = g.groupKey + "_" + mod;
                    renderingTypes.checkOrCreateAdditional(groupPart, "", null);
                    e.putTag(groupPart, "");
                    for (Map.Entry<String, String> te : g.tags.entrySet()) {
                        String targetTag = groupPart + "_" + te.getKey();
                        String targetValue = te.getValue();
                        MapRenderingTypes.MapRulType rt = renderingTypes.getRuleType(te.getKey(), targetValue, false, false);
                        if (rt != null) {
                            if (rt.isAdditional()) {
                                renderingTypes.checkOrCreateAdditional(targetTag, targetValue, rt);
                            } else {
                                renderingTypes.checkOrCreateTextRule(targetTag, rt);
                            }
                        }
                        e.putTag(targetTag, targetValue);
                    }
                    ++mod;
                }
            }
        }
        return tags;
    }

    private static String sortAndAttachUniqueValue(String list, String value) {
        if (list == null) {
            list = "";
        }
        String[] ls = list.split(SPLIT_VALUE);
        TreeSet<String> set = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int i2;
                int i1 = Algorithms.extractFirstIntegerNumber((String)s1);
                if (i1 == (i2 = Algorithms.extractFirstIntegerNumber((String)s2))) {
                    String t1 = Algorithms.extractIntegerSuffix((String)s1);
                    String t2 = Algorithms.extractIntegerSuffix((String)s2);
                    return t1.compareToIgnoreCase(t2);
                }
                return i1 - i2;
            }
        });
        set.add(value.trim());
        for (String l : ls) {
            set.add(l.trim());
        }
        Object r = "";
        for (String a : set) {
            if (((String)r).length() > 0) {
                r = (String)r + SPLIT_VALUE;
            }
            r = (String)r + a;
        }
        return r;
    }

    private static class RelationRulePropagation {
        String relationGroupKeyString;
        String relationGroupValueString;
        Map<String, String> relationNameTags = new LinkedHashMap<String, String>();
        Map<String, String> relationAdditionalTags = new LinkedHashMap<String, String>();
        List<PropagateTagGroup> relationGroups = new ArrayList<PropagateTagGroup>();

        private RelationRulePropagation() {
        }

        public String toString() {
            return String.format("%s - %s: %s %s %s", this.relationGroupKeyString, this.relationGroupValueString, this.relationNameTags, this.relationAdditionalTags, this.relationGroups);
        }
    }

    public static class PropagateTagGroup {
        public Map<String, String> tags = new LinkedHashMap<String, String>();
        public String orderValue = "";
        public String groupKey = "";

        public String toString() {
            return this.groupKey + " " + this.orderValue + " - " + this.tags;
        }
    }

    public static class PropagateEntityTags {
        public Map<String, String> putThroughTags = new LinkedHashMap<String, String>();
        public Map<String, List<PropagateTagGroup>> relationGroupTags = new LinkedHashMap<String, List<PropagateTagGroup>>();

        public String toString() {
            return this.putThroughTags + " " + this.relationGroupTags;
        }
    }
}

