/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.Map;
import net.osmand.util.Algorithms;
import org.apache.commons.lang3.ArrayUtils;

public class OsmcSymbol {
    private String waycolor = "";
    private String background = "";
    private String foreground = "";
    private String foreground2 = "";
    private String text = "";
    private String textcolor = "";

    public OsmcSymbol(String value) {
        String[] tokens = value.split(":", 6);
        tokens = this.toLowerCaseOsmcTags(tokens);
        int tokensLength = tokens.length;
        if (tokensLength > 0) {
            String string = this.waycolor = this.isColor(tokens[0]) ? tokens[0] : this.waycolor;
            if (tokensLength > 1) {
                if (this.isBackground(tokens[1])) {
                    this.background = tokens[1];
                } else if (tokens[1].isEmpty()) {
                    this.background = "white";
                } else if (this.isForeground(tokens[1])) {
                    this.foreground = tokens[1];
                }
            }
            if (tokensLength > 2) {
                int textInd = this.getTextIndex(tokens);
                this.getText(tokens, textInd);
                this.getForegrounds(tokens, textInd);
            }
            this.addTextLengthToBgAndFrg();
        }
    }

    public OsmcSymbol(String background, String text, String textcolor) {
        this.background = background;
        this.text = text;
        this.textcolor = textcolor;
        this.addTextLengthToBgAndFrg();
    }

    public void addOsmcNewTags(Map<String, String> tags) {
        if (!this.waycolor.isEmpty()) {
            tags.put("osmc_waycolor", this.waycolor);
        }
        if (!this.background.isEmpty()) {
            tags.put("osmc_background", this.background);
            tags.put("osmc_stub_name", ".");
        } else {
            if (!this.waycolor.isEmpty()) {
                tags.put("osmc_background", this.waycolor);
            } else {
                tags.put("osmc_background", "white");
            }
            tags.put("osmc_stub_name", ".");
        }
        if (!this.foreground.isEmpty()) {
            tags.put("osmc_foreground", this.foreground);
        }
        if (!this.text.isEmpty()) {
            this.text = this.text.substring(0, Math.min(this.text.length(), 7));
            tags.put("osmc_text", this.text);
            if (!this.textcolor.isEmpty()) {
                tags.put("osmc_textcolor", this.textcolor);
            }
        }
        if (!this.foreground2.isEmpty()) {
            tags.put("osmc_foreground2", this.foreground2);
        }
    }

    private void addTextLengthToBgAndFrg() {
        if (this.text.isEmpty()) {
            return;
        }
        int textLength = this.text.codePointCount(0, this.text.length());
        if ((textLength = Math.min(textLength, 4)) > 1) {
            if (!this.background.isEmpty()) {
                this.background = this.background + "_" + textLength;
            }
            if (!this.foreground.isEmpty()) {
                this.foreground = this.foreground + "_" + textLength;
            }
        }
    }

    private boolean hasForeground() {
        return !this.foreground.isEmpty();
    }

    private String[] toLowerCaseOsmcTags(String[] tokens) {
        ArrayList<String> res = new ArrayList<String>();
        for (String token : tokens) {
            if (!this.isText(token)) {
                res.add(token.toLowerCase());
                continue;
            }
            res.add(token);
        }
        return res.toArray(new String[0]);
    }

    private boolean isColor(String s) {
        return s.equals("black") || s.equals("blue") || s.equals("green") || s.equals("red") || s.equals("white") || s.equals("yellow") || s.equals("orange") || s.equals("purple") || s.equals("pink") || s.equals("teal") || s.equals("brown") || s.equals("gray");
    }

    private boolean isForeground(String s) {
        return s.equals("ammonit") || s.equals("bridleway") || s.equals("heart") || s.equals("hiker") || s.equals("mine") || s.equals("planet") || s.equals("shell") || s.equals("shell_modern") || s.equals("tower") || s.equals("wolfshook") || this.hasColorPrefix(s);
    }

    private boolean isBackground(String s) {
        return this.hasColorPrefix(s) || this.isColor(s);
    }

    private boolean hasColorPrefix(String s) {
        if (s.contains("_")) {
            String[] arr = s.split("_");
            if (arr.length == 0) {
                return false;
            }
            return this.isColor(arr[0]);
        }
        return false;
    }

    private void getText(String[] tokens, int textInd) {
        int afterTextInd = textInd + 1;
        if (textInd != -1 && afterTextInd < tokens.length && (this.isColor(tokens[afterTextInd]) || Algorithms.isEmpty((CharSequence)tokens[afterTextInd]))) {
            this.text = tokens[textInd];
            this.textcolor = tokens[afterTextInd];
        }
    }

    private boolean isText(String s) {
        if (!s.isEmpty()) {
            char first = s.charAt(0);
            return Character.isDigit(first) || Character.isUpperCase(first);
        }
        return false;
    }

    private int getTextIndex(String[] tokens) {
        for (String token : tokens) {
            if (!this.isText(token) && !this.isSpecSymbol(token.trim())) continue;
            return ArrayUtils.indexOf((Object[])tokens, (Object)token);
        }
        return -1;
    }

    private boolean isSpecSymbol(String s) {
        if (!s.isEmpty()) {
            char first = s.charAt(0);
            return !Character.isLetterOrDigit(first);
        }
        return false;
    }

    private void getForegrounds(String[] tokens, int textInd) {
        int foregroundIndex = -1;
        int foregraundIndex2 = -1;
        if (textInd != -1) {
            if (this.hasForeground()) {
                foregraundIndex2 = textInd - 1 >= 2 && this.isForeground(tokens[textInd - 1]) ? textInd - 1 : -1;
            } else if (textInd - 1 == 3 && this.isForeground(tokens[3])) {
                foregroundIndex = this.isForeground(tokens[2]) ? 2 : -1;
                foregraundIndex2 = 3;
            } else if (textInd - 1 == 2 && this.isForeground(tokens[2])) {
                foregroundIndex = 2;
            }
        } else if (this.hasForeground()) {
            foregroundIndex = ArrayUtils.indexOf((Object[])tokens, (Object)this.foreground);
            if (this.isForeground(tokens[foregroundIndex + 1])) {
                foregraundIndex2 = foregroundIndex + 1;
            }
        } else {
            int n = foregroundIndex = this.isForeground(tokens[2]) ? 2 : -1;
            if (tokens.length > 3) {
                foregraundIndex2 = this.isForeground(tokens[3]) ? 3 : -1;
            }
        }
        this.foreground = foregroundIndex != -1 ? tokens[foregroundIndex] : this.foreground;
        this.foreground2 = foregraundIndex2 != -1 ? tokens[foregraundIndex2] : this.foreground2;
    }

    public void setForeground(String foreground) {
        this.foreground = foreground;
    }

    public void setWaycolor(String waycolor) {
        this.waycolor = waycolor;
    }
}

