/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferShort;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class IndexHeightData {
    public static int MAXIMUM_LOADED_DATA = 150;
    private static final double MINIMAL_DISTANCE = 0.0;
    private static final int HEIGHT_ACCURACY = 4;
    private static boolean USE_BILINEAR_INTERPOLATION = false;
    private String srtmDataUrl;
    private File srtmWorkingDir;
    public static final String ELE_ASC_START = "osmand_ele_start";
    public static final String ELE_ASC_END = "osmand_ele_end";
    public static final String ELE_INCLINE = "osmand_ele_incline_";
    public static final String ELE_INCLINE_MAX = "osmand_ele_incline_max";
    public static final String ELE_DECLINE = "osmand_ele_decline_";
    public static final String ELE_DECLINE_MAX = "osmand_ele_decline_max";
    public static final String ELE_ASC_TAG = "osmand_ele_asc";
    public static final String ELE_DESC_TAG = "osmand_ele_desc";
    public static final double INEXISTENT_HEIGHT = Double.MIN_VALUE;
    public static final int MAX_SRTM_COUNT_DOWNLOAD = 20000;
    private int srtmCountDownload;
    public static final double MAX_LAT_LON_DIST = 500000.0;
    public static final Set<String> ELEVATION_TAGS = new TreeSet<String>();
    private Map<Integer, TileData> map = new HashMap<Integer, TileData>();
    private static final Log log;

    public boolean proccess(Way e) {
        if (!IndexHeightData.isHeightDataNeeded(e)) {
            return true;
        }
        WayHeightStats wh = new WayHeightStats();
        List ns = e.getNodes();
        double prevHeight = Double.MIN_VALUE;
        Node prev = null;
        for (int i = 0; i < ns.size(); ++i) {
            Node n = (Node)ns.get(i);
            if (n == null) continue;
            double pointHeight = this.getPointHeight(n.getLatitude(), n.getLongitude());
            if (prev == null) {
                if (pointHeight == Double.MIN_VALUE) continue;
                prevHeight = pointHeight;
                prev = n;
                continue;
            }
            if (MapUtils.getDistance((LatLon)prev.getLatLon(), (LatLon)n.getLatLon()) > 500000.0) {
                System.err.printf("Skip long line %d dist %.1f km\n", e.getId() / 64L, MapUtils.getDistance((LatLon)prev.getLatLon(), (LatLon)n.getLatLon()) / 1000.0);
                return false;
            }
            double segm = MapUtils.getDistance((double)prev.getLatitude(), (double)prev.getLongitude(), (double)n.getLatitude(), (double)n.getLongitude());
            if (!(segm > 0.0) || pointHeight == Double.MIN_VALUE) continue;
            wh.processHeight(pointHeight, prevHeight, segm, n);
            prevHeight = pointHeight;
            prev = n;
        }
        if (wh.firstHeight != Double.MIN_VALUE && wh.lastHeight != Double.MIN_VALUE) {
            e.putTag(ELE_ASC_START, "" + (int)wh.firstHeight);
        }
        if (wh.lastHeight != Double.MIN_VALUE && wh.firstHeight != wh.lastHeight) {
            e.putTag(ELE_ASC_END, "" + (int)wh.lastHeight);
        }
        return true;
    }

    public static boolean isHeightDataNeeded(Way e) {
        if (e.getTag("highway") == null && e.getTag("cycleway") == null && e.getTag("footway") == null && e.getTag("waterway") == null && e.getTag("piste:type") == null) {
            return false;
        }
        if (e.getTag("osmand_change") != null) {
            return false;
        }
        return e.getTag("tunnel") == null && e.getTag("bridge") == null;
    }

    public WayGeneralStats calculateWayGeneralStats(Way w, double DIST_STEP) {
        Node pnode = null;
        WayGeneralStats wg = new WayGeneralStats();
        int I_DIST_STEP = (int)DIST_STEP;
        double dist = 0.0;
        for (int i = 0; i < w.getNodes().size(); ++i) {
            Node node = (Node)w.getNodes().get(i);
            double step = 0.0;
            if (i > 0) {
                step = MapUtils.getDistance((double)pnode.getLatitude(), (double)pnode.getLongitude(), (double)node.getLatitude(), (double)node.getLongitude());
            }
            double h = this.getPointHeight(node.getLatitude(), node.getLongitude());
            if (step > (double)I_DIST_STEP) {
                int extraFragments = (int)(step / DIST_STEP);
                for (int st = 1; st < extraFragments; ++st) {
                    double midlat = pnode.getLatitude() + (node.getLatitude() - pnode.getLatitude()) * (double)st / (double)extraFragments;
                    double midlon = pnode.getLongitude() + (node.getLongitude() - pnode.getLongitude()) * (double)st / (double)extraFragments;
                    double midh = this.getPointHeight(midlat, midlon);
                    double d = MapUtils.getDistance((double)pnode.getLatitude(), (double)pnode.getLongitude(), (double)midlat, (double)midlon);
                    wg.dists.add(dist + d);
                    wg.altitudes.add(midh);
                }
            }
            wg.dists.add(dist += step);
            wg.altitudes.add(h);
            pnode = node;
        }
        IndexHeightData.calculateEleStats(wg, I_DIST_STEP);
        return wg;
    }

    public static void calculateEleStats(WayGeneralStats wg, int DIST_STEP) {
        wg.step = DIST_STEP;
        wg.dist = wg.dists.get(wg.dists.size() - 1);
        double prevUpDownDist = 0.0;
        double prevUpDownH = 0.0;
        double prevGraphDist = 0.0;
        double prevGraphH = 0.0;
        for (int i = 0; i < wg.dists.size(); ++i) {
            double h = wg.altitudes.get(i);
            double sumdist = wg.dists.get(i);
            if (h == Double.MIN_VALUE) continue;
            wg.endEle = h;
            if (wg.eleCount == 0) {
                wg.maxEle = wg.sumEle = h;
                wg.minEle = wg.sumEle;
                wg.startEle = wg.sumEle;
                prevUpDownH = wg.sumEle;
                prevGraphH = wg.sumEle;
                wg.eleCount = 1;
            } else {
                wg.minEle = Math.min(h, wg.minEle);
                wg.maxEle = Math.max(h, wg.maxEle);
                wg.sumEle += h;
                ++wg.eleCount;
            }
            if (sumdist >= prevUpDownDist + (double)DIST_STEP) {
                if (h > prevUpDownH) {
                    wg.up += h - prevUpDownH;
                } else {
                    wg.down += prevUpDownH - h;
                }
                prevUpDownDist = sumdist;
                prevUpDownH = h;
            }
            while (sumdist >= prevGraphDist + (double)DIST_STEP) {
                wg.altIncs.add((int)(h - prevGraphH));
                prevGraphH = h;
                prevGraphDist += (double)DIST_STEP;
            }
        }
    }

    public void setSrtmData(String srtmData, File workingDir) {
        this.srtmDataUrl = srtmData;
        this.srtmWorkingDir = workingDir;
    }

    public double getPointHeight(double lat, double lon) {
        return this.getPointHeight(lat, lon, null, null);
    }

    public double getPointHeight(double lat, double lon, File[] fileName) {
        return this.getPointHeight(lat, lon, fileName, null);
    }

    private double getPointHeight(double lat, double lon, File[] fileName, double[] neighboors) {
        int id;
        TileData tileData;
        int lt = (int)lat;
        int ln = (int)lon;
        double lonDelta = lon - (double)ln;
        double latDelta = lat - (double)lt;
        if (lonDelta < 0.0) {
            lonDelta += 1.0;
            --ln;
        }
        if (latDelta < 0.0) {
            latDelta += 1.0;
            --lt;
        }
        if ((tileData = this.map.get(id = IndexHeightData.getTileId(lt, ln))) == null) {
            tileData = new TileData(id);
            this.map.put(id, tileData);
        }
        if (!tileData.dataLoaded) {
            this.gcTiles();
            try {
                ++tileData.loaded;
                log.info((Object)String.format("SRTM: Load srtm data %d: %d %d", id, lt, ln));
                File missingFile = tileData.loadData(this.srtmDataUrl, this.srtmWorkingDir);
                if (fileName != null && fileName.length > 0) {
                    fileName[0] = missingFile;
                }
                ++this.srtmCountDownload;
                if (this.srtmCountDownload > 20000) {
                    throw new RuntimeException("Max count of download SRTM data 20000");
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        ++tileData.accessed;
        return tileData.getHeight(lonDelta, latDelta, neighboors);
    }

    private void gcTiles() {
        ArrayList<TileData> lst = new ArrayList<TileData>(this.map.values());
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            if (((TileData)it.next()).data != null) continue;
            it.remove();
        }
        if (MAXIMUM_LOADED_DATA != -1 && lst.size() >= MAXIMUM_LOADED_DATA) {
            int toGC = MAXIMUM_LOADED_DATA / 2;
            log.info((Object)String.format("SRTM: GC srtm data %d of %d (total %d).", toGC, lst.size(), this.map.size()));
            Collections.sort(lst, new Comparator<TileData>(){

                @Override
                public int compare(TileData o1, TileData o2) {
                    return -Integer.compare(o1.accessed + 100 * o1.loaded, o2.accessed + 100 * o2.loaded);
                }
            });
            for (int i = 0; i < lst.size(); ++i) {
                TileData tile = (TileData)lst.get(i);
                if (i > toGC) {
                    tile.dataLoaded = false;
                    tile.data = null;
                }
                tile.accessed = 0;
            }
            System.gc();
        }
    }

    private static File loadFile(String fl, String folderURL, File workDir) {
        if (folderURL.startsWith("http://") || folderURL.startsWith("https://")) {
            File res = new File(workDir, fl);
            try {
                InputStream is = new URL(folderURL + fl).openStream();
                FileOutputStream fous = new FileOutputStream(res);
                Algorithms.streamCopy((InputStream)is, (OutputStream)fous);
                is.close();
                fous.close();
            }
            catch (IOException | RuntimeException e) {
                log.warn((Object)String.format("Couldn't access height data %s at %s: %s", fl, folderURL, e.getMessage()), (Throwable)e);
            }
            return res;
        }
        if (folderURL.startsWith("s3://")) {
            String url = folderURL.substring("s3://".length()) + fl;
            File res = new File(workDir, fl);
            int i = url.indexOf(47);
            String bucket = url.substring(0, i);
            String key = url.substring(i + 1);
            try {
                S3Client client = (S3Client)S3Client.builder().build();
                GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(key).build();
                ResponseInputStream obj = client.getObject(request);
                FileOutputStream fous = new FileOutputStream(res);
                Algorithms.streamCopy((InputStream)obj, (OutputStream)fous);
                obj.close();
                fous.close();
            }
            catch (IOException | RuntimeException e) {
                log.warn((Object)String.format("Couldn't access height data %s at %s: %s", fl, folderURL, e.getMessage()), (Throwable)e);
            }
            return res;
        }
        return new File(folderURL, fl);
    }

    public static int getTileId(int lat, int lon) {
        int ln = lon + 180;
        int lt = lat + 90;
        int ind = lt + (ln << 10);
        return ind;
    }

    public static void test(double lat, double lon) {
        int lt = (int)lat;
        int ln = (int)lon;
        double lonDelta = lon - (double)ln;
        double latDelta = lat - (double)lt;
        if (lonDelta < 0.0) {
            lonDelta += 1.0;
            --ln;
        }
        if (latDelta < 0.0) {
            latDelta += 1.0;
            --lt;
        }
        int id = IndexHeightData.getTileId(lt, ln);
        TileData td = new TileData(id);
        System.out.println(lat + " " + lon + " (lat/lon) -> file " + td.getFileName() + " (y, x in %) " + (float)latDelta + " " + (float)lonDelta);
    }

    public static void main(String[] args) throws XmlPullParserException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        IndexHeightData hd = new IndexHeightData();
        hd.setSrtmData("/Users/victorshcherb/osmand/maps/srtm/", null);
        Polygon plg = IndexHeightData.testFileSmoothness(hd);
        long tms = System.currentTimeMillis();
        List<Geometry> lst = IndexHeightData.generateGridPrecision(plg, 2.7, hd);
        System.out.println(System.currentTimeMillis() - tms + " ms");
        IndexHeightData.draw(plg, lst);
    }

    protected static Polygon testFileSmoothness(IndexHeightData hd) throws XmlPullParserException, IOException {
        int next;
        File fl = new File("/Users/victorshcherb/osmand/route.gpx");
        ArrayList<Coordinate> res = new ArrayList<Coordinate>();
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        parser.setInput((Reader)new FileReader(fl));
        ArrayList<LatLon> l = new ArrayList<LatLon>();
        ArrayList<Float> h = new ArrayList<Float>();
        double ele = 0.0;
        double SPECIAL_VALUE = -18000.0;
        double ROUTE_PRECISION = 150.0;
        String name = null;
        while ((next = parser.next()) != 1) {
            if (next == 2) {
                if (parser.getName().equals("trkpt")) {
                    ele = SPECIAL_VALUE;
                    LatLon ls = new LatLon((double)Float.parseFloat(parser.getAttributeValue("", "lat")), (double)Float.parseFloat(parser.getAttributeValue("", "lon")));
                    l.add(ls);
                }
                name = parser.getName();
                continue;
            }
            if (next == 4) {
                if (!name.equals("ele") || ele != SPECIAL_VALUE) continue;
                ele = Double.parseDouble(parser.getText());
                h.add(Float.valueOf((float)ele));
                continue;
            }
            if (next != 3 || !parser.getName().equals("trkpt") || ele != SPECIAL_VALUE) continue;
            h.add(Float.valueOf(0.0f));
        }
        float d = 0.0f;
        int pnt = 0;
        for (int i = 0; i < l.size(); ++i) {
            if (i == 0) {
                Coordinate c = new Coordinate(((LatLon)l.get(i)).getLongitude(), ((LatLon)l.get(i)).getLatitude());
                res.add(c);
                System.out.println("0 " + h.get(0) + " ");
                continue;
            }
            LatLon nxt = (LatLon)l.get(i);
            LatLon prv = (LatLon)l.get(i - 1);
            double dist = MapUtils.getDistance((LatLon)prv, (LatLon)nxt);
            int cf = 1;
            while (dist / (double)cf > ROUTE_PRECISION) {
                cf *= 2;
            }
            double plat = prv.getLatitude();
            double plon = prv.getLongitude();
            for (int j = 0; j < cf; ++j) {
                double nlat = (nxt.getLatitude() - prv.getLatitude()) / (double)cf + plat;
                double nlon = (nxt.getLongitude() - prv.getLongitude()) / (double)cf + plon;
                d = (float)((double)d + MapUtils.getDistance((double)plat, (double)plon, (double)nlat, (double)nlon));
                Coordinate c = new Coordinate(nlon, nlat);
                res.add(c);
                USE_BILINEAR_INTERPOLATION = true;
                double blh = hd.getPointHeight(nlat, nlon, null);
                USE_BILINEAR_INTERPOLATION = false;
                double bch = hd.getPointHeight(nlat, nlon, null);
                System.out.println(String.format("%d %.6f %.6f %.2f %.2f", pnt++, nlat, nlon, Float.valueOf(d), bch, blh));
                plat = nlat;
                plon = nlon;
            }
        }
        Polygon polygon = new GeometryFactory().createPolygon(res.toArray(new Coordinate[res.size()]));
        return polygon;
    }

    private static List<Geometry> generateGridPrecision(Polygon plg, double precision, IndexHeightData hd) {
        Envelope e = plg.getEnvelopeInternal();
        GeometryFactory factory = plg.getFactory();
        int pw = (int)Math.pow(10.0, precision);
        int top = (int)Math.ceil(e.getMaxY() * (double)pw);
        int bottom = (int)Math.floor(e.getMinY() * (double)pw);
        int left = (int)Math.floor(e.getMinX() * (double)pw);
        int right = (int)Math.ceil(e.getMaxX() * (double)pw);
        System.out.println(String.format("Width %d, height %d, Top %.5f, bottom %.5f, left %.5f, right %.5f", right - left, top - bottom, e.getMaxY(), e.getMinY(), e.getMinX(), e.getMaxX()));
        for (int x = left; x <= right; ++x) {
            for (int y = top; y >= bottom; --y) {
                double nlon = (double)x / ((double)pw * 1.0);
                double nlat = (double)y / ((double)pw * 1.0);
                String fmt = "%." + (int)Math.ceil(precision) + "f";
                System.out.println(String.format(fmt + " " + fmt + " %.2f", nlat, nlon, hd.getPointHeight(nlat, nlon, null)));
            }
        }
        ArrayList<Geometry> r = new ArrayList<Geometry>();
        int numVertices = 0;
        int numPolygons = 0;
        for (int x = left; x < right; ++x) {
            for (int y = top; y > bottom; --y) {
                for (int tr = 0; tr < 4; ++tr) {
                    Polygon gridCell = IndexHeightData.genCellTriangle(factory, pw, x, y, tr);
                    if (gridCell.coveredBy((Geometry)plg)) {
                        r.add((Geometry)gridCell);
                        ++numVertices;
                        ++numPolygons;
                        continue;
                    }
                    Geometry intersection = gridCell.intersection((Geometry)plg);
                    r.add(intersection);
                    if (intersection.getNumPoints() < 3) continue;
                    numVertices += intersection.getNumPoints() - 2;
                    ++numPolygons;
                }
            }
        }
        System.out.println("Polygons " + numPolygons + " Min triangles " + numVertices);
        return r;
    }

    protected static Polygon genCellTriangle(GeometryFactory factory, int pw, int x, int y, int ind) {
        ArrayList<Coordinate> ln = new ArrayList<Coordinate>();
        ln.add(new Coordinate(((double)x + 0.5) / ((double)pw * 1.0), ((double)y - 0.5) / ((double)pw * 1.0)));
        ln.add(new Coordinate((double)(x + (ind % 2 == 0 ? 0 : (ind == 1 ? 1 : 0))) / ((double)pw * 1.0), (double)(y - (ind % 2 == 1 ? 0 : (ind == 0 ? 0 : 1))) / ((double)pw * 1.0)));
        ln.add(new Coordinate((double)(x + (ind % 2 == 0 ? 1 : (ind == 1 ? 1 : 0))) / ((double)pw * 1.0), (double)(y - (ind % 2 == 1 ? 1 : (ind == 0 ? 0 : 1))) / ((double)pw * 1.0)));
        ln.add(new Coordinate(((double)x + 0.5) / ((double)pw * 1.0), ((double)y - 0.5) / ((double)pw * 1.0)));
        Polygon gridCell = factory.createPolygon(ln.toArray(new Coordinate[ln.size()]));
        return gridCell;
    }

    protected static Polygon genCell(GeometryFactory factory, int pw, int x, int y) {
        ArrayList<Coordinate> ln = new ArrayList<Coordinate>();
        ln.add(new Coordinate((double)x / ((double)pw * 1.0), (double)y / ((double)pw * 1.0)));
        ln.add(new Coordinate((double)(x + 1) / ((double)pw * 1.0), (double)y / ((double)pw * 1.0)));
        ln.add(new Coordinate((double)(x + 1) / ((double)pw * 1.0), (double)(y - 1) / ((double)pw * 1.0)));
        ln.add(new Coordinate((double)x / ((double)pw * 1.0), (double)(y - 1) / ((double)pw * 1.0)));
        ln.add(new Coordinate((double)x / ((double)pw * 1.0), (double)y / ((double)pw * 1.0)));
        Polygon gridCell = factory.createPolygon(ln.toArray(new Coordinate[ln.size()]));
        return gridCell;
    }

    protected static void simpleTestHeight(IndexHeightData hd) {
        IndexHeightData.cmp(hd, 44.428722, 33.711246, 255.0);
    }

    protected static void testHeight(IndexHeightData hd) {
        IndexHeightData.cmp(hd, 48.57522, 45.72296, -3.0);
        IndexHeightData.cmp(hd, 56.18137, 40.50929, 116.0);
        IndexHeightData.cmp(hd, 44.3992045, 33.9498114, 129.1);
        IndexHeightData.cmp(hd, 56.17828284774868, 40.5031156539917, 116.0);
        IndexHeightData.cmp(hd, 46.0, 9.0, 272.0);
        IndexHeightData.cmp(hd, 46.0, 9.99999, 1748.0);
        IndexHeightData.cmp(hd, 46.999999, 9.999999, 1121.0);
        IndexHeightData.cmp(hd, 46.999999, 9.0, 2834.0);
        IndexHeightData.cmp(hd, 46.0, 9.5, 1822.0);
        IndexHeightData.cmp(hd, 46.99999, 9.5, 531.0);
        IndexHeightData.cmp(hd, 46.05321, 9.94346, 1515.0);
        IndexHeightData.cmp(hd, 46.735, 9.287, 2311.3);
        IndexHeightData.cmp(hd, 46.291, 9.297, 1646.9);
        IndexHeightData.cmp(hd, 46.793, 9.878, 2174.2);
        IndexHeightData.cmp(hd, 46.774, 9.888, 1985.7);
        IndexHeightData.cmp(hd, 46.5, 9.5, 2436.0);
        IndexHeightData.cmp(hd, 46.1, 9.0, 1441.0);
        IndexHeightData.cmp(hd, 46.7, 9.0, 2303.0);
    }

    private static void cmp(IndexHeightData hd, double lat, double lon, double exp) {
        double[] nh = new double[16];
        double pointHeight = hd.getPointHeight(lat, lon, null, nh);
        System.out.println("Lat " + lat + " lon " + lon);
        if (pointHeight != exp) {
            String extra = " NO NEIGHBOR FOUND " + Arrays.toString(nh);
            for (int k = 0; k < 9; ++k) {
                if (nh[k] != exp) continue;
                extra = " neighbor (" + (k / 3 - 1) + " y, " + (k % 3 - 1) + " x) ";
            }
            System.out.println(pointHeight + " (eval) != " + exp + " (exp) - " + extra);
        } else {
            System.out.println(pointHeight + " (eval) == " + exp + " (exp) ");
        }
        System.out.println("----------");
    }

    private static void draw(Polygon plg, List<Geometry> gothers) {
        int WIDTH = 1200;
        int HEIGHT = 800;
        int MARGIN = 250;
        AffineTransformation affine = new AffineTransformation();
        Envelope e = plg.getEnvelopeInternal();
        affine.translate(-e.getMinX(), -e.getMaxY());
        affine.scale((double)(WIDTH - MARGIN) / e.getWidth(), (double)(HEIGHT - MARGIN) / e.getHeight());
        affine.reflect(1.0, 0.0);
        affine.translate((double)(MARGIN / 2), (double)(MARGIN / 2));
        ShapeWriter sw = new ShapeWriter();
        Shape[] finalShapes = new Shape[1 + (gothers == null ? 0 : gothers.size())];
        int ind = 0;
        finalShapes[ind++] = sw.toShape(affine.transform((Geometry)plg));
        if (gothers != null) {
            for (Geometry g : gothers) {
                finalShapes[ind++] = sw.toShape(affine.transform(g));
            }
        }
    }

    static {
        ELEVATION_TAGS.add(ELE_ASC_START);
        ELEVATION_TAGS.add(ELE_ASC_END);
        ELEVATION_TAGS.add(ELE_INCLINE);
        ELEVATION_TAGS.add(ELE_INCLINE_MAX);
        ELEVATION_TAGS.add(ELE_DECLINE);
        ELEVATION_TAGS.add(ELE_DECLINE_MAX);
        ELEVATION_TAGS.add(ELE_ASC_TAG);
        ELEVATION_TAGS.add(ELE_DESC_TAG);
        log = PlatformUtil.getLog(IndexHeightData.class);
    }

    private class WayHeightStats {
        double firstHeight = Double.MIN_VALUE;
        double lastHeight = Double.MIN_VALUE;
        int DEGREE_START = 1;
        int DEGREE_PRECISION = 2;
        int DEGREE_MAX = 30;
        int SIZE = (this.DEGREE_MAX - this.DEGREE_START) / this.DEGREE_PRECISION;
        double[] ascIncline = new double[this.SIZE];
        double[] descIncline = new double[this.SIZE];

        private WayHeightStats() {
        }

        float processHeight(double pointHeight, double prevHeight, double dist, Node n) {
            double[] arr;
            if (this.firstHeight == Double.MIN_VALUE) {
                this.firstHeight = prevHeight;
            }
            this.lastHeight = pointHeight;
            double diff = pointHeight - prevHeight;
            int df = (int)Math.round(diff * 4.0);
            if (df == 0) {
                return 0.0f;
            }
            double degIncline = Math.abs((pointHeight - prevHeight) / dist * 100.0);
            if (df > 0) {
                arr = this.ascIncline;
                n.putTag(IndexHeightData.ELE_ASC_TAG, "" + (float)df / 4.0f);
            } else {
                arr = this.descIncline;
                n.putTag(IndexHeightData.ELE_DESC_TAG, "" + (float)(-df) / 4.0f);
            }
            int maxDeg = 0;
            for (int k = 0; k < this.SIZE; ++k) {
                int bs = this.DEGREE_START + k * this.DEGREE_PRECISION;
                if (!(degIncline >= (double)bs)) continue;
                int n2 = k;
                arr[n2] = arr[n2] + dist;
                maxDeg = bs;
            }
            if (maxDeg > 0) {
                if (df > 0) {
                    n.putTag(IndexHeightData.ELE_INCLINE, "1");
                    n.putTag(IndexHeightData.ELE_INCLINE_MAX, "" + maxDeg);
                } else {
                    n.putTag(IndexHeightData.ELE_DECLINE_MAX, "" + maxDeg);
                    n.putTag(IndexHeightData.ELE_DECLINE + maxDeg, "1");
                }
            }
            return (float)df / 4.0f;
        }
    }

    public static class WayGeneralStats {
        public double startEle = 0.0;
        public double endEle = 0.0;
        public double minEle = 0.0;
        public double maxEle = 0.0;
        public double sumEle = 0.0;
        public int eleCount = 0;
        public double up = 0.0;
        public double down = 0.0;
        public double dist = 0.0;
        public int step = 10;
        public TDoubleArrayList altitudes = new TDoubleArrayList();
        public TDoubleArrayList dists = new TDoubleArrayList();
        public TIntArrayList altIncs = new TIntArrayList();
    }

    private static class TileData {
        DataBufferShort data;
        private int id;
        private boolean dataLoaded;
        private int height;
        private int width;
        public int accessed;
        public int loaded;

        private TileData(int id) {
            this.id = id;
        }

        public File loadData(String srtmDataUrl, File workDir) throws IOException {
            this.dataLoaded = true;
            File f = IndexHeightData.loadFile(this.getFileName() + ".tif", srtmDataUrl, workDir);
            if (f.exists()) {
                try (FileInputStream fis = new FileInputStream(f);){
                    BufferedImage img = ImageIO.read(fis);
                    this.readSRTMData(img);
                }
                catch (Exception e) {
                    this.iterativeReadData(f);
                }
                if (!srtmDataUrl.startsWith("/") && !srtmDataUrl.startsWith(".")) {
                    f.delete();
                }
                return null;
            }
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferedImage iterativeReadData(File file) {
            boolean readSuccess = false;
            BufferedImage img = null;
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("tiff");
            ImageInputStream iis = null;
            while (readers.hasNext() && !readSuccess) {
                ImageReader reader = readers.next();
                if (reader instanceof TIFFImageReader) continue;
                try {
                    iis = ImageIO.createImageInputStream(file);
                    reader.setInput(iis, true);
                    img = reader.read(0);
                    this.readSRTMData(img);
                    readSuccess = true;
                }
                catch (IOException e) {
                    log.info((Object)("Error reading TIFF file with reader " + reader.getClass().getName() + ": " + e.getMessage()));
                }
                finally {
                    reader.dispose();
                    if (iis == null) continue;
                    try {
                        iis.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Error closing ImageInputStream: " + e.getMessage()));
                    }
                }
            }
            if (!readSuccess) {
                log.error((Object)"Failed to read TIFF file with all available readers.");
            }
            return img;
        }

        private void readSRTMData(BufferedImage img) {
            if (img != null) {
                this.width = img.getWidth();
                this.height = img.getHeight();
                this.data = (DataBufferShort)img.getRaster().getDataBuffer();
            }
        }

        private String getFileName() {
            int ln = (this.id >> 10) - 180;
            int lt = this.id - (this.id >> 10 << 10) - 90;
            String nd = this.getId(ln, lt);
            return nd;
        }

        public double getHeight(double x, double y, double[] array) {
            if (this.data == null) {
                return Double.MIN_VALUE;
            }
            if (USE_BILINEAR_INTERPOLATION) {
                return this.bilinearInterpolation(x, y, array);
            }
            return this.bicubicInterpolation(x, y, array);
        }

        protected double bicubicInterpolation(double ix, double iy, double[] cf) {
            double pdx = (double)(this.width - 2) * ix + 1.0;
            double pdy = (double)(this.height - 2) * (1.0 - iy) + 1.0;
            int px = (int)Math.round(pdx);
            int py = (int)Math.round(pdy);
            double x = pdx - (double)px + 0.5;
            double y = pdy - (double)py + 0.5;
            --px;
            --py;
            if (cf == null) {
                cf = new double[16];
            }
            for (int i = 0; i < cf.length; ++i) {
                cf[i] = 0.0;
            }
            double tx = y;
            y = x;
            x = tx;
            cf[0] = (x - 1.0) * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(px, py);
            cf[1] = -x * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(px, py + 1);
            cf[2] = -(x - 1.0) * (x - 2.0) * (x + 1.0) * y * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(px + 1, py);
            cf[3] = x * (x - 2.0) * (x + 1.0) * y * (y - 2.0) * (y + 1.0) / 4.0 * this.getElem(px + 1, py + 1);
            cf[4] = -x * (x - 2.0) * (x - 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 12.0 * this.getElem(px, py - 1);
            cf[5] = -(x + 1.0) * (x - 2.0) * (x - 1.0) * (y - 1.0) * (y - 2.0) * y / 12.0 * this.getElem(px - 1, py);
            cf[6] = x * (x - 2.0) * (x - 1.0) * (y + 1.0) * (y - 2.0) * y / 12.0 * this.getElem(px + 1, py - 1);
            cf[7] = x * (x - 2.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * y / 12.0 * this.getElem(px - 1, py + 1);
            cf[8] = x * (x - 1.0) * (x + 1.0) * (y - 1.0) * (y - 2.0) * (y + 1.0) / 12.0 * this.getElem(px, py + 2);
            cf[9] = (x - 2.0) * (x - 1.0) * (x + 1.0) * (y - 1.0) * y * (y + 1.0) / 12.0 * this.getElem(px + 2, py);
            cf[10] = x * (x - 1.0) * (x - 2.0) * y * (y - 1.0) * (y - 2.0) / 36.0 * this.getElem(px - 1, py - 1);
            cf[11] = -x * (x - 1.0) * (x + 1.0) * y * (y + 1.0) * (y - 2.0) / 12.0 * this.getElem(px + 1, py + 2);
            cf[12] = -x * (x + 1.0) * (x - 2.0) * y * (y - 1.0) * (y + 1.0) / 12.0 * this.getElem(px + 2, py + 1);
            cf[13] = -x * (x - 1.0) * (x + 1.0) * y * (y - 1.0) * (y - 2.0) / 36.0 * this.getElem(px - 1, py + 2);
            cf[14] = -x * (x - 1.0) * (x - 2.0) * y * (y - 1.0) * (y + 1.0) / 36.0 * this.getElem(px + 2, py - 1);
            cf[15] = x * (x - 1.0) * (x + 1.0) * y * (y - 1.0) * (y + 1.0) / 36.0 * this.getElem(px + 2, py + 2);
            double h = 0.0;
            for (int i = 0; i < cf.length; ++i) {
                h += cf[i];
            }
            return h;
        }

        protected double bilinearInterpolation(double x, double y, double[] array) {
            double pdx = (double)(this.width - 2) * x + 1.0;
            double pdy = (double)(this.height - 2) * (1.0 - y) + 1.0;
            int px = (int)Math.round(pdx);
            int py = (int)Math.round(pdy);
            if (array == null) {
                array = new double[]{this.getElem(px - 1, py - 1), this.getElem(px, py - 1), this.getElem(px - 1, py), this.getElem(px, py)};
            }
            double cx = 0.5 + pdx - (double)px;
            double cy = 0.5 + pdy - (double)py;
            double h = (1.0 - cx) * (1.0 - cy) * array[0] + cx * (1.0 - cy) * array[1] + (1.0 - cx) * cy * array[2] + cx * cy * array[3];
            return h;
        }

        private double getElem(int px, int py) {
            int ind;
            if (px <= 0) {
                px = 1;
            }
            if (py <= 0) {
                py = 1;
            }
            if (px >= this.width - 1) {
                px = this.width - 2;
            }
            if (py >= this.height - 1) {
                py = this.height - 2;
            }
            if ((ind = px + py * this.width) >= this.data.getSize()) {
                throw new IllegalArgumentException("Illegal access (" + px + ", " + py + ") " + ind + " - " + this.getFileName());
            }
            int h = this.data.getElem(ind) & 0xFFFF;
            if (h > Short.MAX_VALUE) {
                return h - 65535;
            }
            return h;
        }

        private String getId(int ln, int lt) {
            Object id = "";
            id = lt >= 0 ? (String)id + "N" : (String)id + "S";
            if ((lt = Math.abs(lt)) < 10) {
                id = (String)id + "0";
            }
            id = (String)id + lt;
            id = ln >= 0 ? (String)id + "E" : (String)id + "W";
            if ((ln = Math.abs(ln)) < 10) {
                id = (String)id + "0";
            }
            if (ln < 100) {
                id = (String)id + "0";
            }
            id = (String)id + ln;
            return id;
        }
    }
}

