/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.obf.preparation.AbstractIndexPartCreator;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;

public class DBStreetDAO
extends AbstractIndexPartCreator {
    protected PreparedStatement addressStreetStat;
    private PreparedStatement addressStreetNodeStat;
    private PreparedStatement addressBuildingStat;
    private PreparedStatement addressSearchStreetStat;
    private PreparedStatement addressSearchBuildingStat;
    private PreparedStatement addressRemoveBuildingStat;
    private PreparedStatement addressSearchStreetNodeStat;
    private PreparedStatement addressSearchStreetStatWithoutCityPart;
    private Connection mapConnection;
    private PreparedStatement addressStreetUpdateCityPart;
    private PreparedStatement addressStreetLangsUpdate;
    private long streetIdSequence = 0L;

    public void createDatabaseStructure(Connection mapConnection, DBDialect dialect) throws SQLException {
        this.mapConnection = mapConnection;
        Statement stat = mapConnection.createStatement();
        stat.executeUpdate("create table street (id bigint primary key, latitude double, longitude double, name varchar(1024), name_en varchar(1024), city bigint, citypart varchar(1024), langs varchar(1024))");
        stat.executeUpdate("create table building (id bigint, latitude double, longitude double, name2 varchar(1024), name_en2 varchar(1024), lat2 double, lon2 double, interval int, interpolateType varchar(50), name varchar(1024), name_en varchar(1024), street bigint, postcode varchar(1024))");
        stat.executeUpdate("create table street_node (id bigint, latitude double, longitude double, street bigint, way bigint)");
        stat.close();
        this.createPrimaryIndexes(mapConnection);
        this.addressStreetStat = this.createPrepareStatement(mapConnection, "insert into street (id, latitude, longitude, name, name_en, city, citypart, langs) values (?, ?, ?, ?, ?, ?, ?, ?)");
        this.addressStreetNodeStat = this.createPrepareStatement(mapConnection, "insert into street_node (id, latitude, longitude, street, way) values (?, ?, ?, ?, ?)");
        this.addressBuildingStat = this.createPrepareStatement(mapConnection, "insert into building (id, latitude, longitude, name, name_en, street, postcode, name2, name_en2, lat2, lon2, interval, interpolateType) values (?, ?, ?, ?, ?, ?, ?, ?, ? ,? ,? ,? ,?)");
        this.addressSearchStreetStat = this.createPrepareStatement(mapConnection, "SELECT id,latitude,longitude,langs,name_en FROM street WHERE ? = city AND ? = citypart AND ? = name");
        this.addressSearchStreetStatWithoutCityPart = this.createPrepareStatement(mapConnection, "SELECT id,name,citypart,latitude,longitude,langs,name_en FROM street WHERE ? = city AND ? = name");
        this.addressStreetUpdateCityPart = this.createPrepareStatement(mapConnection, "UPDATE street SET citypart = ? WHERE id = ?");
        this.addressStreetLangsUpdate = this.createPrepareStatement(mapConnection, "UPDATE street SET name_en = ? || name_en, langs = ? WHERE id = ?");
        this.addressSearchBuildingStat = this.createPrepareStatement(mapConnection, "SELECT id FROM building where ? = id");
        this.addressRemoveBuildingStat = this.createPrepareStatement(mapConnection, "DELETE FROM building where ? = id");
        this.addressSearchStreetNodeStat = this.createPrepareStatement(mapConnection, "SELECT way FROM street_node WHERE ? = way");
    }

    public void createIndexes(Connection mapConnection) throws SQLException {
        Statement stat = mapConnection.createStatement();
        stat.executeUpdate("create index building_loc on building (latitude, longitude)");
        stat.executeUpdate("create index street_node_street on street_node (street)");
        stat.close();
    }

    public void createPrimaryIndexes(Connection mapConnection) throws SQLException {
        Statement stat = mapConnection.createStatement();
        stat.executeUpdate("create index street_cnp on street (city,citypart,name,id)");
        stat.executeUpdate("create index street_city on street (city)");
        stat.executeUpdate("create index street_id on street (id)");
        stat.executeUpdate("create index building_postcode on building (postcode)");
        stat.executeUpdate("create index building_street on building (street)");
        stat.executeUpdate("create index building_id on building (id)");
        stat.executeUpdate("create index street_node_way on street_node (way)");
        stat.close();
    }

    protected void writeStreetWayNodes(Set<Long> streetIds, Way way) throws SQLException {
        for (Long streetId : streetIds) {
            for (Node n : way.getNodes()) {
                if (n == null) continue;
                this.addressStreetNodeStat.setLong(1, n.getId());
                this.addressStreetNodeStat.setDouble(2, n.getLatitude());
                this.addressStreetNodeStat.setDouble(3, n.getLongitude());
                this.addressStreetNodeStat.setLong(5, way.getId());
                this.addressStreetNodeStat.setLong(4, streetId);
                this.addBatch(this.addressStreetNodeStat);
            }
        }
    }

    protected void cleanCityPart() throws SQLException {
        Statement stat = this.mapConnection.createStatement();
        stat.executeUpdate("UPDATE street SET citypart = null WHERE id IN (SELECT id FROM street WHERE name IN (SELECT name FROM street GROUP BY name HAVING count(DISTINCT citypart) <= 1))");
        stat.close();
    }

    protected void writeBuilding(Set<Long> streetIds, Building building) throws SQLException {
        for (Long streetId : streetIds) {
            this.addBuildtingToBatch(building, streetId, null, building.getLocation());
            for (Map.Entry next : building.getEntrances().entrySet()) {
                this.addBuildtingToBatch(building, streetId, (String)next.getKey(), (LatLon)next.getValue());
            }
        }
    }

    private void addBuildtingToBatch(Building building, Long streetId, String ref, LatLon loc) throws SQLException {
        this.addressBuildingStat.setLong(1, building.getId());
        this.addressBuildingStat.setDouble(2, loc.getLatitude());
        this.addressBuildingStat.setDouble(3, loc.getLongitude());
        this.addressBuildingStat.setLong(6, streetId);
        this.addressBuildingStat.setString(7, building.getPostcode() == null ? null : building.getPostcode().toUpperCase());
        if (ref != null) {
            this.addressBuildingStat.setString(4, building.getName() + ", " + ref);
            this.addressBuildingStat.setString(5, "");
        } else {
            this.addressBuildingStat.setString(4, building.getName());
            this.addressBuildingStat.setString(5, Algorithms.encodeMap((Map)building.getNamesMap(false)));
            this.addressBuildingStat.setString(8, building.getName2());
            this.addressBuildingStat.setString(9, building.getName2());
            LatLon l = building.getLatLon2();
            this.addressBuildingStat.setDouble(10, l == null ? 0.0 : l.getLatitude());
            this.addressBuildingStat.setDouble(11, l == null ? 0.0 : l.getLongitude());
            this.addressBuildingStat.setInt(12, building.getInterpolationInterval());
            if (building.getInterpolationType() == null) {
                this.addressBuildingStat.setString(13, null);
            } else {
                this.addressBuildingStat.setString(13, building.getInterpolationType().toString());
            }
        }
        this.addBatch(this.addressBuildingStat);
    }

    public SimpleStreet findStreet(String name, City city) throws SQLException {
        this.addressSearchStreetStatWithoutCityPart.setLong(1, city.getId());
        this.addressSearchStreetStatWithoutCityPart.setString(2, name);
        ResultSet rs = this.addressSearchStreetStatWithoutCityPart.executeQuery();
        SimpleStreet foundId = null;
        if (rs.next()) {
            foundId = new SimpleStreet(rs.getLong(1), rs.getString(2), city.getId(), rs.getString(3), rs.getDouble(4), rs.getDouble(5), rs.getString(6), rs.getString(7));
        }
        rs.close();
        return foundId;
    }

    public SimpleStreet findStreet(String name, City city, String cityPart) throws SQLException {
        if (cityPart == null) {
            return this.findStreet(name, city);
        }
        this.addressSearchStreetStat.setLong(1, city.getId());
        this.addressSearchStreetStat.setString(2, cityPart);
        this.addressSearchStreetStat.setString(3, name);
        ResultSet rs = this.addressSearchStreetStat.executeQuery();
        SimpleStreet foundId = null;
        if (rs.next()) {
            foundId = new SimpleStreet(rs.getLong(1), name, city.getId(), cityPart, rs.getDouble(2), rs.getDouble(3), rs.getString(4), rs.getString(5));
        }
        rs.close();
        return foundId;
    }

    protected String constructLangs(Map<String, String> names) {
        Object langs = "";
        if (names != null) {
            for (String l : names.keySet()) {
                langs = (String)langs + l + ";";
            }
        }
        return langs;
    }

    public long insertStreet(String name, Map<String, String> names, LatLon location, City city, String cityPart) throws SQLException {
        long streetId = this.fillInsertStreetStatement(name, names, location, city, cityPart, this.constructLangs(names));
        this.addressStreetStat.execute();
        this.mapConnection.commit();
        return streetId;
    }

    protected long fillInsertStreetStatement(String name, Map<String, String> names, LatLon location, City city, String cityPart, String langs) throws SQLException {
        long streetId = this.streetIdSequence++;
        this.addressStreetStat.setLong(1, streetId);
        this.addressStreetStat.setString(4, name);
        this.addressStreetStat.setString(5, Algorithms.encodeMap(names));
        this.addressStreetStat.setDouble(2, location.getLatitude());
        this.addressStreetStat.setDouble(3, location.getLongitude());
        this.addressStreetStat.setLong(6, city.getId());
        this.addressStreetStat.setString(7, cityPart);
        this.addressStreetStat.setString(8, langs);
        return streetId;
    }

    public boolean findBuilding(Entity e) throws SQLException {
        this.commit();
        this.addressSearchBuildingStat.setLong(1, e.getId());
        ResultSet rs = this.addressSearchBuildingStat.executeQuery();
        boolean exist = rs.next();
        rs.close();
        return exist;
    }

    public boolean removeBuilding(Entity e) throws SQLException {
        this.executePendingPreparedStatements();
        this.addressRemoveBuildingStat.setLong(1, e.getId());
        boolean res = this.addressRemoveBuildingStat.execute();
        this.commit();
        return res;
    }

    public boolean findStreetNode(Entity e) throws SQLException {
        this.commit();
        this.addressSearchStreetNodeStat.setLong(1, e.getId());
        ResultSet rs = this.addressSearchStreetNodeStat.executeQuery();
        boolean exist = rs.next();
        rs.close();
        return exist;
    }

    public void commit() throws SQLException {
        if (this.executePendingPreparedStatements()) {
            this.mapConnection.commit();
        }
    }

    public void close() throws SQLException {
        this.closePreparedStatements(this.addressStreetStat, this.addressStreetNodeStat, this.addressBuildingStat);
    }

    public SimpleStreet updateStreetCityPart(SimpleStreet street, String cityPart) throws SQLException {
        this.addressStreetUpdateCityPart.setString(1, cityPart);
        this.addressStreetUpdateCityPart.setLong(2, street.getId());
        this.addressStreetUpdateCityPart.executeUpdate();
        this.mapConnection.commit();
        return new SimpleStreet(street.getId(), street.getName(), street.getCityId(), cityPart, street.getLocation(), street.getLangs(), street.getNameEn());
    }

    public SimpleStreet updateStreetLangs(SimpleStreet street, Map<String, String> newNames) throws SQLException {
        String langs = street.getLangs() + this.constructLangs(newNames);
        newNames.putAll(Algorithms.decodeMap((String)street.getNameEn()));
        String nameEn = Algorithms.encodeMap(newNames);
        this.addressStreetLangsUpdate.setString(1, nameEn);
        this.addressStreetLangsUpdate.setString(2, langs);
        this.addressStreetLangsUpdate.setLong(3, street.getId());
        this.addressStreetLangsUpdate.executeUpdate();
        this.mapConnection.commit();
        return new SimpleStreet(street.getId(), street.getName(), street.getCityId(), street.getCityPart(), street.getLocation(), langs, nameEn);
    }

    public static class SimpleStreet {
        private final long id;
        private final long cityId;
        private final String name;
        private final String cityPart;
        private final String langs;
        private LatLon location;
        private String nameEn;

        public SimpleStreet(long id, String name, long cityId, String cityPart, double latitude, double longitude, String langs, String nameEn) {
            this(id, name, cityId, cityPart, new LatLon(latitude, longitude), langs, nameEn);
        }

        public SimpleStreet(long id, String name, long cityId, String cityPart, LatLon location, String langs, String nameEn) {
            this.id = id;
            this.name = name;
            this.cityId = cityId;
            this.cityPart = cityPart;
            this.location = location;
            this.langs = langs;
            this.nameEn = nameEn;
        }

        public String getCityPart() {
            return this.cityPart;
        }

        public long getCityId() {
            return this.cityId;
        }

        public String getLangs() {
            return this.langs;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getNameEn() {
            return this.nameEn;
        }

        public LatLon getLocation() {
            return this.location;
        }
    }
}

