/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import net.osmand.PlatformUtil;
import net.osmand.binary.MapZooms;
import net.osmand.binary.OsmandOdb;
import net.osmand.data.QuadRect;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.obf.preparation.BinaryFileReference;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.WayChain;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;

public class BasemapProcessor {
    TLongObjectHashMap<WayChain> coastlinesEndPoint = new TLongObjectHashMap();
    TLongObjectHashMap<WayChain> coastlinesStartPoint = new TLongObjectHashMap();
    private static final byte SEA = 2;
    private static final byte LAND = 1;
    private static final Log log = PlatformUtil.getLog(BasemapProcessor.class);
    public static final int PIXELS_THRESHOLD_AREA = 24;
    private static final int POLYGON_MAX_START_END_DIST = 100;
    private static final int MIN_SIZE_NODES_LONG_ROAD = 500;
    private static final String WATERWAY_TAG = "waterway";
    private static final String NATURAL_TAG = "natural";
    private static final String HIGHWAY_TAG = "highway";
    public static final byte TILE_ZOOMLEVEL = 12;
    private static final byte BITMASK = 3;
    private static final int BITS_COUNT = 0x1000000;
    private BitSet seaTileInfo = new BitSet(0x1000000);
    private BitSet landTileInfo = new BitSet(0x1000000);
    private TIntArrayList typeUse = new TIntArrayList();
    List<MapRenderingTypes.MapRulType> tempNameUse = new ArrayList<MapRenderingTypes.MapRulType>();
    TIntArrayList addtypeUse = new TIntArrayList(8);
    TreeMap<MapRenderingTypes.MapRulType, String> namesUse = new TreeMap(new Comparator<MapRenderingTypes.MapRulType>(){

        @Override
        public int compare(MapRenderingTypes.MapRulType o1, MapRenderingTypes.MapRulType o2) {
            int rhs;
            int lhs = o1.getOrder();
            if (lhs == (rhs = o2.getOrder())) {
                lhs = o1.getInternalId();
                rhs = o2.getInternalId();
            }
            return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
        }
    });
    private final int zoomWaySmoothness;
    private final MapRenderingTypesEncoder renderingTypes;
    private final MapZooms mapZooms;
    private final Log logMapDataWarn;
    private SimplisticQuadTree[] quadTrees;
    private static int MOST_DETAILED_APPROXIMATION = 9;
    private static long ID = -20L;

    protected BasemapProcessor() {
        this.logMapDataWarn = null;
        this.zoomWaySmoothness = 0;
        this.renderingTypes = null;
        this.mapZooms = null;
    }

    public BasemapProcessor(Log logMapDataWarn, MapZooms mapZooms, MapRenderingTypesEncoder renderingTypes, int zoomWaySmoothness) {
        this.logMapDataWarn = logMapDataWarn;
        this.mapZooms = mapZooms;
        this.renderingTypes = renderingTypes;
        this.zoomWaySmoothness = zoomWaySmoothness;
        this.constructBitSetInfo(null);
        this.quadTrees = new SimplisticQuadTree[mapZooms.getLevels().size()];
        for (int i = 0; i < mapZooms.getLevels().size(); ++i) {
            MapZooms.MapZoomPair p = (MapZooms.MapZoomPair)mapZooms.getLevels().get(i);
            this.quadTrees[i] = this.constructTilesQuadTree(Math.min(p.getMaxZoom(), 11));
        }
    }

    protected void constructBitSetInfo(String datFile) {
        try {
            FileInputStream dis = datFile == null ? new BZip2CompressorInputStream(BasemapProcessor.class.getResourceAsStream("oceantiles_12.dat.bz2")) : new FileInputStream(datFile);
            for (int i = 0; i < 0x400000; ++i) {
                int currentByte = ((InputStream)dis).read();
                if ((currentByte >> 6 & 3) == 2) {
                    this.seaTileInfo.set(i * 4);
                } else if ((currentByte >> 6 & 3) == 1) {
                    this.landTileInfo.set(i * 4);
                }
                if ((currentByte >> 4 & 3) == 2) {
                    this.seaTileInfo.set(i * 4 + 1);
                } else if ((currentByte >> 4 & 3) == 1) {
                    this.landTileInfo.set(i * 4 + 1);
                }
                if ((currentByte >> 2 & 3) == 2) {
                    this.seaTileInfo.set(i * 4 + 2);
                } else if ((currentByte >> 2 & 3) == 1) {
                    this.landTileInfo.set(i * 4 + 2);
                }
                if ((currentByte & 3) == 2) {
                    this.seaTileInfo.set(i * 4 + 3);
                    continue;
                }
                if ((currentByte & 3) != 1) continue;
                this.landTileInfo.set(i * 4 + 3);
            }
            ((InputStream)dis).close();
        }
        catch (IOException e) {
            throw new RuntimeException("File with coastline tiles was not found ");
        }
    }

    public int getTileZoomLevel() {
        return 12;
    }

    public boolean isWaterTile(int x, int y, int zoom) {
        if (zoom >= 12) {
            int y1 = y >> zoom - 12;
            int x1 = x >> zoom - 12;
            return this.seaTileInfo.get(y1 * 4096 + x1);
        }
        int x1 = x << 12 - zoom;
        int y1 = y << 12 - zoom;
        int max = 1 << 12 - zoom;
        for (int i = 0; i < max; ++i) {
            for (int j = 0; j < max; ++j) {
                if (this.seaTileInfo.get((y1 + j) * 4096 + (x1 + i))) continue;
                return false;
            }
        }
        return true;
    }

    public float getSeaTile(int x, int y, int zoom) {
        if (zoom >= 12) {
            int y1 = y >> zoom - 12;
            int x1 = x >> zoom - 12;
            if (this.seaTileInfo.get(y1 * 4096 + x1)) {
                return 1.0f;
            }
            return 0.0f;
        }
        int x1 = x << 12 - zoom;
        int y1 = y << 12 - zoom;
        int max = 1 << 12 - zoom;
        int c = 0;
        for (int i = 0; i < max; ++i) {
            for (int j = 0; j < max; ++j) {
                if (!this.seaTileInfo.get((y1 + i) * 4096 + (x1 + j))) continue;
                ++c;
            }
        }
        return (float)c / ((float)max * (float)max);
    }

    public boolean isLandTile(int x, int y, int zoom) {
        if (zoom >= 12) {
            int y1 = y >> zoom - 12;
            int x1 = x >> zoom - 12;
            return this.landTileInfo.get(y1 * 4096 + x1);
        }
        int x1 = x << 12 - zoom;
        int y1 = y << 12 - zoom;
        int max = 1 << 12 - zoom;
        for (int i = 0; i < max; ++i) {
            for (int j = 0; j < max; ++j) {
                if (this.landTileInfo.get((y1 + i) * 4096 + (x1 + j))) continue;
                return false;
            }
        }
        return true;
    }

    public SimplisticQuadTree constructTilesQuadTree(int maxZoom) {
        SimplisticQuadTree rootTree = new SimplisticQuadTree(0, 0, 0);
        int baseZoom = 2;
        int tiles = 1 << baseZoom;
        LinkedList<SimplisticQuadTree> toVisit = new LinkedList<SimplisticQuadTree>();
        for (int x = 0; x < tiles; ++x) {
            for (int y = 0; y < tiles; ++y) {
                toVisit.add(rootTree.getOrCreateSubTree(x, y, baseZoom));
            }
        }
        this.initializeQuadTree(rootTree, baseZoom, maxZoom, toVisit);
        return rootTree;
    }

    protected void initializeQuadTree(SimplisticQuadTree rootTree, int baseZoom, int maxZoom, LinkedList<SimplisticQuadTree> toVisit) {
        while (!toVisit.isEmpty()) {
            SimplisticQuadTree subtree = toVisit.poll();
            int x = subtree.x;
            int y = subtree.y;
            int zoom = subtree.zoom;
            SimplisticQuadTree st = rootTree.getOrCreateSubTree(x, y, zoom);
            st.seaCharacteristic = this.getSeaTile(x, y, zoom);
            if (zoom >= maxZoom || this.isWaterTile(x, y, zoom) || this.isLandTile(x, y, zoom)) continue;
            SimplisticQuadTree[] vis = st.getAllChildren();
            Collections.addAll(toVisit, vis);
        }
    }

    public void writeBasemapFile(BinaryMapIndexWriter writer, String regionName) throws IOException {
        writer.startWriteMapIndex(regionName);
        writer.writeMapEncodingRules(this.renderingTypes.getEncodingRuleTypes());
        int i = 0;
        for (MapZooms.MapZoomPair p : this.mapZooms.getLevels()) {
            writer.startWriteMapLevelIndex(p.getMinZoom(), p.getMaxZoom(), 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            LinkedHashMap<SimplisticQuadTree, BinaryFileReference> refs = new LinkedHashMap<SimplisticQuadTree, BinaryFileReference>();
            this.writeBinaryMapTree(this.quadTrees[i], writer, refs, p);
            this.writeBinaryMapBlock(this.quadTrees[i], writer, refs, p);
            writer.endWriteMapLevelIndex();
            ++i;
        }
        writer.endWriteMapIndex();
        writer.flush();
    }

    private void writeBinaryMapBlock(SimplisticQuadTree simplisticQuadTree, BinaryMapIndexWriter writer, Map<SimplisticQuadTree, BinaryFileReference> refs, MapZooms.MapZoomPair level) throws IOException {
        for (Map.Entry<SimplisticQuadTree, BinaryFileReference> e : refs.entrySet()) {
            OsmandOdb.MapDataBlock.Builder dataBlock = OsmandOdb.MapDataBlock.newBuilder();
            SimplisticQuadTree quad = e.getKey();
            LinkedHashMap<String, Integer> stringTable = new LinkedHashMap<String, Integer>();
            long baseId = 0L;
            for (SimplisticBinaryData w : quad.getData(level)) {
                baseId = Math.min(w.id, baseId);
            }
            dataBlock.setBaseId(baseId);
            for (SimplisticBinaryData w : quad.getData(level)) {
                OsmandOdb.MapData mapData;
                int j;
                int[] wts = null;
                int[] wats = null;
                if (w.types != null) {
                    wts = new int[w.types.length];
                    for (j = 0; j < w.types.length; ++j) {
                        wts[j] = this.renderingTypes.getTypeByInternalId(w.types[j]).getTargetId();
                    }
                }
                if (w.addTypes != null) {
                    wats = new int[w.addTypes.length];
                    for (j = 0; j < w.addTypes.length; ++j) {
                        wats[j] = this.renderingTypes.getTypeByInternalId(w.addTypes[j]).getTargetId();
                    }
                }
                if ((mapData = writer.writeMapData(w.id - baseId, quad.x << 31 - quad.zoom, quad.y << 31 - quad.zoom, false, w.coordinates, w.innerCoordinates, wts, wats, w.names, new byte[]{}, null, stringTable, dataBlock, level.getMaxZoom() > 15)) == null) continue;
                dataBlock.addDataObjects(mapData);
            }
            writer.writeMapDataBlock(dataBlock, stringTable, e.getValue());
        }
    }

    private void writeBinaryMapTree(SimplisticQuadTree quadTree, BinaryMapIndexWriter writer, Map<SimplisticQuadTree, BinaryFileReference> refs, MapZooms.MapZoomPair p) throws IOException {
        BinaryFileReference ref;
        int xL = quadTree.x << 31 - quadTree.zoom;
        int xR = (quadTree.x + 1 << 31 - quadTree.zoom) - 1;
        int yT = quadTree.y << 31 - quadTree.zoom;
        int yB = (quadTree.y + 1 << 31 - quadTree.zoom) - 1;
        boolean defined = quadTree.dataIsDefined(p);
        int sea = 0;
        if (!quadTree.areChildrenDefined()) {
            int n = sea = (double)quadTree.seaCharacteristic > 0.5 ? -1 : 1;
        }
        if ((ref = writer.startMapTreeElement(xL, xR, yT, yB, defined, sea)) != null) {
            refs.put(quadTree, ref);
        }
        if (quadTree.areChildrenDefined()) {
            SimplisticQuadTree[] allChildren;
            for (SimplisticQuadTree ch : allChildren = quadTree.getAllChildren()) {
                this.writeBinaryMapTree(ch, writer, refs, p);
            }
        }
        writer.endWriteMapTreeElement();
    }

    public void processEntity(boolean mini, Entity e) {
        if (e instanceof Way && "reverse_coastline".equals(((Way)e).getModifiableTags().get(NATURAL_TAG))) {
            ((Way)e).putTag(NATURAL_TAG, "coastline");
            Collections.reverse(((Way)e).getNodes());
            ((Way)e).getNodeIds().reverse();
        }
        long refId = -Math.abs(e.getId());
        boolean coastline = "coastline".equals(e.getTag(NATURAL_TAG));
        for (int level = 0; level < this.mapZooms.getLevels().size(); ++level) {
            int zoomToEncode;
            boolean mostDetailed = level == 0;
            MapZooms.MapZoomPair zoomPair = this.mapZooms.getLevel(level);
            if (mostDetailed && !(e instanceof Node) && !coastline) continue;
            int n = zoomToEncode = mostDetailed ? Math.max(MOST_DETAILED_APPROXIMATION, zoomPair.getMinZoom() + 1) : zoomPair.getMaxZoom();
            if (mostDetailed && zoomPair.getMaxZoom() < 10) {
                throw new IllegalStateException("Zoom pair is not detailed " + zoomPair);
            }
            this.renderingTypes.encodeEntityWithType(e, zoomToEncode, this.typeUse, this.addtypeUse, this.namesUse, this.tempNameUse);
            if (this.typeUse.isEmpty()) continue;
            if (e instanceof Relation) {
                Relation r = (Relation)e;
                Iterator it = r.getMembers().iterator();
                List outer = null;
                ArrayList<List<Node>> inner = new ArrayList<List<Node>>();
                while (it.hasNext()) {
                    Relation.RelationMember n2 = (Relation.RelationMember)it.next();
                    if (n2.getRole().equals("outer")) {
                        if (outer != null) {
                            throw new IllegalStateException("2 outer lines for relation = " + e.getId());
                        }
                        outer = ((Way)n2.getEntity()).getNodes();
                        continue;
                    }
                    if (!n2.getRole().equals("inner")) continue;
                    inner.add(((Way)n2.getEntity()).getNodes());
                }
                if (outer == null || OsmMapUtils.polygonAreaPixels(outer, (int)zoomToEncode) < 24.0) continue;
                this.addObject(refId, level, zoomPair, zoomToEncode, outer, inner);
                continue;
            }
            if (e instanceof Way) {
                boolean polygon;
                if (((Way)e).getNodes().size() < 2) continue;
                double dist = OsmMapUtils.getDistance((Node)((Way)e).getFirstNode(), (Node)((Way)e).getLastNode());
                boolean bl = polygon = dist < 100.0;
                if ("coastline".equals(e.getTag(NATURAL_TAG))) {
                    if (polygon && !mostDetailed && OsmMapUtils.polygonAreaPixels((List)((Way)e).getNodes(), (int)zoomToEncode) < 24.0) continue;
                    this.splitContinuousWay(((Way)e).getNodes(), this.typeUse.toArray(), !this.addtypeUse.isEmpty() ? this.addtypeUse.toArray() : null, zoomPair, zoomToEncode, this.quadTrees[level], refId);
                    continue;
                }
                polygon = this.isPolygon(e);
                List ns = ((Way)e).getNodes();
                if (!polygon) {
                    QuadRect qr = ((Way)e).getLatLonBBox();
                    if (qr == null) continue;
                    double mult = 1.0 / MapUtils.getPowZoom((double)Math.max(31 - (zoomToEncode + 8), 0));
                    int rx = MapUtils.get31TileNumberX((double)qr.right);
                    int lx = MapUtils.get31TileNumberX((double)qr.left);
                    int by = MapUtils.get31TileNumberY((double)qr.bottom);
                    int ty = MapUtils.get31TileNumberY((double)qr.top);
                    if (mult * (double)(rx - lx) < 24.0 && mult * (double)(by - ty) < 24.0) {
                        continue;
                    }
                } else if (OsmMapUtils.polygonAreaPixels((List)ns, (int)zoomToEncode) < 24.0) continue;
                this.addObject(refId, level, zoomPair, zoomToEncode, ns, null);
                continue;
            }
            int z = this.getViewZoom(zoomPair.getMinZoom(), zoomToEncode);
            int tilex = (int)MapUtils.getTileNumberX((float)z, (double)((Node)e).getLongitude());
            int tiley = (int)MapUtils.getTileNumberY((float)z, (double)((Node)e).getLatitude());
            this.addRawData(Collections.singletonList((Node)e), null, this.typeUse.toArray(), !this.addtypeUse.isEmpty() ? this.addtypeUse.toArray() : null, zoomPair, this.quadTrees[level], z, tilex, tiley, (Map<MapRenderingTypes.MapRulType, String>)(this.namesUse.isEmpty() ? null : new LinkedHashMap<MapRenderingTypes.MapRulType, String>(this.namesUse)), refId);
        }
    }

    private boolean isPolygon(Entity e) {
        double startEndDist = OsmMapUtils.getDistance((Node)((Way)e).getFirstNode(), (Node)((Way)e).getLastNode());
        boolean isLongRoad = e.getTag(WATERWAY_TAG) == null && e.getTag(NATURAL_TAG) == null && e.getTag(HIGHWAY_TAG) != null && ((Way)e).getNodes().size() > 500;
        return startEndDist < 100.0 && !isLongRoad;
    }

    private void addObject(long refId, int level, MapZooms.MapZoomPair zoomPair, int zoomToEncode, List<Node> way, List<List<Node>> inner) {
        int z = this.getViewZoom(zoomPair.getMinZoom(), zoomToEncode);
        int tilex = 0;
        int tiley = 0;
        boolean sameTile = false;
        while (!sameTile) {
            tilex = (int)MapUtils.getTileNumberX((float)z, (double)way.get(0).getLongitude());
            tiley = (int)MapUtils.getTileNumberY((float)z, (double)way.get(0).getLatitude());
            sameTile = true;
            for (int i = 1; i < way.size(); ++i) {
                int tx = (int)MapUtils.getTileNumberX((float)z, (double)way.get(i).getLongitude());
                int ty = (int)MapUtils.getTileNumberY((float)z, (double)way.get(i).getLatitude());
                if (tx == tilex && ty == tiley) continue;
                sameTile = false;
                break;
            }
            if (sameTile) continue;
            --z;
        }
        ArrayList<Node> res = new ArrayList<Node>();
        OsmMapUtils.simplifyDouglasPeucker(way, (int)(zoomToEncode - 1 + 8 + this.zoomWaySmoothness), (int)3, res, (boolean)false);
        if (inner != null) {
            Iterator<List<Node>> it = inner.iterator();
            while (it.hasNext()) {
                List<Node> list = it.next();
                if (OsmMapUtils.polygonAreaPixels(list, (int)zoomToEncode) < 24.0) {
                    it.remove();
                    continue;
                }
                ArrayList<Node> result = new ArrayList<Node>();
                OsmMapUtils.simplifyDouglasPeucker(list, (int)(zoomToEncode - 1 + 8 + this.zoomWaySmoothness), (int)4, result, (boolean)false);
                if (result.size() <= 3) {
                    it.remove();
                    continue;
                }
                list = result;
            }
        }
        this.addRawData(res, inner, this.typeUse.toArray(), !this.addtypeUse.isEmpty() ? this.addtypeUse.toArray() : null, zoomPair, this.quadTrees[level], z, tilex, tiley, (Map<MapRenderingTypes.MapRulType, String>)(this.namesUse.isEmpty() ? null : new LinkedHashMap<MapRenderingTypes.MapRulType, String>(this.namesUse)), refId);
    }

    public void splitContinuousWay(List<Node> ns, int[] types, int[] addTypes, MapZooms.MapZoomPair zoomPair, int zoomToEncode, SimplisticQuadTree quadTree, long refId) {
        int z = this.getViewZoom(zoomPair.getMinZoom(), zoomToEncode);
        int i = 1;
        Node prevNode = ns.get(0);
        int px31 = MapUtils.get31TileNumberX((double)prevNode.getLongitude());
        int py31 = MapUtils.get31TileNumberY((double)prevNode.getLatitude());
        while (i < ns.size()) {
            ArrayList<Node> w = new ArrayList<Node>();
            w.add(prevNode);
            int tilex = px31 >> 31 - z;
            int tiley = py31 >> 31 - z;
            boolean sameTile = true;
            while (sameTile && i < ns.size()) {
                Node next = ns.get(i);
                int ntilex = (int)MapUtils.getTileNumberX((float)z, (double)next.getLongitude());
                int ntiley = (int)MapUtils.getTileNumberY((float)z, (double)next.getLatitude());
                if (ntilex == tilex && tiley == ntiley) {
                    sameTile = true;
                    w.add(next);
                    prevNode = next;
                    px31 = MapUtils.get31TileNumberX((double)prevNode.getLongitude());
                    py31 = MapUtils.get31TileNumberY((double)prevNode.getLatitude());
                    ++i;
                    continue;
                }
                int nx31 = MapUtils.get31TileNumberX((double)next.getLongitude());
                int ny31 = MapUtils.get31TileNumberY((double)next.getLatitude());
                int leftX = (tilex << 31 - z) - 1;
                int rightX = tilex + 1 << 31 - z;
                if (rightX < 0) {
                    rightX = Integer.MAX_VALUE;
                }
                int topY = (tiley << 31 - z) - 1;
                int bottomY = tiley + 1 << 31 - z;
                if (bottomY < 0) {
                    bottomY = Integer.MAX_VALUE;
                }
                long inter = MapAlgorithms.calculateIntersection((int)px31, (int)py31, (int)nx31, (int)ny31, (int)leftX, (int)rightX, (int)bottomY, (int)topY);
                int cy31 = (int)inter;
                int cx31 = (int)(inter >> 32);
                if (inter == -1L) {
                    cx31 = nx31;
                    cy31 = ny31;
                    ++i;
                    this.logMapDataWarn.warn((Object)("Can't find intersection for " + MapUtils.get31LongitudeX((int)px31) + "," + MapUtils.get31LatitudeY((int)py31) + " - " + MapUtils.get31LongitudeX((int)nx31) + "," + MapUtils.get31LatitudeY((int)ny31)));
                    this.logMapDataWarn.warn((Object)("Values " + px31 + "," + py31 + " -- " + nx31 + "," + ny31 + "   boundary " + leftX + "," + topY + "," + rightX + "," + bottomY));
                }
                prevNode = new Node(MapUtils.get31LatitudeY((int)cy31), MapUtils.get31LongitudeX((int)cx31), -1000L);
                px31 = cx31;
                py31 = cy31;
                w.add(prevNode);
                break;
            }
            ArrayList<Node> res = new ArrayList<Node>();
            OsmMapUtils.simplifyDouglasPeucker(w, (int)(zoomToEncode - 1 + 8 + this.zoomWaySmoothness), (int)3, res, (boolean)true);
            this.addRawData(res, null, types, addTypes, zoomPair, quadTree, z, tilex, tiley, null, refId);
        }
    }

    private void addRawData(List<Node> res, List<List<Node>> inner, int[] types, int[] addTypes, MapZooms.MapZoomPair zoomPair, SimplisticQuadTree quadTree, int z, int tilex, int tiley, Map<MapRenderingTypes.MapRulType, String> names, long id) {
        SimplisticQuadTree quad = quadTree.getOrCreateSubTree(tilex, tiley, z);
        if (quad == null) {
            if (this.logMapDataWarn != null) {
                this.logMapDataWarn.error((Object)("Tile " + tilex + " / " + tiley + " at " + z + " can not be found"));
            } else {
                System.err.println("Tile " + tilex + " / " + tiley + " at " + z + " can not be found");
            }
        }
        ByteArrayOutputStream bcoordinates = new ByteArrayOutputStream();
        for (Node n : res) {
            if (n == null) continue;
            int y = MapUtils.get31TileNumberY((double)n.getLatitude());
            int x = MapUtils.get31TileNumberX((double)n.getLongitude());
            try {
                Algorithms.writeInt((OutputStream)bcoordinates, (int)x);
                Algorithms.writeInt((OutputStream)bcoordinates, (int)y);
            }
            catch (IOException e1) {
                throw new IllegalStateException(e1);
            }
        }
        SimplisticBinaryData data = new SimplisticBinaryData();
        data.id = ID--;
        data.coordinates = bcoordinates.toByteArray();
        data.types = types;
        data.addTypes = addTypes;
        data.names = names;
        if (inner != null && inner.size() > 0) {
            bcoordinates = new ByteArrayOutputStream();
            for (List<Node> ln : inner) {
                try {
                    for (Node n : ln) {
                        if (n == null) continue;
                        int y = MapUtils.get31TileNumberY((double)n.getLatitude());
                        int x = MapUtils.get31TileNumberX((double)n.getLongitude());
                        Algorithms.writeInt((OutputStream)bcoordinates, (int)x);
                        Algorithms.writeInt((OutputStream)bcoordinates, (int)y);
                    }
                    Algorithms.writeInt((OutputStream)bcoordinates, (int)0);
                    Algorithms.writeInt((OutputStream)bcoordinates, (int)0);
                }
                catch (IOException e1) {
                    throw new IllegalStateException(e1);
                }
            }
        }
        data.innerCoordinates = bcoordinates.toByteArray();
        quad.addQuadData(zoomPair, data);
    }

    private int getViewZoom(int minZoom, int maxZoom) {
        return Math.min((minZoom + maxZoom) / 2 - 1, minZoom + 1);
    }

    public static void main(String[] args) throws InterruptedException, SQLException, IOException, XMLStreamException, XmlPullParserException {
        if (args.length == 0) {
            System.out.println("Please specify folder with basemap *.osm or *.osm.bz2 files");
        } else {
            boolean mini = false;
            boolean detailed = false;
            MapRenderingTypesEncoder rt = new MapRenderingTypesEncoder("basemap");
            int zoomSmoothness = 2;
            MapZooms zooms = MapZooms.parseZooms((String)"1-2;3;4-5;6-7;8-9;10-11;12-");
            MOST_DETAILED_APPROXIMATION = 9;
            String fileName = "World_basemap_2.obf";
            File folder = new File(args[0]);
            if (args.length >= 2) {
                if (args[1].equals("mini")) {
                    mini = true;
                    detailed = false;
                    zoomSmoothness = 2;
                    zooms = MapZooms.parseZooms((String)"1-2;3;4-5;6-8;9-");
                    MOST_DETAILED_APPROXIMATION = 9;
                    fileName = "World_basemap_mini_2.obf";
                } else if (args[1].equals("detailed")) {
                    mini = false;
                    detailed = true;
                    zoomSmoothness = 2;
                    zooms = MapZooms.parseZooms((String)"1-2;3;4-5;6-7;8-9;10-11;12-");
                    MOST_DETAILED_APPROXIMATION = 11;
                    fileName = "World_basemap_detailed_2.obf";
                }
            }
            IndexCreatorSettings settings = new IndexCreatorSettings();
            settings.indexMap = true;
            settings.indexAddress = false;
            settings.indexPOI = true;
            settings.indexTransport = false;
            settings.indexRouting = false;
            settings.zoomWaySmoothness = zoomSmoothness;
            IndexCreator creator = new IndexCreator(folder, settings);
            creator.setDialects(!mini ? DBDialect.SQLITE : DBDialect.SQLITE_IN_MEMORY, !mini ? DBDialect.SQLITE : DBDialect.SQLITE_IN_MEMORY);
            creator.setMapFileName(fileName);
            ArrayList<File> src = new ArrayList<File>();
            BasemapProcessor.parseFiles(folder, src);
            creator.generateBasemapIndex(mini, new ConsoleProgressImplementation(1.0), null, zooms, rt, log, "basemap", src.toArray(new File[src.size()]));
        }
    }

    private static void parseFiles(File folder, List<File> src) {
        for (File f : folder.listFiles()) {
            if (f.isDirectory() && f.getName().startsWith("proc_")) {
                BasemapProcessor.parseFiles(f, src);
            }
            if (!f.getName().endsWith(".osm") && !f.getName().endsWith(".osm.bz2") && !f.getName().endsWith(".osm.gz")) continue;
            src.add(f);
        }
    }

    protected static class SimplisticQuadTree {
        int zoom;
        int x;
        int y;
        float seaCharacteristic;
        SimplisticQuadTree[] children = null;
        Map<MapZooms.MapZoomPair, List<SimplisticBinaryData>> dataObjects = null;

        public SimplisticQuadTree(int x, int y, int zoom) {
            this.x = x;
            this.y = y;
            this.zoom = zoom;
        }

        public SimplisticQuadTree[] getAllChildren() {
            this.initChildren();
            return this.children;
        }

        public boolean areChildrenDefined() {
            return this.children != null;
        }

        public void addQuadData(MapZooms.MapZoomPair p, SimplisticBinaryData w) {
            if (this.dataObjects == null) {
                this.dataObjects = new LinkedHashMap<MapZooms.MapZoomPair, List<SimplisticBinaryData>>();
            }
            if (!this.dataObjects.containsKey(p)) {
                this.dataObjects.put(p, new ArrayList());
            }
            this.dataObjects.get(p).add(w);
        }

        public boolean dataIsDefined(MapZooms.MapZoomPair p) {
            return this.dataObjects != null && this.dataObjects.get(p) != null;
        }

        public List<SimplisticBinaryData> getData(MapZooms.MapZoomPair p) {
            return this.dataObjects.get(p);
        }

        public SimplisticQuadTree getOrCreateSubTree(int x, int y, int zm) {
            if (zm <= this.zoom) {
                return this;
            }
            this.initChildren();
            int nx = (x >> zm - this.zoom - 1) - (this.x << 1);
            int ny = (y >> zm - this.zoom - 1) - (this.y << 1);
            if (nx > 1 || nx < 0 || ny > 1 || ny < 0) {
                return null;
            }
            return this.children[nx * 2 + ny].getOrCreateSubTree(x, y, zm);
        }

        private void initChildren() {
            if (this.children == null) {
                this.children = new SimplisticQuadTree[4];
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        this.children[i * 2 + j] = new SimplisticQuadTree((this.x << 1) + i, (this.y << 1) + j, this.zoom + 1);
                        this.children[i * 2 + j].seaCharacteristic = this.seaCharacteristic;
                    }
                }
            }
        }
    }

    private static class SimplisticBinaryData {
        public byte[] coordinates;
        public byte[] innerCoordinates;
        public int[] types;
        public int[] addTypes;
        public long id = -500L;
        public Map<MapRenderingTypes.MapRulType, String> names;

        private SimplisticBinaryData() {
        }
    }
}

