/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.diff;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;
import net.osmand.IProgress;
import net.osmand.obf.diff.DiffParser;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.util.Algorithms;
import org.xmlpull.v1.XmlPullParserException;

public class RelationDiffGenerator {
    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("test")) {
            args = new String[4];
            ArrayList<String> s = new ArrayList<String>();
            s.add("/Users/macmini/OsmAnd/overpass/issue_x/23_12_06_12_10_before_rel.osm");
            s.add("/Users/macmini/OsmAnd/overpass/issue_x/23_12_06_12_10_after_rel.osm");
            s.add("/Users/macmini/OsmAnd/overpass/issue_x/23_12_06_12_10_diff.osm");
            s.add("/Users/macmini/OsmAnd/overpass/issue_x/_after_rel_m.osm");
            args = s.toArray(new String[0]);
        } else if (args.length < 4) {
            System.out.println("Usage: <path before_rel.osm.gz file> <path to after_rel.osm.gz file> <path to _diff.osm file> <path to write result> ");
            System.exit(1);
        }
        String start = args[0];
        String end = args[1];
        String diff = args[2];
        String result = args[3];
        try {
            RelationDiffGenerator rdg = new RelationDiffGenerator();
            File startFile = new File(start);
            File endFile = new File(end);
            File targetFile = new File(result);
            File diffFile = new File(diff);
            rdg.compareOsmFiles(startFile, endFile, diffFile, targetFile);
        }
        catch (IOException | XMLStreamException | XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    private void compareOsmFiles(File start, File end, File diffFile, File targetFile) throws IOException, XmlPullParserException, XMLStreamException {
        long time = System.currentTimeMillis();
        InputStream startIs = start.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(start)) : new FileInputStream(start);
        InputStream endIs = end.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(end)) : new FileInputStream(end);
        BufferedInputStream startStream = new BufferedInputStream(startIs, 32768);
        BufferedInputStream endStream = new BufferedInputStream(endIs, 32768);
        OsmBaseStorage startStorage = new OsmBaseStorage();
        OsmBaseStorage endStorage = new OsmBaseStorage();
        startStorage.parseOSM((InputStream)startStream, IProgress.EMPTY_PROGRESS);
        long t1 = System.currentTimeMillis() - time;
        System.out.println("Parse " + start.getName() + ": " + t1 / 1000L + " sec.");
        endStorage.parseOSM((InputStream)endStream, IProgress.EMPTY_PROGRESS);
        long t2 = System.currentTimeMillis() - time - t1;
        System.out.println("Parse " + end.getName() + ": " + t2 / 1000L + " sec.");
        ((InputStream)startStream).close();
        ((InputStream)endStream).close();
        Map startEntities = startStorage.getRegisteredEntities();
        Map endEntities = endStorage.getRegisteredEntities();
        int statisticAddedMembers = 0;
        HashSet<Entity.EntityId> deletedObjIds = new HashSet<Entity.EntityId>();
        if (diffFile != null) {
            try {
                DiffParser.fetchModifiedIds(diffFile, null, deletedObjIds);
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
            }
        }
        long t3 = System.currentTimeMillis() - time - t2;
        System.out.println("Parse _diff.osm in " + t3 / 1000L + " sec.");
        for (Map.Entry e : startEntities.entrySet()) {
            Entity.EntityType entityType = ((Entity.EntityId)e.getKey()).getType();
            if (entityType != Entity.EntityType.NODE && entityType != Entity.EntityType.WAY || endEntities.containsKey(e.getKey()) || deletedObjIds.contains(e.getKey())) continue;
            endStorage.registerEntity((Entity)e.getValue(), null);
            ++statisticAddedMembers;
        }
        long t4 = System.currentTimeMillis() - time - t3;
        System.out.println("Added " + statisticAddedMembers + " node/ways: in " + t4 / 1000L + " sec.");
        File targetFileSource = targetFile.getName().endsWith(".gz") ? new File(targetFile.getAbsolutePath().replace(".gz", "")) : targetFile;
        targetFileSource.delete();
        FileOutputStream output = new FileOutputStream(targetFileSource);
        OsmStorageWriter w = new OsmStorageWriter();
        w.saveStorage(output, endStorage, null, true);
        ((OutputStream)output).close();
        if (targetFile.getName().endsWith(".gz")) {
            FileInputStream fis = new FileInputStream(targetFileSource);
            GZIPOutputStream gzout = new GZIPOutputStream(new FileOutputStream(targetFile));
            Algorithms.streamCopy((InputStream)fis, (OutputStream)gzout);
            fis.close();
            gzout.close();
            targetFileSource.delete();
        }
        long t5 = System.currentTimeMillis() - time - t4;
        System.out.println("Wrote result into " + targetFile.getName() + " in " + t5 / 1000L + " sec.");
    }
}

