/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.diff;

import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.MapZooms;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Amenity;
import net.osmand.data.MapObject;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportStop;
import net.osmand.obf.BinaryInspector;
import net.osmand.obf.diff.DiffParser;
import net.osmand.obf.diff.ObfFileInMemory;
import net.osmand.osm.edit.Entity;
import org.xmlpull.v1.XmlPullParserException;
import rtree.RTreeException;

public class ObfDiffGenerator {
    private static final long ID_MULTIPOLYGON_LIMIT = 0x20000000000L;
    private static final int COORDINATES_PRECISION_COMPARE = 0;
    private static final String OSMAND_CHANGE_VALUE = "delete";
    private static final String OSMAND_CHANGE_TAG = "osmand_change";
    public static boolean COMPARE_TRANSPORT = true;

    public static void main(String[] args) throws IOException, RTreeException {
        if (args.length == 1 && args[0].equals("test")) {
            args = new String[]{System.getProperty("maps.dir") + "Andorra_europe_2.obf", System.getProperty("maps.dir") + "Andorra_europe_2.obf_", "stdout"};
        }
        if (args.length < 3) {
            System.out.println("Usage: <path to old obf> <path to new obf> <[result file name] or [stdout]> <path to diff file (optional)>");
            System.exit(1);
            return;
        }
        try {
            ObfDiffGenerator generator = new ObfDiffGenerator();
            generator.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run(String[] args) throws IOException, RTreeException, SQLException {
        File result;
        File start = new File(args[0]);
        File end = new File(args[1]);
        File diff = args.length < 4 ? null : new File(args[3]);
        File file = result = args[2].equals("stdout") ? null : new File(args[2]);
        if (!start.exists()) {
            System.err.println("Input Obf file doesn't exist: " + start.getAbsolutePath());
            System.exit(1);
            return;
        }
        if (!end.exists()) {
            System.err.println("Input Obf file doesn't exist: " + end.getAbsolutePath());
            System.exit(1);
            return;
        }
        this.generateDiff(start, end, result, diff);
    }

    private void generateDiff(File start, File end, File result, File diff) throws IOException, RTreeException, SQLException {
        ObfFileInMemory fStart = new ObfFileInMemory();
        fStart.readObfFiles(Collections.singletonList(start));
        ObfFileInMemory fEnd = new ObfFileInMemory();
        fEnd.readObfFiles(Collections.singletonList(end));
        HashSet<Entity.EntityId> allModifiedObjIds = new HashSet<Entity.EntityId>();
        if (diff != null) {
            try {
                DiffParser.fetchModifiedIds(diff, allModifiedObjIds, null);
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Comparing the files...");
        this.compareMapData(fStart, fEnd, result == null, allModifiedObjIds);
        this.compareRouteData(fStart, fEnd, result == null, allModifiedObjIds);
        this.comparePOI(fStart, fEnd, result == null, allModifiedObjIds);
        if (COMPARE_TRANSPORT) {
            this.compareTransport(fStart, fEnd, result == null, allModifiedObjIds);
        }
        System.out.println("Finished comparing.");
        if (result != null) {
            if (result.exists()) {
                result.delete();
            }
            fEnd.writeFile(result, false);
        }
    }

    private void compareTransport(ObfFileInMemory fStart, ObfFileInMemory fEnd, boolean print, Set<Entity.EntityId> modifiedObjIds) {
        TLongObjectHashMap<TransportStop> startStopData = this.cleanStopsAndAdjustId(fStart.getTransportStops());
        TLongObjectHashMap<TransportStop> endStopData = this.cleanStopsAndAdjustId(fEnd.getTransportStops());
        if (endStopData == null) {
            return;
        }
        if (print) {
            System.out.println("Compare transport data");
        }
        TLongObjectHashMap endStopDataDeleted = new TLongObjectHashMap();
        TLongHashSet existingStops = new TLongHashSet();
        long[] lArray = startStopData.keys();
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long stopId = lArray[i];
            TransportStop stopS = (TransportStop)startStopData.get(stopId.longValue());
            TransportStop stopE = (TransportStop)endStopData.get(stopId.longValue());
            existingStops.add(stopId.longValue());
            if (stopE == null) {
                if (print) {
                    System.out.println("Transport stop " + stopId + " is missing in (2): " + stopS);
                    continue;
                }
                Entity.EntityId aid = this.getTransportEntityId((MapObject)stopS, Entity.EntityType.NODE);
                Entity.EntityId aidWay = this.getTransportEntityId((MapObject)stopS, Entity.EntityType.WAY);
                if (modifiedObjIds.size() == 0 || modifiedObjIds.contains(aid) || modifiedObjIds.contains(aidWay)) {
                    stopS.setDeleted();
                    endStopData.put(stopId.longValue(), (Object)stopS);
                    continue;
                }
                endStopDataDeleted.put(stopId.longValue(), (Object)stopS);
                continue;
            }
            boolean cmp = stopE.compareStop(stopS);
            if (!cmp && print) {
                System.out.println("Transport stop " + stopId + " is not equal: " + stopS + " != " + stopE);
            }
            if (!cmp && !print) continue;
            TransportStop stop = (TransportStop)endStopData.remove(stopId.longValue());
            endStopDataDeleted.put(stopId.longValue(), (Object)stop);
        }
        TLongObjectIterator stopIterator = endStopData.iterator();
        while (stopIterator.hasNext()) {
            stopIterator.advance();
            TransportStop s = (TransportStop)stopIterator.value();
            if (s.isDeleted()) continue;
            long stopId = stopIterator.key();
            if (print) {
                System.out.println("Transport stop " + s.getId() + " is missing in (1): " + s);
                continue;
            }
            if (existingStops.contains(stopId)) continue;
            Entity.EntityId aid = this.getTransportEntityId((MapObject)s, Entity.EntityType.NODE);
            Entity.EntityId aidWay = this.getTransportEntityId((MapObject)s, Entity.EntityType.WAY);
            if (modifiedObjIds == null || modifiedObjIds.contains(aid) || modifiedObjIds.contains(aidWay)) continue;
            stopIterator.remove();
            endStopDataDeleted.put(stopId, (Object)s);
        }
        TLongObjectHashMap<TransportRoute> startRouteData = fStart.getTransportRoutes();
        TLongObjectHashMap<TransportRoute> endRouteData = fEnd.getTransportRoutes();
        TLongObjectHashMap routeDeletedStops = new TLongObjectHashMap();
        TLongHashSet existingRoutes = new TLongHashSet();
        Object object = startRouteData.keys();
        int cmp = ((long[])object).length;
        for (int i = 0; i < cmp; ++i) {
            Long routeId = object[i];
            try {
                TransportStop originalStop;
                existingRoutes.add(routeId.longValue());
                TransportRoute routeS = (TransportRoute)startRouteData.get(routeId.longValue());
                TransportRoute routeE = (TransportRoute)endRouteData.get(routeId.longValue());
                routeDeletedStops.clear();
                if (routeE == null) {
                    Entity.EntityId aid = this.getTransportRouteId(routeS);
                    if (modifiedObjIds != null && !modifiedObjIds.contains(aid)) continue;
                    for (TransportStop s : routeS.getForwardStops()) {
                        routeDeletedStops.put(ObfDiffGenerator.adjustTransportRouteStopIdToId(s.getId()), (Object)s);
                    }
                    if (print) {
                        System.out.println("Transport route " + routeId + " is missing in (2): " + routeS);
                    }
                } else {
                    boolean cmp2 = routeE.compareRoute(routeS);
                    if (!cmp2) {
                        if (print) {
                            System.out.println("Transport route " + routeId + " is not equal: " + routeS + " != " + routeE);
                        }
                        if (routeS != null) {
                            for (TransportStop s : routeS.getForwardStops()) {
                                routeDeletedStops.put(ObfDiffGenerator.adjustTransportRouteStopIdToId(s.getId()), (Object)s);
                            }
                        }
                        for (TransportStop s : routeE.getForwardStops()) {
                            long stopId = ObfDiffGenerator.adjustTransportRouteStopIdToId(s.getId());
                            routeDeletedStops.remove(stopId);
                            originalStop = this.checkEndStopData(endStopData, (TLongObjectHashMap<TransportStop>)endStopDataDeleted, s, routeId, stopId);
                            originalStop.addRouteId(routeId.longValue());
                        }
                    }
                    if (cmp2 || print) {
                        endRouteData.remove(routeId.longValue());
                    }
                }
                for (long stopId : routeDeletedStops.keys()) {
                    originalStop = this.checkEndStopData(endStopData, (TLongObjectHashMap<TransportStop>)endStopDataDeleted, (TransportStop)routeDeletedStops.get(stopId), routeId, stopId);
                    originalStop.addDeletedRouteId(routeId.longValue());
                }
                continue;
            }
            catch (RuntimeException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        object = endRouteData.valueCollection().iterator();
        while (object.hasNext()) {
            TransportRoute route = (TransportRoute)object.next();
            if (print) {
                System.out.println("Transport route " + route.getId() / 2L + " is missing in (1): " + route);
                continue;
            }
            if (existingRoutes.contains(route.getId().longValue())) continue;
            for (TransportStop s : route.getForwardStops()) {
                long routeId = route.getId();
                TransportStop originalStop = this.checkEndStopData(endStopData, (TLongObjectHashMap<TransportStop>)endStopDataDeleted, s, routeId, s.getId());
                originalStop.addRouteId(routeId);
            }
        }
    }

    private TransportStop checkEndStopData(TLongObjectHashMap<TransportStop> endStopData, TLongObjectHashMap<TransportStop> endStopDataDeleted, TransportStop errorStop, long routeId, long stopId) {
        if (!endStopData.contains(stopId)) {
            if (!endStopDataDeleted.contains(stopId)) {
                throw new IllegalArgumentException(String.format("Missing stop %d for route %d: %s", stopId, routeId / 2L, errorStop));
            }
            endStopData.put(stopId, (Object)((TransportStop)endStopDataDeleted.get(stopId)));
        }
        return (TransportStop)endStopData.get(stopId);
    }

    private TLongObjectHashMap<TransportStop> cleanStopsAndAdjustId(TLongObjectHashMap<TransportStop> transportStops) {
        if (transportStops == null) {
            return null;
        }
        for (TransportStop s : transportStops.valueCollection()) {
            s.setRoutesIds(null);
            s.setDeletedRoutesIds(null);
        }
        return transportStops;
    }

    public static long adjustTransportStopIdToId(long id) {
        return id;
    }

    public static long adjustTransportRouteStopIdToId(long id) {
        return id;
    }

    private void comparePOI(ObfFileInMemory fStart, ObfFileInMemory fEnd, boolean print, Set<Entity.EntityId> modifiedObjIds) {
        TLongObjectHashMap<Map<String, Amenity>> startPoiSource = fStart.getPoiObjects();
        TLongObjectHashMap<Map<String, Amenity>> endPoiSource = fEnd.getPoiObjects();
        if (endPoiSource == null) {
            return;
        }
        Map<String, Amenity> startPoi = this.buildPoiMap(startPoiSource);
        Map<String, Amenity> endPoi = this.buildPoiMap(endPoiSource);
        if (print) {
            System.out.println("Compare POI");
        }
        for (String idx : startPoi.keySet()) {
            Amenity objE = endPoi.get(idx);
            Amenity objS = startPoi.get(idx);
            Entity.EntityId aid = this.getMapObjectId((MapObject)objS);
            if (print) {
                if (objE == null) {
                    System.out.println("POI " + idx + " is missing in (2): " + objS);
                    continue;
                }
                if (!objS.comparePoi(objE)) {
                    System.out.println("POI " + idx + " is not equal: " + objS + " != " + objE);
                }
                endPoi.remove(idx);
                continue;
            }
            if (objE == null) {
                if (modifiedObjIds.size() != 0 && !modifiedObjIds.contains(aid) && aid != null) continue;
                objS.setAdditionalInfo(OSMAND_CHANGE_TAG, OSMAND_CHANGE_VALUE);
                endPoi.put(idx, objS);
                if (endPoiSource.get(objS.getId().longValue()) == null) {
                    endPoiSource.put(objS.getId().longValue(), new TreeMap());
                }
                ((Map)endPoiSource.get(objS.getId().longValue())).put(objS.getType().getKeyName(), objS);
                continue;
            }
            if (!objS.comparePoi(objE)) continue;
            endPoi.remove(idx);
            ((Map)endPoiSource.get(objS.getId().longValue())).remove(objS.getType().getKeyName());
        }
        if (print) {
            for (Map.Entry<String, Amenity> e : endPoi.entrySet()) {
                System.out.println("POI " + e.getKey() + " is missing in (1): " + e.getValue());
            }
        }
    }

    public Map<String, Amenity> buildPoiMap(TLongObjectHashMap<Map<String, Amenity>> startPoiSource) {
        HashMap<String, Amenity> map = new HashMap<String, Amenity>();
        for (Map am : startPoiSource.valueCollection()) {
            for (Map.Entry next : am.entrySet()) {
                String key = ((Amenity)next.getValue()).getId() + ":" + (String)next.getKey();
                map.put(key, (Amenity)next.getValue());
            }
        }
        return map;
    }

    private void compareMapData(ObfFileInMemory fStart, ObfFileInMemory fEnd, boolean print, Set<Entity.EntityId> modifiedObjIds) {
        int deleteId;
        fStart.filterAllZoomsBelow(13);
        fEnd.filterAllZoomsBelow(13);
        BinaryMapIndexReader.MapIndex mi = fEnd.getMapIndex();
        Integer rl = mi.getRule(OSMAND_CHANGE_TAG, OSMAND_CHANGE_VALUE);
        if (rl != null) {
            deleteId = rl;
        } else {
            deleteId = mi.decodingRules.size() + 1;
            mi.initMapEncodingRule(0, deleteId, OSMAND_CHANGE_TAG, OSMAND_CHANGE_VALUE);
        }
        for (MapZooms.MapZoomPair mz : fStart.getZooms()) {
            TLongObjectHashMap<BinaryMapDataObject> startData = fStart.get(mz);
            TLongObjectHashMap<BinaryMapDataObject> endData = fEnd.get(mz);
            if (print) {
                System.out.println("Compare map " + mz);
            }
            if (endData == null) continue;
            Object object = startData.keys();
            int n = ((long[])object).length;
            for (int i = 0; i < n; ++i) {
                Long idx = object[i];
                BinaryMapDataObject objE = (BinaryMapDataObject)endData.get(idx.longValue());
                BinaryMapDataObject objS = (BinaryMapDataObject)startData.get(idx.longValue());
                Entity.EntityId thisEntityId = this.getMapEntityId(objS.getId());
                if (print) {
                    if (objE == null) {
                        System.out.println("Map " + idx + " is missing in (2): " + this.toString(objS));
                        continue;
                    }
                    if (!objE.compareBinary(objS, 0)) {
                        System.out.println("Map " + idx + " is not equal: " + this.toString(objS) + " != " + this.toString(objE));
                    }
                    endData.remove(idx.longValue());
                    continue;
                }
                if (objE == null) {
                    if (modifiedObjIds.size() != 0 && !modifiedObjIds.contains(thisEntityId) && thisEntityId != null) continue;
                    BinaryMapDataObject obj = new BinaryMapDataObject(idx.longValue(), objS.getCoordinates(), null, objS.getObjectType(), objS.isArea(), new int[]{deleteId}, null, 0, 0);
                    endData.put(idx.longValue(), (Object)obj);
                    continue;
                }
                if (!objE.compareBinary(objS, 0)) continue;
                endData.remove(idx.longValue());
            }
            if (!print) continue;
            object = endData.valueCollection().iterator();
            while (object.hasNext()) {
                BinaryMapDataObject e = (BinaryMapDataObject)object.next();
                System.out.println("Map " + e.getId() + " is missing in (1): " + this.toString(e));
            }
        }
    }

    private Entity.EntityId getMapObjectId(MapObject objS) {
        Long id = objS.getId();
        if (id < 0x20000000000L && id > 0L) {
            if (id % 2L == 0L) {
                return new Entity.EntityId(Entity.EntityType.NODE, Long.valueOf(id >> 1));
            }
            return new Entity.EntityId(Entity.EntityType.WAY, Long.valueOf(id >> 1));
        }
        return null;
    }

    private Entity.EntityId getTransportEntityId(MapObject objS, Entity.EntityType tp) {
        Long id = objS.getId();
        return new Entity.EntityId(tp, Long.valueOf(id >> 6));
    }

    private Entity.EntityId getTransportRouteId(TransportRoute route) {
        return new Entity.EntityId(Entity.EntityType.RELATION, Long.valueOf(route.getId() >> 1));
    }

    private Entity.EntityId getMapEntityId(long id) {
        if (id < 0x20000000000L && id > 0L) {
            if (id % 2L == 0L) {
                return new Entity.EntityId(Entity.EntityType.NODE, Long.valueOf(id >> 7));
            }
            return new Entity.EntityId(Entity.EntityType.WAY, Long.valueOf(id >> 7));
        }
        return null;
    }

    private String toString(BinaryMapDataObject objS) {
        StringBuilder s = new StringBuilder();
        BinaryInspector.printMapDetails(objS, s, false);
        return s.toString();
    }

    private void compareRouteData(ObfFileInMemory fStart, ObfFileInMemory fEnd, boolean print, Set<Entity.EntityId> modifiedObjIds) {
        BinaryMapRouteReaderAdapter.RouteRegion ri = fEnd.getRouteIndex();
        int deleteId = ri.searchRouteEncodingRule(OSMAND_CHANGE_TAG, OSMAND_CHANGE_VALUE);
        if (deleteId == -1) {
            deleteId = ri.routeEncodingRules.size();
            if (deleteId == 0) {
                deleteId = 1;
            }
            ri.initRouteEncodingRule(deleteId, OSMAND_CHANGE_TAG, OSMAND_CHANGE_VALUE);
        }
        TLongObjectHashMap<RouteDataObject> startData = fStart.getRoutingData();
        TLongObjectHashMap<RouteDataObject> endData = fEnd.getRoutingData();
        if (endData == null) {
            return;
        }
        if (print) {
            System.out.println("Compare route data");
        }
        Object object = startData.keys();
        int n = ((long[])object).length;
        for (int i = 0; i < n; ++i) {
            Long idx = object[i];
            RouteDataObject objE = (RouteDataObject)endData.get(idx.longValue());
            RouteDataObject objS = (RouteDataObject)startData.get(idx.longValue());
            if (print) {
                if (objE == null) {
                    System.out.println("Route " + idx + " is missing in (2): " + objS);
                    continue;
                }
                if (!objE.compareRoute(objS)) {
                    System.out.println("Route " + idx + " is not equal: " + objS + " != " + objE);
                }
                endData.remove(idx.longValue());
                continue;
            }
            if (objE == null) {
                Entity.EntityId wayId = new Entity.EntityId(Entity.EntityType.WAY, Long.valueOf(idx >> 6));
                if (modifiedObjIds.size() != 0 && !modifiedObjIds.contains(wayId)) continue;
                RouteDataObject rdo = this.generateDeletedRouteObject(ri, deleteId, objS);
                endData.put(idx.longValue(), (Object)rdo);
                continue;
            }
            if (!objE.compareRoute(objS)) continue;
            endData.remove(idx.longValue());
        }
        if (print) {
            object = endData.valueCollection().iterator();
            while (object.hasNext()) {
                RouteDataObject e = (RouteDataObject)object.next();
                System.out.println("Route " + e.getId() + " is missing in (1): " + e);
            }
        }
    }

    private RouteDataObject generateDeletedRouteObject(BinaryMapRouteReaderAdapter.RouteRegion ri, int deleteId, RouteDataObject objS) {
        RouteDataObject rdo = new RouteDataObject(ri);
        rdo.id = objS.id;
        rdo.pointsX = objS.pointsX;
        rdo.pointsY = objS.pointsY;
        rdo.types = new int[]{deleteId};
        return rdo;
    }
}

