/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import net.osmand.PlatformUtil;
import net.osmand.osm.edit.Entity;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DiffParser {
    private static final String ATTR_ID = "id";
    private static final String TYPE_RELATION = "relation";
    private static final String TYPE_WAY = "way";
    private static final String TYPE_NODE = "node";
    private static final String TYPE_ACTION = "action";
    private static final String ATTR_ACTION_TYPE = "type";

    public static void fetchModifiedIds(File diff, Set<Entity.EntityId> all, Set<Entity.EntityId> deleted) throws IOException, XmlPullParserException {
        int tok;
        InputStream fis = diff.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(diff)) : new FileInputStream(diff);
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        parser.setInput(fis, "UTF-8");
        ActionType actionType = null;
        while ((tok = parser.next()) != 1) {
            if (tok == 2) {
                String name = parser.getName();
                if (TYPE_ACTION.equals(name)) {
                    actionType = ActionType.getType(parser.getAttributeValue("", ATTR_ACTION_TYPE));
                }
                Entity.EntityId entityId = null;
                if (TYPE_NODE.equals(name)) {
                    entityId = new Entity.EntityId(Entity.EntityType.NODE, Long.valueOf(DiffParser.parseLong(parser, ATTR_ID, -1L)));
                } else if (TYPE_WAY.equals(name)) {
                    entityId = new Entity.EntityId(Entity.EntityType.WAY, Long.valueOf(DiffParser.parseLong(parser, ATTR_ID, -1L)));
                } else if (TYPE_RELATION.equals(name)) {
                    entityId = new Entity.EntityId(Entity.EntityType.RELATION, Long.valueOf(DiffParser.parseLong(parser, ATTR_ID, -1L)));
                }
                if (entityId == null) continue;
                if (all != null) {
                    all.add(entityId);
                }
                if (deleted == null || actionType == null || actionType == ActionType.MODIFY) continue;
                deleted.add(entityId);
                continue;
            }
            if (tok != 3 || !TYPE_ACTION.equals(parser.getName()) || actionType == null) continue;
            actionType = null;
        }
    }

    protected static long parseLong(XmlPullParser parser, String name, long defVal) {
        long ret = defVal;
        String value = parser.getAttributeValue("", name);
        if (value == null) {
            return defVal;
        }
        try {
            ret = Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    private static enum ActionType {
        CREATE("create"),
        DELETE("delete"),
        MODIFY("modify");

        final String type;

        private ActionType(String type) {
            this.type = type;
        }

        static ActionType getType(String typeStr) {
            for (ActionType at : ActionType.values()) {
                if (!at.type.equals(typeStr)) continue;
                return at;
            }
            return null;
        }
    }
}

