/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.binary.MapZooms;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.IndexHeightData;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.OsmRouteType;
import net.osmand.shared.data.KQuadRect;
import net.osmand.shared.gpx.GpxFile;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.primitives.Track;
import net.osmand.shared.gpx.primitives.TrkSegment;
import net.osmand.shared.gpx.primitives.WptPt;
import net.osmand.shared.io.KFile;
import net.osmand.shared.util.KAlgorithms;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import rtree.RTree;

public class OsmGpxWriteContext {
    private static final NumberFormat latLonFormat = new DecimalFormat("0.00#####", new DecimalFormatSymbols());
    public final QueryParams qp;
    public int tracks = 0;
    public int segments = 0;
    long id = -10L;
    XmlSerializer serializer = null;
    OutputStream outputStream = null;

    public OsmGpxWriteContext(QueryParams qp) {
        this.qp = qp;
    }

    private boolean validatedTrackSegment(TrkSegment t) {
        boolean isOnePointIn = false;
        boolean testPoints = this.qp.minlat != -1000.0 || this.qp.minlon != -1000.0 || this.qp.maxlat != -1000.0 || this.qp.maxlon != -1000.0;
        for (WptPt p : t.getPoints()) {
            if (p.getLat() >= 90.0 || p.getLat() <= -90.0 || p.getLon() >= 180.0 || p.getLon() <= -180.0) {
                return false;
            }
            if (!testPoints || !(p.getLat() >= this.qp.minlat) || !(p.getLat() <= this.qp.maxlat) || !(p.getLon() >= this.qp.minlon) || !(p.getLon() <= this.qp.maxlon)) continue;
            isOnePointIn = true;
        }
        return !testPoints || isOnePointIn;
    }

    public void startDocument() throws IllegalArgumentException, IllegalStateException, IOException {
        if (this.qp.osmFile != null) {
            this.outputStream = new FileOutputStream(this.qp.osmFile);
            if (this.qp.osmFile.getName().endsWith(".gz")) {
                this.outputStream = new GZIPOutputStream(this.outputStream);
            }
            this.serializer = PlatformUtil.newSerializer();
            this.serializer.setOutput((Writer)new BufferedWriter(new OutputStreamWriter(this.outputStream)));
            this.serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            this.serializer.startDocument("UTF-8", Boolean.valueOf(true));
            this.serializer.startTag(null, "osm");
            this.serializer.attribute(null, "version", "0.6");
        }
    }

    public void writeTrack(OsmGpxFile gpxInfo, Map<String, String> extraTrackTags, GpxFile gpxFile, GpxTrackAnalysis analysis, String routeIdPrefix) throws IOException, SQLException {
        LinkedHashMap<String, String> gpxTrackTags = new LinkedHashMap<String, String>();
        if (this.qp.details < 1) {
            boolean validTrack = false;
            for (Track t : gpxFile.getTracks()) {
                for (TrkSegment s : t.getSegments()) {
                    if (s.getPoints().isEmpty() || !this.validatedTrackSegment(s)) continue;
                    validTrack = true;
                }
            }
            if (validTrack) {
                this.serializer.startTag(null, "node");
                this.serializer.attribute(null, "id", "" + this.id--);
                this.serializer.attribute(null, "action", "modify");
                this.serializer.attribute(null, "version", "1");
                this.serializer.attribute(null, "lat", latLonFormat.format(gpxFile.findPointToShow().getLat()));
                this.serializer.attribute(null, "lon", latLonFormat.format(gpxFile.findPointToShow().getLon()));
                this.tagValue(this.serializer, "route", "segment");
                this.tagValue(this.serializer, "route_type", "track");
                this.tagValue(this.serializer, "route_radius", gpxFile.getOuterRadius());
                this.addGenericTags(gpxTrackTags, null);
                this.addGpxInfoTags(gpxTrackTags, gpxInfo, routeIdPrefix);
                this.addExtensionsTags(gpxTrackTags, gpxFile.getExtensions());
                this.addPointGroupsTags(gpxTrackTags, gpxFile.getPointsGroups());
                this.addAnalysisTags(gpxTrackTags, analysis);
                this.serializeTags(extraTrackTags, gpxTrackTags);
                this.serializer.endTag(null, "node");
            }
        } else {
            for (Track t : gpxFile.getTracks()) {
                for (TrkSegment s : t.getSegments()) {
                    long nid;
                    if (s.getPoints().isEmpty() || !this.validatedTrackSegment(s)) continue;
                    ++this.segments;
                    long idStart = this.id;
                    double dlon = ((WptPt)s.getPoints().get(0)).getLon();
                    double dlat = ((WptPt)s.getPoints().get(0)).getLat();
                    KQuadRect qr = new KQuadRect(dlon, dlat, dlon, dlat);
                    for (WptPt p : s.getPoints()) {
                        --this.id;
                        GpxUtilities.INSTANCE.updateQR(qr, p, dlat, dlon);
                        this.writePoint(nid, p, null, null, null);
                    }
                    long endid = this.id;
                    this.serializer.startTag(null, "way");
                    this.serializer.attribute(null, "id", "" + this.id--);
                    this.serializer.attribute(null, "action", "modify");
                    this.serializer.attribute(null, "version", "1");
                    for (nid = idStart; nid > endid; --nid) {
                        this.serializer.startTag(null, "nd");
                        this.serializer.attribute(null, "ref", "" + nid);
                        this.serializer.endTag(null, "nd");
                    }
                    this.tagValue(this.serializer, "route", "segment");
                    this.tagValue(this.serializer, "route_type", "track");
                    int radius = (int)MapUtils.getDistance((double)qr.getBottom(), (double)qr.getLeft(), (double)qr.getTop(), (double)qr.getRight());
                    this.tagValue(this.serializer, "route_radius", MapUtils.convertDistToChar((int)radius, (char)'A', (int)5000, (int)2, (int)5));
                    this.addGenericTags(gpxTrackTags, t);
                    this.addGpxInfoTags(gpxTrackTags, gpxInfo, routeIdPrefix);
                    this.addExtensionsTags(gpxTrackTags, gpxFile.getExtensions());
                    this.addPointGroupsTags(gpxTrackTags, gpxFile.getPointsGroups());
                    this.addAnalysisTags(gpxTrackTags, analysis);
                    this.addElevationTags(gpxTrackTags, s);
                    this.serializeTags(extraTrackTags, gpxTrackTags);
                    this.serializer.endTag(null, "way");
                }
            }
            for (WptPt p : gpxFile.getPointsList()) {
                long nid;
                --this.id;
                if (gpxInfo == null) continue;
                this.writePoint(nid, p, "point", routeIdPrefix + gpxInfo.id, gpxInfo.name);
            }
        }
        ++this.tracks;
    }

    private void addPointGroupsTags(Map<String, String> gpxTrackTags, Map<String, GpxUtilities.PointsGroup> pointsGroups) {
        ArrayList<String> pgNames = new ArrayList<String>();
        ArrayList<String> pgIcons = new ArrayList<String>();
        ArrayList<String> pgColors = new ArrayList<String>();
        ArrayList<String> pgBackgrounds = new ArrayList<String>();
        for (String name : pointsGroups.keySet()) {
            pgNames.add(name);
            pgIcons.add(pointsGroups.get(name).getIconName());
            pgBackgrounds.add(pointsGroups.get(name).getBackgroundType());
            pgColors.add(KAlgorithms.INSTANCE.colorToString(pointsGroups.get(name).getColor()));
        }
        String delimiter = "~~~";
        gpxTrackTags.put("points_groups_names", String.join((CharSequence)"~~~", pgNames));
        gpxTrackTags.put("points_groups_icons", String.join((CharSequence)"~~~", pgIcons));
        gpxTrackTags.put("points_groups_colors", String.join((CharSequence)"~~~", pgColors));
        gpxTrackTags.put("points_groups_backgrounds", String.join((CharSequence)"~~~", pgBackgrounds));
    }

    private void addExtensionsTags(Map<String, String> gpxTrackTags, Map<String, String> extensions) {
        if (extensions != null) {
            if (extensions.containsKey("color")) {
                gpxTrackTags.put("color", extensions.get("color"));
                gpxTrackTags.remove("colour_int");
                gpxTrackTags.remove("colour");
            }
            if (extensions.containsKey("width")) {
                gpxTrackTags.put("width", extensions.get("width"));
            }
            for (String key : extensions.keySet()) {
                gpxTrackTags.put("gpx_" + key, extensions.get(key));
            }
        }
    }

    private void addElevationTags(Map<String, String> gpxTrackTags, TrkSegment s) {
        IndexHeightData.WayGeneralStats wgs = new IndexHeightData.WayGeneralStats();
        for (WptPt p : s.getPoints()) {
            wgs.altitudes.add(p.getEle());
            wgs.dists.add(p.getDistance());
        }
        IndexHeightData.calculateEleStats(wgs, 25);
        if (wgs.eleCount > 0) {
            int st = (int)wgs.startEle;
            gpxTrackTags.put("start_ele", String.valueOf((int)wgs.startEle));
            gpxTrackTags.put("end_ele__start", String.valueOf((int)wgs.endEle - st));
            gpxTrackTags.put("avg_ele__start", String.valueOf((int)(wgs.sumEle / (double)wgs.eleCount) - st));
            gpxTrackTags.put("min_ele__start", String.valueOf((int)wgs.minEle - st));
            gpxTrackTags.put("max_ele__start", String.valueOf((int)wgs.maxEle - st));
            gpxTrackTags.putIfAbsent("diff_ele_up", String.valueOf((int)wgs.up));
            gpxTrackTags.putIfAbsent("diff_ele_down", String.valueOf((int)wgs.down));
            gpxTrackTags.put("ele_graph", MapAlgorithms.encodeIntHeightArrayGraph((int)wgs.step, (TIntArrayList)wgs.altIncs, (int)3));
        }
    }

    private void serializeTags(Map<String, String> extraTrackTags, Map<String, String> gpxTrackTags) throws IOException {
        if (extraTrackTags != null) {
            gpxTrackTags.putAll(extraTrackTags);
        }
        for (Map.Entry<String, String> e : gpxTrackTags.entrySet()) {
            this.tagValue(this.serializer, e.getKey(), e.getValue());
        }
    }

    public void endDocument() throws IOException {
        if (this.serializer != null) {
            this.serializer.endDocument();
            this.serializer.flush();
            this.outputStream.close();
        }
    }

    private void addGenericTags(Map<String, String> gpxTrackTags, Track p) throws IOException {
        if (p != null) {
            int color;
            if (!Algorithms.isEmpty((CharSequence)p.getName())) {
                gpxTrackTags.put("name", p.getName());
            }
            if (!Algorithms.isEmpty((CharSequence)p.getDesc())) {
                gpxTrackTags.put("description", p.getDesc());
            }
            if ((color = p.getColor(Integer.valueOf(0)).intValue()) != 0) {
                gpxTrackTags.put("colour", MapRenderingTypesEncoder.formatColorToPalette(Algorithms.colorToString((int)color), false));
                gpxTrackTags.put("colour_int", Algorithms.colorToString((int)color));
            }
        }
    }

    private void addGpxInfoTags(Map<String, String> gpxTrackTags, OsmGpxFile gpxInfo, String routeIdPrefix) {
        if (gpxInfo != null) {
            gpxTrackTags.put("route_id", routeIdPrefix + gpxInfo.id);
            gpxTrackTags.put("ref", "" + gpxInfo.id % 1000L);
            gpxTrackTags.put("name", gpxInfo.name);
            gpxTrackTags.put("route_name", gpxInfo.name);
            gpxTrackTags.put("user", gpxInfo.user);
            gpxTrackTags.put("date", gpxInfo.timestamp.toString());
            gpxTrackTags.put("description", gpxInfo.description);
            OsmRouteType activityType = OsmRouteType.getTypeFromTags((String[])gpxInfo.tags);
            for (String tg : gpxInfo.tags) {
                gpxTrackTags.put("tag_" + tg, tg);
            }
            if (activityType != null) {
                gpxTrackTags.put("gpx_bg", activityType.getColor() + "_hexagon_3_road_shield");
                gpxTrackTags.put("color", activityType.getColor());
                gpxTrackTags.put("route_activity_type", activityType.getName().toLowerCase());
            }
        }
    }

    private void addAnalysisTags(Map<String, String> gpxTrackTags, GpxTrackAnalysis analysis) throws IOException {
        gpxTrackTags.put("distance", latLonFormat.format(analysis.getTotalDistance()));
        if (analysis.isTimeSpecified()) {
            gpxTrackTags.put("time_span", "" + analysis.getTimeSpan());
            gpxTrackTags.put("time_span_no_gaps", "" + analysis.getTimeSpanWithoutGaps());
            gpxTrackTags.put("time_moving", "" + analysis.getTimeMoving());
            gpxTrackTags.put("time_moving_no_gaps", "" + analysis.getTimeMovingWithoutGaps());
        }
        if (analysis.hasElevationData()) {
            gpxTrackTags.put("avg_ele", latLonFormat.format(analysis.getAvgElevation()));
            gpxTrackTags.put("min_ele", latLonFormat.format(analysis.getMinElevation()));
            gpxTrackTags.put("max_ele", latLonFormat.format(analysis.getMaxElevation()));
            gpxTrackTags.put("diff_ele_up", latLonFormat.format(analysis.getDiffElevationUp()));
            gpxTrackTags.put("diff_ele_down", latLonFormat.format(analysis.getDiffElevationDown()));
        }
        if (analysis.hasSpeedData()) {
            gpxTrackTags.put("avg_speed", latLonFormat.format(analysis.getAvgSpeed()));
            gpxTrackTags.put("max_speed", latLonFormat.format(analysis.getMaxSpeed()));
            gpxTrackTags.put("min_speed", latLonFormat.format(analysis.getMinSpeed()));
        }
    }

    private void writePoint(long id, WptPt p, String routeType, String routeId, String routeName) throws IOException {
        int color;
        this.serializer.startTag(null, "node");
        this.serializer.attribute(null, "lat", latLonFormat.format(p.getLat()));
        this.serializer.attribute(null, "lon", latLonFormat.format(p.getLon()));
        this.serializer.attribute(null, "id", "" + id);
        this.serializer.attribute(null, "action", "modify");
        this.serializer.attribute(null, "version", "1");
        if (routeType != null) {
            this.tagValue(this.serializer, "route", routeType);
            this.tagValue(this.serializer, "route_type", "track_point");
            this.tagValue(this.serializer, "route_id", routeId);
            this.tagValue(this.serializer, "route_name", routeName);
        }
        if (!Algorithms.isEmpty((CharSequence)p.getName())) {
            this.tagValue(this.serializer, "name", p.getName());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getDesc())) {
            this.tagValue(this.serializer, "description", p.getDesc());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getCategory())) {
            this.tagValue(this.serializer, "category", p.getCategory());
            this.tagValue(this.serializer, "points_groups_category", p.getCategory());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getComment())) {
            this.tagValue(this.serializer, "note", p.getComment());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getLink())) {
            this.tagValue(this.serializer, "url", p.getLink());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getIconName())) {
            this.tagValue(this.serializer, "gpx_icon", p.getIconName());
        }
        if (!Algorithms.isEmpty((CharSequence)p.getBackgroundType())) {
            this.tagValue(this.serializer, "gpx_bg", p.getBackgroundType());
        }
        if ((color = p.getColor(Integer.valueOf(0)).intValue()) != 0) {
            this.tagValue(this.serializer, "colour", MapRenderingTypesEncoder.formatColorToPalette(Algorithms.colorToString((int)color), false));
            this.tagValue(this.serializer, "colour_int", Algorithms.colorToString((int)color));
        }
        if (this.qp.details >= 2) {
            if (!Double.isNaN(p.getEle())) {
                this.tagValue(this.serializer, "ele", latLonFormat.format(p.getEle()));
            }
            if (!Double.isNaN(p.getSpeed()) && p.getSpeed() > 0.0) {
                this.tagValue(this.serializer, "speed", latLonFormat.format(p.getSpeed()));
            }
            if (!Double.isNaN(p.getHdop())) {
                this.tagValue(this.serializer, "hdop", latLonFormat.format(p.getHdop()));
            }
        }
        this.serializer.endTag(null, "node");
    }

    private void tagValue(XmlSerializer serializer, String tag, String value) throws IOException {
        if (Algorithms.isEmpty((CharSequence)value)) {
            return;
        }
        serializer.startTag(null, "tag");
        serializer.attribute(null, "k", tag);
        serializer.attribute(null, "v", value);
        serializer.endTag(null, "tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeObf(Map<String, GpxFile> gpxFiles, List<KFile> files, File tmpFolder, String fileName, File targetObf) throws IOException, SQLException, InterruptedException, XmlPullParserException {
        this.startDocument();
        if (gpxFiles != null) {
            for (Map.Entry<String, GpxFile> entry : gpxFiles.entrySet()) {
                gpxFile = entry.getValue();
                this.writeFile(gpxFile, entry.getKey());
            }
        } else if (files != null) {
            for (KFile gf : files) {
                gpxFile = GpxUtilities.INSTANCE.loadGpxFile(gf, null, false);
                this.writeFile(gpxFile, gf.name());
            }
        }
        this.endDocument();
        IndexCreatorSettings settings = new IndexCreatorSettings();
        settings.indexMap = true;
        settings.indexAddress = false;
        settings.indexPOI = true;
        settings.indexTransport = false;
        settings.indexRouting = false;
        RTree.clearCache();
        try {
            tmpFolder.mkdirs();
            IndexCreator ic = new IndexCreator(tmpFolder, settings);
            MapRenderingTypesEncoder types = new MapRenderingTypesEncoder(null, fileName);
            ic.setMapFileName(fileName);
            IProgress prog = IProgress.EMPTY_PROGRESS;
            ic.generateIndexes(this.qp.osmFile, prog, null, MapZooms.getDefault(), types, null);
            new File(tmpFolder, ic.getMapFileName()).renameTo(targetObf);
        }
        finally {
            Algorithms.removeAllFiles((File)tmpFolder);
        }
        return targetObf;
    }

    private void writeFile(GpxFile gpxFile, String fileName) throws SQLException, IOException {
        GpxTrackAnalysis analysis = gpxFile.getAnalysis(gpxFile.getModifiedTime());
        OsmGpxFile file = new OsmGpxFile();
        String name = fileName;
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        file.name = name;
        file.id = gpxFile.getModifiedTime() / 1000L;
        file.timestamp = new Date(gpxFile.getModifiedTime());
        file.description = "";
        file.tags = new String[0];
        this.writeTrack(file, null, gpxFile, analysis, "GPX");
    }

    public static void generateObfFromGpx(List<String> subArgs) throws IOException, SQLException, XmlPullParserException, InterruptedException {
        KFile file;
        if (subArgs.size() != 0 && ((file = new KFile(subArgs.get(0))).isDirectory() || file.name().endsWith(".gpx") || file.name().endsWith(".gpx.gz"))) {
            QueryParams qp = new QueryParams();
            qp.osmFile = File.createTempFile(file.getFileNameWithoutExtension(), ".osm");
            OsmGpxWriteContext ctx = new OsmGpxWriteContext(qp);
            File dir = new File(file.isDirectory() ? file.name() : file.parent().name());
            File tmpFolder = new File(dir, String.valueOf(System.currentTimeMillis()));
            File targetObf = new File(dir, file.getFileNameWithoutExtension() + ".obf");
            List<KFile> files = new ArrayList<KFile>();
            if (file.isDirectory()) {
                files = file.listFiles();
            } else {
                files.add(file);
            }
            if (!files.isEmpty()) {
                ctx.writeObf(null, files, tmpFolder, file.getFileNameWithoutExtension(), targetObf);
            }
            if (!qp.osmFile.delete()) {
                qp.osmFile.deleteOnExit();
            }
        }
    }

    public static class QueryParams {
        public static final int DETAILS_POINTS = 0;
        public static final int DETAILS_TRACKS = 1;
        public static final int DETAILS_ELE_SPEED = 2;
        public int details = 2;
        public File osmFile;
        public File obfFile;
        public String tag;
        public int limit = -1;
        public String user;
        public String datestart;
        public String dateend;
        public Set<OsmRouteType> activityTypes = null;
        public double minlat = -1000.0;
        public double maxlat = -1000.0;
        public double maxlon = -1000.0;
        public double minlon = -1000.0;
    }

    public static class OsmGpxFile {
        public static final double ERROR_NUMBER = -1000.0;
        public long id;
        public String name;
        public Date timestamp;
        public boolean pending;
        public String user;
        public String visibility;
        public double lat;
        public double lon;
        public String description;
        public double minlat = -1000.0;
        public double minlon = -1000.0;
        public double maxlat = -1000.0;
        public double maxlon = -1000.0;
        public String[] tags;
        public String gpx;
        public byte[] gpxGzip;
    }
}

